/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.ISCSITargetPort;
import com.hitachi.smi.common.LUPathObject;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.ResourceGroupInfo;
import com.hitachi.smi.common.ResourceRestriction;
import com.hitachi.smi.common.StorageHardwareIDs;
import com.hitachi.smi.common.VirtualLDEV;
import com.hitachi.smi.instrumentation.AuthorizedPrivilegeInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.instrumentation.SCSIProtocolControllerInstrumentation;
import com.hitachi.smi.instrumentation.StorageClientSettingDataInstrumentation;
import com.hitachi.smi.instrumentation.iSCSI.iSCSIProtocolEndpointInstrumentation;
import com.hitachi.smi.jobs.DeleteProtocolController;
import com.hitachi.smi.jobs.ExposeHidePaths;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.provider.jobservice.CIM_ConcreteJob;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMException;

public class ControllerConfigurationServiceInstrumentation
extends BaseInstrumentation {
    static final Pattern hitachiLUNMatchString = Pattern.compile("50[2-4]");
    private static final int VALID_ACCESS = 2;
    private static final String mClassName = "HITACHI_ControllerConfigurationService".substring("HITACHI_".length());
    final SCSIProtocolControllerInstrumentation mSCSIProtocolControllerInstrumentation = (SCSIProtocolControllerInstrumentation)ControllerConfigurationServiceInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SCSIProtocolControllerInstrumentation");
    final AuthorizedPrivilegeInstrumentation mAuthorizedPrivilegeInstrumentation = (AuthorizedPrivilegeInstrumentation)ControllerConfigurationServiceInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.AuthorizedPrivilegeInstrumentation");

    private static short[] validateLUName(RMIObjectMapping rmiObj, String luName) {
        short[] ret = null;
        short sLdkc = -1;
        mLogger.log(Level.INFO, "ValidateLUName: LUName: {0}", luName);
        if (null != rmiObj && null != luName) {
            BaseDeviceNumber dn = null;
            int encodedSerial = -1;
            try {
                if (luName.startsWith("HITACHI") && luName.length() == 20) {
                    mLogger.fine("ValidateLUName: Parsing HITACHI");
                    if (' ' == luName.charAt(7)) {
                        sLdkc = 0;
                    } else {
                        mLogger.log(Level.FINE, "LUName {0} is for R600/R700, DKC value is {1}", new Object[]{luName, Character.valueOf(luName.charAt(7))});
                        sLdkc = 1;
                    }
                    String r50 = luName.substring(8, 11);
                    mLogger.log(Level.FINE, "ValidateLUName: r50: {0}", r50);
                    Matcher m = hitachiLUNMatchString.matcher(r50);
                    if (m.matches() || r50.endsWith("50")) {
                        String storedVendor;
                        String serial = luName.substring(11, 16);
                        encodedSerial = Integer.parseInt(serial, 16);
                        String vendor = luName.substring(0, 7);
                        if (vendor.equalsIgnoreCase(storedVendor = rmiObj.getVendor())) {
                            short cu = Short.parseShort(luName.substring(16, 18), 16);
                            short ldev = Short.parseShort(luName.substring(18, 20), 16);
                            mLogger.log(Level.FINE, "ValidateLUName: cu: {0}, ldev: {1}", new Object[]{cu, ldev});
                            dn = ControllerConfigurationServiceInstrumentation.verifyVirtualDN(sLdkc, cu, ldev, encodedSerial, rmiObj);
                        } else {
                            mLogger.log(Level.SEVERE, "ValidateLUName{0}: Encoded vendor, {1}, does not match actual vendor, {2}.", new Object[]{luName, vendor, storedVendor});
                        }
                    } else {
                        mLogger.log(Level.SEVERE, "ValidateLUName: Unexpected LUName: {0}, r50: {1}", new Object[]{luName, r50});
                    }
                } else if (luName.startsWith("R500") && luName.length() == 20) {
                    mLogger.fine("ValidateLUName: Parsing HP");
                    String ldkc = luName.substring(5, 8);
                    sLdkc = ldkc.equals("003") ? (short)0 : (' ' == luName.charAt(13) ? (short)-1 : (short)Short.parseShort(luName.substring(6, 9)));
                    String serial = ' ' == luName.charAt(13) ? luName.substring(8, 13) : luName.substring(5, 13);
                    encodedSerial = Integer.parseInt(serial);
                    int cu_ldev = Integer.parseInt(luName.substring(14, 19));
                    short cu = (short)(cu_ldev / 256);
                    short ldev = (short)(cu_ldev - cu);
                    long devNum = BaseDeviceNumber.makeUniqueDN(sLdkc, cu, ldev);
                    mLogger.log(Level.FINE, "ValidateLUName: cu: {0}, ldev: {1}, DN: {2}", new Object[]{cu, ldev, devNum});
                    dn = DeviceNumber.find(Long.toString(devNum), false, rmiObj.getRMIObject());
                } else if (luName.startsWith("60060E80") && luName.length() == 32) {
                    String serial;
                    if ('7' == luName.charAt(9)) {
                        String ldkc = luName.substring(8, 9);
                        sLdkc = Short.parseShort(ldkc);
                        serial = '9' == luName.charAt(18) ? luName.substring(22, 28) : luName.substring(19, 24);
                    } else {
                        sLdkc = Short.parseShort(luName.substring(15, 18));
                        serial = luName.substring(18, 24);
                    }
                    encodedSerial = Integer.parseInt(serial, 16);
                    short cu = Short.parseShort(luName.substring(28, 30), 16);
                    short ldev = Short.parseShort(luName.substring(30, 32), 16);
                    long devNum = BaseDeviceNumber.makeUniqueDN(sLdkc, cu, ldev);
                    mLogger.log(Level.FINE, "ValidateLUName: cu: {0}, ldev: {1}, DN: {2}", new Object[]{cu, ldev, devNum});
                    dn = DeviceNumber.find(Long.toString(devNum), false, rmiObj.getRMIObject());
                }
            }
            catch (Throwable th) {
                mLogger.log(Level.SEVERE, "ValidateLUName: Exception parsing LUName: {0} " + luName, th);
            }
            if (null != dn) {
                ret = new short[]{dn.getLdkc(), dn.getCu(), dn.getLdev()};
            } else {
                mLogger.log(Level.SEVERE, "ValidateLUName: could not find DN matching luName {0}", new Object[]{luName});
            }
        } else {
            mLogger.log(Level.SEVERE, "ValidateLUName: Invalid parameter, rmiObj: {0}, luName: {1}", new Object[]{rmiObj, luName});
        }
        return ret;
    }

    private static DeviceNumber verifyVirtualDN(short sLdkc, short cu, short ldev, int encodedSerial, RMIObjectMapping rmiObj) throws WBEMException {
        DeviceNumber dn;
        VirtualLDEV vLDev = VirtualLDEV.find(rmiObj.getRMIObject(), sLdkc, cu, ldev, encodedSerial);
        if (null == vLDev || 255 != vLDev.getVirtLDEVInfo().getCu()) {
            VirtualLDEV vLDev2;
            short dkcVal = null == vLDev ? sLdkc : vLDev.getRealDKC();
            short cuVal = null == vLDev ? cu : vLDev.getRealCU();
            short ldevVal = null == vLDev ? ldev : vLDev.getRealLDEV();
            long devNum = BaseDeviceNumber.makeUniqueDN(dkcVal, cuVal, ldevVal);
            mLogger.log(Level.FINE, "Looking for Real DN, {0},, virtual data is {1}", new Object[]{devNum, vLDev});
            String devNumStr = Long.toString(devNum);
            dn = DeviceNumber.find(devNumStr, false, rmiObj.getRMIObject());
            if (null != dn && null == vLDev && null != (vLDev2 = VirtualLDEV.find(rmiObj.getRMIObject(), devNumStr))) {
                BaseDeviceNumber virtData = vLDev2.getVirtLDEVInfo();
                if (vLDev2.getRealLDEV() != virtData.getLdev() || vLDev2.getRealCU() != virtData.getCu() || vLDev2.getRealDKC() != virtData.getLdkc()) {
                    dn = null;
                    mLogger.log(Level.SEVERE, "{0} for virtual volume {1} does not point at itself, this request is invalid", new Object[]{vLDev, devNum});
                }
            }
        } else {
            mLogger.log(Level.WARNING, "LDEV ({0}:{1}:{2} with encoded serial of {3} has no valid virtual data: {4}", new Object[]{sLdkc, cu, ldev, encodedSerial, vLDev});
            dn = null;
        }
        return dn;
    }

    public void afterJobComplete() {
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
            for (RMIObjectMapping device : devices) {
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, device.getRMIObject()));
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    private Object extrinsic_DeleteProtocolController(CIMObjectPath op, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        UnsignedInteger32 ret;
        CIMObjectPath scsiPC = null;
        boolean deleteChildrenPC = false;
        boolean deleteUnits = false;
        for (CIMArgument<?> arg : inArgs) {
            String mthName = arg.getName();
            if ("ProtocolController".equalsIgnoreCase(mthName)) {
                scsiPC = (CIMObjectPath)arg.getValue();
                continue;
            }
            if ("DeleteChildrenProtocolControllers".equalsIgnoreCase(mthName)) {
                deleteChildrenPC = (Boolean)arg.getValue();
                continue;
            }
            if (!"DeleteUnits".equalsIgnoreCase(mthName)) continue;
            deleteUnits = (Boolean)arg.getValue();
        }
        if (!deleteChildrenPC && null != scsiPC) {
            DeleteProtocolController dpc;
            CIM_ConcreteJob job;
            String deviceID = (String)scsiPC.getKeyValue("DeviceID");
            String sysName = (String)scsiPC.getKeyValue("SystemName");
            String portID = ProviderLibs.getAllButEndString(deviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            String domainID = ProviderLibs.getEndString(deviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            PortandHostGroupInfo phg = PortandHostGroupInfo.find(ProviderLibs.getSerialFromString(sysName), sysName, null, portID, domainID, null, false, null);
            ISCSITargetPort.ISCSITarget iSCSI = null;
            if (null == phg) {
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(ProviderLibs.getSerialFromString(sysName));
                ISCSITargetPort port = ISCSITargetPort.find(device.getRMIObject(), Integer.parseInt(portID));
                if (null == port) {
                    mLogger.log(Level.SEVERE, "Unable to find Hostgroup or iSCSI port {0}, domain {1}", new Object[]{portID, domainID});
                    return ProviderConstants.UINT32_FIVE;
                }
                iSCSI = port.getTarget(Short.parseShort(domainID));
                if (null == iSCSI) {
                    mLogger.log(Level.SEVERE, "Unable to find Hostgroup or target for port {0}, domain {1}", new Object[]{portID, domainID});
                    return ProviderConstants.UINT32_FIVE;
                }
            }
            if ((job = (dpc = new DeleteProtocolController(mHandle.getProperty("javax.wbem.provider.Principal"), op.getHost(), op, phg, iSCSI, deleteUnits)).submitJob()) != null) {
                try {
                    ProviderLibs.waitForJob(job);
                    ret = dpc.getRetVal();
                }
                catch (Throwable e) {
                    mLogger.log(Level.SEVERE, "DeleteProtocolController encountered an exception: " + e, e);
                    ret = ProviderConstants.UINT32_FOUR;
                }
            } else {
                ret = ProviderConstants.UINT32_FOUR;
            }
        } else {
            String msg = deleteChildrenPC ? "'DeleteChildrenProtocolControllers' parameter must be 'false'" : String.format("Unable to locate SCSIProtocolController: %s", scsiPC);
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            logger.severe(msg);
            ret = ProviderConstants.UINT32_FIVE;
        }
        return ret;
    }

    private UnsignedInteger32 extrinsic_ExposePaths(CIMObjectPath pOp, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        int retVal = 0;
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(pOp, "SystemName");
        try {
            short[] portAndHostValues;
            pathParameters params = new pathParameters(true, pInArgs);
            CIMObjectPath[] protocolControllers = params.getProtocolControllers();
            String[] targetPortIDs = params.getTargetPortIDs();
            String[] initiatorPortIDs = params.getInitiatorPortIDs();
            String[] luNames = params.getLUNames();
            String[] deviceNumbers = params.getDeviceNumbers();
            UnsignedInteger16[] deviceAccesses = params.getDeviceAccesses();
            String elementName = params.getElementName();
            CIMObjectPath clientSettingData = params.getClientSettingData();
            short[][] luValsArray = new short[luNames.length][];
            short[] sLUNums = new short[luNames.length];
            FCPort fcPort = null;
            short port = -1;
            short hostGrp = -1;
            retVal = this.validateLuNamesDeviceAccessesandDeviceNumbers(luNames, deviceAccesses, deviceNumbers);
            RMIObjectCache rmiObj = device.getRMIObject();
            if (0 == retVal && 0 == protocolControllers.length) {
                FCPort[] tFCPort = new FCPort[1];
                short[] tempHG = new short[1];
                retVal = this.validateTargetPortIDs(rmiObj, targetPortIDs, tFCPort, tempHG);
                if (0 == retVal) {
                    fcPort = tFCPort[0];
                    hostGrp = tempHG[0];
                }
            } else if (0 == retVal) {
                if (0 == targetPortIDs.length) {
                    retVal = this.validateProtocolController(protocolControllers, initiatorPortIDs, luNames);
                } else {
                    mLogger.severe("ControllerConfigurationService:ExposePaths - Returning \"Invalid Target Port ID\" because a protocolController was specified and Target Port IDs.  Cannot specify Target Port IDs if a protocolController was specified.");
                    retVal = 4099;
                }
            }
            if (0 == retVal && initiatorPortIDs.length > 0) {
                boolean setPortHAndHostValues;
                if (-1 != port && -1 != hostGrp) {
                    setPortHAndHostValues = false;
                    portAndHostValues = new short[]{port, hostGrp};
                } else if (protocolControllers.length > 0) {
                    setPortHAndHostValues = true;
                    portAndHostValues = ProviderLibs.getPortAndHostFromProtocolController(protocolControllers[0]);
                } else if (null != fcPort) {
                    setPortHAndHostValues = true;
                    portAndHostValues = new short[]{fcPort.getPort(), hostGrp};
                } else {
                    setPortHAndHostValues = false;
                    portAndHostValues = null;
                    mLogger.severe("ControllerConfigurationService:ExposePaths - Returning \"Invalid Parameter\" because provider cannot determine port and hostgroup values from protocolController: " + (protocolControllers == null ? "null" : protocolControllers[0]));
                    retVal = 5;
                }
                if (0 == retVal) {
                    HashSet<String> initPortMap = new HashSet<String>();
                    retVal = this.populatePortMap(initPortMap, initiatorPortIDs);
                    if (0 == retVal) {
                        retVal = this.validateHostGroupInitiators(rmiObj, portAndHostValues, initiatorPortIDs, initPortMap, fcPort);
                    }
                    if (0 == retVal && setPortHAndHostValues) {
                        if (null != portAndHostValues) {
                            port = portAndHostValues[0];
                            hostGrp = portAndHostValues[1];
                        } else {
                            mLogger.severe("ExposePaths: portAndHostValues is null");
                            retVal = 5;
                        }
                    }
                }
            }
            if (0 == retVal && luNames.length > 0) {
                boolean setPortHAndHostValues;
                if (-1 != port && -1 != hostGrp) {
                    setPortHAndHostValues = false;
                    portAndHostValues = new short[]{port, hostGrp};
                } else if (protocolControllers.length > 0) {
                    setPortHAndHostValues = true;
                    portAndHostValues = ProviderLibs.getPortAndHostFromProtocolController(protocolControllers[0]);
                } else if (null != fcPort) {
                    setPortHAndHostValues = true;
                    portAndHostValues = new short[]{fcPort.getPort(), hostGrp};
                } else {
                    setPortHAndHostValues = false;
                    portAndHostValues = null;
                    mLogger.severe("ControllerConfigurationService:ExposePaths - Returning \"Invalid Parameter\" because provider cannot determine port and hostgroup values from protocolController: " + (protocolControllers == null ? "null" : protocolControllers[0]));
                    retVal = 5;
                }
                if (null != portAndHostValues && 0 == (retVal = this.processLUNames(device, luNames, deviceNumbers, sLUNums, luValsArray, portAndHostValues)) && setPortHAndHostValues) {
                    port = portAndHostValues[0];
                    hostGrp = portAndHostValues[1];
                }
            }
            if (0 == retVal && initiatorPortIDs.length > 0) {
                retVal = this.verifyInitiatorsMatchPort(rmiObj, initiatorPortIDs[0], fcPort, port);
            }
            int hostMode = -1;
            if (0 == retVal && null != clientSettingData) {
                CIMInstance csd = mHandle.getInstance(clientSettingData, null);
                if (null != csd) {
                    UnsignedInteger16[] clientTypes = (UnsignedInteger16[])csd.getPropertyValue("ClientTypes");
                    hostMode = StorageClientSettingDataInstrumentation.getHostModeFromClientType(rmiObj, clientTypes[0].intValue());
                } else {
                    throw new WBEMException(4, "Unable to find ClientSettingData information: " + clientSettingData);
                }
            }
            if (0 == retVal) {
                retVal = this.validateResourceGroup(rmiObj, fcPort, port, hostGrp, luValsArray);
            }
            if (0 == retVal) {
                ExposeHidePaths data = new ExposeHidePaths(device.getSerialNumber(), mHandle.getProperty("javax.wbem.provider.Principal"), pOp.getHost(), pOp, fcPort, port, hostGrp, initiatorPortIDs, luValsArray, sLUNums, protocolControllers, elementName, hostMode, true);
                CIM_ConcreteJob job = data.submitJob();
                if (job != null) {
                    mLogger.log(Level.INFO, "Job created: {0}, Params {1}", new Object[]{job.getInstanceID(), data.toString()});
                    CIMObjectPath coPath = job.getCIMObjectPath(pOp);
                    pOutArgs[0] = new CIMArgument("Job", new CIMDataType("CIM_ConcreteJob"), (Object)coPath);
                    retVal = 4096;
                } else {
                    retVal = 4;
                }
            }
        }
        catch (Throwable th) {
            retVal = 4;
            mLogger.log(Level.SEVERE, "ControllerConfigurationService:ExposePaths - Returning \"Failed\" because exception was caught", th);
        }
        return new UnsignedInteger32((long)retVal);
    }

    private UnsignedInteger32 extrinsic_HidePaths(CIMObjectPath pOp, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        int retVal = 0;
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(pOp, "SystemName");
        try {
            pathParameters params = new pathParameters(false, pInArgs);
            String[] targetPortIDs = params.getTargetPortIDs();
            Object[] protocolControllers = params.getProtocolControllers();
            String[] initiatorPortIDs = params.getInitiatorPortIDs();
            String[] luNames = params.getLUNames();
            if (protocolControllers.length < 1) {
                mLogger.info("ControllerConfigurationService:HidePaths - Returning \"Invalid Parameter\" because no protocolController was specified");
                retVal = 5;
            } else if (1 != protocolControllers.length) {
                retVal = 5;
                mLogger.log(Level.SEVERE, "ControllerConfigurationService:HidePaths - Returning \"Invalid Parameter\"  because {0} ProtocolControllers were  passed in but this function only supports 1", protocolControllers.length);
            } else if (!this.mSCSIProtocolControllerInstrumentation.instanceExists(protocolControllers[0])) {
                retVal = 5;
                mLogger.info("ControllerConfigurationService:HidePaths - Returning \"Invalid Parameter\"  because the specified ProtocolController doesn't exists");
            } else if (initiatorPortIDs.length == 0 && luNames.length == 0 && targetPortIDs.length == 0) {
                retVal = 5;
                mLogger.info("ControllerConfigurationService:HidePaths - Returning \"Invalid Parameter\"  because there were no LUNames, TargetPorts or Initiator Ports specified");
            }
            short[] portAndHostValues = null;
            short[] luNum = new short[luNames.length];
            FCPort fcPort = null;
            if (0 == retVal) {
                try {
                    portAndHostValues = ProviderLibs.getPortAndHostFromProtocolController(protocolControllers[0]);
                    if (null == portAndHostValues) {
                        retVal = 5;
                        mLogger.info("ControllerConfigurationService:HidePaths - Returning \"Invalid Parameter\" because provider cannot determine port and hostgroup values from protocolController: " + Arrays.toString(protocolControllers));
                    } else if (256 < portAndHostValues[0] || 255 < portAndHostValues[1]) {
                        mLogger.info("ControllerConfigurationService:HidePaths - Returning \"Invalid Parameter\" because one of the following is false to many ports: " + (portAndHostValues[0] > 256) + ", to many host groups: " + (portAndHostValues[1] > 255));
                        retVal = 5;
                    }
                    if (0 == retVal) {
                        retVal = this.validateInitiators4Hidepaths(device, initiatorPortIDs, portAndHostValues, (CIMObjectPath)protocolControllers[0]);
                    }
                    if (0 == retVal) {
                        retVal = this.validateLUNNames4HidePaths(device, luNames, luNum, portAndHostValues);
                    }
                }
                catch (WBEMException we) {
                    retVal = 4;
                    mLogger.info("ControllerConfigurationService:HidePaths - Returning \"Failed\" because and exception was thrown when verifying the specified Protocol Controller exists:\n" + (Object)((Object)we));
                }
            }
            if (0 == retVal && targetPortIDs.length > 0) {
                if (StorageHardwareIDs.isIDHostWWN(targetPortIDs[0])) {
                    fcPort = FCPort.find(targetPortIDs[0], FCPort.PortTypeRequested.OPEN, device.getRMIObject());
                } else {
                    int[] decoded = iSCSIProtocolEndpointInstrumentation.decodeName(targetPortIDs[0]);
                    fcPort = FCPort.find((short)decoded[0], FCPort.PortTypeRequested.iSCSI, device.getRMIObject());
                }
                if (null == fcPort || fcPort.getPort() != portAndHostValues[0]) {
                    mLogger.info("ControllerConfigurationService:HidePaths - Returning \"Invalid Target Port ID\" because specified Target Port is invalid: " + targetPortIDs[0]);
                    retVal = 4099;
                } else if (fcPort.getPortkind() == 7 || fcPort.getPortkind() == 8) {
                    mLogger.info("ControllerConfigurationService:HidePaths - Returning \"Invalid Target Port ID\" because specified Target Port is a MainFrame port: " + targetPortIDs[0]);
                    retVal = 4099;
                }
            }
            if (0 == retVal) {
                ExposeHidePaths data = new ExposeHidePaths(device.getSerialNumber(), mHandle.getProperty("javax.wbem.provider.Principal"), pOp.getHost(), pOp, fcPort, portAndHostValues[0], portAndHostValues[1], initiatorPortIDs, null, luNum, (CIMObjectPath[])protocolControllers, null, -1, false);
                CIM_ConcreteJob job = data.submitJob();
                if (job != null) {
                    mLogger.log(Level.INFO, "Job created: {0}, Params {1}", new Object[]{job.getInstanceID(), data.toString()});
                    CIMObjectPath coPath = job.getCIMObjectPath(pOp);
                    pOutArgs[0] = new CIMArgument("Job", new CIMDataType("CIM_ConcreteJob"), (Object)coPath);
                    retVal = 4096;
                } else {
                    retVal = 4;
                }
            }
        }
        catch (Throwable th) {
            retVal = 4;
            mLogger.log(Level.SEVERE, "ControllerConfigurationService:HidePaths - Returning \"Failed\" because exception was caught", th);
        }
        return new UnsignedInteger32((long)retVal);
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        CIMProperty[] keys = retOP.getKeys();
        CIMProperty[] props = new CIMProperty[]{keys[0], keys[1], keys[2], keys[3], new CIMProperty("StartMode", CIMDataType.STRING_T, (Object)"Automatic", false), new CIMProperty("Started", CIMDataType.BOOLEAN_T, (Object)new Boolean(true), false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false), new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(2)}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)mClassName, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)mClassName, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)mClassName, false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_ControllerConfigurationService");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_ControllerConfigurationService", true), new CIMProperty("Name", CIMDataType.STRING_T, (Object)mClassName, true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)rmiObj.getSMISMappingContainer().getStorageSystemName(), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_ControllerConfigurationService", keys, op.getXmlSchemaName());
    }

    private ResourceGroupInfo getFCPortResourceGroup(FCPort fcPort) throws Exception {
        ResourceGroupInfo rsg = ResourceGroupInfo.find(fcPort);
        if (null == rsg) {
            throw new Exception("unable to find resource group for port: " + fcPort);
        }
        return rsg;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            String sysNameVal;
            String name;
            String sccName;
            String ccName;
            String string = ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
            if (null == ccName || !ccName.equals("HITACHI_ControllerConfigurationService")) {
                throw new WBEMException(6, op.toString());
            }
            String string2 = sccName = null != op.getKey("SystemCreationClassName") ? (String)op.getKey("SystemCreationClassName").getValue() : null;
            if (null == sccName || !sccName.equals("HITACHI_StorageSystem")) {
                throw new WBEMException(6, op.toString());
            }
            String string3 = name = null != op.getKey("Name") ? (String)op.getKey("Name").getValue() : null;
            if (null == name || !name.equals(mClassName)) {
                throw new WBEMException(6, op.toString());
            }
            String ssName = device.getStorageSystemName();
            String string4 = sysNameVal = null != op.getKey("SystemName") && null != op.getKey("SystemName").getValue() ? (String)op.getKey("SystemName").getValue() : null;
            if (null == sysNameVal || !sysNameVal.equals(ssName)) {
                throw new WBEMException(6, op != null ? op.toString() : null);
            }
            return this.generateInstance(op, propertyList, device.getRMIObject());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    private short getLUNum(RMIObjectCache rmiObj, short pPort, short pHostGroup, short pLdkc, short pCUNum, short pLdevNum) {
        short ret = -1;
        try {
            if (null != rmiObj) {
                ClosableAddableIteratorCB<LUPathObject> callback = new ClosableAddableIteratorCB<LUPathObject>();
                LUPathObject.getLUPaths(rmiObj, callback, pPort);
                CloseableAddableIterator<LUPathObject> luPaths = callback.getWrappedCloseableAddableIter();
                while (luPaths.hasNext() && -1 == ret) {
                    LUPathObject luPath = (LUPathObject)luPaths.next();
                    if (pLdkc != luPath.getDKC() || pCUNum != luPath.getCU() || pLdevNum != luPath.getLDEV() || pHostGroup != luPath.getSHostGrp() || pPort != luPath.getSPort()) continue;
                    ret = luPath.getSLun();
                }
            }
        }
        catch (Throwable th) {
            // empty catch block
        }
        return ret;
    }

    private int getSLUNNums(int index, short[] luVals, short[] sLUNums, String deviceNumber, short port, short hostValues, RMIObjectMapping device) throws WBEMException {
        int retVal = 0;
        long deviceID = BaseDeviceNumber.makeUniqueDN(luVals[0], luVals[1], luVals[2]);
        DeviceNumber dn = null;
        try {
            dn = DeviceNumber.find(String.valueOf(deviceID), device.getRMIObject());
        }
        catch (WBEMException we) {
            // empty catch block
        }
        if (null != dn) {
            if (!ResourceRestriction.isVolumeUsageUsable(dn)) {
                mLogger.log(Level.SEVERE, "ControllerConfigurationService:ExposePaths - Returning \"Invalid Parameter\" because specified volume ({0}) usage is {1}", new Object[]{dn.getDn(), dn.getUsageValue()});
                retVal = 5;
            } else if (dn.isOpenVolume()) {
                short currentLUNum = this.getLUNum(device.getRMIObject(), port, hostValues, luVals[0], luVals[1], luVals[2]);
                if (-1 == currentLUNum) {
                    if (null == deviceNumber) {
                        sLUNums[index] = LUPathObject.getFreeLunNumber(device.getSerialNumber(), port, hostValues);
                    } else {
                        sLUNums[index] = Short.parseShort(deviceNumber, 16);
                        if (LUPathObject.isLunUsed(device.getSerialNumber(), port, hostValues, sLUNums[index])) {
                            mLogger.info("ControllerConfigurationService:ExposePaths - LUNum \"" + Arrays.toString(sLUNums) + "\" is already " + "being used on port \"" + port + "\"");
                            retVal = 4102;
                        }
                    }
                    if (0 == retVal && (256 < port || 255 < hostValues || 2048 < sLUNums[index])) {
                        mLogger.log(Level.SEVERE, "ControllerConfigurationService: ExposedPaths returning invalid parameter port value is to large: {0} or has too many HostGroups {1} or has too many luns: {2}", new Object[]{256 < port, 255 < hostValues, 2048 < sLUNums[index]});
                        retVal = 5;
                    }
                }
            } else {
                mLogger.log(Level.SEVERE, "ControllerConfigurationService:ExposePaths - Returning \"Invalid Parameter\" because volume with ldkc: {0}, cu: {1}, ldev: {2} refers to a non-OPEN volume.", new Object[]{luVals[0], luVals[1], luVals[2]});
                retVal = 5;
            }
        }
        return retVal;
    }

    public Object invokeMethod(CIMObjectPath op, String methodName, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        try {
            if (methodName.equalsIgnoreCase("ExposePaths")) {
                return this.extrinsic_ExposePaths(op, inArgs, outArgs);
            }
            if (methodName.equalsIgnoreCase("HidePaths")) {
                return this.extrinsic_HidePaths(op, inArgs, outArgs);
            }
            if (methodName.equalsIgnoreCase("ExposePathsWithNameAndHostType")) {
                return this.extrinsic_ExposePaths(op, inArgs, outArgs);
            }
            if ("DeleteProtocolController".equalsIgnoreCase(methodName)) {
                return this.extrinsic_DeleteProtocolController(op, inArgs, outArgs);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(17, op.getObjectName() + " does not support the method: " + methodName);
    }

    private boolean isValidInitTargetCombo(CIMObjectPath protocolController, String initiatorPortID) {
        boolean ret = false;
        if (null != protocolController && null != initiatorPortID) {
            CIMProperty cpDeviceID = protocolController.getKey("DeviceID");
            CIMProperty cpSystemName = protocolController.getKey("SystemName");
            if (null != cpDeviceID && null != cpDeviceID.getValue() && null != cpSystemName && null != cpSystemName.getValue()) {
                String authPrivInstanceID = (String)cpSystemName.getValue() + "." + (String)cpDeviceID.getValue() + "." + initiatorPortID;
                CIMProperty[] authPrivKeys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)authPrivInstanceID, true)};
                CIMObjectPath opAuthPriv = new CIMObjectPath(protocolController.getScheme(), protocolController.getHost(), protocolController.getPort(), protocolController.getNamespace(), "HITACHI_AuthorizedPrivilege", authPrivKeys, protocolController.getXmlSchemaName());
                try {
                    ret = this.mAuthorizedPrivilegeInstrumentation.instanceExists(opAuthPriv);
                }
                catch (WBEMException we) {
                    mLogger.log(Level.WARNING, "Caught exception trying to get instance of CIM_AuthorizedPrivilege: " + opAuthPriv, we);
                }
            }
        }
        return ret;
    }

    private int populatePortMap(Set<String> initPortMap, String[] initiatorPortIDs) {
        int retVal = 0;
        Boolean isFC = null;
        for (String initiatorPortID : initiatorPortIDs) {
            boolean isValidWWN = StorageHardwareIDs.isIDHostWWN(initiatorPortID);
            if (null == isFC) {
                isFC = new Boolean(isValidWWN);
            }
            boolean isValidiSCSIName = StorageHardwareIDs.isIDiSCSIName(initiatorPortID);
            if (!isValidWWN && !isValidiSCSIName) {
                retVal = 4098;
                mLogger.severe("ControllerConfigurationService:ExposePaths - Returning \"Invalid Initiator Port ID\" because one of the specified Initiator ports, " + initiatorPortID + ", is not a valid HostWWN name");
                break;
            }
            if (isFC != isValidWWN) {
                retVal = 4098;
                initPortMap.clear();
                mLogger.log(Level.SEVERE, "ControllerConfigurationService:ExposePaths - Returning \"Invalid Initiator Port ID\" because one of the specified Initiator ports, {0} is {1}FC but previous ports are {2}FC. Initiators can not be mixed.", new Object[]{initiatorPortID, isFC == false ? "" : "not ", isFC != false ? "" : "not "});
                break;
            }
            initPortMap.add(initiatorPortID);
        }
        return retVal;
    }

    private int processLUNames(RMIObjectMapping device, String[] luNames, String[] deviceNumbers, short[] sLUNums, short[][] luValsArray, short[] portAndHostValues) throws WBEMException {
        int retVal = 0;
        for (int idx = 0; idx < luNames.length; ++idx) {
            short[] luVals = null;
            try {
                if (luNames[idx].substring(luNames[idx].length() - 4).equalsIgnoreCase("FFFF")) {
                    mLogger.severe("ControllerConfigurationService:ExposePaths - Returning \"Invalid Logical Unit ID\" because ldkc, cu and ldev values from luNames[{0}] represents a non-virtualized volume: " + luNames[idx]);
                    retVal = 4097;
                } else {
                    luVals = ControllerConfigurationServiceInstrumentation.validateLUName(device, luNames[idx]);
                    if (null != luVals && null != deviceNumbers) {
                        retVal = this.getSLUNNums(idx, luVals, sLUNums, 0 == deviceNumbers.length ? null : deviceNumbers[idx], portAndHostValues[0], portAndHostValues[1], device);
                    } else {
                        mLogger.log(Level.SEVERE, "ControllerConfigurationService:ExposePaths - Returning \"Invalid Logical Unit ID\" because ldkc, cu and ldev values could not be determined from luNames value : ", luNames[idx]);
                        retVal = 4097;
                    }
                }
            }
            catch (NumberFormatException e) {
                mLogger.severe("ControllerConfigurationService:ExposePaths - Returning \"Invalid Parameter\" because of an invaid device number value: " + (null != deviceNumbers ? deviceNumbers[idx] : "null"));
                retVal = 5;
            }
            if (0 != retVal) break;
            luValsArray[idx] = luVals;
        }
        return retVal;
    }

    private int validateHostGroupInitiators(RMIObjectCache rmiObj, short[] portAndHostValues, String[] initiatorPortIDs, Set<String> initPortMap, FCPort fcPort) throws WBEMException {
        int retVal = this.verifySpaceForInitator(initiatorPortIDs.length, portAndHostValues);
        if (0 == retVal) {
            FCPort localFCPort;
            if (null == fcPort) {
                localFCPort = FCPort.find(portAndHostValues[0], FCPort.PortTypeRequested.ALL, rmiObj);
                if (null == localFCPort) {
                    throw new WBEMException("Specified Port and Host are invalid" + Arrays.toString(portAndHostValues));
                }
            } else {
                localFCPort = fcPort;
            }
            retVal = !localFCPort.isRequestedType(FCPort.PortTypeRequested.iSCSI) ? this.validateWWNsNotExposed(rmiObj, portAndHostValues, initPortMap, initiatorPortIDs) : this.validateISCSINamesNotExposed(rmiObj, portAndHostValues[0], portAndHostValues[1], initPortMap, initiatorPortIDs);
        }
        return retVal;
    }

    private int validateInitiators4Hidepaths(RMIObjectMapping device, String[] initiatorPortIDs, short[] portAndHostValues, CIMObjectPath protocolController) {
        int retVal = 0;
        Boolean isFC = null;
        for (int x = 0; x < initiatorPortIDs.length && retVal == 0; ++x) {
            String initiatorPortID = initiatorPortIDs[x];
            boolean isValidWWN = StorageHardwareIDs.isIDHostWWN(initiatorPortID);
            if (null == isFC) {
                isFC = new Boolean(isValidWWN);
            }
            boolean isValidISCSIName = StorageHardwareIDs.isIDiSCSIName(initiatorPortID);
            if (!isValidWWN && !isValidISCSIName) {
                retVal = 4098;
                mLogger.info("ControllerConfigurationService:HidePaths - Returning \"Invalid Initiator Port ID\" because one of the specified Initiator ports, " + initiatorPortID + ", is not a valid HostWWN/iSCSI name");
                continue;
            }
            if (isFC != isValidWWN) {
                retVal = 4098;
                mLogger.log(Level.SEVERE, "ControllerConfigurationService:HidePaths - Returning \"Invalid Initiator Port ID\" because one of the specified Initiator ports, {0}, is {1}FC but previous ports are {2}FC. Initiators can not be mixed.", new Object[]{initiatorPortID, isFC == false ? "" : "not ", isFC != false ? "" : "not "});
                continue;
            }
            if (!StorageHardwareIDs.getStorageHardwareIDs().isIDAssigned(device, initiatorPortID)) {
                retVal = 4098;
                mLogger.info("ControllerConfigurationService:HidePaths - Returning \"Invalid Initiator Port ID\" because one of the specified Initiator ports, " + initiatorPortID + ", is not an assigned initiator port");
                continue;
            }
            if (this.isValidInitTargetCombo(protocolController, initiatorPortID)) continue;
            retVal = 4100;
            mLogger.info("ControllerConfigurationService:HidePaths - Returning \"Target/Initiator combination not exposed\" because one of the specified Initiator ports, " + initiatorPortID + ", is not associated " + "to the specified " + "SCSIProtocolController");
        }
        return retVal;
    }

    private int validateISCSINamesNotExposed(RMIObjectCache rmiObj, short portID, short hostValues, Set<String> initPortMap, String[] initiatorPortIDs) throws WBEMException {
        int retVal = 0;
        ISCSITargetPort port = ISCSITargetPort.find(rmiObj, portID);
        if (null == port) {
            throw new WBEMException("Unable to find TargetPort " + portID);
        }
        ISCSITargetPort.ISCSITarget target = port.getTarget(hostValues);
        if (null == target) {
            throw new WBEMException("Unable to find target " + hostValues + " in TargetPort " + port);
        }
        List<ISCSITargetPort.RemoteiSCSIName> rNames = target.getRemoteNames();
        for (ISCSITargetPort.RemoteiSCSIName rName : rNames) {
            if (!initPortMap.contains(rName.getName())) continue;
            mLogger.severe("ControllerConfigurationService:ExposedPaths - Returning \"Target Initiator Combination Already Exposed\" because one of the specified Initiator ports, " + rName + ", is already assigned to iSCSI port  " + portID);
            retVal = 4101;
        }
        return retVal;
    }

    private int validateLuNamesDeviceAccessesandDeviceNumbers(String[] luNames, UnsignedInteger16[] deviceAccesses, String[] deviceNumbers) {
        int retVal = 0;
        if (luNames.length != deviceNumbers.length && deviceNumbers.length != 0) {
            retVal = 5;
            mLogger.log(Level.SEVERE, "ControllerConfigurationService:ExposePaths - Returning \"Invalid Parameter\" because the number of LUNames, {0}, passed in was not equal to the number of DeviceNumbers, {1}, that were passed in", new Object[]{luNames.length, deviceNumbers.length});
        } else if (luNames.length != deviceAccesses.length && deviceAccesses.length != 0) {
            retVal = 5;
            mLogger.log(Level.SEVERE, "ControllerConfigurationService:ExposePaths - Returning \"Invalid Parameter\" because the number of LUNames, {0}, passed in was not equal to the number of DeviceAccessess, {1}, that were passed in", new Object[]{luNames.length, deviceAccesses.length});
        } else if (null != deviceAccesses) {
            for (UnsignedInteger16 access : deviceAccesses) {
                if (null == access || access.intValue() == 2) continue;
                mLogger.log(Level.SEVERE, "ControllerConfigurationService:ExposePaths - The only valid DeviceAccess value is {0} but a value of {1} was specified.", new Object[]{2, access});
                retVal = 4100;
                break;
            }
        }
        return retVal;
    }

    private int validateLUNNames4HidePaths(RMIObjectMapping device, String[] luNames, short[] luNum, short[] portAndHostValues) throws WBEMException {
        int retVal = 0;
        for (int i = 0; i < luNames.length && retVal == 0; ++i) {
            short[] luVals = null;
            try {
                luVals = ControllerConfigurationServiceInstrumentation.validateLUName(device, luNames[i]);
                if (null != luVals) {
                    luNum[i] = this.getLUNum(device.getRMIObject(), portAndHostValues[0], portAndHostValues[1], luVals[0], luVals[1], luVals[2]);
                    if (-1 != luNum[i]) {
                        if (luNum[i] < 2048) {
                            long deviceID = BaseDeviceNumber.makeUniqueDN(luVals[0], luVals[1], luVals[2]);
                            DeviceNumber dn = null;
                            try {
                                dn = DeviceNumber.find(String.valueOf(deviceID), device.getRMIObject());
                            }
                            catch (WBEMException we) {
                                // empty catch block
                            }
                            if (null != dn) {
                                if (!ResourceRestriction.isVolumeUsable(dn)) {
                                    mLogger.severe("ControllerConfigurationService:HidePaths - Returning \"Invalid Parameter\" because specified LUName (" + luNames[i] + ") belongs to a restricted pool");
                                    retVal = 5;
                                    continue;
                                }
                                if (dn.isOpenVolume()) continue;
                                mLogger.info("ControllerConfigurationService:HidePaths - Returning \"Invalid Parameter\" because secified LUName (" + luNames[i] + ") is not OPEN ");
                                retVal = 5;
                                continue;
                            }
                            mLogger.info("ControllerConfigurationService:HidePaths - Returning \"Invalid Parameter\" because secified LUName (" + luNames[i] + ") does not " + "reference a valid LDev");
                            retVal = 5;
                            continue;
                        }
                        mLogger.info("ControllerConfigurationService:HidePaths - Returning \"Invalid Parameter\" because to many luns for hostgroup(" + portAndHostValues[1] + "). Max allowed: " + 2048 + ", number of luns: " + Arrays.toString(luNum));
                        retVal = 5;
                        continue;
                    }
                    mLogger.info("ControllerConfigurationService:HidePaths - Returning \"Invalid Logical Unit ID\" because ldkc, cu and ldev values had no LUParths");
                    retVal = 4097;
                    continue;
                }
                mLogger.info("ControllerConfigurationService:HidePaths - Returning \"Invalid Logical Unit ID\" because ldkc, cu and ldev values could not be determined from luNames value : " + luNames[i]);
                retVal = 4097;
                continue;
            }
            catch (NumberFormatException e) {
                mLogger.info("ControllerConfigurationService:HidePaths - Returning \"Invalid Logical Unit ID\" because cu and ldev values could not be determined from luNames value : " + luNames[i]);
                retVal = 4097;
            }
        }
        return retVal;
    }

    private int validateProtocolController(CIMObjectPath[] protocolControllers, String[] initiatorPortIDs, String[] luNames) {
        int retVal = 0;
        if (0 == initiatorPortIDs.length && 0 == luNames.length) {
            mLogger.severe("ControllerConfigurationService:ExposePaths - Returning \"Invalid Parameter\"  because a ProtocolController was specified but no LUNames or InitiatorPortIDs were specified.  1 (or both) are required");
            retVal = 5;
        }
        if (0 == retVal) {
            try {
                if (null != protocolControllers && protocolControllers.length > 0 && !this.mSCSIProtocolControllerInstrumentation.instanceExists(protocolControllers[0])) {
                    retVal = 5;
                    mLogger.log(Level.SEVERE, "ControllerConfigurationService:ExposePaths - Returning \"Invalid Parameter\"  because the specified ProtocolController doesn't exists: {0}", null != protocolControllers ? protocolControllers[0] : "no protocol controllers");
                }
            }
            catch (WBEMException we) {
                retVal = 4;
                mLogger.severe("ControllerConfigurationService:ExposePaths - Returning \"Failed\" because and exception was thrown when verifying the specified Protocol Controller exists:\n" + (Object)((Object)we));
            }
        }
        return retVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int validateResourceGroup(RMIObjectCache rmiObj, FCPort fcPort, short port, short hostGrp, short[][] luValsArray) {
        int ret = 0;
        try {
            ResourceGroupInfo portRsg;
            if (null != fcPort) {
                portRsg = this.getFCPortResourceGroup(fcPort);
            } else {
                if (-1 == port) throw new Exception("can not validate: FCPort: " + fcPort + ", port: " + port + ", hostGrp: " + hostGrp);
                FCPort tmpPort = FCPort.find(port, FCPort.PortTypeRequested.ALL, rmiObj);
                if (null == tmpPort) throw new Exception("unable to find FCPort for port ID: " + port);
                portRsg = this.getFCPortResourceGroup(tmpPort);
            }
            short[][] arr$ = luValsArray;
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                short[] luVals = arr$[i$];
                long dnNum = BaseDeviceNumber.makeUniqueDN(luVals[0], luVals[1], luVals[2]);
                String dnStr = Long.toString(dnNum);
                DeviceNumber dn = DeviceNumber.find(dnStr, false, rmiObj);
                if (null == dn) throw new Exception("no Volume with DN: " + dnStr);
                ResourceGroupInfo ldevRsg = ResourceGroupInfo.find(dn);
                if (null == ldevRsg || ldevRsg.getId() != portRsg.getId()) {
                    throw new Exception("ldev(" + dnStr + ") resource group (" + (null == ldevRsg ? "null" : Integer.valueOf(ldevRsg.getId())) + ") does not match port(" + (null != fcPort ? fcPort.getPort() : port) + ") resource group(" + portRsg.getId() + ")");
                }
                mLogger.log(Level.FINE, "DN({0}) resource group({1}) matches FCPort({2}) resource group({3})", new Object[]{dn.getDn(), ldevRsg.getId(), null != fcPort ? fcPort.getControlID() : port, portRsg.getId()});
                ++i$;
            }
            return ret;
        }
        catch (Throwable t) {
            mLogger.log(Level.SEVERE, "ValidateResourceGroup: " + t.getMessage(), t);
            return 5;
        }
    }

    private int validateTargetPortIDs(RMIObjectCache rmiObj, String[] targetPortIDs, FCPort[] outPort, short[] outHostGrp) throws WBEMException {
        boolean isFC;
        if (null == outPort || outPort.length < 1) {
            throw new WBEMException("Passed in FCPort must be an array with room for at least 1 element");
        }
        if (null == outHostGrp || outHostGrp.length < 1) {
            throw new WBEMException("Passed in short must be an array with room for at least 1 element");
        }
        int retVal = 0;
        FCPort fcPort = null;
        int hostGrp = -1;
        if (1 != targetPortIDs.length) {
            mLogger.severe("ControllerConfigurationService:ExposePaths - Returning \"Invalid Parameter\" because no protocol controller was specified and there was either 0 or more than 1 TargetPortID specified");
            return 5;
        }
        if (StorageHardwareIDs.isIDHostWWN(targetPortIDs[0])) {
            fcPort = FCPort.find(targetPortIDs[0], FCPort.PortTypeRequested.OPEN, rmiObj);
            isFC = true;
        } else if (StorageHardwareIDs.isIDiSCSIName(targetPortIDs[0])) {
            int[] decodedVals = iSCSIProtocolEndpointInstrumentation.decodeName(targetPortIDs[0]);
            fcPort = FCPort.find((short)decodedVals[0], FCPort.PortTypeRequested.iSCSI, rmiObj);
            isFC = false;
        } else {
            fcPort = null;
            isFC = false;
        }
        if (null == fcPort) {
            mLogger.severe("ControllerConfigurationService:ExposePaths - Returning \"Invalid Target Port ID\" because specified Target Port is invalid: " + targetPortIDs[0]);
            retVal = 4099;
        } else if (fcPort.getPortkind() == 7 || fcPort.getPortkind() == 8) {
            mLogger.severe("ControllerConfigurationService:ExposePaths - Returning \"Invalid Target Port ID\" because specified Target Port is a MainFrame port: " + targetPortIDs[0]);
            retVal = 4099;
        } else if (fcPort.getPort() < 256) {
            try {
                if (isFC) {
                    hostGrp = PortandHostGroupInfo.getFreeHostGroup(rmiObj, fcPort.getPort(), mLogger);
                } else {
                    ISCSITargetPort targetPort = ISCSITargetPort.find(rmiObj, fcPort.getPort());
                    if (null != targetPort) {
                        hostGrp = targetPort.getAvailableTargetID();
                    }
                }
            }
            catch (Throwable t) {
                if (t instanceof WBEMException) {
                    throw (WBEMException)t;
                }
                throw new WBEMException(1, "" + t, null, t);
            }
            if (hostGrp == -1) {
                mLogger.severe("ControllerConfigurationService:ExposePaths - Returning \"Invalid Target Port ID\" because it could not finda HostGroup/iSCSI Target on specified Port: " + targetPortIDs[0]);
                retVal = 4099;
            }
        } else {
            mLogger.severe("ControllerConfigurationService:ExposePaths - Returning \"Invalid Target Port ID\" because specified Target Port is larger then allowed: " + fcPort.getPort() + ", max: " + 256);
            retVal = 4099;
        }
        if (0 == retVal) {
            outPort[0] = fcPort;
            outHostGrp[0] = hostGrp;
        }
        return retVal;
    }

    private int validateWWNsNotExposed(RMIObjectCache rmiObj, short[] portAndHostValues, Set<String> initPortMap, String[] initiatorPortIDs) throws WBEMException {
        PortandHostGroupInfo phgi;
        int retVal = 0;
        CommonClassAsList<PortandHostGroupInfo> callback = new CommonClassAsList<PortandHostGroupInfo>();
        PortandHostGroupInfo.getPortandHostGroupInfo(rmiObj, callback, null, null, String.valueOf(portAndHostValues[0]), null, null, true, null, false);
        LinkedList<PortandHostGroupInfo> phgiList = callback.getReturnValue();
        callback = null;
        while (0 == retVal && null != (phgi = phgiList.poll())) {
            Object[] hostWWNs = phgi.getHostWWNs();
            if (phgi.getHostgroupID() == portAndHostValues[1]) {
                retVal = this.verifySpaceForInitator(initiatorPortIDs.length + hostWWNs.length, new short[]{-1, -1});
            }
            for (int x = 0; x < hostWWNs.length && 0 == retVal; ++x) {
                String hostWWN = hostWWNs[x];
                if (!initPortMap.contains(hostWWN)) continue;
                mLogger.severe("ControllerConfigurationService:ExposedPaths - Returning \"Target Initiator Combination Already Exposed\" because one of the specified Initiator ports, " + Arrays.toString(hostWWNs) + ", is already assigned to port  " + portAndHostValues[0]);
                retVal = 4101;
            }
        }
        return retVal;
    }

    private int verifyInitiatorsMatchPort(RMIObjectCache rmiObj, String initiatorID, FCPort fcPort, short port) throws WBEMException {
        int portType;
        int retVal = 0;
        boolean isFC = StorageHardwareIDs.isIDHostWWN(initiatorID);
        if (null == fcPort) {
            FCPort localFCPort = FCPort.find(port, FCPort.PortTypeRequested.ALL, rmiObj);
            if (null != localFCPort) {
                portType = localFCPort.getByPortKindNo();
            } else {
                portType = -1;
                mLogger.log(Level.SEVERE, "ControllerConfigurationService: Returning \"Invalid Target Port\"  because we could not find a port with id {0} ", port);
                retVal = 4099;
            }
        } else {
            portType = fcPort.getByPortKindNo();
        }
        if (0 == retVal && (isFC && 5 == portType || !isFC && 5 != portType)) {
            mLogger.log(Level.SEVERE, "ControllerConfigurationService: Returning \"Invalid Target Port\"  because the port, {0}, is {1} and the initiator type is ", new Object[]{port, 5 == portType ? "iSCSI" : "FC", isFC ? "FC" : "iSCSI"});
            retVal = 4099;
        }
        return retVal;
    }

    private int verifySpaceForInitator(int numInitiatorPortIDs, short[] portAndHostValues) {
        int retVal = 0;
        if (numInitiatorPortIDs > 255) {
            mLogger.severe("ControllerConfigurationService:ExposedPaths - Returning \"Invalid Parameter\" because the total number of initiators, " + numInitiatorPortIDs + ", to the hostgroup is to large. " + "Maximum of initiators per hostgroup is: " + 255);
            retVal = 5;
        }
        if (0 == retVal && -1 != portAndHostValues[0] && 256 < portAndHostValues[0] || 255 < portAndHostValues[1]) {
            mLogger.severe("ControllerConfigurationService: ExposedPaths returning invalid parameter port value to large: " + (256 < portAndHostValues[0]) + ", Too many HostGroups: " + (255 < portAndHostValues[1]));
            retVal = 5;
        }
        return retVal;
    }

    private class pathParameters {
        private String[] mDeviceNumbers;
        private String[] mInitiatorPortIDs;
        private UnsignedInteger16[] mDeviceAccesses;
        private String[] mLUNames;
        private CIMObjectPath[] mProtocolControllers;
        private String[] mTargetPortIDs;
        private String mElementName;
        private CIMObjectPath mClientSettingData;

        pathParameters(boolean exposePaths, CIMArgument<?>[] inArgs) throws WBEMException {
            for (CIMArgument<?> arg : inArgs) {
                if (null == arg) continue;
                String argName = arg.getName();
                if ("LUNames".equalsIgnoreCase(argName)) {
                    this.mLUNames = (String[])arg.getValue();
                    continue;
                }
                if ("InitiatorPortIDs".equalsIgnoreCase(argName)) {
                    this.mInitiatorPortIDs = (String[])arg.getValue();
                    continue;
                }
                if ("TargetPortIDs".equalsIgnoreCase(argName)) {
                    this.mTargetPortIDs = (String[])arg.getValue();
                    continue;
                }
                if ("ProtocolControllers".equals(argName)) {
                    this.mProtocolControllers = (CIMObjectPath[])arg.getValue();
                    continue;
                }
                if (exposePaths && "DeviceNumbers".equalsIgnoreCase(argName)) {
                    this.mDeviceNumbers = (String[])arg.getValue();
                    continue;
                }
                if (exposePaths && "DeviceAccesses".equalsIgnoreCase(argName)) {
                    this.mDeviceAccesses = (UnsignedInteger16[])arg.getValue();
                    continue;
                }
                if (exposePaths && "ElementName".equalsIgnoreCase(argName)) {
                    this.mElementName = (String)arg.getValue();
                    continue;
                }
                if (exposePaths && "ClientSettingData".equalsIgnoreCase(argName)) {
                    this.mClientSettingData = (CIMObjectPath)arg.getValue();
                    continue;
                }
                throw new WBEMException(4, argName + " is not a valid parameter");
            }
        }

        public CIMObjectPath getClientSettingData() {
            return this.mClientSettingData;
        }

        public UnsignedInteger16[] getDeviceAccesses() {
            return null != this.mDeviceAccesses ? this.mDeviceAccesses : new UnsignedInteger16[]{};
        }

        public String[] getDeviceNumbers() {
            return null != this.mDeviceNumbers ? this.mDeviceNumbers : new String[]{};
        }

        public String getElementName() {
            return this.mElementName;
        }

        public String[] getInitiatorPortIDs() {
            return null != this.mInitiatorPortIDs ? this.mInitiatorPortIDs : new String[]{};
        }

        public String[] getLUNames() {
            return null != this.mLUNames ? this.mLUNames : new String[]{};
        }

        public CIMObjectPath[] getProtocolControllers() {
            return null != this.mProtocolControllers ? this.mProtocolControllers : new CIMObjectPath[]{};
        }

        public String[] getTargetPortIDs() {
            return null != this.mTargetPortIDs ? this.mTargetPortIDs : new String[]{};
        }
    }
}

