/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.DiskDriveStatus;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public class DiskExtentInstrumentation
extends BaseInstrumentation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
        try {
            Integer iRDevNum;
            Integer iCDevNum;
            int expCDevNum = -1;
            int expRDevNum = -1;
            Integer n = iCDevNum = null != expectedValues ? (Integer)expectedValues.get("CDevNum") : null;
            if (null != iCDevNum) {
                expCDevNum = iCDevNum;
            }
            Integer n2 = iRDevNum = null != expectedValues ? (Integer)expectedValues.get("RDevNum") : null;
            if (null != iRDevNum) {
                expRDevNum = iRDevNum;
            }
            for (RMIObjectMapping device : devices) {
                ClosableAddableIteratorCB<PDEVInfoEntry> callback = new ClosableAddableIteratorCB<PDEVInfoEntry>();
                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, expCDevNum, expRDevNum);
                CloseableAddableIterator<PDEVInfoEntry> pdevs = callback.getWrappedCloseableAddableIter();
                while (pdevs.hasNext()) {
                    CIMObjectPath retOP;
                    PDEVInfoEntry pdev = (PDEVInfoEntry)pdevs.next();
                    if (null != refInfo) {
                        retOP = this.generateObjectPath(op, pdev);
                        refInfo.addReference(iter, retOP);
                        continue;
                    }
                    if (isObjectPath) {
                        retOP = this.generateObjectPath(op, pdev);
                        iter.add(retOP);
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, pdev));
                }
            }
        }
        catch (WBEMException we) {
            iter.setException(we);
            iter.close();
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, "Exception during enum operation: " + th, null, th);
            iter.setException(we);
            iter.close();
        }
        finally {
            Object callback = null;
            if (iter != null && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        PDEVInfoEntry infoEntry = (PDEVInfoEntry)o[0];
        try {
            String deviceID = infoEntry.getDeviceID();
            String elementName = "DiskExtent:" + deviceID;
            BigInteger capInBytes = infoEntry.getHddDiskCapacityInBytes();
            UnsignedInteger64 cpvNumOfBlocks = new UnsignedInteger64(capInBytes.divide(BigInteger.valueOf(512L)));
            CIMProperty[] keys = retOP.getKeys();
            DiskDriveStatus status = DiskDriveStatus.getStatus(infoEntry.getHddStatus());
            CIMProperty[] retProps = new CIMProperty[]{keys[0], keys[1], keys[2], keys[3], new CIMProperty("ConsistsOf", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false), new CIMProperty("DataOrganization", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("BlockSize", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_512, false), new CIMProperty("NumberOfBlocks", CIMDataType.UINT64_T, (Object)cpvNumOfBlocks, false), new CIMProperty("ConsumableBlocks", CIMDataType.UINT64_T, (Object)cpvNumOfBlocks, false), new CIMProperty("SequentialAccess", CIMDataType.BOOLEAN_T, (Object)new Boolean(false), false), new CIMProperty("ExtentStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_SIX}, false), new CIMProperty("DeltaReservation", CIMDataType.UINT8_T, (Object)ProviderConstants.UINT8_100, false), new CIMProperty("Primordial", CIMDataType.BOOLEAN_T, (Object)new Boolean(true), false), new CIMProperty("Name", CIMDataType.STRING_T, (Object)deviceID, false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false), new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(status.getOpStatus())}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{status.getStatusDescr()}, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(status.getHealth()), false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)deviceID, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)deviceID, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)elementName, false), new CIMProperty("ExtentStripeLength", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ONE, false), new CIMProperty("ExtentDiscriminator", CIMDataType.STRING_ARRAY_T, (Object)new String[]{"SNIA:DiskDrive", "SNIA:Pool Component"}, false), this.getSVDeviceIDs(infoEntry)};
            return new CIMInstance(retOP, retProps).filterProperties(propList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        String systemName;
        ProviderLibs.validateVARArgs(new Class[]{PDEVInfoEntry.class}, o, "HITACHI_DiskExtent");
        PDEVInfoEntry infoEntry = (PDEVInfoEntry)o[0];
        String deviceID = infoEntry.getDeviceID();
        try {
            systemName = RMIObjectMapping.getRMIObjectMapping(infoEntry.getSerialNumber()).getStorageSystemName();
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_DiskExtent", true), new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)deviceID, true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)systemName, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_DiskExtent", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            int[] deviceIDValues;
            String ssName;
            String sysName;
            String deviceID = null != op.getKey("DeviceID") && null != op.getKey("DeviceID").getValue() ? (String)op.getKey("DeviceID").getValue() : null;
            String ccName = null != op.getKey("CreationClassName") && null != op.getKey("DeviceID").getValue() ? (String)op.getKey("CreationClassName").getValue() : null;
            String sccName = null != op.getKey("SystemCreationClassName") && null != op.getKey("DeviceID").getValue() ? (String)op.getKey("SystemCreationClassName").getValue() : null;
            String string = sysName = null != op.getKey("DeviceID") && null != op.getKey("SystemName").getValue() ? (String)op.getKey("SystemName").getValue() : null;
            if (null != deviceID && null != ccName && null != sccName && null != sysName && sysName.equals(ssName = device.getStorageSystemName()) && null != (deviceIDValues = PDEVInfoEntry.parseDeviceID(deviceID))) {
                PDEVInfoEntry infoEntry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1]);
                return this.generateInstance(op, propertyList, infoEntry);
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    private CIMProperty<String[]> getSVDeviceIDs(PDEVInfoEntry infoEntry) {
        String[] vals;
        CIMProperty ret = null;
        try {
            DeviceNumber dn;
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(infoEntry.getSerialNumber()).getRMIObject();
            CommonClassAsList<DeviceNumber> callback = new CommonClassAsList<DeviceNumber>();
            DeviceNumber.getDNs(rmiObj, callback, false, true, null, infoEntry.getFb4(), infoEntry.getPg(), -1);
            LinkedList<DeviceNumber> dns = callback.getReturnValue();
            callback = null;
            mLogger.log(Level.INFO, "Disk({0}) has {1} LDEVs on {2}.", new Object[]{infoEntry.getDeviceID(), dns.size(), infoEntry.getSerialNumber()});
            ArrayList<String> devIDs = new ArrayList<String>(dns.size());
            while ((dn = dns.poll()) != null) {
                devIDs.add(dn.getDNAsString());
            }
            vals = devIDs.toArray(new String[devIDs.size()]);
        }
        catch (Throwable t) {
            mLogger.log(Level.SEVERE, "An exception occurred while determining DiskExtent SVDeviceIDs - setting to null", t);
            vals = null;
        }
        ret = new CIMProperty("SVDeviceIDs", CIMDataType.STRING_ARRAY_T, vals, false);
        return ret;
    }
}

