/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class HostedImportedStoragePoolPrimordialInstrumentation
extends BaseAssocInstrumentation {
    protected HostedImportedStoragePoolPrimordialInstrumentation() {
        super("HITACHI_HostedImportedStoragePoolPrimordial", "HITACHI_StorageSystem", "GroupComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageSystemInstrumentation"), "HITACHI_ImportedStoragePoolPrimordial", "PartComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ImportedStoragePoolPrimordialInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_HostedImportedStoragePoolPrimordial".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                    if (isObjectPath) {
                        iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            for (RMIObjectMapping device : devices) {
                CIMObjectPath opStorageSystem = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath opHostedImportedStoragePoolPrimordial = this.getReference2Instrumentation().generateObjectPath(op, device.getRMIObject());
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, opStorageSystem, opHostedImportedStoragePoolPrimordial));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, opStorageSystem, opHostedImportedStoragePoolPrimordial));
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opHostedImportedStoragePoolPrimordial;
            String cpnStorageSystem = this.getReference1PropertyName();
            CIMObjectPath opStorageSystem = op.getKey(cpnStorageSystem) != null ? (CIMObjectPath)op.getKey(cpnStorageSystem).getValue() : null;
            String cpnImportedStoragePoolPrimordial = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = opHostedImportedStoragePoolPrimordial = op.getKey(cpnImportedStoragePoolPrimordial) != null ? (CIMObjectPath)op.getKey(cpnImportedStoragePoolPrimordial).getValue() : null;
            if (null != opHostedImportedStoragePoolPrimordial && null != opStorageSystem) {
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageSystem, "Name");
                String ssName = opStorageSystem.getKey("Name") != null && opStorageSystem.getKey("Name").getValue() != null ? (String)opStorageSystem.getKey("Name").getValue() : null;
                String cvImportedStoragePoolPrimordial = opHostedImportedStoragePoolPrimordial.getKey("InstanceID") != null && opHostedImportedStoragePoolPrimordial.getKey("InstanceID").getValue() != null ? (String)opHostedImportedStoragePoolPrimordial.getKey("InstanceID").getValue() : null;
                String importedStoragePoolPrimordialStorageSystemName = ProviderLibs.getAllButEndString(cvImportedStoragePoolPrimordial, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                if (null != ssName && null != importedStoragePoolPrimordialStorageSystemName && ssName.equals(importedStoragePoolPrimordialStorageSystemName) && ssName.equals(device.getStorageSystemName())) {
                    opStorageSystem = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                    opHostedImportedStoragePoolPrimordial = this.getReference2Instrumentation().generateObjectPath(op, device.getRMIObject());
                    return this.generateInstance(op, propertyList, opStorageSystem, opHostedImportedStoragePoolPrimordial);
                }
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean isObjectnameRef1;
            if (null != assocName && "HITACHI_HostedImportedStoragePoolPrimordial".equalsIgnoreCase(assocName.getObjectName()) && ((isObjectnameRef1 = objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName())) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName) || objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName))) {
                String prop2Examine = isObjectnameRef1 ? "Name" : "InstanceID";
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, prop2Examine);
                CIMObjectPath opStorageSystem = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                CIMObjectPath opHostedImportedStoragePoolPrimordial = this.getReference2Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(objectName, opStorageSystem, opHostedImportedStoragePoolPrimordial));
                } else {
                    iter.add(this.generateInstance(objectName, propertyList, opStorageSystem, opHostedImportedStoragePoolPrimordial));
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

