/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class HostedStorageHardwareIDManagementServiceInstrumentation
extends BaseAssocInstrumentation {
    protected HostedStorageHardwareIDManagementServiceInstrumentation() {
        super("HITACHI_HostedStorageHardwareIDManagementService", "HITACHI_StorageSystem", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageSystemInstrumentation"), "HITACHI_StorageHardwareIDManagementService", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageHardwareIDManagementServiceInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_HostedStorageHardwareIDManagementService".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                    if (isObjectPath) {
                        iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            for (RMIObjectMapping device : devices) {
                CIMObjectPath opStorageSystem = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath opStorageHardwareIDManagementService = this.getReference2Instrumentation().generateObjectPath(op, device.getRMIObject());
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, opStorageSystem, opStorageHardwareIDManagementService));
                    continue;
                }
                CIMInstance instAssoc = this.generateInstance(op, propertyList, opStorageSystem, opStorageHardwareIDManagementService);
                iter.add(instAssoc.filterProperties(propertyList));
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opStorageHardwareIDManagementService;
            String ssPropName = this.getReference1PropertyName();
            CIMObjectPath opStorageSystem = op.getKey(ssPropName) != null ? (CIMObjectPath)op.getKey(ssPropName).getValue() : null;
            String cpnStorageHardwareIDManagementService = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = opStorageHardwareIDManagementService = op.getKey(cpnStorageHardwareIDManagementService) != null ? (CIMObjectPath)op.getKey(cpnStorageHardwareIDManagementService).getValue() : null;
            if (null != opStorageHardwareIDManagementService && null != opStorageSystem) {
                String sysNameStorageHardwareIDManagementService;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageSystem, "Name");
                String ssName = opStorageSystem.getKey("Name") != null && opStorageSystem.getKey("Name").getValue() != null ? (String)opStorageSystem.getKey("Name").getValue() : null;
                String string = sysNameStorageHardwareIDManagementService = opStorageHardwareIDManagementService.getKey("SystemName") != null && opStorageHardwareIDManagementService.getKey("SystemName").getValue() != null ? (String)opStorageHardwareIDManagementService.getKey("SystemName").getValue() : null;
                if (null != ssName && null != sysNameStorageHardwareIDManagementService && ssName.equals(sysNameStorageHardwareIDManagementService) && ssName.equals(device.getStorageSystemName())) {
                    opStorageSystem = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                    opStorageHardwareIDManagementService = this.getReference2Instrumentation().generateObjectPath(op, device.getRMIObject());
                    CIMInstance ci = this.generateInstance(op, propertyList, opStorageSystem, opStorageHardwareIDManagementService);
                    return ci.filterProperties(propertyList);
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean isObjectnameRef1;
            if (null != assocName && "HITACHI_HostedStorageHardwareIDManagementService".equalsIgnoreCase(assocName.getObjectName()) && ((isObjectnameRef1 = objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName())) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName) || objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName))) {
                String pro2Examine = isObjectnameRef1 ? "Name" : "SystemName";
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, pro2Examine);
                CIMObjectPath opStorageSystem = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                CIMObjectPath opStorageHardwareIDManagementService = this.getReference2Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(objectName, opStorageSystem, opStorageHardwareIDManagementService));
                } else {
                    CIMInstance instAssoc = this.generateInstance(objectName, propertyList, opStorageSystem, opStorageHardwareIDManagementService);
                    iter.add(instAssoc.filterProperties(propertyList));
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

