/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMException;

public class LunMaskPrivilegeServiceInstrumentation
extends BaseInstrumentation {
    private static final String mServiceName = "HITACHI_LunMaskPrivilegeService".substring("HITACHI_".length());

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
            for (RMIObjectMapping device : devices) {
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, device.getRMIObject()));
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws WBEMException {
        try {
            ArrayList props = new ArrayList();
            CIMObjectPath opRet = this.generateObjectPath(op, o);
            CIMProperty[] keys = opRet.getKeys();
            ProviderLibs.addKeysToProperties(keys, props);
            props.add(new CIMProperty("StartMode", CIMDataType.STRING_T, (Object)"Automatic", false));
            props.add(new CIMProperty("Started", CIMDataType.BOOLEAN_T, (Object)new Boolean(true), false));
            props.add(new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false));
            props.add(new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false));
            props.add(new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false));
            props.add(new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false));
            props.add(new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false));
            props.add(new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false));
            props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)mServiceName, false));
            props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)mServiceName, false));
            props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)mServiceName, false));
            return new CIMInstance(opRet, props.toArray(new CIMProperty[props.size()])).filterProperties(propertyList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws WBEMException {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_LunMaskPrivilegeService");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        try {
            String systemName = rmiObj.getSMISMappingContainer().getStorageSystemName();
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_LunMaskPrivilegeService", true), new CIMProperty("Name", CIMDataType.STRING_T, (Object)mServiceName, true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)systemName, true)};
            return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_LunMaskPrivilegeService", keys, op.getXmlSchemaName());
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            String sysNameVal;
            String name;
            String sccName;
            String ccName;
            String string = ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
            if (null == ccName || !ccName.equals("HITACHI_LunMaskPrivilegeService")) {
                throw new WBEMException(6, op.toString());
            }
            String string2 = sccName = null != op.getKey("SystemCreationClassName") ? (String)op.getKey("SystemCreationClassName").getValue() : null;
            if (null == sccName || !sccName.equals("HITACHI_StorageSystem")) {
                throw new WBEMException(6, op.toString());
            }
            String string3 = name = null != op.getKey("Name") ? (String)op.getKey("Name").getValue() : null;
            if (null == name || !name.equals(mServiceName)) {
                throw new WBEMException(6, op.toString());
            }
            String ssName = device.getStorageSystemName();
            String string4 = sysNameVal = null != op.getKey("SystemName") && null != op.getKey("SystemName").getValue() ? (String)op.getKey("SystemName").getValue() : null;
            if (null == sysNameVal || !sysNameVal.equals(ssName)) {
                throw new WBEMException(6, "can not find instance for " + op);
            }
            return this.generateInstance(op, propertyList, device.getRMIObject());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    public Object invokeMethod(CIMObjectPath pOp, String pMethodName, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        UnsignedInteger32 oRet = null;
        if ("AssignAccess".equalsIgnoreCase(pMethodName)) {
            oRet = ProviderConstants.UINT32_ONE;
        } else if ("RemoveAccess".equalsIgnoreCase(pMethodName)) {
            oRet = ProviderConstants.UINT32_ONE;
        } else {
            throw new WBEMException(17, pOp.getObjectName() + " does not support the method: " + pMethodName);
        }
        return oRet;
    }
}

