/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class ManagedStorageHardwareIDInstrumentation
extends BaseAssocInstrumentation {
    protected ManagedStorageHardwareIDInstrumentation() {
        super("HITACHI_ManagedStorageHardwareID", "HITACHI_StorageHardwareIDManagementService", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageHardwareIDManagementServiceInstrumentation"), "HITACHI_StorageHardwareID", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageHardwareIDInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean closeIter = true;
            if (null != assocName && "HITACHI_ManagedStorageHardwareID".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        closeIter = false;
                        this.getReference2Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, this.getReference2SearchProperties(objectName), null);
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                }
            }
            if (closeIter && null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CIMObjectPath opStorageHardwareIDManagementService = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath opStorageHardwareID = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), this.getReference2ClassName(), null);
                ReferenceInfo newRefInfo = new ReferenceInfo(opStorageHardwareIDManagementService, null, this.getReference1PropertyName(), this.getReference2PropertyName(), propertyList, isObjectPath, this);
                this.getReference2Instrumentation().enumerate(deviceIter, opStorageHardwareID, new String[0], null, null, continueOnError, true, this.getReference2SearchProperties(opStorageHardwareIDManagementService), newRefInfo);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opStorageHardwareID;
            String cpnStorageHardwareIDManagementService = this.getReference1PropertyName();
            CIMObjectPath opStorageHardwareIDManagementService = op.getKey(cpnStorageHardwareIDManagementService) != null ? (CIMObjectPath)op.getKey(cpnStorageHardwareIDManagementService).getValue() : null;
            String cpnStorageHardwareID = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = opStorageHardwareID = op.getKey(cpnStorageHardwareID) != null ? (CIMObjectPath)op.getKey(cpnStorageHardwareID).getValue() : null;
            if (null != opStorageHardwareID && null != opStorageHardwareIDManagementService && this.getReference1Instrumentation().instanceExists(opStorageHardwareIDManagementService)) {
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageHardwareIDManagementService, "SystemName");
                String sysNameStorageHardwareIDManagementService = (String)opStorageHardwareIDManagementService.getKeyValue("SystemName");
                String shiInstName = (String)opStorageHardwareID.getKeyValue("InstanceID");
                if (null == sysNameStorageHardwareIDManagementService || null == shiInstName) {
                    String msg = String.format("%s could not find system name (%s) or instanceID (%s) property", op.toString(), sysNameStorageHardwareIDManagementService, shiInstName);
                    throw new WBEMException(6, msg);
                }
                String sysNameStorageHardwareID = shiInstName.substring(0, sysNameStorageHardwareIDManagementService.length());
                if (null != sysNameStorageHardwareIDManagementService && null != sysNameStorageHardwareID && sysNameStorageHardwareIDManagementService.equals(sysNameStorageHardwareID) && sysNameStorageHardwareIDManagementService.equals(device.getStorageSystemName())) {
                    CIMInstance ci = this.getReference2Instrumentation().getInstance(opStorageHardwareID, new String[0]);
                    opStorageHardwareID = ci.getObjectPath();
                    ci = null;
                    opStorageHardwareIDManagementService = this.getReference1Instrumentation().generateObjectPath(opStorageHardwareIDManagementService, device.getRMIObject());
                    return this.generateInstance(op, propertyList, opStorageHardwareIDManagementService, opStorageHardwareID);
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath opRef1) {
        String sysName;
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        CIMProperty cpSysName = opRef1.getKey("SystemName");
        if (null != cpSysName && null != (sysName = (String)cpSysName.getValue())) {
            ret.put("SystemName", sysName);
        }
        return ret;
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_ManagedStorageHardwareID".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    CIMObjectPath opStorageHardwareID = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), null);
                    CIMObjectPath opStorageHardwareIDManagementService = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    ReferenceInfo newRefInfo = new ReferenceInfo(opStorageHardwareIDManagementService, null, this.getReference1PropertyName(), this.getReference2PropertyName(), propertyList, isObjectPath, this);
                    Hashtable<String, Object> expectedValues = this.getReference2SearchProperties(objectName);
                    this.getReference2Instrumentation().enumerate(iter, opStorageHardwareID, new String[0], null, null, continueOnError, true, expectedValues, newRefInfo);
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    CIMObjectPath opStorageHardwareIDManagementService = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                    CIMObjectPath opStorageHardwareID = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, opStorageHardwareIDManagementService, opStorageHardwareID));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, opStorageHardwareIDManagementService, opStorageHardwareID));
                    }
                    if (null != iter) {
                        iter.done();
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

