/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.VolumeTypeEnum;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public final class SnapshotVolumeBasedOnSnapshotVolumeCompositeExtentInstrumentation
extends BaseAssocInstrumentation {
    protected SnapshotVolumeBasedOnSnapshotVolumeCompositeExtentInstrumentation() {
        super("HITACHI_SnapshotVolumeBasedOnSnapshotVolumeCompositeExtent", "HITACHI_SnapshotVolumeCompositeExtent", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SnapshotVolumeCompositeExtentInstrumentation"), "HITACHI_StorageVolume", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_SnapshotVolumeBasedOnSnapshotVolumeCompositeExtent".equalsIgnoreCase(assocName.getObjectName())) {
                RMIObjectMapping mapping;
                String deviceID;
                DeviceNumber deviceNum;
                CIMProperty deviceIDProp;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    if (!shouldTestInst || this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping mapping2 = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        CIMProperty deviceIDProp2 = objectName.getKey("DeviceID");
                        if (null != deviceIDProp2) {
                            String deviceID2 = (String)deviceIDProp2.getValue();
                            DeviceNumber dn = DeviceNumber.find(deviceID2, true, mapping2.getRMIObject());
                            if (isObjectPath) {
                                iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, dn));
                            } else {
                                iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, dn));
                            }
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && (!shouldTestInst || this.getReference2Instrumentation().instanceExists(objectName)) && null != (deviceIDProp = objectName.getKey("DeviceID")) && null != (deviceNum = DeviceNumber.find(deviceID = (String)deviceIDProp.getValue(), true, (mapping = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName")).getRMIObject())) && deviceNum.isQSVvol() && deviceNum.getSLUSEElmCount() != 0) {
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, deviceNum));
                    } else if (null != deviceNum) {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, deviceNum));
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter) {
                iter.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                Callback<DeviceNumber> callback = new Callback<DeviceNumber>(deviceIter, isObjectPath, refInfo, op, propertyList);
                DeviceNumber.getDNs(device.getRMIObject(), callback, (short)-1, true, VolumeTypeEnum.QSVVOL);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            if (null != iter) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        finally {
            if (null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws Exception {
        CIMObjectPath assocOP = this.generateObjectPath(op, o);
        CIMProperty<?>[] props = this.getProperties(assocOP.getKeys());
        CIMInstance ci = new CIMInstance(assocOP, props);
        return ci.filterProperties(propertyList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{DeviceNumber.class}, o, "HITACHI_SnapshotVolumeBasedOnSnapshotVolumeCompositeExtent");
        DeviceNumber dn = (DeviceNumber)o[0];
        CIMObjectPath opSnapVolCompExt = this.getReference1Instrumentation().generateObjectPath(op, dn);
        CIMObjectPath opSV = this.getReference2Instrumentation().generateObjectPath(op, dn);
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty(this.getReference1PropertyName(), new CIMDataType(this.getReference1ClassName()), (Object)opSnapVolCompExt, true), new CIMProperty(this.getReference2PropertyName(), new CIMDataType(this.getReference2ClassName()), (Object)opSV, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_SnapshotVolumeBasedOnSnapshotVolumeCompositeExtent", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMInstance instStorVol;
            CIMProperty cpVolDevID;
            CIMInstance instSnapVolCompExt;
            CIMProperty cpSnapDevID;
            CIMObjectPath opStorVol;
            CIMObjectPath opSnapVolCompExt = op.getKey(this.getReference1PropertyName()) != null ? (CIMObjectPath)op.getKey(this.getReference1PropertyName()).getValue() : null;
            CIMObjectPath cIMObjectPath = opStorVol = op.getKey(this.getReference2PropertyName()) != null ? (CIMObjectPath)op.getKey(this.getReference2PropertyName()).getValue() : null;
            if (null != opSnapVolCompExt && null != opStorVol && null != (cpSnapDevID = (instSnapVolCompExt = this.getReference1Instrumentation().getInstance(opSnapVolCompExt, null)).getProperty("DeviceID")) && null != (cpVolDevID = (instStorVol = this.getReference2Instrumentation().getInstance(opStorVol, null)).getProperty("DeviceID")) && cpVolDevID.getValue().equals(cpSnapDevID.getValue())) {
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorVol, "SystemName");
                DeviceNumber dn = DeviceNumber.find((String)cpVolDevID.getValue(), device.getRMIObject());
                if (null != dn) {
                    return this.generateInstance(op, propertyList, dn);
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    protected CIMProperty<?>[] getProperties(CIMProperty<?>[] keys) throws WBEMException {
        ArrayList props = new ArrayList();
        ProviderLibs.addKeysToProperties(keys, props);
        props.add(new CIMProperty("StartingAddress", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false));
        props.add(new CIMProperty("EndingAddress", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false));
        props.add(new CIMProperty("OrderIndex", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false));
        return props.toArray(new CIMProperty[props.size()]);
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath objectName) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String name = null != objectName && null != objectName.getKey("DeviceID") ? (String)objectName.getKey("DeviceID").getValue() : null;
        hTable.put("DeviceID", name);
        return hTable;
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_SnapshotVolumeBasedOnSnapshotVolumeCompositeExtent".equalsIgnoreCase(assocName.getObjectName())) {
                RMIObjectMapping device;
                DeviceNumber deviceNum;
                CIMProperty deviceIDProp;
                String deviceID = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName) && null != (deviceIDProp = objectName.getKey("DeviceID"))) {
                        deviceID = (String)deviceIDProp.getValue();
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && null != (deviceIDProp = objectName.getKey("DeviceID"))) {
                    deviceID = (String)deviceIDProp.getValue();
                }
                if (null != deviceID && null != (deviceNum = DeviceNumber.find(deviceID, true, (device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName")).getRMIObject())) && deviceNum.isQSVvol() && deviceNum.getSLUSEElmCount() != 0) {
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, deviceNum));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, deviceNum));
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we1 = new WBEMException(1, th.toString(), null, th);
            mLogger.log(Level.SEVERE, th.getLocalizedMessage(), th);
            if (null != iter) {
                iter.setException(we1);
                iter.close();
            }
            throw we1;
        }
        if (null != iter) {
            iter.done();
        }
    }

    private class Callback<E extends DeviceNumber>
    extends IteratorCallbackIMPL<E> {
        protected Callback(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (this.mIter.isClosed()) {
                ret = false;
            } else {
                try {
                    E dn = item;
                    if (this.mIsObjectPath) {
                        this.mIter.add(SnapshotVolumeBasedOnSnapshotVolumeCompositeExtentInstrumentation.this.generateObjectPath(this.mOP, dn));
                    } else {
                        this.mIter.add(SnapshotVolumeBasedOnSnapshotVolumeCompositeExtentInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, dn));
                    }
                }
                catch (Exception e) {
                    WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
            }
            return ret;
        }
    }
}

