/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.GeneratedStorageSettingsIMPL;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.StorageCapabilitiesIMPL;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public class StorageCapabilitiesInstrumentation
extends BaseInstrumentation {
    private static final String ARG_NEW_SETTING = "NewSetting";
    protected static final String ARG_PARITY_LAYOUT = "ParityLayout";
    private static final String ARG_SETTING_TYPE = "SettingType";
    protected static final String ARG_STRIPE_DEPTHS = "StripeDepths";
    protected static final String ARG_STRIPE_LENGTHS = "StripeLengths";
    private static final String MTH_CREATESETTING = "CreateSetting";
    private static final String MTH_GETSUPPORTEDPARITYLAYOUTS = "GetSupportedParityLayouts";
    private static final String MTH_GETSUPPORTEDSTRIPEDEPTHRANGE = "GetSupportedStripeDepthRange";
    private static final String MTH_GETSUPPORTEDSTRIPEDEPTHS = "GetSupportedStripeDepths";
    private static final String MTH_GETSUPPORTEDSTRIPELENGTHRANGE = "GetSupportedStripeLengthRange";
    private static final String MTH_GETSUPPORTEDSTRIPELENGTHS = "GetSupportedStripeLengths";

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"SystemName", "InstanceID"});
            int chassis = -1;
            int ag = -1;
            if (expectedValues != null) {
                if (1 != devices.size()) {
                    throw new WBEMException("CIM_StorageCapabilities appears to have been called by an association but it could not determine which managed device to use: " + expectedValues);
                }
                String expVal = (String)expectedValues.get("InstanceID");
                if (expVal != null) {
                    Integer[] ints = ProviderLibs.getInstanceIDInts(expVal);
                    chassis = ints[0];
                    ag = ints[1];
                }
            }
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackHandler<ChassisArrayGroup> callback = new CallbackHandler<ChassisArrayGroup>(deviceIter, isObjectPath, refInfo, op, propertyList, ag, device.getStorageSystemName());
                ChassisArrayGroup.getChassisArrayGroup(device.getRMIObject(), callback, false, chassis, -1, -1, ag);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    protected Object extrinsic_CreateSetting(CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs, CIMObjectPath op) throws WBEMException {
        UnsignedInteger32 ret = ProviderConstants.UINT32_ZED;
        try {
            if (inArgs != null && inArgs.length == 1 && inArgs[0].getName().equalsIgnoreCase(ARG_SETTING_TYPE)) {
                UnsignedInteger16 goal = (UnsignedInteger16)inArgs[0].getValue();
                if (goal.intValue() == 2 || goal.intValue() == 3) {
                    GeneratedStorageSettingsIMPL setting = GeneratedStorageSettingsIMPL.createSetting(op, goal.intValue());
                    CIMObjectPath newSetting = this.getStorageSettingOP(op, setting);
                    outArgs[0] = new CIMArgument(ARG_NEW_SETTING, new CIMDataType(newSetting.getObjectName()), (Object)newSetting);
                } else {
                    mLogger.log(Level.WARNING, "SettingType value not allowed: " + goal.toString());
                    ret = ProviderConstants.UINT32_FIVE;
                }
            } else {
                mLogger.log(Level.WARNING, "Paramater missing: SettingType");
                ret = ProviderConstants.UINT32_FIVE;
            }
        }
        catch (WBEMException we) {
            mLogger.log(Level.SEVERE, "Exception while invoking CreateSetting: " + we.toString(), we);
            ret = ProviderConstants.UINT32_TWO;
        }
        return ret;
    }

    protected Object extrinsic_GetSupportedParityLayouts(CIMObjectPath op, CIMArgument<?>[] outArgs) throws WBEMException {
        return this.GetSupportedParityLengthsHelper(op, outArgs, true);
    }

    protected Object extrinsic_GetSupportedStripeDepthRange(CIMObjectPath op, CIMArgument<?>[] outArgs) throws WBEMException {
        return this.GetSupportedStripeXXXRange(op, outArgs, true);
    }

    protected Object extrinsic_GetSupportedStripeDepths(CIMObjectPath op, CIMArgument<?>[] outArgs) throws WBEMException {
        outArgs[0] = new CIMArgument(ARG_STRIPE_DEPTHS, CIMDataType.UINT64_ARRAY_T, (Object)new UnsignedInteger64[0]);
        UnsignedInteger32 ret = ProviderConstants.UINT32_ZED;
        return ret;
    }

    protected UnsignedInteger32 extrinsic_GetSupportedStripeLengthRange(CIMObjectPath op, CIMArgument<?>[] outArgs) throws WBEMException {
        return this.GetSupportedStripeXXXRange(op, outArgs, false);
    }

    protected Object extrinsic_GetSupportedStripeLengths(CIMObjectPath op, CIMArgument<?>[] outArgs) throws WBEMException {
        return this.GetSupportedParityLengthsHelper(op, outArgs, false);
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        StorageCapabilitiesIMPL storageCapabilitiesIMPL = (StorageCapabilitiesIMPL)o[0];
        CIMProperty[] keys = retOP.getKeys();
        UnsignedInteger16[] supportedDataOrg = new UnsignedInteger16[]{ProviderConstants.UINT16_TWO};
        String caption = "StorageCapabilities." + storageCapabilitiesIMPL.getChassis() + "." + storageCapabilitiesIMPL.getArrayGroup();
        CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("ElementType", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getElementType(), false), new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)storageCapabilitiesIMPL.isNoSinglePointOfFailure(), false), new CIMProperty("NoSinglePointOfFailureDefault", CIMDataType.BOOLEAN_T, (Object)storageCapabilitiesIMPL.isNoSinglePointOfFailure(), false), new CIMProperty("DataRedundancyMax", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getDataRedunMax(), false), new CIMProperty("DataRedundancyMin", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getDataRedunMin(), false), new CIMProperty("DataRedundancyDefault", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getDataRedun(), false), new CIMProperty("PackageRedundancyMax", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getPkgRedunMax(), false), new CIMProperty("PackageRedundancyMin", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getPkgRedunMin(), false), new CIMProperty("PackageRedundancyDefault", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getPkgRedun(), false), new CIMProperty("DeltaReservationMax", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getDeltaReservationMax(), false), new CIMProperty("DeltaReservationMin", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getDeltaReservationMin(), false), new CIMProperty("DeltaReservationDefault", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getDeltaReservation(), false), new CIMProperty("ExtentStripeLengthDefault", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getExtentStripLength(), false), new CIMProperty("ParityLayoutDefault", CIMDataType.UINT16_T, (Object)storageCapabilitiesIMPL.getParityLayout(), false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)caption, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)caption, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)caption, false), new CIMProperty("SupportedDataOrganizations", CIMDataType.UINT16_ARRAY_T, (Object)supportedDataOrg, false), new CIMProperty("SupportedExtentTypes", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("SupportedCompressionRates", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_FIVE}, false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws WBEMException {
        ProviderLibs.validateVARArgs(new Class[]{StorageCapabilitiesIMPL.class}, o, "HITACHI_StorageCapabilities");
        StorageCapabilitiesIMPL storageCapabilitiesIMPL = (StorageCapabilitiesIMPL)o[0];
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(storageCapabilitiesIMPL.getSerialNumber());
        StringBuffer instID = new StringBuffer(device.getStorageSystemName());
        instID.append(".");
        instID.append(String.valueOf(storageCapabilitiesIMPL.getChassis()));
        instID.append(".");
        instID.append(String.valueOf(storageCapabilitiesIMPL.getArrayGroup()));
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)instID.toString(), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageCapabilities", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            StorageCapabilitiesIMPL storageCapabilitiesIMPL;
            String instID;
            String string = instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null == instID) {
                throw new WBEMException(6, op.toString());
            }
            String[] instanceIDParts = ProviderLibs.parseStorageCapabilitiesInstanceID(instID);
            String systemName = instanceIDParts[0];
            String chassisArrayID = instanceIDParts[1];
            if (null == systemName || null == chassisArrayID || !systemName.equals(device.getStorageSystemName())) {
                throw new WBEMException(6, op.toString());
            }
            ChassisArrayGroup cag = ChassisArrayGroup.find(device.getRMIObject(), false, chassisArrayID);
            if (null != cag && null != (storageCapabilitiesIMPL = new StorageCapabilitiesIMPL(cag, systemName))) {
                return this.generateInstance(op, propertyList, storageCapabilitiesIMPL);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    protected CIMObjectPath getStorageSettingOP(CIMObjectPath op, GeneratedStorageSettingsIMPL setting) {
        String clzName = "HITACHI_GeneratedStorageSetting";
        String objName = op.getObjectName();
        if (objName.contains("ImportedPrimordial")) {
            clzName = "HITACHI_GeneratedStorageSettingOfImportedPrimordialPool";
        } else if (objName.contains("Primordial")) {
            clzName = "HITACHI_GeneratedStorageSettingOfPrimordialPool";
        } else if (objName.contains("ThinProvisioningPool")) {
            clzName = "HITACHI_GeneratedThinProvisioningPoolSetting";
        }
        CIMProperty[] key = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)setting.getInstanceID(), true)};
        CIMObjectPath retOP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), clzName, key, op.getXmlSchemaName());
        return retOP;
    }

    protected Object GetSupportedParityLengthsHelper(CIMObjectPath op, CIMArgument<?>[] outArgs, boolean doParity) throws WBEMException {
        UnsignedInteger32 ret = null;
        ChassisArrayGroup cag = ProviderLibs.getCAGFromOp(op);
        if (cag != null && !cag.isContainedDNsOpenVolume()) {
            ret = ProviderConstants.UINT32_TWO;
            cag = null;
        }
        if (cag != null) {
            UnsignedInteger16[] unsignedInteger16Array;
            UnsignedInteger16 value = null;
            if (doParity) {
                if (cag.isExternalVol() || cag.isFICONDMVol()) {
                    ret = ProviderConstants.UINT32_ONE;
                } else if (!cag.isContainedDNsOpenVolume()) {
                    ret = ProviderConstants.UINT32_TWO;
                } else if (cag.isAouVol()) {
                    ret = ProviderConstants.UINT32_TWO;
                } else {
                    String rl = cag.getRaidLevel();
                    value = ProviderLibs.getParityLayout(rl);
                    if (value != null && value.intValue() == 2) {
                        value = ProviderConstants.UINT16_THREE;
                    }
                    ret = ProviderConstants.UINT32_ZED;
                }
            } else {
                String rl = cag.getRaidLevel();
                int length = ProviderLibs.getExtentStripeLen(rl);
                value = new UnsignedInteger16(length);
                ret = ProviderConstants.UINT32_ZED;
            }
            String string = doParity ? ARG_PARITY_LAYOUT : ARG_STRIPE_LENGTHS;
            if (value == null) {
                unsignedInteger16Array = new UnsignedInteger16[]{};
            } else {
                UnsignedInteger16[] unsignedInteger16Array2 = new UnsignedInteger16[1];
                unsignedInteger16Array = unsignedInteger16Array2;
                unsignedInteger16Array2[0] = value;
            }
            outArgs[0] = new CIMArgument(string, CIMDataType.UINT16_ARRAY_T, (Object)unsignedInteger16Array);
        } else if (ret == null) {
            if (doParity) {
                outArgs[0] = new CIMArgument(ARG_STRIPE_LENGTHS, CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_THREE});
                ret = ProviderConstants.UINT32_ZED;
            } else {
                outArgs[0] = new CIMArgument(ARG_STRIPE_LENGTHS, CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0]);
                ret = ProviderConstants.UINT32_ZED;
            }
        }
        return ret;
    }

    protected UnsignedInteger32 GetSupportedStripeXXXRange(CIMObjectPath op, CIMArgument<?>[] outArgs, boolean doDepth) throws WBEMException {
        outArgs[0] = new CIMArgument("MinimumStripeDepth", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
        outArgs[1] = new CIMArgument("MaximumStripeDepth", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
        outArgs[2] = new CIMArgument("StripeDepthDivisor", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
        UnsignedInteger32 ret = doDepth ? ProviderConstants.UINT32_TWO : ProviderConstants.UINT32_THREE;
        return ret;
    }

    public Object invokeMethod(CIMObjectPath op, String methodName, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        Object ret = null;
        if (methodName.equalsIgnoreCase(MTH_CREATESETTING)) {
            ret = this.extrinsic_CreateSetting(inArgs, outArgs, op);
        } else if (methodName.equalsIgnoreCase(MTH_GETSUPPORTEDSTRIPELENGTHRANGE)) {
            ret = this.extrinsic_GetSupportedStripeLengthRange(op, outArgs);
        } else if (methodName.equalsIgnoreCase(MTH_GETSUPPORTEDSTRIPEDEPTHS)) {
            ret = this.extrinsic_GetSupportedStripeDepths(op, outArgs);
        } else if (methodName.equalsIgnoreCase(MTH_GETSUPPORTEDSTRIPEDEPTHRANGE)) {
            ret = this.extrinsic_GetSupportedStripeDepthRange(op, outArgs);
        } else if (methodName.equalsIgnoreCase(MTH_GETSUPPORTEDSTRIPELENGTHS)) {
            ret = this.extrinsic_GetSupportedStripeLengths(op, outArgs);
        } else if (methodName.equalsIgnoreCase(MTH_GETSUPPORTEDPARITYLAYOUTS)) {
            ret = this.extrinsic_GetSupportedParityLayouts(op, outArgs);
        } else {
            throw new WBEMException(17, methodName + " is not known");
        }
        return ret;
    }

    private class CallbackHandler<E extends ChassisArrayGroup>
    extends IteratorCallbackIMPL<E> {
        private int mArrayGroup;
        private final String mSystemName;

        protected CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, int ag, String systemName) {
            super(iter, isObjectPath, refInfo, op, propertyList);
            this.mArrayGroup = -1;
            this.mArrayGroup = ag;
            this.mSystemName = systemName;
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block7: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E cag = item;
                        if (this.mArrayGroup != -1) {
                            ret = ((ChassisArrayGroup)cag).getArrayGroup() != this.mArrayGroup;
                        }
                        if (-1 != this.mArrayGroup && (this.mArrayGroup == -1 || ret)) break block7;
                        StorageCapabilitiesIMPL storageCapabilitiesIMPL = new StorageCapabilitiesIMPL((ChassisArrayGroup)cag, this.mSystemName);
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, StorageCapabilitiesInstrumentation.this.generateObjectPath(this.mOP, storageCapabilitiesIMPL));
                            break block7;
                        }
                        if (this.mIsObjectPath) {
                            this.mIter.add(StorageCapabilitiesInstrumentation.this.generateObjectPath(this.mOP, storageCapabilitiesIMPL));
                            break block7;
                        }
                        this.mIter.add(StorageCapabilitiesInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, storageCapabilitiesIMPL));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

