/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class StorageClientSettingDataInstrumentation
extends BaseInstrumentation {
    private static final ClientType[] StdClientTypes = new ClientType[]{new ClientType(2, "Standard", 0), new ClientType(32772, "VMWare", 1), new ClientType(5, "OpenVMS", 5), new ClientType(6, "Tru64", 7), new ClientType(3, "Solaris", 9), new ClientType(7, "Netware", 10), new ClientType(15, "Microsoft Windows", 12), new ClientType(9, "AIX", 15), new ClientType(32773, "VMware Extension", 33), new ClientType(32815, "Windows Extension", 44), new ClientType(32771, "UVM", 76)};

    protected static int getHostModeFromClientType(RMIObjectCache rmiObj, int pClientType) {
        int ret = -1;
        List<ClientType> types = StorageClientSettingDataInstrumentation.getSupportedClientTypes(rmiObj.getSMISMappingContainer());
        for (ClientType type : types) {
            if (type.mClientType != pClientType) continue;
            ret = type.mHostMode;
            break;
        }
        return ret;
    }

    private static List<ClientType> getSupportedClientTypes(RMIObjectMapping device) {
        ArrayList<ClientType> clientTypes = new ArrayList<ClientType>(Arrays.asList(StdClientTypes));
        return clientTypes;
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, "ElementName");
            UnsignedInteger16 hostMode = null;
            if (expectedValues != null) {
                hostMode = (UnsignedInteger16)expectedValues.get("HostMode");
            }
            for (RMIObjectMapping device : devices) {
                List<ClientType> clientTypes = StorageClientSettingDataInstrumentation.getSupportedClientTypes(device);
                for (ClientType thisType : clientTypes) {
                    if (hostMode != null && !thisType.isHostMode(hostMode)) continue;
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, device.getRMIObject(), thisType));
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, device.getRMIObject(), thisType));
                }
            }
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
            }
            throw we;
        }
        finally {
            if (null != iter) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        ClientType clientType = (ClientType)o[1];
        CIMProperty[] keys = retOP.getKeys();
        CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("ClientTypes", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(clientType.getValue())}, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)clientType.toString(), false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)clientType.toString(), false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)clientType.toString(), false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class, ClientType.class}, o, "HITACHI_StorageClientSettingData");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        ClientType clientType = (ClientType)o[1];
        String instanceID = rmiObj.getSMISMappingContainer().getStorageSystemName() + "." + clientType.getValue();
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)instanceID, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageClientSettingData", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            String instanceID;
            String string = instanceID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null != instanceID) {
                int index = instanceID.lastIndexOf(ProviderConstants.ID_SEPERATOR_AS_CHAR);
                String ssNameValue = instanceID.substring(0, index);
                String ssName = device.getStorageSystemName();
                if (null != ssName && ssName.equals(ssNameValue)) {
                    String clientTypeValue = instanceID.substring(index + 1);
                    List<ClientType> clientTypes = StorageClientSettingDataInstrumentation.getSupportedClientTypes(device);
                    for (ClientType ct : clientTypes) {
                        if (ct.getValue() != Integer.parseInt(clientTypeValue)) continue;
                        return this.generateInstance(op, propertyList, device.getRMIObject(), ct);
                    }
                }
            }
            throw new WBEMException(6, op != null ? op.toString() : null);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    static class ClientType {
        private final int mClientType;
        private final String mStrVal;
        private final int mHostMode;

        private ClientType(int val, String strVal, int hostMode) {
            this.mClientType = val;
            this.mStrVal = strVal;
            this.mHostMode = hostMode;
        }

        public int getHostMode() {
            return this.mHostMode;
        }

        public int getValue() {
            return this.mClientType;
        }

        public boolean isHostMode(UnsignedInteger16 hostMode) {
            boolean ret = false;
            if (hostMode == null || hostMode.intValue() == this.mHostMode) {
                ret = true;
            }
            return ret;
        }

        public String toString() {
            return this.mStrVal;
        }
    }
}

