/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdateType;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;
import sanproject.serverux.data.SANRmiException;

public class StoragePoolInstrumentation
extends BaseInstrumentation
implements CacheUpdateNotifier {
    protected static final String CAN_GETSUPPORTEDSIZERANGE_ELEMENTTYPE = "ElementType";
    protected static final String CAN_GETSUPPORTEDSIZERANGE_SIZES = "Sizes";

    protected static <T extends Serializable> void generateIndication(BaseInstrumentation inst, CacheUpdateType type, T pObj) throws Exception {
        CIMInstance indication;
        CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_StoragePool", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
        CIMInstance sourceInstance = inst.generateInstance(op, null, pObj);
        IndicationHelper helper = new IndicationHelper(mHandle);
        switch (type) {
            case ADD: {
                indication = helper.createInstCreationInstance(sourceInstance);
                break;
            }
            case DELETE: {
                indication = helper.createInstDeletionInstance(sourceInstance);
                break;
            }
            default: {
                throw new WBEMException("Function doe not work with modify");
            }
        }
        mHandle.deliverEvent(indication, null);
    }

    public static String getPoolID(ChassisArrayGroup cag) throws Exception {
        String ret = "StoragePool:" + RMIObjectMapping.getRMIObjectMapping(cag.getSerialNumber()).getStorageSystemName() + "." + cag.getChassis() + "-" + cag.getPg();
        return ret;
    }

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            try {
                StoragePoolInstrumentation.generateIndication(this, CacheUpdateType.ADD, pObj);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_StoragePool added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            try {
                StoragePoolInstrumentation.generateIndication(this, CacheUpdateType.DELETE, pObj);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_StoragePool deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_StoragePool", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                CIMInstance prevInstance = this.generateInstance(op, null, pObj);
                ChassisArrayGroup cag = (ChassisArrayGroup)pObj;
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(cag.getSerialNumber());
                ChassisArrayGroup newInst = ChassisArrayGroup.find(device.getRMIObject(), false, cag.getChassisArrayID());
                if (newInst != null) {
                    CIMInstance sourceInstance = this.generateInstance(op, null, newInst);
                    IndicationHelper helper = new IndicationHelper(mHandle);
                    CIMInstance indication = helper.createInstModificationInstance(sourceInstance, prevInstance);
                    mHandle.deliverEvent(indication, null);
                } else {
                    mLogger.severe("Unable to find a CAG that with ID: " + cag.getChassisArrayID());
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_StoragePool modified indication instance", t);
            }
        }
    }

    private UnsignedInteger32 defaultFail(UnsignedInteger32 ret, CIMArgument<?>[] pOutArgs) {
        pOutArgs[0] = new CIMArgument("MinimumVolumeSize", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
        pOutArgs[1] = new CIMArgument("MaximumVolumeSize", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED);
        pOutArgs[2] = new CIMArgument("VolumeSizeDivisor", CIMDataType.UINT64_T, (Object)new UnsignedInteger64("1048576"));
        return ret;
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            int fb4 = -1;
            int pg = -1;
            int vdev = -1;
            int ag = -1;
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"SystemName", "InstanceID"});
            if (expectedValues != null) {
                Integer[] ret;
                if (1 != devices.size()) {
                    mLogger.log(Level.SEVERE, "{0} called with parameters for an association call, no device infoavailable. expValues: {1}, devices found: {2}", new Object[]{"HITACHI_StoragePool", expectedValues, devices.size()});
                    if (null != iter) {
                        iter.done();
                    }
                    return;
                }
                String expID = (String)expectedValues.get("DeviceID");
                if (expID != null) {
                    if (expID.contains(".")) {
                        ret = ProviderLibs.getChassisAndArrayGroupFromDeviceID(expID);
                        fb4 = ret[0];
                        ag = ret[1];
                    } else {
                        DeviceNumber dn = DeviceNumber.find(expID, devices.get(0).getRMIObject());
                        if (dn == null) {
                            if (null != iter) {
                                iter.done();
                            }
                            return;
                        }
                        fb4 = dn.getFb4();
                        pg = dn.getPg();
                        vdev = dn.getVdev();
                    }
                } else {
                    expID = (String)expectedValues.get("InstanceID");
                    if (expID != null) {
                        ret = ProviderLibs.getInstanceIDInts(expID);
                        fb4 = ret[0];
                        ag = ret[1];
                    }
                }
            }
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackHandler<ChassisArrayGroup> callback = new CallbackHandler<ChassisArrayGroup>(deviceIter, isObjectPath, refInfo, op, propertyList, ag);
                ChassisArrayGroup.getChassisArrayGroup(device.getRMIObject(), callback, isObjectPath, fb4, pg, vdev, ag);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    protected UnsignedInteger32 extrinsic_GetSupportedSizeRange(CIMObjectPath pOp, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        String msg;
        UnsignedInteger64 minVolSize;
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(pOp, "InstanceID");
        UnsignedInteger32 ret = ProviderConstants.UINT32_ZED;
        UnsignedInteger64 maxVolSize = minVolSize = ProviderConstants.UINT64_ZED;
        CIMObjectPath goal = null;
        UnsignedInteger16 elementType = null;
        String opName = pOp.getObjectName();
        if (null == opName) {
            mLogger.severe("GetSupportedSizeRange Objectpath is null!");
            return this.defaultFail(ret, pOutArgs);
        }
        if (opName.toLowerCase().contains("Primordial".toLowerCase())) {
            return this.defaultFail(ProviderConstants.UINT32_TWO, pOutArgs);
        }
        opName = null;
        for (CIMArgument<?> arg : pInArgs) {
            if (arg.getName().equalsIgnoreCase("Goal")) {
                goal = (CIMObjectPath)arg.getValue();
                continue;
            }
            if (!arg.getName().equalsIgnoreCase(CAN_GETSUPPORTEDSIZERANGE_ELEMENTTYPE)) continue;
            elementType = (UnsignedInteger16)arg.getValue();
        }
        if (elementType == null) {
            msg = "ElementType can not be null";
            mLogger.severe("ElementType can not be null");
            return this.defaultFail(ret, pOutArgs);
        }
        if (3 != elementType.intValue()) {
            msg = "ElementType must have a value of 3, passed in" + elementType;
            mLogger.severe(msg);
            return this.defaultFail(ret, pOutArgs);
        }
        CIMProperty cpKey = pOp.getKey("InstanceID");
        if (null == cpKey) {
            throw new WBEMException(4, "StoragePool is null");
        }
        String instID = (String)cpKey.getValue();
        ChassisArrayGroup cag = ChassisArrayGroup.find(device.getRMIObject(), instID, -1, -1, false);
        if (null != cag) {
            UnsignedInteger64 volumeSizeDivisor;
            String emulationType;
            if (cag.isQsVvol() || cag.isAouVol()) {
                return this.defaultFail(ProviderConstants.UINT32_ZED, pOutArgs);
            }
            if (!cag.isContainedDNsOpenVolume()) {
                return this.defaultFail(ProviderConstants.UINT32_ZED, pOutArgs);
            }
            if (!ProviderLibs.checkSettingGoal(goal, cag, mHandle)) {
                return this.defaultFail(ret, pOutArgs);
            }
            long smallestMaxPoolSize = 0L;
            long min = 0L;
            long maxPoolSize = 0L;
            List<BaseDeviceNumber> dns = cag.getContainedDNs();
            if (dns != null && dns.size() > 0) {
                BaseDeviceNumber dn = dns.get(0);
                emulationType = dn.getEmulationType();
            } else {
                emulationType = "OPEN-V";
            }
            if (!cag.isAouVol()) {
                min = BaseDeviceNumber.getMinPoolSize(emulationType);
                minVolSize = new UnsignedInteger64(BigInteger.valueOf(min));
            }
            maxPoolSize = BaseDeviceNumber.getMaxPoolSize(emulationType);
            long largestFreeSpace = cag.getLargestFreeSpace().longValue();
            smallestMaxPoolSize = (largestFreeSpace *= cag.getBlockSize().longValue()) < maxPoolSize ? largestFreeSpace : maxPoolSize;
            maxVolSize = new UnsignedInteger64(BigInteger.valueOf(smallestMaxPoolSize));
            if (cag.isAouVol()) {
                volumeSizeDivisor = new UnsignedInteger64("44040192");
                if (minVolSize.longValue() != 0L) {
                    minVolSize = ProviderConstants.THIN_VOLUME_MIN_ALLOWED_SIZE;
                }
            } else {
                volumeSizeDivisor = new UnsignedInteger64("1048576");
            }
            pOutArgs[0] = new CIMArgument("MinimumVolumeSize", CIMDataType.UINT64_T, (Object)minVolSize);
            pOutArgs[1] = new CIMArgument("MaximumVolumeSize", CIMDataType.UINT64_T, (Object)maxVolSize);
            pOutArgs[2] = new CIMArgument("VolumeSizeDivisor", CIMDataType.UINT64_T, (Object)volumeSizeDivisor);
            return ret;
        }
        throw new WBEMException(6, "Can not locate the specified StoragePool " + pOp);
    }

    protected Object extrinsic_getSupportedSizes(CIMObjectPath pOp, CIMArgument<?>[] pOutArgs) throws WBEMException {
        UnsignedInteger64[] emptyArray = new UnsignedInteger64[]{};
        pOutArgs[0] = new CIMArgument(CAN_GETSUPPORTEDSIZERANGE_SIZES, CIMDataType.UINT64_ARRAY_T, (Object)emptyArray);
        UnsignedInteger32 ret = ProviderConstants.UINT32_TWO;
        return ret;
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath p, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(p, o);
        ChassisArrayGroup cag = (ChassisArrayGroup)o[0];
        try {
            ArrayList props = new ArrayList();
            CIMProperty[] keys = retOP.getKeys();
            String cvPoolID = StoragePoolInstrumentation.getPoolID(cag);
            ProviderLibs.addKeysToProperties(keys, props);
            props.add(new CIMProperty("Name", CIMDataType.STRING_T, (Object)cvPoolID, false));
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(cag.getSerialNumber());
            UnsignedInteger16 value = cag.getConsistsOf(device.getRMIObject());
            props.add(new CIMProperty("ConsistsOf", CIMDataType.UINT16_T, (Object)value, false));
            UnsignedInteger16 usage = null;
            usage = value.intValue() == 1 ? (cag.isvVol() ? ProviderConstants.UINT16_THREE : ProviderConstants.UINT16_TWO) : ProviderConstants.UINT16_32768;
            props.add(new CIMProperty("Usage", CIMDataType.UINT16_T, (Object)usage, false));
            props.add(new CIMProperty("Primordial", CIMDataType.BOOLEAN_T, (Object)false, false));
            long numBlk = cag.getNumberOfBlocks().longValue();
            long freeBlk = cag.getTotalNumFreeBlocks().longValue();
            long blkSize = cag.getBlockSize().longValue();
            BigInteger calc = BigInteger.valueOf(blkSize * numBlk);
            UnsignedInteger64 cvTotalManagedSpace = new UnsignedInteger64(calc);
            props.add(new CIMProperty("TotalManagedSpace", CIMDataType.UINT64_T, (Object)cvTotalManagedSpace, false));
            calc = BigInteger.valueOf(blkSize * freeBlk);
            UnsignedInteger64 cvRemaningManagedSpace = new UnsignedInteger64(calc);
            props.add(new CIMProperty("RemainingManagedSpace", CIMDataType.UINT64_T, (Object)cvRemaningManagedSpace, false));
            props.add(new CIMProperty("PoolID", CIMDataType.STRING_T, (Object)cvPoolID, false));
            props.add(new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(ProviderConstants.OP_STATUS_INDEX.OK.getStatusValue())}, false));
            props.add(new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false));
            props.add(new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderLibs.getHealthState4CAG(cag.getSerialNumber(), cag.getFb4(), cag.getPg()), false));
            props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)cvPoolID, false));
            props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)cvPoolID, false));
            props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)cvPoolID, false));
            props.add(new CIMProperty("SpaceLimitDetermination", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false));
            props.add(new CIMProperty("SpaceLimit", CIMDataType.UINT64_T, (Object)cvTotalManagedSpace, false));
            props.add(new CIMProperty("ElementsShareSpace", CIMDataType.BOOLEAN_T, (Object)Boolean.FALSE, false));
            props.add(new CIMProperty("ReservedSpace", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false));
            return new CIMInstance(retOP, props.toArray(new CIMProperty[props.size()])).filterProperties(propList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath p, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{ChassisArrayGroup.class}, o, "HITACHI_StoragePool");
        ChassisArrayGroup cag = (ChassisArrayGroup)o[0];
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(cag.getSerialNumber());
        try {
            String systemName = device.getStorageSystemName();
            String keyValue = systemName + "." + cag.getChassis() + "." + cag.getArrayGroup();
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)keyValue, true)};
            return new CIMObjectPath(p.getScheme(), p.getHost(), p.getPort(), p.getNamespace(), "HITACHI_StoragePool", keys, p.getXmlSchemaName());
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            ChassisArrayGroup data = ProviderLibs.getCAGFromOp(op);
            if (data != null) {
                return this.generateInstance(op, propertyList, data);
            }
        }
        catch (WBEMException we) {
            if (6 == we.getID() || 1 == we.getID()) {
                throw we;
            }
            throw new WBEMException(1, we.toString(), null, (Throwable)we);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    public UnsignedInteger64 getTotalManagedSpace(RMIObjectMapping device) throws RemoteException, SANRmiException, WBEMException {
        throw new WBEMException(1, "HITACHI_StoragePool.getTotalManagedSpace should not be called");
    }

    public Object invokeMethod(CIMObjectPath pOp, String pMethodName, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        Object oRet = null;
        if ("GetSupportedSizes".equalsIgnoreCase(pMethodName)) {
            oRet = this.extrinsic_getSupportedSizes(pOp, pOutArgs);
        } else if ("GetSupportedSizeRange".equalsIgnoreCase(pMethodName)) {
            oRet = pOp.getObjectName().contains("Primordial") ? ProviderConstants.UINT32_TWO : this.extrinsic_GetSupportedSizeRange(pOp, pInArgs, pOutArgs);
        } else {
            throw new WBEMException(17, "StoragePool does not know about the method: " + pMethodName);
        }
        return oRet;
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_StoragePool".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstAdd(true);
            } else {
                this.setListen4InstAdd(false);
            }
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_StoragePool".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(true);
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_StoragePool".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(true);
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_StoragePool AND SourceInstance.CIM_StoragePool::TotalManagedSpace <> PreviousInstance.CIM_StoragePool::TotalManagedSpace".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstMod(true);
            } else {
                this.setListen4InstMod(false);
            }
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.VDEV, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.VDEV, this, null);
        }
    }

    private class CallbackHandler<E extends ChassisArrayGroup>
    extends IteratorCallbackIMPL<E> {
        private int arrayGroup;

        private CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, int ag) {
            super(iter, isObjectPath, refInfo, op, propertyList);
            this.arrayGroup = -1;
            this.arrayGroup = ag;
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block7: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E cag = item;
                        if (-1 != this.arrayGroup && ((ChassisArrayGroup)cag).getArrayGroup() != this.arrayGroup) {
                            ret = true;
                            break block7;
                        }
                        if (((ChassisArrayGroup)cag).isAouVol()) break block7;
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, StoragePoolInstrumentation.this.generateObjectPath(this.mOP, cag));
                            break block7;
                        }
                        if (this.mIsObjectPath) {
                            this.mIter.add(StoragePoolInstrumentation.this.generateObjectPath(this.mOP, cag));
                            break block7;
                        }
                        this.mIter.add(StoragePoolInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, cag));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

