/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public final class StorageVolumeBasedOnCompositeLDEVExtentInstrumentation
extends BaseAssocInstrumentation {
    protected StorageVolumeBasedOnCompositeLDEVExtentInstrumentation() {
        super("HITACHI_StorageVolumeBasedOnCompositeLDEVExtent", "HITACHI_CompositeLDEVExtent", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.CompositeLDEVExtentInstrumentation"), "HITACHI_StorageVolume", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            if (null == assocName || !"HITACHI_StorageVolumeBasedOnCompositeLDEVExtent".equalsIgnoreCase(assocName.getObjectName())) {
                return;
            }
            if (!(!objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) || null != role && !role.equalsIgnoreCase(this.getReference1PropertyName()) || null != resultRole && !resultRole.equalsIgnoreCase(this.getReference2PropertyName()) || shouldTestInst && !this.getReference1Instrumentation().instanceExists(objectName))) {
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                RMIObjectCache rmiObj = device.getRMIObject();
                CIMProperty deviceIDProp = objectName.getKey("DeviceID");
                String deviceID = (String)deviceIDProp.getValue();
                DeviceNumber deviceNum = DeviceNumber.find(deviceID, true, rmiObj);
                if (null != deviceNum && !deviceNum.isAOUVol() && !deviceNum.isQSVvol()) {
                    if (isObjectPath) {
                        iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, deviceNum));
                    } else {
                        iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, deviceNum));
                    }
                }
            } else if (!(!objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) || null != role && !role.equalsIgnoreCase(this.getReference2PropertyName()) || null != resultRole && !resultRole.equalsIgnoreCase(this.getReference1PropertyName()) || shouldTestInst && !this.getReference2Instrumentation().instanceExists(objectName))) {
                String deviceID;
                DeviceNumber deviceNum;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                CIMProperty deviceIDProp = objectName.getKey("DeviceID");
                if (null != deviceIDProp && null != (deviceNum = DeviceNumber.find(deviceID = (String)deviceIDProp.getValue(), true, device.getRMIObject())) && !deviceNum.isAOUVol() && !deviceNum.isQSVvol()) {
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, deviceNum));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, deviceNum));
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                Callback<DeviceNumber> callback = new Callback<DeviceNumber>(deviceIter, isObjectPath, refInfo, op, propertyList);
                DeviceNumber.getDNs(device.getRMIObject(), callback, isObjectPath, null == propertyList || propertyList.length > 0, null, -1, -1, -1, true);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            if (null != iter) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws Exception {
        CIMObjectPath assocOP = this.generateObjectPath(op, o);
        CIMProperty key1 = assocOP.getKey(this.getReference1PropertyName());
        CIMProperty key2 = assocOP.getKey(this.getReference2PropertyName());
        ArrayList<CIMProperty> props = new ArrayList<CIMProperty>(5);
        props.add(key1);
        props.add(key2);
        props.add(new CIMProperty("StartingAddress", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false));
        props.add(new CIMProperty("EndingAddress", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false));
        props.add(new CIMProperty("OrderIndex", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false));
        return new CIMInstance(assocOP, props.toArray(new CIMProperty[props.size()])).filterProperties(propertyList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{DeviceNumber.class}, o, "HITACHI_StorageVolumeBasedOnCompositeLDEVExtent");
        DeviceNumber dn = (DeviceNumber)o[0];
        CIMObjectPath opCompLDev = this.getReference1Instrumentation().generateObjectPath(op, dn);
        CIMObjectPath opSV = this.getReference2Instrumentation().generateObjectPath(op, dn);
        return super.generateObjectPath(op, opCompLDev, opSV);
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath svOP;
            CIMObjectPath cLDevOP = op.getKey(this.getReference1PropertyName()) != null ? (CIMObjectPath)op.getKey(this.getReference1PropertyName()).getValue() : null;
            CIMObjectPath cIMObjectPath = svOP = op.getKey(this.getReference2PropertyName()) != null ? (CIMObjectPath)op.getKey(this.getReference2PropertyName()).getValue() : null;
            if (null != cLDevOP && null != svOP) {
                String svDeviceID;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(svOP, "SystemName");
                CIMProperty cLDevDeviceIDProp = cLDevOP.getKey("DeviceID");
                String cLDevDeviceID = null != cLDevDeviceIDProp ? (String)cLDevDeviceIDProp.getValue() : null;
                CIMProperty svDeviceIDProp = svOP.getKey("DeviceID");
                String string = svDeviceID = null != svDeviceIDProp ? (String)svDeviceIDProp.getValue() : null;
                if (null != svDeviceID && svDeviceID.equals(cLDevDeviceID)) {
                    DeviceNumber deviceNum;
                    String svSysNameKeyVal;
                    String cLDevCCName = null != cLDevOP.getKey("CreationClassName") ? (String)cLDevOP.getKey("CreationClassName").getValue() : null;
                    String cLDevSCCName = null != cLDevOP.getKey("SystemCreationClassName") ? (String)cLDevOP.getKey("SystemCreationClassName").getValue() : null;
                    String cLDevSysNameKeyVal = null != cLDevOP.getKey("SystemName") ? (String)cLDevOP.getKey("SystemName").getValue() : null;
                    String svCCName = null != svOP.getKey("CreationClassName") ? (String)svOP.getKey("CreationClassName").getValue() : null;
                    String svSCCName = null != svOP.getKey("SystemCreationClassName") ? (String)svOP.getKey("SystemCreationClassName").getValue() : null;
                    String string2 = svSysNameKeyVal = null != svOP.getKey("SystemName") ? (String)svOP.getKey("SystemName").getValue() : null;
                    if (null != cLDevCCName && cLDevCCName.equals(this.getReference1ClassName()) && null != cLDevSCCName && cLDevSCCName.equals("HITACHI_StorageSystem") && null != cLDevSysNameKeyVal && cLDevSysNameKeyVal.equals(svSysNameKeyVal) && null != svCCName && svCCName.equals(this.getReference2ClassName()) && null != svSCCName && svSCCName.equals("HITACHI_StorageSystem") && (deviceNum = DeviceNumber.find(cLDevDeviceID, true, device.getRMIObject())) != null) {
                        return this.generateInstance(op, propertyList, deviceNum);
                    }
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath objectName) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String name = null != objectName && null != objectName.getKey("DeviceID") ? (String)objectName.getKey("DeviceID").getValue() : null;
        hTable.put("DeviceID", name);
        return hTable;
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_StorageVolumeBasedOnCompositeLDEVExtent".equalsIgnoreCase(assocName.getObjectName())) {
                DeviceNumber dn;
                CIMProperty deviceIDProp;
                String deviceID = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName) && null != (deviceIDProp = objectName.getKey("DeviceID"))) {
                        deviceID = (String)deviceIDProp.getValue();
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName) && null != (deviceIDProp = objectName.getKey("DeviceID"))) {
                    deviceID = (String)deviceIDProp.getValue();
                }
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                if (null != deviceID && null != (dn = DeviceNumber.find(deviceID, device.getRMIObject())) && !dn.isAOUVol() && !dn.isQSVvol()) {
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, dn));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, dn));
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we1 = new WBEMException(1, th.toString(), null, th);
            mLogger.log(Level.SEVERE, th.getLocalizedMessage(), th);
            if (null != iter) {
                iter.setException(we1);
                iter.close();
            }
            throw we1;
        }
        if (null != iter) {
            iter.done();
        }
    }

    private class Callback<E extends DeviceNumber>
    extends IteratorCallbackIMPL<E> {
        protected Callback(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (this.mIter.isClosed()) {
                ret = false;
            } else if (!((DeviceNumber)item).isAOUVol() && !((DeviceNumber)item).isQSVvol()) {
                try {
                    if (this.mIsObjectPath) {
                        this.mIter.add(StorageVolumeBasedOnCompositeLDEVExtentInstrumentation.this.generateObjectPath(this.mOP, item));
                    } else {
                        this.mIter.add(StorageVolumeBasedOnCompositeLDEVExtentInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, item));
                    }
                }
                catch (Exception e) {
                    WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
            }
            return ret;
        }
    }
}

