/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public final class TierServiceAffectsElementTierDomainInstrumentation
extends BaseAssocInstrumentation {
    protected TierServiceAffectsElementTierDomainInstrumentation() {
        super("HITACHI_TierServiceAffectsElementTierDomain", "HITACHI_TierService", "AffectingElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.TierServiceInstrumentation"), "HITACHI_TierDomain", "AffectedElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.TierDomainInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_TierServiceAffectsElementTierDomain".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("AffectingElement")) && (null == resultRole || resultRole.equalsIgnoreCase("AffectedElement"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        Hashtable<String, Object> depSearchProps = new Hashtable<String, Object>();
                        depSearchProps.put("SystemName", device.getStorageSystemName());
                        this.getReference2Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, depSearchProps, null);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("AffectedElement")) && (null == resultRole || resultRole.equalsIgnoreCase("AffectingElement")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        PassthruIterator deviceIter = new PassthruIterator(iter);
        try {
            for (RMIObjectMapping device : devices) {
                CIMObjectPath opTierService = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath opTierDomain = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_TierDomain", null, op.getXmlSchemaName());
                ReferenceInfo newRefInfo = new ReferenceInfo(opTierService, null, "AffectingElement", "AffectedElement", propertyList, isObjectPath, this);
                Hashtable<String, Object> depSearchProps = new Hashtable<String, Object>();
                depSearchProps.put("Name", device.getStorageSystemName());
                this.getReference2Instrumentation().enumerate(deviceIter, opTierDomain, new String[0], null, null, continueOnError, true, depSearchProps, newRefInfo);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opTierDomain;
            String cpnTierService = this.getReference1PropertyName();
            CIMObjectPath opTierService = op.getKey(cpnTierService) != null ? (CIMObjectPath)op.getKey(cpnTierService).getValue() : null;
            String cpnTierDomain = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = opTierDomain = op.getKey(cpnTierDomain) != null ? (CIMObjectPath)op.getKey(cpnTierDomain).getValue() : null;
            if (null != opTierDomain && null != opTierService) {
                String systemNameTierDomain;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opTierService, "SystemName");
                String systemNameTierService = device.getStorageSystemName();
                String nameTierDomain = opTierDomain.getKey("Name") != null && opTierDomain.getKey("Name").getValue() != null ? (String)opTierDomain.getKey("Name").getValue() : null;
                String string = systemNameTierDomain = null != nameTierDomain ? ProviderLibs.getAllButEndString(nameTierDomain, ProviderConstants.ID_SEPERATOR_AS_CHAR) : null;
                if (null != systemNameTierService && null != systemNameTierDomain && systemNameTierService.equals(systemNameTierDomain) && this.getReference2Instrumentation().instanceExists(opTierDomain)) {
                    return this.generateInstance(op, propertyList, opTierService, opTierDomain);
                }
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_TierServiceAffectsElementTierDomain".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase("HITACHI_TierService") && (null == role || role.equalsIgnoreCase("AffectingElement")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    CIMObjectPath opTierDomain = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_TierDomain", null, objectName.getXmlSchemaName());
                    CIMObjectPath opTierService = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    ReferenceInfo newRefInfo = new ReferenceInfo(opTierService, null, "AffectingElement", "AffectedElement", propertyList, isObjectPath, this);
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    Hashtable<String, Object> depSearchProps = new Hashtable<String, Object>();
                    depSearchProps.put("SystemName", device.getStorageSystemName());
                    this.getReference2Instrumentation().enumerate(iter, opTierDomain, new String[0], null, null, continueOnError, true, depSearchProps, newRefInfo);
                    needToCloseIter = false;
                } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_TierDomain") && (null == role || role.equalsIgnoreCase("AffectedElement")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                    CIMObjectPath opTierService = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                    CIMObjectPath opTierDomain = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, opTierService, opTierDomain));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, opTierService, opTierDomain));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

