/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class TierServiceCapabilitiesInstrumentation
extends BaseInstrumentation {
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "ElementName", expectedValues);
        try {
            Iterator iterDevs = devices.iterator();
            while (iterDevs.hasNext()) {
                CIMObjectPath objPath;
                String ssName = ((RMIObjectMapping)iterDevs.next()).getStorageSystemName();
                if (null != refInfo) {
                    objPath = this.generateObjectPath(op, ssName);
                    refInfo.addReference(iter, objPath);
                    continue;
                }
                if (isObjectPath) {
                    objPath = this.generateObjectPath(op, ssName);
                    iter.add(objPath);
                    continue;
                }
                CIMInstance ci = this.generateInstance(op, propertyList, ssName);
                iter.add(ci);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            Throwable t = null != th.getCause() ? th.getCause() : th;
            WBEMException we = new WBEMException(1, t.toString(), null, t);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        try {
            CIMObjectPath retOP = this.generateObjectPath(op, o);
            String clzStr = "HITACHI_TierServiceCapabilities".substring("HITACHI_".length());
            CIMProperty[] keys = retOP.getKeys();
            CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("SupportedFeatures", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO, ProviderConstants.UINT16_FOUR, ProviderConstants.UINT16_SIX}, false), new CIMProperty("SupportedStorageObjects", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0], false), new CIMProperty("SupportedStorageElements", CIMDataType.UINT16_ARRAY_T, null, false), new CIMProperty("SupportedAsynchronousActions", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0], false), new CIMProperty("SupportedSynchronousActions", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0], false), new CIMProperty("SupportedTierFeatures", CIMDataType.UINT16_ARRAY_T, null, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)clzStr, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)clzStr, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)clzStr, false)};
            return new CIMInstance(retOP, props).filterProperties(propList);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{String.class}, o, "HITACHI_TierServiceCapabilities");
        String sysName = (String)o[0];
        try {
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)sysName, true)};
            return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_TierServiceCapabilities", keys, op.getXmlSchemaName());
        }
        catch (Throwable th) {
            Throwable t = null != th.getCause() ? th.getCause() : th;
            throw new WBEMException(1, t.toString(), null, t);
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            CIMObjectPath real = this.generateObjectPath(op, device.getStorageSystemName());
            if (null != real && real.equalsModelPath(op)) {
                CIMInstance ret = this.generateInstance(op, propertyList, device.getStorageSystemName());
                return ret;
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            Throwable t = null != th.getCause() ? th.getCause() : th;
            throw new WBEMException(1, t.toString(), null, t);
        }
        throw new WBEMException(6, op != null ? op.toString() : null);
    }
}

