/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.StoragePoolInstrumentation;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public class UnpairedSnapshotVolumePoolInstrumentation
extends StoragePoolInstrumentation {
    private static String CCN_NAME = "HITACHI_UnpairedSnapshotVolumePool";
    private static final String VOLUMEDIVISORSIZE_VAL = "1048576";

    private String createInstanceID(RMIObjectMapping device) throws Exception {
        StringBuilder ret = new StringBuilder(device.getStorageSystemName());
        ret.append(ProviderConstants.ID_SEPERATOR_AS_CHAR);
        ret.append("UnpairedSnapshotVolumePool");
        return ret.toString();
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"SystemName", "InstanceID"});
        try {
            for (RMIObjectMapping device : devices) {
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, device.getRMIObject()));
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (iter != null && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    protected UnsignedInteger32 extrinsic_GetSupportedSizeRange(CIMObjectPath pOp, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        String msg;
        UnsignedInteger32 ret = ProviderConstants.UINT32_ZED;
        UnsignedInteger64 volumeSizeDivisor = new UnsignedInteger64(VOLUMEDIVISORSIZE_VAL);
        UnsignedInteger64 minVolSize = ProviderConstants.UINT64_ZED;
        UnsignedInteger64 maxVolSize = ProviderConstants.UINT64_ZED;
        CIMObjectPath goal = null;
        UnsignedInteger16 elementType = null;
        for (CIMArgument<?> arg : pInArgs) {
            if (arg.getName().equalsIgnoreCase("Goal")) {
                goal = (CIMObjectPath)arg.getValue();
                continue;
            }
            if (!arg.getName().equalsIgnoreCase("ElementType")) continue;
            elementType = (UnsignedInteger16)arg.getValue();
        }
        if (elementType == null) {
            msg = "ElementType can not be null";
            mLogger.severe("ElementType can not be null");
            minVolSize = maxVolSize = ProviderConstants.UINT64_ZED;
        } else if (3 != elementType.intValue()) {
            msg = "ElementType must have a value of 3, passed in" + elementType;
            mLogger.severe(msg);
            minVolSize = maxVolSize = ProviderConstants.UINT64_ZED;
        }
        if (maxVolSize.longValue() != 0L && goal != null) {
            ThinPool tp = ProviderLibs.getSnapShotPool(pOp);
            if (tp == null || !ProviderLibs.checkSettingGoal(goal, tp, mHandle)) {
                minVolSize = maxVolSize = ProviderConstants.UINT64_ZED;
            }
            goal = null;
        }
        pOutArgs[0] = new CIMArgument("MinimumVolumeSize", CIMDataType.UINT64_T, (Object)minVolSize);
        pOutArgs[1] = new CIMArgument("MaximumVolumeSize", CIMDataType.UINT64_T, (Object)maxVolSize);
        pOutArgs[2] = new CIMArgument("VolumeSizeDivisor", CIMDataType.UINT64_T, (Object)volumeSizeDivisor);
        return ret;
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath p, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(p, o);
        String theName = CCN_NAME.substring("HITACHI_".length());
        ArrayList<CIMProperty> props = new ArrayList<CIMProperty>();
        CIMProperty[] keys = retOP.getKeys();
        props.add(keys[0]);
        props.add(new CIMProperty("Usage", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FOUR, false));
        props.add(new CIMProperty("Label", CIMDataType.STRING_T, null, false));
        props.add(new CIMProperty("PoolID", CIMDataType.STRING_T, (Object)theName, false));
        props.add(new CIMProperty("Primordial", CIMDataType.BOOLEAN_T, (Object)false, false));
        props.add(new CIMProperty("TotalManagedSpace", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false));
        props.add(new CIMProperty("RemainingManagedSpace", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false));
        props.add(new CIMProperty("Name", CIMDataType.STRING_T, (Object)theName, false));
        props.add(new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(ProviderConstants.OP_STATUS_INDEX.OK.getStatusValue())}, false));
        props.add(new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false));
        props.add(new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false));
        props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)theName, false));
        props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)theName, false));
        props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)theName, false));
        props.add(new CIMProperty("SpaceLimitDetermination", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_THREE, false));
        props.add(new CIMProperty("SpaceLimit", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(BigInteger.valueOf(0x40000000000L)), false));
        props.add(new CIMProperty("ElementsShareSpace", CIMDataType.BOOLEAN_T, (Object)Boolean.TRUE, false));
        props.add(new CIMProperty("ReservedSpace", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false));
        return new CIMInstance(retOP, props.toArray(new CIMProperty[props.size()])).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, CCN_NAME);
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String instID = this.createInstanceID(rmiObj.getSMISMappingContainer());
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)instID, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), CCN_NAME, keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            String value;
            CIMProperty key = op.getKey("InstanceID");
            if (null != key && null != (value = (String)key.getValue()) && value.compareTo(this.createInstanceID(device)) == 0) {
                return this.generateInstance(op, propertyList, device.getRMIObject());
            }
        }
        catch (WBEMException we) {
            if (6 == we.getID() || 1 == we.getID()) {
                throw we;
            }
            throw new WBEMException(1, we.toString(), null, (Throwable)we);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
    }
}

