/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation.iSCSI;

import com.hitachi.smi.common.CHAInfo;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class ElementCapabilitiesiSCSIConfigurationInstrumentation
extends BaseAssocInstrumentation {
    public ElementCapabilitiesiSCSIConfigurationInstrumentation() {
        super("HITACHI_ElementCapabilitiesiSCSIConfiguration", "HITACHI_StorageProcessorSystem", "ManagedElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageProcessorSystemInstrumentation"), "HITACHI_iSCSIConfigurationCapabilities", "Capabilities", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.iSCSI.iSCSIConfigurationCapabilitiesInstrumentation"));
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            for (RMIObjectMapping device : devices) {
                CIMObjectPath opISCSIonfig = this.getReference2Instrumentation().generateObjectPath(op, device.getStorageSystemName());
                CommonClassAsList<CHAInfo> callback = new CommonClassAsList<CHAInfo>();
                CHAInfo.getCHAInfoByCtrID(device.getRMIObject(), callback, -1);
                LinkedList<CHAInfo> chaInfoList = callback.getReturnValue();
                callback = null;
                CHAInfo chaInfo = chaInfoList.poll();
                while (chaInfo != null) {
                    CIMObjectPath opStorageProcessorSystem = this.getReference1Instrumentation().generateObjectPath(op, chaInfo);
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, opStorageProcessorSystem, opISCSIonfig));
                    } else {
                        iter.add(this.generateInstance(op, propertyList, opStorageProcessorSystem, opISCSIonfig));
                    }
                    chaInfo = chaInfoList.poll();
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath opRef2) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String name = (String)opRef2.getKey("InstanceID").getValue();
        hTable.put("ElementName", name);
        return hTable;
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath opRef1) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String name = (String)opRef1.getKey("Name").getValue();
        hTable.put("InstanceID", ProviderLibs.getAllButEndString(name, ProviderConstants.ID_SEPERATOR_AS_CHAR));
        return hTable;
    }
}

