/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRemote;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.sanproject.rmi.SanRmiException;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.HitachiJobCallbackIF;
import com.hitachi.smi.jobs.HitachiJobCallbackIF2;
import com.hitachi.smi.jobs.HitachiJobIF;
import com.hitachi.smi.jobs.HitachiJobService;
import com.hitachi.smi.jobs.JobQueue;
import com.ws.wbem.provider.jobservice.CIM_ConcreteJob;
import com.ws.wbem.provider.jobservice.CIM_MethodResult;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;
import sanproject.serverux.data.SANRmiException;

public abstract class Coalescable
implements HitachiJobIF {
    protected static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.provider");
    protected static final int STATUS_WAIT_INTERVAL = 1000;
    private List<AbstractJobImpl> abstractJobImpls;
    private Queue<?> itemQueue = null;
    private HitachiJobService jobService = new HitachiJobService();
    private Object rmiResultObject = null;
    private Throwable error = null;
    private CIMObjectPath[] affectedElements = null;
    private CIMObjectPath owningService = null;
    private final String[] affectedJobElementClassNames = new String[]{"HITACHI_AffectedJobElementJob"};
    private String deviceSerial;

    protected Coalescable() {
        this(null);
    }

    protected Coalescable(String deviceSerial) {
        this.deviceSerial = deviceSerial;
    }

    protected void apply() throws WBEMException {
        this.apply(true);
    }

    protected void apply(boolean updateJobs) throws WBEMException {
        RMIObjectCache rmiObj = null;
        if (this.itemQueue == null || this.itemQueue.isEmpty()) {
            throw new WBEMException("'apply' method called but there are no methods to execute.");
        }
        String jobID = null == this.getJob() ? "UNKNOWN" : this.getJob().getInstanceID();
        long lockID = -1L;
        try {
            rmiObj = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber()).getRMIObject();
            if (updateJobs) {
                this.markServerJobStarted();
            }
            lockID = rmiObj.keyValueAPI_Lock();
            mLogger.finer("Obtained RMI object lock");
            this.setAuditInfo();
            rmiObj.setTransactionStartEx(lockID);
            mLogger.log(Level.INFO, "{0} transaction starts, calling setMethods {1} times.", new Object[]{jobID, this.itemQueue.size()});
            for (Object rmiAction : this.itemQueue) {
                List<Object> rmiActionsList = Arrays.asList(rmiAction);
                rmiObj.setMethods(rmiActionsList);
            }
            mLogger.finer("Methods set");
            rmiObj.setCommit();
            mLogger.info("Commiting transaction.");
            Object hitachiJobResult = rmiObj.getStatusInfoEx();
            while (null == hitachiJobResult) {
                mLogger.finer("Job running, sleeping 1000 milliseconds");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    mLogger.log(Level.FINEST, "getStatusInfoEx sleep interrupted - this is OK", ie);
                }
                if (this.getHitachiJobServiceObject() != null) {
                    this.getHitachiJobServiceObject().updateElapsedTime();
                }
                hitachiJobResult = rmiObj.getStatusInfoEx();
            }
            this.setResult(hitachiJobResult);
        }
        catch (SANRmiException sre) {
            this.setResult((Object)sre);
            throw new WBEMException(1, "Exception from backend: " + sre.getErrMsgEn(), null, (Throwable)sre);
        }
        catch (Throwable t) {
            this.setResult(t);
            String clz = t.getClass().getSimpleName();
            throw new WBEMException(1, "Received " + clz + " from backend: " + t, null, t);
        }
        finally {
            if (null != rmiObj) {
                try {
                    if (-1L != lockID) {
                        this.clearAuditInfo();
                        rmiObj.keyValueAPI_Unlock(lockID);
                    }
                }
                catch (Throwable t) {
                    mLogger.log(Level.INFO, "An error occurred during the  RMI unlock call (Informational only): " + t, t);
                }
            }
            mLogger.log(Level.INFO, "{0} transaction has completed", jobID);
        }
        if (updateJobs) {
            this.markServerJobDone();
        }
    }

    protected void apply2() throws WBEMException {
        this.apply2(true);
    }

    protected void apply2(boolean updateJobs) throws WBEMException {
        RMIObjectCache rmiObj = null;
        if (this.itemQueue == null || this.itemQueue.size() != 1) {
            throw new WBEMException("'apply2' method called but there are '" + (this.itemQueue == null ? "0" : Integer.valueOf(this.itemQueue.size())) + "' elements but it must contain 1");
        }
        String jobID = null == this.getJob() ? "UNKNOWN" : this.getJob().getInstanceID();
        long lockID = -1L;
        try {
            rmiObj = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber()).getRMIObject();
            if (updateJobs) {
                this.markServerJobStarted();
            }
            lockID = rmiObj.keyValueAPI_Lock();
            mLogger.finer("Obtained RMI object lock");
            this.setAuditInfo();
            rmiObj.setTransactionStartEx(lockID);
            mLogger.log(Level.INFO, "{0} transaction starts, calling setMethods", jobID);
            ArrayList rmiActionsList = new ArrayList(1);
            rmiActionsList.add(this.getItemQueue().poll());
            rmiObj.setMethods(rmiActionsList);
            mLogger.finer("apply2 methods set");
            rmiObj.setCommit();
            mLogger.info("Commiting transaction.");
            Object hitachiJobResult = rmiObj.getStatusInfoEx();
            while (null == hitachiJobResult) {
                mLogger.finer("Job running, sleeping 1000 milliseconds");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    mLogger.log(Level.FINEST, "getStatusInfoEx sleep interrupted - this is OK", ie);
                }
                if (this.getHitachiJobServiceObject() != null) {
                    this.getHitachiJobServiceObject().updateElapsedTime();
                }
                hitachiJobResult = rmiObj.getStatusInfoEx();
            }
            this.setResult(hitachiJobResult);
        }
        catch (SANRmiException sre) {
            this.setResult((Object)sre);
            throw new WBEMException(1, "Exception from backend: " + sre.getErrMsgEn(), null, (Throwable)sre);
        }
        catch (Throwable t) {
            this.setResult(t);
            String clz = t.getClass().getSimpleName();
            throw new WBEMException(1, "Received " + clz + " from backend: " + t, null, t);
        }
        finally {
            if (null != rmiObj) {
                try {
                    if (-1L != lockID) {
                        this.clearAuditInfo();
                        rmiObj.keyValueAPI_Unlock(lockID);
                    }
                }
                catch (Throwable t) {
                    mLogger.log(Level.INFO, "An error occurred during the  RMI unlock call (Informational only): " + t, t);
                }
            }
            mLogger.log(Level.INFO, "{0} transaction has completed", jobID);
        }
        if (updateJobs) {
            this.markServerJobDone();
        }
    }

    protected void clearAuditInfo() {
    }

    protected void createConcreteJob(String methodName, String userName, String clientIP, CIMObjectPath owningService, List<CIMObjectPath> affectedElements) throws WBEMException {
        if (this.jobService == null) {
            this.jobService = new HitachiJobService();
        }
        this.jobService.createConcreteJobInServer(this.getDeviceSerialNumber(), methodName, userName, clientIP, owningService.getHost(), owningService.getPort(), this);
        this.owningService = owningService;
        this.setAffectedElements(affectedElements);
        this.jobService.getJob().setDescription("Coalesced " + (this.abstractJobImpls == null ? "" : Integer.valueOf(this.abstractJobImpls.size())) + " " + methodName + " calls for " + userName + " on " + this.getDeviceSerialNumber());
    }

    protected void createConcreteJobFromAbstractJobs() throws WBEMException {
        List<AbstractJobImpl> listOfJobs = this.getAbstractJobImpls();
        if (listOfJobs != null && listOfJobs.size() > 0) {
            AbstractJobImpl childAbstractJob = listOfJobs.get(0);
            CIMObjectPath op = null;
            String methodName = null;
            String userName = null;
            String clientIP = null;
            CIMObjectPath owningService = null;
            if (methodName == null) {
                methodName = childAbstractJob.getMethodName();
            }
            if (userName == null) {
                userName = childAbstractJob.getUserName();
            }
            if (null == this.deviceSerial) {
                this.deviceSerial = childAbstractJob.getDeviceSerial();
            }
            if (op == null) {
                op = childAbstractJob.getOwningElement();
            }
            if (clientIP == null) {
                clientIP = childAbstractJob.getClientIP();
            }
            if (owningService == null) {
                owningService = childAbstractJob.getOwningElement();
            }
            if (null == this.deviceSerial || null == userName || null == clientIP) {
                throw new WBEMException("Not all required information provided, Device: " + this.deviceSerial + ", user: " + userName + ", client IP: " + clientIP);
            }
            if (this.getJob() == null) {
                this.createConcreteJob(methodName, userName, clientIP, owningService, new ArrayList<CIMObjectPath>(0));
            }
            if (mLogger.isLoggable(Level.INFO)) {
                StringBuilder childJobIDs = new StringBuilder();
                int idx = 0;
                for (AbstractJobImpl child : listOfJobs) {
                    if (0 != idx) {
                        childJobIDs.append(", ");
                    } else {
                        ++idx;
                    }
                    childJobIDs.append(child.getJobID());
                }
                mLogger.log(Level.INFO, "CoalescedJob {0}, children coalesced: {1}", new Object[]{this.getJob().getInstanceID(), childJobIDs.toString()});
            }
        } else {
            throw new WBEMException("Unable to create concrete job because the list of jobs is null or empty: " + listOfJobs);
        }
    }

    protected List<Integer> doStepCompleteNotification(HitachiJobCallbackIF2.StepCompleted type) {
        AbstractJobImpl child;
        HitachiJobCallbackIF childCallback;
        int numChildren = this.abstractJobImpls.size();
        ArrayList<Integer> ret = new ArrayList<Integer>(numChildren);
        for (int x = 0; x < numChildren && null != (childCallback = (child = this.abstractJobImpls.get(x)).getCallback()) && childCallback instanceof HitachiJobCallbackIF2; ++x) {
            if (this.error == null) {
                child.setRmiResult(this.rmiResultObject);
            } else {
                child.setError(this.error);
            }
            HitachiJobCallbackIF2 callback = (HitachiJobCallbackIF2)((Object)child);
            if (callback.jobStepCompleted(type)) continue;
            ret.add(x);
        }
        return ret;
    }

    protected void doUpdateJobs(HitachiJobCallbackIF.CallBackType type) {
        for (AbstractJobImpl job : this.abstractJobImpls) {
            try {
                if (this.error == null) {
                    job.setRmiResult(this.rmiResultObject);
                } else {
                    job.setError(this.error);
                }
                HitachiJobCallbackIF callback = job.getCallback();
                if (null != callback) {
                    callback.jobStateCallback(type);
                    continue;
                }
                if (type == HitachiJobCallbackIF.CallBackType.AFTER_JOB_COMPLETE) continue;
                job.getHitachiJobServiceObject().updateElapsedTime();
                CIM_ConcreteJob concreteJob = job.getJob();
                concreteJob.setOperationalStatus(this.getJob().getOperationalStatus());
                concreteJob.setPercentComplete(this.getJob().getPercentComplete());
                concreteJob.setJobState(this.getJob().getJobState());
                concreteJob.setJobStatus(this.getJob().getJobStatus());
                job.getHitachiJobServiceObject().updateJob(this.getJob().getCIMInstance(this.getOwningElement()));
            }
            catch (Throwable t) {
                mLogger.log(Level.WARNING, "Exception in updating job " + job.getJob().getInstanceID() + " doing " + (Object)((Object)type), t);
            }
        }
    }

    protected abstract void executeJob(List<AbstractJobImpl> var1) throws WBEMException;

    protected List<AbstractJobImpl> getAbstractJobImpls() {
        return this.abstractJobImpls;
    }

    public CIMObjectPath[] getAffectedElements() {
        if (mLogger.isLoggable(Level.FINE)) {
            StringBuilder msg = new StringBuilder("getAffectedElements called ");
            msg.append("for job ");
            msg.append(this.jobService.getJobID());
            msg.append(", affected class names are: ");
            msg.append(Arrays.toString(this.affectedJobElementClassNames));
            msg.append(", returning ");
            msg.append(this.affectedElements == null ? 0 : this.affectedElements.length);
            msg.append(" ObjectPaths. Elements: ");
            msg.append(Arrays.toString(this.affectedElements));
            mLogger.fine(msg.toString());
        }
        return this.affectedElements;
    }

    public String[] getAffectedJobElementClassName() {
        return this.affectedJobElementClassNames;
    }

    public String getAssociatedJobMethodResultClassName() {
        return null;
    }

    protected String getDeviceSerialNumber() throws WBEMException {
        return this.deviceSerial;
    }

    @Override
    public HitachiJobService getHitachiJobServiceObject() {
        return this.jobService;
    }

    protected Queue<?> getItemQueue() {
        return this.itemQueue;
    }

    public CIM_ConcreteJob getJob() {
        CIM_ConcreteJob ret = null;
        if (this.jobService != null) {
            ret = this.jobService.getJob();
        }
        return ret;
    }

    public CIM_MethodResult getMethodResult() {
        return null;
    }

    public CIMObjectPath getOwningElement() {
        return this.owningService;
    }

    public String getOwningJobElementClassName() {
        return "CIM_OwningJobElement";
    }

    protected Object getResult() throws WBEMException {
        if (this.error != null) {
            if (this.error instanceof WBEMException) {
                throw (WBEMException)this.error;
            }
            throw new WBEMException(1, "Exception occurred in back end: " + this.error, null, this.error);
        }
        return this.rmiResultObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SanResponse invoke(RMIObjectCache rmiObj, SanData generalParam, SanRequest sanRequest, SanRemote sanRemote) throws WBEMException {
        SanResponse responseData = null;
        long lockID = -1L;
        try {
            lockID = rmiObj.keyValueAPI_Lock();
            mLogger.log(Level.FINE, "Job {0} got system lock", this.getJob().getInstanceID());
            SanObject gp = generalParam.getObj("AccountInfo");
            if (null == gp && null == (gp = generalParam.newObj("AccountInfo"))) {
                throw new WBEMException("Unable to add resource lock ID to parameter");
            }
            gp.putLong("ResourcelockId", lockID);
            responseData = rmiObj.keyValueAPI_Invoke("Coalescable", sanRemote, generalParam, sanRequest, false);
            if (null == rmiObj) return responseData;
        }
        catch (SanDataException | SanRmiException | RemoteException e) {
            try {
                Throwable t = e;
                while (null != t.getCause()) {
                    t = t.getCause();
                }
                throw new WBEMException(1, t.getMessage(), null, t);
            }
            catch (Throwable throwable) {
                if (null == rmiObj) throw throwable;
                try {
                    if (-1L != lockID) {
                        this.clearAuditInfo();
                        rmiObj.keyValueAPI_Unlock(lockID);
                        mLogger.log(Level.FINE, "Job {0} released system lock", new Object[]{this.getJob().getInstanceID()});
                    }
                }
                catch (Throwable t) {
                    mLogger.log(Level.INFO, "An error occurred during the  RMI unlock call (Informational only): " + t, t);
                }
                try {
                    rmiObj.refreshUx(0);
                    throw throwable;
                }
                catch (RemoteException | SANRmiException e2) {
                    mLogger.log(Level.SEVERE, "Invoke error calling refreshUx, ignoring", e2);
                }
                throw throwable;
            }
        }
        try {
            if (-1L != lockID) {
                this.clearAuditInfo();
                rmiObj.keyValueAPI_Unlock(lockID);
                mLogger.log(Level.FINE, "Job {0} released system lock", new Object[]{this.getJob().getInstanceID()});
            }
        }
        catch (Throwable t) {
            mLogger.log(Level.INFO, "An error occurred during the  RMI unlock call (Informational only): " + t, t);
        }
        try {
            rmiObj.refreshUx(0);
            return responseData;
        }
        catch (RemoteException | SANRmiException e) {
            mLogger.log(Level.SEVERE, "Invoke error calling refreshUx, ignoring", e);
            return responseData;
        }
    }

    protected void markAndRemoveChildJobWithError(Iterator<AbstractJobImpl> iter, AbstractJobImpl childJob, String msg) {
        mLogger.severe(msg);
        WBEMException we = new WBEMException(msg);
        childJob.getHitachiJobServiceObject().markServerJobDone(we);
        childJob.getHitachiJobServiceObject().markServerjobComplete();
        JobQueue.getJobQ().addCompletedJob(childJob);
        iter.remove();
    }

    protected void markServerJobComplete() {
        this.doUpdateJobs(HitachiJobCallbackIF.CallBackType.BEFORE_JOB_COMPLETE);
        this.jobService.markServerjobComplete();
        JobQueue.getJobQ().addCompletedJob(this);
        for (AbstractJobImpl job : this.abstractJobImpls) {
            job.getHitachiJobServiceObject().markServerjobComplete();
            JobQueue.getJobQ().addCompletedJob(job);
        }
        this.doUpdateJobs(HitachiJobCallbackIF.CallBackType.AFTER_JOB_COMPLETE);
    }

    protected void markServerJobDone() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Coalescable.this.jobService.markServerJobDone(Coalescable.this.error);
                Coalescable.this.doUpdateJobs(HitachiJobCallbackIF.CallBackType.AFTER_TRANSACTION);
                Coalescable.this.markServerJobComplete();
            }
        };
        if (this.error == null) {
            Thread xthread = new Thread(runnable, "Coalesced job " + (this.getJob() == null ? "Unknown" : this.getJob().getInstanceID()));
            xthread.setDaemon(true);
            xthread.start();
        } else {
            this.jobService.markServerJobDone(this.error);
            this.doUpdateJobs(HitachiJobCallbackIF.CallBackType.AFTER_TRANSACTION);
            this.markServerJobComplete();
        }
    }

    protected void markServerJobStarted() {
        this.markServerJobStarted(50);
    }

    protected void markServerJobStarted(int percent) {
        this.jobService.markServerJobStarted(percent);
        this.doUpdateJobs(HitachiJobCallbackIF.CallBackType.BEFORE_TRANSACTION);
    }

    protected void setAbstractJobImpls(List<AbstractJobImpl> actionItems) {
        this.abstractJobImpls = actionItems;
    }

    protected void setAffectedElements(List<CIMObjectPath> affectedElements) {
        this.affectedElements = affectedElements.toArray(new CIMObjectPath[affectedElements.size()]);
    }

    protected void setAuditInfo() {
    }

    protected void setDeviceSerialNumber(String deviceNumber) {
        this.deviceSerial = deviceNumber;
    }

    protected void setItemQueue(Queue<?> theQueue) {
        this.itemQueue = theQueue;
    }

    protected void setResult(Object theResult) {
        if (theResult instanceof Throwable) {
            this.error = (Throwable)theResult;
        } else {
            this.rmiResultObject = theResult;
        }
    }

    protected void updateChildrenJobPercentComplete(int newPercent) {
        for (AbstractJobImpl job : this.abstractJobImpls) {
            if (job == null || job.getHitachiJobServiceObject() == null) continue;
            job.getHitachiJobServiceObject().updateServerJobPercentComplete(newPercent, true);
        }
    }
}

