/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.cache.HitachiCacheMangerService;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.CoalescedCreateModifyNormalPool;
import com.hitachi.smi.jobs.HitachiJobCallbackIF;
import java.io.Serializable;
import java.util.Set;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class CreateModifyNormalPool
extends AbstractJobImpl
implements HitachiJobCallbackIF,
CacheUpdateNotifier {
    private static final BaseInstrumentation bi = BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StoragePoolInstrumentation");
    private final int raidLvl;
    private boolean jobDone;
    private final int fb4;
    private final int pg;

    public CreateModifyNormalPool(String serialNumber, String user, String ip, CIMObjectPath owningSrvc, Set<PDEVInfoEntry> pdevInfos, int raidLvlInt, int fb4, int pg) throws WBEMException {
        super(serialNumber, "CreateOrModifyStoragePool", user, ip, owningSrvc, "HITACHI_AffectedJobElementStoragePool", "HITACHI_StorageCSOwningJobElement", null);
        this.raidLvl = raidLvlInt;
        this.setActionItem(pdevInfos);
        this.fb4 = fb4;
        this.pg = pg;
        this.jobDone = false;
        this.setCallback(this);
        CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.VDEV, this, serialNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        ChassisArrayGroup cag = (ChassisArrayGroup)pObj;
        if (this.getFb4() == cag.getFb4() && this.getPg() == cag.getPg()) {
            CreateModifyNormalPool createModifyNormalPool = this;
            synchronized (createModifyNormalPool) {
                try {
                    this.setAffectedElements(new CIMObjectPath[]{bi.generateObjectPath(this.getOwningElement(), cag)});
                }
                catch (Throwable e) {
                    mLogger.log(Level.SEVERE, "Unable to set affected elements", e);
                }
                this.jobDone = true;
                this.notifyAll();
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
    }

    @Override
    protected Set<PDEVInfoEntry> getActionItem() {
        return (Set)super.getActionItem();
    }

    @Override
    public CIMObjectPath[] getAffectedElements() {
        CIMObjectPath[] ret = null;
        if (this.jobDone) {
            ret = super.getAffectedElements();
        }
        return ret;
    }

    @Override
    protected Coalescable getCoalescableObject() {
        return new CoalescedCreateModifyNormalPool();
    }

    protected final int getFb4() {
        return this.fb4;
    }

    protected final int getPg() {
        return this.pg;
    }

    public int getRaidLvl() {
        return this.raidLvl;
    }

    @Override
    public void jobStateCallback(HitachiJobCallbackIF.CallBackType type) throws WBEMException {
        switch (type) {
            case BEFORE_TRANSACTION: {
                this.getHitachiJobServiceObject().markServerJobStarted(10);
                break;
            }
            case BEFORE_JOB_COMPLETE: {
                this.getHitachiJobServiceObject().updateElapsedTime();
                break;
            }
            case AFTER_TRANSACTION: {
                this.getHitachiJobServiceObject().updateElapsedTime();
                this.processJobComplete();
                this.unsubscribe();
                break;
            }
        }
        if (type != HitachiJobCallbackIF.CallBackType.AFTER_JOB_COMPLETE) {
            this.getHitachiJobServiceObject().updateJob(this.getJob().getCIMInstance(this.getOwningElement()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJobComplete() {
        WBEMException we = null;
        try {
            this.getRMIResult();
        }
        catch (WBEMException e) {
            we = e;
            this.jobDone = true;
        }
        while (!this.jobDone && !HitachiCacheMangerService.isShuttingDown()) {
            CreateModifyNormalPool createModifyNormalPool = this;
            synchronized (createModifyNormalPool) {
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException e) {
                    mLogger.log(Level.SEVERE, "Wait was interuptted, job is in an unknown state", e);
                    we = new WBEMException("Wait was interuptted, job is in an unknown state");
                    break;
                }
            }
        }
        this.getHitachiJobServiceObject().markServerJobDone(we);
    }

    @Override
    protected void setError(Throwable error) {
        super.setError(error);
        this.unsubscribe();
    }

    private void unsubscribe() {
        CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.VDEV, this, this.getDeviceSerial());
    }
}

