/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.mof;

import com.ws.cim.mof.MOFComments;
import com.ws.cim.mof.MOFCommentsClass;
import com.ws.cim.mof.MOFCommentsMethod;
import com.ws.cim.mof.MOFStyleBase;
import com.ws.cim.mof.compiler.CIMMutableClass;
import com.ws.cim.mof.compiler.CIMMutableClassProperty;
import com.ws.cim.mof.compiler.CIMMutableMethod;
import com.ws.cim.mof.compiler.CIMMutableParameter;
import com.ws.cim.mof.compiler.CIMMutableProperty;
import com.ws.cim.mof.compiler.CIMMutableQualifier;
import com.ws.cim.mof.compiler.CIMMutableQualifierType;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTime;
import javax.cim.CIMInstance;
import javax.cim.CIMQualifier;

public class MOFStyleMutable
extends MOFStyleBase {
    private CIMMutableQualifier getQualifier(CIMMutableQualifier[] qualifiers, String name) {
        for (CIMMutableQualifier q : qualifiers) {
            if (!name.equals(q.getName())) continue;
            return q;
        }
        return null;
    }

    @Override
    public String generateMOF(Object o) {
        String mof = null;
        if (o instanceof CIMInstance) {
            mof = this.generateInstanceMOF((CIMInstance)o);
        } else if (o instanceof CIMMutableClass) {
            CIMMutableClass cmClass = (CIMMutableClass)o;
            mof = this.generateClassMOF(cmClass.getCIMClass(), new CIMClassComments(cmClass));
        } else if (o instanceof CIMMutableQualifierType) {
            CIMMutableQualifierType cqt = (CIMMutableQualifierType)o;
            mof = this.generateQualifierTypeMOF(cqt.getCIMQualifierType(), new CIMQualifierTypeComments(cqt));
        } else if (o instanceof CIMQualifier) {
            mof = this.generateQualifierMOF((CIMQualifier)o);
        } else if (o instanceof CIMDateTime) {
            mof = this.generateDateTimeMOF((CIMDateTime)o);
        } else if (o instanceof CIMMutableClassProperty) {
            CIMMutableClassProperty cmClassProperty = (CIMMutableClassProperty)o;
            mof = this.generateClassPropertyMOF(cmClassProperty.getCIMProperty(), new CIMClassPropertyComments(cmClassProperty));
        } else if (o instanceof CIMMutableProperty) {
            CIMMutableProperty cmProperty = (CIMMutableProperty)o;
            mof = this.generatePropertyMOF(cmProperty.getCIMProperty(), null);
        } else if (o instanceof CIMDataType) {
            mof = this.generateDataTypeMOF((CIMDataType)o);
        } else if (o instanceof CIMMutableMethod) {
            CIMMutableMethod cmMethod = (CIMMutableMethod)o;
            mof = this.generateMethodMOF(cmMethod.getMethod(), new CIMMethodComments(cmMethod));
        } else if (o instanceof CIMMutableParameter) {
            CIMMutableParameter cmParameter = (CIMMutableParameter)o;
            mof = this.generateParameterMOF(cmParameter.getParameter(), new CIMParameterComments(cmParameter));
        } else {
            mof = String.valueOf(o);
        }
        return mof;
    }

    class CIMQualifierTypeComments
    implements MOFComments {
        CIMMutableQualifierType mQualifierType;

        CIMQualifierTypeComments(CIMMutableQualifierType qualifierType) {
            this.mQualifierType = qualifierType;
        }

        @Override
        public String getPreComment() {
            return this.mQualifierType.getComment();
        }

        @Override
        public String getPostComment() {
            return null;
        }

        @Override
        public String getQualifierComment(String name) {
            return null;
        }
    }

    class CIMClassComments
    implements MOFCommentsClass {
        CIMMutableClass mClass;

        CIMClassComments(CIMMutableClass clazz) {
            this.mClass = clazz;
        }

        @Override
        public String getPreComment() {
            return this.mClass.getQualifierListComments();
        }

        @Override
        public String getPostComment() {
            return this.mClass.getClassEndComments();
        }

        @Override
        public String getQualifierComment(String name) {
            CIMMutableQualifier q = MOFStyleMutable.this.getQualifier(this.mClass.getQualifiers(), name);
            if (null != q) {
                return q.getComment();
            }
            return null;
        }

        @Override
        public MOFCommentsMethod getMethodComments(String name) {
            return new CIMMethodComments(this.mClass.getMethod(name));
        }

        @Override
        public MOFComments getPropertyComments(String name) {
            return new CIMClassPropertyComments(this.mClass.getProperty(name));
        }
    }

    class CIMParameterComments
    implements MOFComments {
        CIMMutableParameter mParameter;

        CIMParameterComments(CIMMutableParameter parameter) {
            this.mParameter = parameter;
        }

        @Override
        public String getPreComment() {
            return this.mParameter.getComment();
        }

        @Override
        public String getPostComment() {
            return null;
        }

        @Override
        public String getQualifierComment(String name) {
            CIMMutableQualifier q = MOFStyleMutable.this.getQualifier(this.mParameter.getQualifiers(), name);
            if (null != q) {
                return q.getComment();
            }
            return null;
        }
    }

    class CIMClassPropertyComments
    implements MOFComments {
        CIMMutableClassProperty mProperty;

        CIMClassPropertyComments(CIMMutableClassProperty property) {
            this.mProperty = property;
        }

        @Override
        public String getPreComment() {
            return this.mProperty.getComment();
        }

        @Override
        public String getPostComment() {
            return null;
        }

        @Override
        public String getQualifierComment(String name) {
            CIMMutableQualifier q = MOFStyleMutable.this.getQualifier(this.mProperty.getQualifiers(), name);
            if (null != q) {
                return q.getComment();
            }
            return null;
        }
    }

    class CIMMethodComments
    implements MOFCommentsMethod {
        private final CIMMutableMethod mMethod;

        CIMMethodComments(CIMMutableMethod method) {
            this.mMethod = method;
        }

        @Override
        public String getPreComment() {
            return this.mMethod.getComment();
        }

        @Override
        public String getPostComment() {
            return null;
        }

        @Override
        public String getQualifierComment(String name) {
            CIMMutableQualifier q = MOFStyleMutable.this.getQualifier(this.mMethod.getQualifiers(), name);
            if (null != q) {
                return q.getComment();
            }
            return null;
        }

        @Override
        public MOFComments getParameterComments(String name) {
            CIMMutableParameter parameter = this.getMutableParamter(this.mMethod.getParameters(), name);
            if (null != parameter) {
                return new CIMParameterComments(parameter);
            }
            return null;
        }

        private CIMMutableParameter getMutableParamter(CIMMutableParameter[] parameters, String name) {
            for (CIMMutableParameter p : parameters) {
                if (!name.equals(p.getName())) continue;
                return p;
            }
            return null;
        }
    }
}

