/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem;

public enum IndicationType {
    InstanceCreation(0, "CIM_InstCreation"),
    InstanceDeletion(1, "CIM_InstDeletion"),
    InstanceModification(2, "CIM_InstModification"),
    InstanceRead(3, "CIM_InstRead"),
    InstanceMethodCall(4, "CIM_InstMethodCall"),
    ClassCreation(5, "CIM_ClassCreation"),
    ClassDeletion(6, "CIM_ClassDeletion"),
    ClassModification(7, "CIM_ClassModification"),
    Process(0, null);

    private final int mOffset;
    private final String mClassName;

    private IndicationType(int offset, String className) {
        this.mOffset = offset;
        this.mClassName = className;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public boolean isInstanceIndication() {
        return this.equals((Object)InstanceCreation) || this.equals((Object)InstanceDeletion) || this.equals((Object)InstanceModification) || this.equals((Object)InstanceRead) || this.equals((Object)InstanceMethodCall);
    }

    public boolean isClassIndication() {
        return this.equals((Object)ClassCreation) || this.equals((Object)ClassDeletion) || this.equals((Object)ClassModification);
    }

    public boolean isProcessIndication() {
        return this.equals((Object)Process);
    }

    public static IndicationType getIndicationTypeByClassName(String classname) {
        IndicationType ret = null;
        if (null != classname) {
            String tmpClassname = classname.toLowerCase();
            if (tmpClassname.equalsIgnoreCase(InstanceModification.getClassName())) {
                ret = InstanceModification;
            } else if (tmpClassname.equals(InstanceDeletion.getClassName())) {
                ret = InstanceDeletion;
            } else if (tmpClassname.equals(InstanceCreation.getClassName())) {
                ret = InstanceCreation;
            } else if (tmpClassname.equals(InstanceMethodCall.getClassName())) {
                ret = InstanceMethodCall;
            } else if (tmpClassname.equals(InstanceRead.getClassName())) {
                ret = InstanceRead;
            } else if (tmpClassname.equals(IndicationType.ClassCreation.mClassName)) {
                ret = ClassCreation;
            } else if (tmpClassname.equals(ClassDeletion.getClassName())) {
                ret = ClassDeletion;
            } else if (tmpClassname.equals(ClassModification.getClassName())) {
                ret = ClassModification;
            }
        }
        return ret;
    }
}

