/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.client.adapter.common;

import com.ws.logging.TraceDocument;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingInputStream
extends InputStream {
    private final InputStream mStream;
    private final Logger mLogger = Logger.getLogger("com.ws.wbem.client");
    private StringBuffer mBuffer;

    public LoggingInputStream(InputStream stream) {
        this.mStream = stream;
        this.mBuffer = new StringBuffer();
    }

    @Override
    public int read() throws IOException {
        int b = this.mStream.read();
        if (b > 0) {
            this.mBuffer.append((char)b);
        }
        return b;
    }

    @Override
    public void close() throws IOException {
        if (this.mBuffer.length() > 0) {
            this.mLogger.log(Level.FINEST, this.mBuffer.toString());
            TraceDocument.trace((String)this.mBuffer.toString(), (boolean)false);
        }
        this.mBuffer = new StringBuffer();
        this.mStream.close();
    }
}

