/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.repository;

import com.ws.utilities.WSIStandardMessages;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.CIMRepository;
import com.ws.wbem.query.WBEMQuery;
import com.ws.wbem.query.WBEMQueryLanguageFactory;
import com.ws.wbem.query.fql.FQLParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.cim.CIMArgument;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMMethod;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.CIMQualifier;
import javax.cim.CIMQualifierType;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.provider.ProviderHandle;
import org.wbemservices.wbem.repository.CIMAssocClassRlogEntry;
import org.wbemservices.wbem.repository.CIMAssocInstanceRlogEntry;
import org.wbemservices.wbem.repository.CIMClassRlogEntry;
import org.wbemservices.wbem.repository.CIMInstanceRlogEntry;
import org.wbemservices.wbem.repository.CIMNameSpaceRlogEntry;
import org.wbemservices.wbem.repository.CIMQualifierTypeRlogEntry;
import org.wbemservices.wbem.repository.CIMRlogEntry;
import org.wbemservices.wbem.repository.ClassChecker;
import org.wbemservices.wbem.repository.InstanceNameUtils;
import org.wbemservices.wbem.repository.LogException;
import org.wbemservices.wbem.repository.LogHandler;
import org.wbemservices.wbem.repository.PersistentStore;
import org.wbemservices.wbem.repository.ReadersWriter;
import org.wbemservices.wbem.repository.ReliableLog;

public class PSRlogImpl
implements CIMRepository {
    private static CIMRepository mRepository;
    private ProviderHandle pch;
    private static final String CIMROOT = "/";
    public static final String TOP = "top";
    private static final int LOG_VERSION = 1;
    private static HashMap<String, CIMNameSpaceRlogEntry> nameSpacesMap;
    private ReliableLog log;
    private boolean inRecovery;
    private final Object snapshotNotifier = new Object();
    private final int logToSnapshotThresh = 200;
    private int logFileSize = 0;
    private final Thread snapshotter = new SnapshotThread();
    private PersistentStore store = null;
    private ClassChecker classCheck;
    private final ReadersWriter concurrentObj = new ReadersWriter();

    private static String cleanNamespace(String namespace) {
        String ret;
        for (ret = namespace; ret != null && ret.startsWith(CIMROOT); ret = ret.substring(1)) {
        }
        return ret;
    }

    static Object deserialize(byte[] bytes) throws WBEMException {
        Object obj;
        try {
            ByteArrayInputStream bas = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bas);
            obj = ois.readObject();
            ois.close();
            bas.close();
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
        return obj;
    }

    static CIMNameSpaceRlogEntry getNameSpaceEntryFromMap(String namespace, WBEMOperation genericOperationName) throws WBEMException {
        String ns = PSRlogImpl.cleanNamespace(namespace.replace('\\', '/'));
        CIMNameSpaceRlogEntry nsentry = nameSpacesMap.get(ns);
        if (nsentry == null) {
            throw WBEMOperationErrors.getNamespaceNotFoundException((CIMObjectPath)new CIMObjectPath(null, null, null, namespace, "", null), (WBEMOperation)genericOperationName, null);
        }
        return nsentry;
    }

    public static CIMRepository getRepository() {
        return mRepository;
    }

    static byte[] serialize(Object obj) throws WBEMException {
        byte[] bytes;
        try {
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bas);
            oos.writeObject(obj);
            oos.flush();
            bytes = bas.toByteArray();
            oos.close();
            bas.close();
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
        return bytes;
    }

    public void activateFilter(CIMInstance filter, CIMInstance listenerDestination, CIMInstance subscription) throws WBEMException {
    }

    private void addCIMClass(CIMClass cc) throws WBEMException {
        String namespace = PSRlogImpl.cleanNamespace(cc.getObjectPath().getNamespace());
        String cname = cc.getName();
        String supercc = cc.getSuperClassName();
        boolean assoc = cc.isAssociation();
        CIMRlogEntry ccentry = this.createClassDo(namespace, cname, supercc, assoc, cc);
        this.createAddElementLogRecord(namespace, ccentry, cc, cname);
    }

    private void addCIMElementDo(String iname, String namespace, CIMInstance ci) throws WBEMException {
        String cname = ci.getClassName();
        namespace = PSRlogImpl.cleanNamespace(namespace);
        CIMRlogEntry entry = this.addCIMInstanceDo(namespace, iname, cname, ci);
        this.createAddElementLogRecord(namespace, entry, ci, iname);
    }

    private CIMRlogEntry addCIMInstanceDo(String namespace, String iname, String cname, CIMInstance ci) throws WBEMException {
        try {
            namespace = PSRlogImpl.cleanNamespace(namespace);
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace, WBEMOperation.CREATEINSTANCE);
            CIMClassRlogEntry ccentry = nsentry.getClass(cname);
            if (ccentry == null) {
                throw WBEMOperationErrors.getClassNotFoundException((CIMObjectPath)ci.getObjectPath(), (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)ci.getClassName());
            }
            CIMInstanceRlogEntry cientry = ccentry.getInstance(iname);
            if (cientry != null) {
                throw WBEMOperationErrors.getInstanceExistsException((CIMObjectPath)ci.getObjectPath(), (WBEMOperation)WBEMOperation.CREATEINSTANCE, (String)ci.getClassName());
            }
            if (ccentry instanceof CIMAssocClassRlogEntry) {
                cientry = new CIMAssocInstanceRlogEntry(nsentry, iname);
                CIMAssocInstanceRlogEntry associentry = (CIMAssocInstanceRlogEntry)cientry;
                associentry.validateInstanceAssociations();
                associentry.createAssciations(ci);
                associentry.addInstanceAssociations(cname, associentry);
            } else {
                cientry = new CIMInstanceRlogEntry(nsentry, iname);
            }
            ccentry.addInstance(cientry);
            return cientry;
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
    }

    private void addLogRecord(LogRecord rec) {
        try {
            if (!this.inRecovery) {
                this.log.update(rec, true);
                if (++this.logFileSize >= 200) {
                    this.concurrentObj.waiterNotify(this.snapshotNotifier);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIterator<CIMClass> associatorClasses(CIMObjectPath op, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers) throws WBEMException {
        try {
            this.concurrentObj.readLock();
            ArrayList v = new ArrayList();
            if (role != null && role.length() != 0 && resultRole != null && resultRole.length() != 0 && role.equalsIgnoreCase(resultRole)) {
                CloseableAddableIterator closeableAddableIterator = new CloseableAddableIterator(v);
                return closeableAddableIterator;
            }
            String ns = op.getNamespace();
            String cname = op.getObjectName();
            ns = PSRlogImpl.cleanNamespace(ns.replace('\\', '/'));
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(ns, WBEMOperation.ASSOCIATORCLASSES);
            this.intAssociators(nsentry, cname, assocClass, resultClass, role, resultRole, includeQualifiers, null, v, false);
            CloseableAddableIterator closeableAddableIterator = new CloseableAddableIterator(v);
            return closeableAddableIterator;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    public CloseableIterator<CIMInstance> associators(CIMObjectPath op, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError) throws WBEMException {
        FQLParser fqlParser = FQLParser.getFQLParser((String)filterQueryLanguage, (String)filterQuery, (CIMObjectPath)objectName, (WBEMOperation)WBEMOperation.ASSOCIATORS);
        return fqlParser.evaluate(this.instanceAssociators(op, objectName, resultClass, role, resultRole, propertyList, false, false));
    }

    public void authorizeFilter(CIMInstance filter, CIMInstance listenerDestination, CIMInstance subscription) throws WBEMException {
    }

    private boolean checkIfQualifierInUse(CIMObjectPath path, CIMQualifierType<?> qt) throws WBEMException {
        CloseableIterator<CIMObjectPath> allClasses = this.enumerateClassNamesDo(new CIMObjectPath(null, null, null, path.getNamespace(), "", null), true);
        while (allClasses.hasNext()) {
            CIMMethod[] methods;
            CIMClassProperty[] props;
            CIMObjectPath cop = (CIMObjectPath)allClasses.next();
            CIMClass cimclass = this.getClassDo(cop);
            CIMQualifier classQual = cimclass.getQualifier(qt.getName());
            if (classQual != null) {
                return true;
            }
            for (CIMClassProperty prop : props = cimclass.getProperties()) {
                CIMQualifier propQual = prop.getQualifier(qt.getName());
                if (propQual == null) continue;
                return true;
            }
            for (CIMMethod method : methods = cimclass.getMethods()) {
                CIMQualifier methQual = method.getQualifier(qt.getName());
                if (methQual == null) continue;
                return true;
            }
        }
        return false;
    }

    public void close() {
        Logger logger = Logger.getLogger("com.ws.wbem.jserver");
        logger.info("Repository shutdown");
    }

    private void createAddElementLogRecord(String namespace, CIMRlogEntry entry, Object element, String iname) throws WBEMException {
        this.createLogRecord(PSRlogImpl.cleanNamespace(namespace), entry, element, true, iname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createClass(CIMClass cc) throws WBEMException {
        try {
            cc = this.classCheck.checkClassSanity(PSRlogImpl.cleanNamespace(cc.getObjectPath().getNamespace()), cc, null);
            this.concurrentObj.writeLock();
            this.addCIMClass(cc);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private CIMRlogEntry createClassDo(String namespace, String cname, String supercc, boolean assoc, CIMClass cc) throws WBEMException {
        namespace = PSRlogImpl.cleanNamespace(namespace);
        if (supercc == null || supercc.length() == 0) {
            supercc = TOP;
        }
        try {
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace, WBEMOperation.CREATECLASS);
            CIMClassRlogEntry ccentry = nsentry.getClass(cname);
            if (ccentry != null) {
                throw WBEMOperationErrors.getClassExistsException((CIMObjectPath)cc.getObjectPath(), (WBEMOperation)WBEMOperation.CREATECLASS, (String)cc.getName());
            }
            CIMClassRlogEntry supccentry = nsentry.getClass(supercc);
            if (supccentry == null) {
                throw WBEMOperationErrors.getSuperClassNotFoundException((CIMObjectPath)cc.getObjectPath(), (String)cc.getSuperClassName(), (WBEMOperation)WBEMOperation.CREATECLASS, (String)cc.getName());
            }
            if (assoc) {
                ccentry = new CIMAssocClassRlogEntry(nsentry, cname, supercc);
                ((CIMAssocClassRlogEntry)ccentry).createAssciations(cc);
            } else {
                ccentry = new CIMClassRlogEntry(nsentry, cname, supercc);
            }
            supccentry.addSubClass(ccentry);
            nsentry.addClass(ccentry);
            return ccentry;
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMObjectPath createInstance(CIMInstance ci) throws WBEMException {
        String namespace = PSRlogImpl.cleanNamespace(ci.getObjectPath().getNamespace());
        CIMClass cc = this.getClass(ci.getObjectPath(), false, true);
        if (cc.hasQualifierValue("Abstract", (Object)true)) {
            Object[] o = new Object[]{cc.getName()};
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)ci.getObjectPath(), (String)WSIStandardMessages.getMessage((String)"ERROR_INSTANCE_IS_ABSTRACT", (Object[])o), (WBEMOperation)WBEMOperation.CREATEINSTANCE, null);
        }
        if (cc.hasQualifierValue("Indication", (Object)true)) {
            Object[] o = new Object[]{cc.getName()};
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)ci.getObjectPath(), (String)WSIStandardMessages.getMessage((String)"ERROR_INSTANCE_IS_INDICATION", (Object[])o), (WBEMOperation)WBEMOperation.CREATEINSTANCE, null);
        }
        ArrayList<CIMProperty> l = new ArrayList<CIMProperty>();
        for (int i = 0; i < cc.getPropertyCount(); ++i) {
            CIMClassProperty ccp = cc.getProperty(i);
            if (ccp == null || !ccp.isKey()) continue;
            if (ci.getPropertyValue(ccp.getName()) == null) {
                Object[] o = new Object[]{ccp.getName()};
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)ci.getObjectPath(), (String)WSIStandardMessages.getMessage((String)"ERROR_PROPERTY_KEY_VALUE_NULL", (Object[])o), (WBEMOperation)WBEMOperation.CREATEINSTANCE, null);
            }
            l.add(new CIMProperty(ccp.getName(), ccp.getDataType(), ci.getPropertyValue(ccp.getName()), true));
        }
        CIMObjectPath cop = new CIMObjectPath(null, null, null, namespace, cc.getName(), l.toArray(new CIMProperty[l.size()]));
        ci = ci.deriveInstance(cop);
        String iname = InstanceNameUtils.getInstanceNameKey(ci.getObjectPath());
        try {
            this.concurrentObj.writeLock();
            this.addCIMElementDo(iname, namespace, ci);
            CIMObjectPath cIMObjectPath = ci.getObjectPath();
            return cIMObjectPath;
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private void createLogRecord(String namespace, CIMRlogEntry entry, Object element, boolean add, String name) throws WBEMException {
        String otherName = null;
        namespace = PSRlogImpl.cleanNamespace(namespace);
        boolean assoc = false;
        AddCIMQualifierLogObj rec = null;
        try {
            entry.createPersistObject(PSRlogImpl.serialize(element));
        }
        catch (IOException ioe) {
            return;
        }
        PersistentStore.PersistObject po = entry.getPersistObject();
        if (element instanceof CIMQualifierType) {
            rec = add ? new AddCIMQualifierLogObj(namespace, name, po) : new SetCIMQualifierLogObj(namespace, name, po);
        } else if (element instanceof CIMClass) {
            assoc = ((CIMClass)element).isAssociation();
            otherName = ((CIMClass)element).getSuperClassName();
            rec = add ? new AddCIMClassLogObj(namespace, name, otherName, assoc, po) : new SetCIMClassLogObj(namespace, name, otherName, po);
        } else if (element instanceof CIMInstance) {
            otherName = ((CIMInstance)element).getClassName();
            if (add) {
                assoc = entry instanceof CIMAssocInstanceRlogEntry;
                rec = new AddCIMInstanceLogObj(namespace, name, otherName, assoc, po);
            } else {
                rec = new SetCIMInstanceLogObj(namespace, name, otherName, po);
            }
        }
        this.addLogRecord(rec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNamespace(String name) throws WBEMException {
        try {
            this.concurrentObj.writeLock();
            this.createNameSpaceDo(name);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private void createNameSpaceDo(String namespace) throws WBEMException {
        String ns = PSRlogImpl.cleanNamespace(namespace.replace('\\', '/'));
        try {
            if (ns == null || ns.length() == 0 || ns.equals(CIMROOT)) {
                Object[] o = new Object[]{namespace};
                throw new WBEMException(4, WSIStandardMessages.getMessage((String)"ERROR_NAMESPACE_INVALID_ARG", (Object[])o));
            }
            CIMNameSpaceRlogEntry nsentry = nameSpacesMap.get(ns);
            if (nsentry != null) {
                Object[] o = new Object[]{namespace};
                throw new WBEMException(11, WSIStandardMessages.getMessage((String)"ERROR_NAMESPACE_EXISTS", (Object[])o));
            }
            nsentry = new CIMNameSpaceRlogEntry(ns);
            nsentry.addClass(new CIMClassRlogEntry(nsentry, TOP, ""));
            this.putNameSpaceEntryToMap(nsentry);
            this.addLogRecord(new CreateNameSpaceLogObj(ns));
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createQualifierType(CIMQualifierType<?> qt) throws WBEMException {
        try {
            this.concurrentObj.writeLock();
            String qtName = qt.getName();
            String namespace = PSRlogImpl.cleanNamespace(qt.getObjectPath().getNamespace());
            CIMRlogEntry qtentry = this.createQualifierTypeDo(namespace, qtName);
            this.createAddElementLogRecord(namespace, qtentry, qt, qtName);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private CIMRlogEntry createQualifierTypeDo(String namespace, String qtName) throws WBEMException {
        try {
            namespace = PSRlogImpl.cleanNamespace(namespace);
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace, WBEMOperation.CREATEQUALIFIERTYPE);
            CIMQualifierTypeRlogEntry qtentry = nsentry.getQualifierType(qtName);
            if (qtentry != null) {
                throw WBEMOperationErrors.getQualifierTypeAlreadyExistsException((CIMObjectPath)new CIMObjectPath(null, null, null, namespace, qtName, null), (WBEMOperation)WBEMOperation.CREATEQUALIFIERTYPE);
            }
            qtentry = new CIMQualifierTypeRlogEntry(namespace, qtName);
            nsentry.addQualifierType(qtentry);
            return qtentry;
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
    }

    private void createSetElementLogRecord(String namespace, CIMRlogEntry entry, Object element, String iname) throws WBEMException {
        this.createLogRecord(PSRlogImpl.cleanNamespace(namespace), entry, element, false, iname);
    }

    public void deActivateFilter(CIMInstance filter, CIMInstance listenerDestination, CIMInstance subscription) throws WBEMException {
    }

    private ArrayList<String> deepEnum(CIMNameSpaceRlogEntry nsentry, String cname) throws WBEMException {
        CIMClassRlogEntry ccentry = nsentry.getClass(cname);
        if (ccentry == null) {
            throw new WBEMException(6, cname);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(cname);
        for (int i = 0; i < list.size(); ++i) {
            ccentry = nsentry.getClass(list.get(i));
            if (ccentry == null) {
                throw new WBEMException(6, cname);
            }
            ArrayList<String> subclasskeyList = new ArrayList<String>(ccentry.getSubClassKeys());
            for (int j = 0; j < subclasskeyList.size(); ++j) {
                list.add(subclasskeyList.get(j));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteClass(CIMObjectPath op) throws WBEMException {
        this.getClass(op, false, true);
        try {
            this.concurrentObj.writeLock();
            this.deleteClassDo(op);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private void deleteClassDo(CIMObjectPath target) throws WBEMException {
        try {
            String namespace = PSRlogImpl.cleanNamespace(target.getNamespace());
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace, WBEMOperation.DELETECLASS);
            CIMClassRlogEntry ccentry = nsentry.getClass(target.getObjectName());
            if (ccentry == null) {
                throw WBEMOperationErrors.getClassNotFoundException((CIMObjectPath)target, (WBEMOperation)WBEMOperation.DELETECLASS, (String)"");
            }
            if (ccentry.hasClassAssociation()) {
                throw WBEMOperationErrors.getClassHasReferencesException((CIMObjectPath)target, (WBEMOperation)WBEMOperation.DELETECLASS, (String)"");
            }
            String supercc = ccentry.getSuperClassName();
            CIMClassRlogEntry superentry = nsentry.getClass(supercc.length() == 0 ? TOP : supercc);
            if (superentry == null) {
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)supercc, (WBEMOperation)WBEMOperation.DELETECLASS, (String)"");
            }
            this.validateAssociationClass(ccentry);
            superentry.removeSubClass(target.getObjectName());
            nsentry.removeClass(target.getObjectName());
            if (ccentry instanceof CIMAssocClassRlogEntry) {
                ((CIMAssocClassRlogEntry)ccentry).removeClassAssociations();
            }
            ArrayList<CIMClassRlogEntry> list = new ArrayList<CIMClassRlogEntry>(ccentry.getSubClassCollection());
            for (int i = 0; i < list.size(); ++i) {
                ccentry = list.get(i);
                ArrayList<CIMClassRlogEntry> v = new ArrayList<CIMClassRlogEntry>(ccentry.getSubClassCollection());
                for (int j = 0; j < v.size(); ++j) {
                    list.add(v.get(j));
                }
                nsentry.removeClass(ccentry.getNameKey());
                if (!(ccentry instanceof CIMAssocClassRlogEntry)) continue;
                ((CIMAssocClassRlogEntry)ccentry).removeClassAssociations();
            }
            this.addLogRecord(new DeleteClassLogObj(namespace, target.getObjectName()));
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
    }

    public void deleteInstance(CIMObjectPath op) throws WBEMException {
        String namespace = PSRlogImpl.cleanNamespace(op.getNamespace());
        this.getInstance(op, null);
        this.deleteInstance(namespace, InstanceNameUtils.getInstanceNameKey(op));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteInstance(String namespace, String iname) throws WBEMException {
        try {
            this.concurrentObj.writeLock();
            this.deleteInstanceDo(namespace, iname);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private void deleteInstanceDo(String namespace, String iname) throws WBEMException {
        String cname = iname.substring(0, iname.indexOf(58));
        try {
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace, WBEMOperation.DELETEINSTANCE);
            CIMClassRlogEntry ccentry = nsentry.getClass(cname);
            if (ccentry == null) {
                throw WBEMOperationErrors.getClassNotFoundException((CIMObjectPath)new CIMObjectPath(null, null, null, namespace, cname, null), (WBEMOperation)WBEMOperation.DELETEINSTANCE, (String)"");
            }
            CIMInstanceRlogEntry cientry = ccentry.getInstance(iname);
            if (cientry.hasAssociation()) {
                throw WBEMOperationErrors.getClassHasReferencesException((CIMObjectPath)new CIMObjectPath(null, null, null, namespace, cname, null), (WBEMOperation)WBEMOperation.DELETEINSTANCE, (String)"");
            }
            if (cientry instanceof CIMAssocInstanceRlogEntry) {
                ((CIMAssocInstanceRlogEntry)cientry).removeInstanceAssociations(cname, iname);
            }
            ccentry.removeInstance(iname);
            this.addLogRecord(new DeleteInstanceLogObj(namespace, iname));
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNamespace(String name) throws WBEMException {
        try {
            this.concurrentObj.writeLock();
            this.deleteNameSpaceDo(name);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private void deleteNameSpaceDo(String namespace) throws WBEMException {
        if (namespace == null || namespace.length() == 0) {
            throw new WBEMException(4, WSIStandardMessages.getMessage((String)"ERROR_NAMESPACE_INVALID_ARG", null));
        }
        String ns = PSRlogImpl.cleanNamespace(namespace.replace('\\', '/'));
        try {
            CIMNameSpaceRlogEntry nsentry = nameSpacesMap.get(ns);
            if (nsentry == null) {
                Object[] o = new Object[]{namespace};
                throw new WBEMException(6, WSIStandardMessages.getMessage((String)"ERROR_NAMESPACE_NOT_FOUND", (Object[])o));
            }
            nameSpacesMap.remove(ns);
            this.addLogRecord(new DeleteNameSpaceLogObj(ns));
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteQualifierType(CIMObjectPath target) throws WBEMException {
        try {
            this.concurrentObj.writeLock();
            CIMQualifierType<?> qt = this.getQualifierTypeDo(target, WBEMOperation.DELETEQUALIFIERTYPE);
            if (qt == null) {
                throw WBEMOperationErrors.getQualifierTypeNotFoundException((CIMObjectPath)target, (WBEMOperation)WBEMOperation.DELETEQUALIFIERTYPE);
            }
            if (this.checkIfQualifierInUse(target, qt)) {
                Object[] o = new Object[]{qt.getName()};
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (String)WSIStandardMessages.getMessage((String)"ERROR_QUALIFIERTYPE_IN_USE", (Object[])o), (WBEMOperation)WBEMOperation.DELETEQUALIFIERTYPE, (String)"");
            }
            try {
                String namespace = PSRlogImpl.cleanNamespace(target.getNamespace());
                CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace, WBEMOperation.DELETEQUALIFIERTYPE);
                nsentry.removeQualifierType(target.getObjectName());
                this.addLogRecord(new DeleteQualifierLogObj(namespace, target.getObjectName()));
            }
            catch (WBEMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WBEMException(1, e.toString(), null, (Throwable)e);
            }
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    public CloseableIterator<CIMClass> enumerateClasses(CIMObjectPath op, boolean deep, boolean localonly, boolean iq) throws WBEMException {
        String className = op.getObjectName();
        if (className == null || className.length() == 0 || className.equalsIgnoreCase(TOP)) {
            className = TOP;
        }
        CloseableAddableIterator ccArrayList = new CloseableAddableIterator();
        try {
            String namespace = PSRlogImpl.cleanNamespace(op.getNamespace());
            this.concurrentObj.readLock();
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace, WBEMOperation.ENUMERATECLASSES);
            CIMClassRlogEntry ccentry = nsentry.getClass(className);
            if (ccentry == null) {
                throw WBEMOperationErrors.getClassNotFoundException((CIMObjectPath)op, (WBEMOperation)WBEMOperation.ENUMERATECLASSES, (String)"");
            }
            ArrayList<CIMClassRlogEntry> list = new ArrayList<CIMClassRlogEntry>(ccentry.getSubClassCollection());
            for (int i = 0; i < list.size(); ++i) {
                ccentry = list.get(i);
                if (deep) {
                    ArrayList<CIMClassRlogEntry> v = new ArrayList<CIMClassRlogEntry>(ccentry.getSubClassCollection());
                    for (int j = 0; j < v.size(); ++j) {
                        list.add(v.get(j));
                    }
                }
                CIMClass cc = (CIMClass)PSRlogImpl.deserialize(ccentry.getValue());
                cc = cc.filterProperties(localonly, iq);
                CIMObjectPath newPath = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), cc.getName(), null, op.getXmlSchemaName());
                cc = new CIMClass(newPath, cc.getSuperClassName(), cc.getQualifiers(), cc.getProperties(), cc.getMethods(), cc.isAssociation(), cc.isKeyed());
                ccArrayList.add((Object)cc);
            }
            CloseableAddableIterator closeableAddableIterator = ccArrayList;
            return closeableAddableIterator;
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
        finally {
            this.concurrentObj.readUnlock();
            ccArrayList.done();
        }
    }

    public CloseableIterator<CIMObjectPath> enumerateClassNames(CIMObjectPath op, boolean deep) throws WBEMException {
        try {
            this.concurrentObj.readLock();
            CloseableIterator<CIMObjectPath> closeableIterator = this.enumerateClassNamesDo(op, deep);
            return closeableIterator;
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    private CloseableIterator<CIMObjectPath> enumerateClassNamesDo(CIMObjectPath op, boolean deep) throws WBEMException {
        String namespace;
        CIMNameSpaceRlogEntry nsentry;
        CIMClassRlogEntry ccentry;
        String className;
        if (null == op) {
            throw WBEMOperationErrors.getNamespaceNotFoundException((CIMObjectPath)op, (WBEMOperation)WBEMOperation.ENUMERATECLASSNAMES, null);
        }
        String string = className = op == null ? null : op.getObjectName();
        if (className == null || className.length() == 0 || className.equalsIgnoreCase(TOP)) {
            className = TOP;
        }
        if ((ccentry = (nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace = PSRlogImpl.cleanNamespace(op.getNamespace()), WBEMOperation.ENUMERATECLASSNAMES)).getClass(className)) == null) {
            throw WBEMOperationErrors.getClassNotFoundException((CIMObjectPath)op, (WBEMOperation)WBEMOperation.ENUMERATECLASSNAMES, (String)"");
        }
        ArrayList<CIMClassRlogEntry> list = new ArrayList<CIMClassRlogEntry>(ccentry.getSubClassCollection());
        CloseableAddableIterator copArrayList = new CloseableAddableIterator();
        for (int i = 0; i < list.size(); ++i) {
            ccentry = list.get(i);
            if (deep) {
                ArrayList<CIMClassRlogEntry> v = new ArrayList<CIMClassRlogEntry>(ccentry.getSubClassCollection());
                for (int j = 0; j < v.size(); ++j) {
                    list.add(v.get(j));
                }
            }
            copArrayList.add((Object)new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), namespace, ccentry.getName(), null));
        }
        copArrayList.done();
        return copArrayList;
    }

    private CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath op, boolean deep, boolean localOnly, boolean includeClassOrigin, String[] propertyList) throws WBEMException {
        ArrayList instanceList = this.enumInstances(op, deep, false, localOnly, includeClassOrigin, propertyList);
        return new CloseableAddableIterator((Collection)instanceList);
    }

    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError) throws WBEMException {
        FQLParser fqlParser = FQLParser.getFQLParser((String)filterQueryLanguage, (String)filterQuery, (CIMObjectPath)op, (WBEMOperation)WBEMOperation.ENUMERATEINSTANCES);
        return fqlParser.evaluate(this.enumerateInstances(op, false, false, false, propertyList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] enumerateNamespaces() throws WBEMException {
        try {
            this.concurrentObj.readLock();
            String[] stringArray = this.enumNameSpaceDo();
            return stringArray;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIterator<CIMQualifierType<?>> enumerateQualifierTypes(CIMObjectPath op) throws WBEMException {
        try {
            this.concurrentObj.readLock();
            CloseableIterator<CIMQualifierType<?>> closeableIterator = this.enumerateQualifierTypesDo(op.getNamespace());
            return closeableIterator;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    private CloseableIterator<CIMQualifierType<?>> enumerateQualifierTypesDo(String namespace) throws WBEMException {
        try {
            namespace = PSRlogImpl.cleanNamespace(namespace);
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace, WBEMOperation.ENUMERATEQUALIFIERTYPES);
            ArrayList<CIMQualifierTypeRlogEntry> a = new ArrayList<CIMQualifierTypeRlogEntry>(nsentry.getQualifierCollection());
            CIMQualifierType qt = null;
            CloseableAddableIterator cqtList = new CloseableAddableIterator();
            for (int i = 0; i < a.size(); ++i) {
                CIMQualifierTypeRlogEntry qtentry = a.get(i);
                if (qtentry != null) {
                    qt = (CIMQualifierType)PSRlogImpl.deserialize(qtentry.getValue());
                }
                cqtList.add(qt);
            }
            cqtList.done();
            return cqtList;
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList enumInstances(CIMObjectPath op, boolean deep, boolean needop, boolean localonly, boolean ico, String[] pl) throws WBEMException {
        try {
            this.concurrentObj.readLock();
            ArrayList<Object> arrayList = this.enumInstancesDo(op, deep, needop, localonly, ico, pl);
            return arrayList;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    private ArrayList<Object> enumInstancesDo(CIMObjectPath op, boolean deep, boolean needop, boolean localonly, boolean ico, String[] pl) throws WBEMException {
        String namespace = PSRlogImpl.cleanNamespace(op.getNamespace());
        String className = op.getObjectName();
        ArrayList<Object> instanceList = new ArrayList<Object>();
        if (className == null || className.equalsIgnoreCase(TOP)) {
            className = TOP;
        }
        try {
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace, WBEMOperation.ENUMERATEINSTANCES);
            CIMClassRlogEntry ccentry = nsentry.getClass(className);
            if (ccentry == null) {
                throw WBEMOperationErrors.getClassNotFoundException((CIMObjectPath)op, (WBEMOperation)WBEMOperation.ENUMERATEINSTANCES, (String)"");
            }
            CIMClass cc = (CIMClass)PSRlogImpl.deserialize(ccentry.getValue());
            this.getInstanceList(op, ccentry, deep, localonly, ico, pl, needop, instanceList, cc.isAssociation());
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
        return instanceList;
    }

    private String[] enumNameSpaceDo() throws WBEMException {
        ArrayList<CIMNameSpaceRlogEntry> list = new ArrayList<CIMNameSpaceRlogEntry>(nameSpacesMap.values());
        ArrayList<String> nsArray = new ArrayList<String>(list.size());
        for (int c = 0; c < list.size(); ++c) {
            CIMNameSpaceRlogEntry ns = list.get(c);
            nsArray.add(ns.getName());
        }
        return nsArray.toArray(new String[list.size()]);
    }

    public CloseableIterator<CIMInstance> execQuery(CIMObjectPath op, String stmt, String queryType) throws WBEMException {
        String namespace = PSRlogImpl.cleanNamespace(op.getNamespace());
        WBEMQuery wq = null;
        try {
            wq = WBEMQueryLanguageFactory.getQuery((String)queryType);
        }
        catch (Exception e) {
            throw WBEMOperationErrors.getUnknownQueryLanguageException((CIMObjectPath)op, (String)queryType, null, (WBEMOperation)WBEMOperation.EXECUTEQUERY);
        }
        if (!wq.initialize(stmt)) {
            throw WBEMOperationErrors.getInvalidQueryException((CIMObjectPath)op, (String)queryType, (String)stmt, (WBEMOperation)WBEMOperation.EXECUTEQUERY, null);
        }
        CloseableAddableIterator result = new CloseableAddableIterator();
        try {
            CloseableIterator<CIMInstance> v = this.enumerateInstances(new CIMObjectPath(null, null, null, namespace, op.getObjectName().toLowerCase(), null), null, null, null, false);
            while (v.hasNext()) {
                CIMInstance ci = (CIMInstance)v.next();
                if (!wq.testWhereClause(ci)) continue;
                result.add((Object)wq.applySelectList(ci));
            }
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
        result.done();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMClass getClass(CIMObjectPath op, boolean lo, boolean iq) throws WBEMException {
        if (op == null) {
            throw new WBEMException(6);
        }
        try {
            this.concurrentObj.readLock();
            CIMClass cc = this.getClassDo(op);
            CIMObjectPath newPath = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), cc.getName(), null, op.getXmlSchemaName());
            cc = new CIMClass(newPath, cc.getSuperClassName(), cc.getQualifiers(), cc.getProperties(), cc.getMethods(), cc.isAssociation(), cc.isKeyed());
            CIMClass cIMClass = cc.filterProperties(lo, iq);
            return cIMClass;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    private CIMClass getClassDo(CIMObjectPath op) throws WBEMException {
        try {
            String namespace = PSRlogImpl.cleanNamespace(op.getNamespace());
            CIMClass cc = null;
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace, WBEMOperation.GETCLASS);
            CIMClassRlogEntry ccentry = nsentry.getClass(op.getObjectName());
            if (ccentry == null) {
                throw new WBEMException(6, "Can not find class: " + op.getObjectName());
            }
            cc = (CIMClass)PSRlogImpl.deserialize(ccentry.getValue());
            return cc;
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMInstance getInstance(CIMObjectPath target, String[] propertyList) throws WBEMException {
        CIMInstance ci = null;
        try {
            this.concurrentObj.readLock();
            ci = this.getInstanceDo(target, InstanceNameUtils.getInstanceNameKey(target));
        }
        finally {
            this.concurrentObj.readUnlock();
        }
        return ci.filterProperties(propertyList);
    }

    private CIMInstance getInstanceDo(CIMObjectPath target, String iname) throws WBEMException {
        if (iname.indexOf(58) == -1) {
            throw WBEMOperationErrors.getInstanceNotFoundException((CIMObjectPath)target, (WBEMOperation)WBEMOperation.GETINSTANCE, (String)"");
        }
        String cname = iname.substring(0, iname.indexOf(58));
        CIMInstanceRlogEntry cientry = null;
        try {
            String namespace = PSRlogImpl.cleanNamespace(target.getNamespace());
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace, WBEMOperation.GETINSTANCE);
            CIMClassRlogEntry ccentry = nsentry.getClass(cname);
            if (ccentry == null) {
                throw WBEMOperationErrors.getClassNotFoundException((CIMObjectPath)target, (WBEMOperation)WBEMOperation.GETINSTANCE, (String)"");
            }
            cientry = ccentry.getInstance(iname);
            if (cientry != null) {
                CIMInstance ci = (CIMInstance)PSRlogImpl.deserialize(cientry.getValue());
                CIMClass cc = (CIMClass)PSRlogImpl.deserialize(ccentry.getValue());
                ci = cc.isAssociation() ? this.updateAssociationInstance(ci, target) : ci.deriveInstance(this.updatePath(target, ci.getObjectPath(), null));
                return ci;
            }
            throw WBEMOperationErrors.getInstanceNotFoundException((CIMObjectPath)target, (WBEMOperation)WBEMOperation.GETINSTANCE, (String)"");
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)e, (WBEMOperation)WBEMOperation.GETINSTANCE, (String)"");
        }
    }

    private void getInstanceList(CIMObjectPath target, CIMClassRlogEntry ccentry, boolean deep, boolean localOnly, boolean ico, String[] pl, boolean needop, ArrayList<Object> list, boolean pIsAssociation) throws WBEMException {
        try {
            for (CIMInstanceRlogEntry cientry : ccentry.getInstanceCollection()) {
                CIMInstance ci = (CIMInstance)PSRlogImpl.deserialize(cientry.getValue());
                if (pIsAssociation) {
                    ci = this.updateAssociationInstance(ci, target);
                }
                if (needop) {
                    list.add(this.updatePath(target, ci.getObjectPath(), null));
                    continue;
                }
                ci = ci.filterProperties(pl);
                ci = ci.deriveInstance(this.updatePath(target, ci.getObjectPath(), null));
                list.add(ci);
            }
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
    }

    private String[] getListofChanges(CIMInstance pOriginal, CIMInstance pNew) {
        ArrayList<String> list = new ArrayList<String>();
        for (CIMProperty p : pNew.getProperties()) {
            CIMProperty oProp = pOriginal.getProperty(p.getName());
            if (oProp != null) {
                if (oProp.getValue() == null) {
                    if (p.getValue() == null) continue;
                    list.add(p.getName());
                    continue;
                }
                if (oProp.getValue().equals(p.getValue())) continue;
                list.add(p.getName());
                continue;
            }
            list.add(p.getName());
        }
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMQualifierType<?> getQualifierType(CIMObjectPath op) throws WBEMException {
        try {
            this.concurrentObj.readLock();
            CIMQualifierType<?> cIMQualifierType = this.getQualifierTypeDo(op, WBEMOperation.GETQUALIFIERTYPE);
            return cIMQualifierType;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    private CIMQualifierType<?> getQualifierTypeDo(CIMObjectPath target, WBEMOperation operation) throws WBEMException {
        String namespace = PSRlogImpl.cleanNamespace(target.getNamespace());
        String qtName = target.getObjectName();
        CIMQualifierType qt = null;
        CIMQualifierTypeRlogEntry qtentry = null;
        try {
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace, WBEMOperation.GETQUALIFIERTYPE);
            qtentry = nsentry.getQualifierType(qtName);
            if (qtentry == null) {
                throw WBEMOperationErrors.getQualifierTypeNotFoundException((CIMObjectPath)target, (WBEMOperation)operation);
            }
            qt = (CIMQualifierType)PSRlogImpl.deserialize(qtentry.getValue());
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
        return qt;
    }

    private void init(String logpath) throws IOException {
        this.log = new ReliableLog(logpath, new LocalLogHandler());
        this.store = new PersistentStore(logpath + "/store");
        CIMRlogEntry.setPersistentStore(this.store);
        this.inRecovery = true;
        this.log.recover();
        this.inRecovery = false;
        if (nameSpacesMap == null) {
            nameSpacesMap = new HashMap();
        }
        this.log.snapshot();
        this.snapshotter.start();
    }

    public void init(String logpath, ProviderHandle pc) throws WBEMException {
        PSRlogImpl.setRepostiory(this);
        this.pch = pc;
        try {
            this.init(logpath);
            this.classCheck = new ClassChecker(this);
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
    }

    private static void setRepostiory(CIMRepository repository) {
        mRepository = repository;
    }

    public void initialize(ProviderHandle ch) {
        this.pch = ch;
    }

    private CloseableIterator instanceAssociators(CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, boolean needop, boolean isRef) throws WBEMException {
        CloseableAddableIterator v = new CloseableAddableIterator();
        if (role != null && role.length() != 0 && resultRole != null && resultRole.length() != 0 && role.equalsIgnoreCase(resultRole)) {
            return v;
        }
        String ns = objectName.getNamespace();
        String cname = objectName.getObjectName();
        String asname = assocName.getObjectName();
        ns = PSRlogImpl.cleanNamespace(ns.replace('\\', '/'));
        try {
            this.concurrentObj.readLock();
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(ns, WBEMOperation.ASSOCIATORS);
            CIMClassRlogEntry ccentry = nsentry.getClass(cname);
            if (ccentry == null) {
                CloseableAddableIterator closeableAddableIterator = v;
                return closeableAddableIterator;
            }
            String iname = InstanceNameUtils.getInstanceNameKey(objectName);
            CIMInstanceRlogEntry cientry = ccentry.getInstance(iname);
            if (cientry == null) {
                CloseableAddableIterator closeableAddableIterator = v;
                return closeableAddableIterator;
            }
            CIMAssocInstanceRlogEntry[] cimap = cientry.getAssociations(asname);
            if (cimap == null) {
                CloseableAddableIterator closeableAddableIterator = v;
                return closeableAddableIterator;
            }
            HashMap<String, String> dups = new HashMap<String, String>();
            for (CIMAssocInstanceRlogEntry element : cimap) {
                if (dups.get(element.getName()) != null) continue;
                dups.put(element.getName(), "");
                if (isRef) {
                    CIMObjectPath asop = element.matchAssociator(iname, role, resultRole);
                    if (asop == null) continue;
                    if (needop) {
                        v.add((Object)this.updateAssociationPath(asop, objectName));
                        continue;
                    }
                    CIMInstance ci = this.getInstanceDo(asop, InstanceNameUtils.getInstanceNameKey(asop));
                    v.add((Object)ci.filterProperties(propertyList));
                    continue;
                }
                ArrayList<CIMObjectPath> rv = element.matchRole(iname, role, resultRole);
                HashSet<String> resultClassSet = null;
                if (resultClass != null && resultClass.length() != 0) {
                    resultClassSet = new HashSet<String>();
                    resultClassSet.add(resultClass.toLowerCase());
                    CloseableIterator<CIMObjectPath> iCOP = this.enumerateClassNamesDo(new CIMObjectPath(null, null, null, ns, resultClass, null), true);
                    while (iCOP.hasNext()) {
                        CIMObjectPath op = (CIMObjectPath)iCOP.next();
                        resultClassSet.add(op.getObjectName().toLowerCase());
                    }
                }
                int size = rv.size();
                for (int k = 0; k < size; ++k) {
                    CIMObjectPath op = rv.get(k);
                    if (resultClassSet != null && !resultClassSet.contains(op.getObjectName().toLowerCase())) continue;
                    if (needop) {
                        v.add((Object)op);
                        continue;
                    }
                    CIMInstance ci = this.getInstanceDo(op, InstanceNameUtils.getInstanceNameKey(op));
                    v.add((Object)ci.filterProperties(propertyList));
                }
            }
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
        finally {
            v.done();
            this.concurrentObj.readUnlock();
        }
        return v;
    }

    private void intAssociators(CIMNameSpaceRlogEntry nsentry, String cname, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, String[] propertyList, ArrayList v, boolean op) throws WBEMException {
        ArrayList<String> assoclist = new ArrayList<String>();
        ArrayList<String> resultclist = new ArrayList<String>();
        CIMClassRlogEntry ccentry = nsentry.getClass(cname);
        if (ccentry == null) {
            return;
        }
        if (assocClass != null && assocClass.length() != 0) {
            try {
                assoclist = this.deepEnum(nsentry, assocClass);
            }
            catch (WBEMException e) {
                return;
            }
        }
        if (resultClass != null && resultClass.length() != 0) {
            try {
                resultclist = this.deepEnum(nsentry, resultClass);
                String sc = nsentry.getClass(resultClass).getSuperClassName();
                while (sc.length() != 0 && !sc.equals(TOP)) {
                    resultclist.add(sc);
                    sc = nsentry.getClass(sc).getSuperClassName();
                }
            }
            catch (WBEMException e) {
                return;
            }
        }
        this.intGetAssociators(nsentry, cname, assoclist, resultclist, role, resultRole, includeQualifiers, propertyList, v, op);
    }

    private void intGetAssociators(CIMNameSpaceRlogEntry nsentry, String cname, ArrayList<String> assoclist, ArrayList<String> resultclist, String role, String resultRole, boolean includeQualifiers, String[] propertyList, ArrayList v, boolean op) throws WBEMException {
        try {
            CIMClassRlogEntry ccentry = nsentry.getClass(cname);
            if (ccentry == null) {
                return;
            }
            CIMAssocClassRlogEntry[] list = ccentry.getAssocications();
            for (int i = 0; list != null && i < list.length; ++i) {
                boolean match = true;
                match = this.matchClassList(list[i].getName(), assoclist);
                ArrayList<String> al = null;
                if (match) {
                    al = list[i].matchRole(cname, role, resultRole);
                }
                if (al == null || al.isEmpty()) continue;
                for (int k = 0; k < al.size(); ++k) {
                    if (!this.matchClassList(al.get(k), resultclist)) continue;
                    CIMClassRlogEntry newentry = nsentry.getClass(al.get(k));
                    if (newentry == null) {
                        throw new WBEMException(1, cname);
                    }
                    CIMClass cc = (CIMClass)PSRlogImpl.deserialize(newentry.getValue());
                    if (op) {
                        if (v.contains(cc.getObjectPath())) continue;
                        v.add(cc.getObjectPath());
                        continue;
                    }
                    if (v.contains(cc)) continue;
                    cc = cc.filterProperties(false, includeQualifiers);
                    v.add(cc);
                }
            }
            String supercc = ccentry.getSuperClassName();
            if (supercc == null || supercc.length() == 0) {
                return;
            }
            this.intGetAssociators(nsentry, supercc, assoclist, resultclist, role, resultRole, includeQualifiers, propertyList, v, op);
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
    }

    private void intGetReferences(CIMNameSpaceRlogEntry nsentry, String cname, ArrayList<String> assoclist, ArrayList<String> resultclist, String role, String resultRole, boolean includeQualifiers, String[] propertyList, ArrayList v, boolean needop) throws WBEMException {
        try {
            CIMClassRlogEntry ccentry = nsentry.getClass(cname);
            if (ccentry == null) {
                Object[] o = new Object[]{cname};
                throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_CLASS_NOT_FOUND", (Object[])o));
            }
            CIMAssocClassRlogEntry[] list = ccentry.getAssocications();
            for (int i = 0; list != null && i < list.length; ++i) {
                boolean match = true;
                match = this.matchClassList(list[i].getName(), assoclist);
                ArrayList<String> al = null;
                if (match) {
                    al = list[i].matchRole(cname, role, resultRole);
                }
                if (al == null || al.isEmpty()) continue;
                for (int k = 0; k < al.size(); ++k) {
                    if (!this.matchClassList(al.get(k), resultclist)) continue;
                    CIMClassRlogEntry newentry = nsentry.getClass(list[i].getName());
                    if (newentry == null) {
                        throw new WBEMException(1, list[i].getName());
                    }
                    CIMClass cc = (CIMClass)PSRlogImpl.deserialize(newentry.getValue());
                    if (needop) {
                        if (v.contains(cc.getObjectPath())) continue;
                        v.add(cc.getObjectPath());
                        continue;
                    }
                    if (v.contains(cc = cc.filterProperties(false, includeQualifiers))) continue;
                    v.add(cc);
                }
            }
            String supercc = ccentry.getSuperClassName();
            if (supercc == null || supercc.length() == 0) {
                return;
            }
            this.intGetReferences(nsentry, supercc, assoclist, resultclist, role, resultRole, includeQualifiers, propertyList, v, needop);
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
    }

    private void intReferences(CIMNameSpaceRlogEntry nsentry, String cname, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, String[] propertyList, ArrayList v, boolean needop) throws WBEMException {
        ArrayList<String> assoclist = new ArrayList<String>();
        ArrayList<String> resultclist = new ArrayList<String>();
        CIMClassRlogEntry ccentry = nsentry.getClass(cname);
        if (ccentry == null) {
            Object[] o = new Object[]{cname};
            throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_CLASS_NOT_FOUND", (Object[])o));
        }
        if (assocClass != null && assocClass.length() != 0) {
            try {
                assoclist = this.deepEnum(nsentry, assocClass);
            }
            catch (WBEMException e) {
                return;
            }
        }
        if (resultClass != null && resultClass.length() != 0) {
            try {
                resultclist = this.deepEnum(nsentry, resultClass);
                String sc = nsentry.getClass(resultClass).getSuperClassName();
                while (sc.length() != 0 && !sc.equals(TOP)) {
                    resultclist.add(sc);
                    sc = nsentry.getClass(sc).getSuperClassName();
                }
            }
            catch (WBEMException e) {
                return;
            }
        }
        this.intGetReferences(nsentry, cname, assoclist, resultclist, role, resultRole, includeQualifiers, propertyList, v, needop);
    }

    public Object invokeMethod(CIMObjectPath op, String methodName, CIMArgument<?>[] inputArguments, CIMArgument<?>[] outputArguments) throws WBEMException {
        throw WBEMOperationErrors.getNoSuchMethodException((CIMObjectPath)op, (String)methodName, (WBEMOperation)WBEMOperation.INVOKEMETHOD);
    }

    private boolean matchClassList(String cname, ArrayList<String> list) {
        if (list.isEmpty()) {
            return true;
        }
        for (int j = 0; j < list.size(); ++j) {
            if (!cname.equalsIgnoreCase(list.get(j))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyClass(CIMClass cc) throws WBEMException {
        try {
            String namespace = PSRlogImpl.cleanNamespace(cc.getObjectPath().getNamespace());
            cc = this.classCheck.checkClassSanity(namespace, cc, null);
            this.concurrentObj.writeLock();
            this.setClassDo(cc);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyInstance(CIMInstance ci, String[] propertyList) throws WBEMException {
        try {
            CIMClass cc = null;
            try {
                cc = this.getClass(ci.getObjectPath(), false, true);
            }
            catch (WBEMException we) {
                if (we.getID() == 6) {
                    throw WBEMOperationErrors.getClassNotFoundException((CIMObjectPath)ci.getObjectPath(), (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)"");
                }
                throw we;
            }
            CIMClassProperty[] ccpPropArray = cc.getProperties();
            ArrayList<String> validPropList = new ArrayList<String>();
            for (CIMClassProperty p : ccpPropArray) {
                validPropList.add(p.getName().toLowerCase());
            }
            CIMClassProperty[] ccpKeyArray = cc.getKeys();
            ArrayList<String> nonWriteList = new ArrayList<String>();
            for (CIMClassProperty p : ccpKeyArray) {
                nonWriteList.add(p.getName().toLowerCase());
            }
            CIMInstance originalInstance = this.getInstance(ci.getObjectPath(), null);
            String[] pList = propertyList;
            if (pList == null) {
                pList = this.getListofChanges(originalInstance, ci);
            }
            if (pList != null) {
                for (String name : pList) {
                    if (!validPropList.contains(name.toLowerCase())) {
                        throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)ci.getObjectPath(), (String)("[DSP0200 1.3.0 | 2.3.2.8]The following property is not a valid property name for this class: " + name), (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)"");
                    }
                    if (!nonWriteList.contains(name.toLowerCase())) continue;
                    throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)ci.getObjectPath(), (String)("[DSP0200 1.3.0 | 2.3.2.8]Key values can not be modified: " + name), (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)"");
                }
            } else {
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)ci.getObjectPath(), (String)"No changes were detected in the instance!", (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)"");
            }
            ArrayList<Object> newPropList = new ArrayList<Object>();
            ArrayList<String> lcList = new ArrayList<String>();
            for (String string : pList) {
                if (lcList.contains(string.toLowerCase())) continue;
                lcList.add(string.toLowerCase());
                CIMProperty p = originalInstance.getProperty(string);
                if (p == null) {
                    CIMClassProperty ccp = cc.getProperty(string);
                    if (ccp == null) continue;
                    CIMDataType dt = ccp.getDataType();
                    boolean isEmbedded = ccp.hasQualifier("EmbeddedInstance") || ccp.hasQualifier("EmbeddedObject");
                    newPropList.add(new CIMProperty(ccp.getName(), isEmbedded ? (dt.isArray() ? CIMDataType.OBJECT_ARRAY_T : CIMDataType.OBJECT_T) : ccp.getDataType(), ci.getPropertyValue(ccp.getName()), ccp.isKey()));
                    continue;
                }
                CIMProperty cp = originalInstance.getProperty(string);
                newPropList.add(new CIMProperty(cp.getName(), cp.getDataType(), ci.getPropertyValue(cp.getName()), cp.isKey()));
            }
            for (String string : originalInstance.getProperties()) {
                if (lcList.contains(string.getName().toLowerCase())) continue;
                newPropList.add(string);
            }
            CIMInstance ni = new CIMInstance(originalInstance.getObjectPath(), newPropList.toArray(new CIMProperty[newPropList.size()]));
            this.concurrentObj.writeLock();
            this.setInstanceDo(originalInstance.getObjectPath(), ni, cc, propertyList);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    public void modifyQualifierType(CIMQualifierType<?> qt) throws WBEMException {
        if (qt == null || qt.getObjectPath() == null) {
            throw new IllegalArgumentException(WSIStandardMessages.getMessage((String)"ERROR_QUALIFIERTYPE_INVALID_ARG", this.pch == null ? null : this.pch.getRequestedLocales()));
        }
        try {
            this.concurrentObj.writeLock();
            if (this.checkIfQualifierInUse(qt.getObjectPath(), qt)) {
                Object[] o = new Object[]{qt.getName()};
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)qt.getObjectPath(), (String)WSIStandardMessages.getMessage((String)"ERROR_QUALIFIERTYPE_IN_USE", (Object[])o), (WBEMOperation)WBEMOperation.MODIFYQUALIFIERTYPE, (String)"");
            }
            this.setQualifierTypeDo(qt.getObjectPath().getNamespace(), qt);
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private void putNameSpaceEntryToMap(CIMNameSpaceRlogEntry nsentry) {
        nameSpacesMap.put(nsentry.getName(), nsentry);
    }

    private void recoverSnapshot(InputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream stream = new ObjectInputStream(in);
        if (!PSRlogImpl.class.getName().equals(stream.readUTF())) {
            throw new IOException("log from wrong implementation");
        }
        if (stream.readInt() != 1) {
            throw new IOException("wrong log format version");
        }
        nameSpacesMap = (HashMap)stream.readObject();
        this.store.recoverFromSnapshot(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableIterator<CIMClass> referenceClasses(CIMObjectPath op, String assocClass, String role, String resultClass, boolean includeQualifiers) throws WBEMException {
        try {
            this.concurrentObj.readLock();
            ArrayList v = new ArrayList();
            String resultRole = null;
            String ns = op.getNamespace();
            String cname = op.getObjectName();
            ns = PSRlogImpl.cleanNamespace(ns.replace('\\', '/'));
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(ns, WBEMOperation.REFERENCECLASSES);
            this.intReferences(nsentry, cname, assocClass, resultClass, role, resultRole, includeQualifiers, null, v, false);
            CloseableAddableIterator closeableAddableIterator = new CloseableAddableIterator(v);
            return closeableAddableIterator;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    public CloseableIterator<CIMInstance> references(CIMObjectPath resultClass, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError) throws WBEMException {
        FQLParser fqlParser = FQLParser.getFQLParser((String)filterQueryLanguage, (String)filterQuery, (CIMObjectPath)objectName, (WBEMOperation)WBEMOperation.REFERENCES);
        return fqlParser.evaluate(this.instanceAssociators(resultClass, objectName, null, role, null, propertyList, false, true));
    }

    private void setClassDo(CIMClass cc) throws WBEMException {
        CIMObjectPath cop = cc.getObjectPath();
        this.getClassDo(cop);
        String name = cc.getName();
        String supercc = cc.getSuperClassName();
        CIMRlogEntry entry = this.setClassDo(cop.getNamespace(), name, supercc);
        this.createSetElementLogRecord(cop.getNamespace(), entry, cc, name);
    }

    private CIMRlogEntry setClassDo(String namespace, String cname, String supercc) throws WBEMException {
        if (supercc == null || supercc.length() == 0) {
            supercc = TOP;
        }
        namespace = PSRlogImpl.cleanNamespace(namespace);
        try {
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace, WBEMOperation.MODIFYCLASS);
            CIMClassRlogEntry ccentry = nsentry.getClass(cname);
            if (ccentry == null) {
                ccentry = new CIMClassRlogEntry(nsentry, cname, supercc);
                nsentry.addClass(ccentry);
            }
            return ccentry;
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
    }

    private void setInstanceDo(CIMObjectPath op, CIMInstance ci, CIMClass cc, String[] propertyList) throws WBEMException {
        String namespace = PSRlogImpl.cleanNamespace(op.getNamespace());
        String iname = InstanceNameUtils.getInstanceNameKey(op);
        CIMRlogEntry entry = this.setInstanceDo(namespace, iname, ci.getClassName());
        PSRlogImpl.deserialize(entry.getValue());
        this.createSetElementLogRecord(namespace, entry, ci, iname);
    }

    private CIMRlogEntry setInstanceDo(String namespace, String iname, String cname) throws WBEMException {
        try {
            namespace = PSRlogImpl.cleanNamespace(namespace);
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace, WBEMOperation.MODIFYINSTANCE);
            CIMClassRlogEntry ccentry = nsentry.getClass(cname);
            if (ccentry == null) {
                Object[] o = new Object[]{cname};
                throw new WBEMException(5, WSIStandardMessages.getMessage((String)"ERROR_CLASS_NOT_FOUND", (Object[])o));
            }
            CIMInstanceRlogEntry cientry = ccentry.getInstance(iname);
            if (cientry == null) {
                Object[] o = new Object[]{iname};
                throw new WBEMException(6, WSIStandardMessages.getMessage((String)"ERROR_INSTANCE_NOT_FOUND", (Object[])o));
            }
            return cientry;
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
    }

    private void setQualifierTypeDo(String namespace, CIMQualifierType<?> qt) throws WBEMException {
        String qtName = qt.getName();
        CIMRlogEntry entry = this.setQualifierTypeDo(namespace, qtName);
        this.createSetElementLogRecord(namespace, entry, qt, qtName);
    }

    private CIMRlogEntry setQualifierTypeDo(String namespace, String qtName) throws WBEMException {
        try {
            namespace = PSRlogImpl.cleanNamespace(namespace);
            CIMNameSpaceRlogEntry nsentry = PSRlogImpl.getNameSpaceEntryFromMap(namespace, WBEMOperation.MODIFYQUALIFIERTYPE);
            CIMQualifierTypeRlogEntry qtentry = nsentry.getQualifierType(qtName);
            if (qtentry == null) {
                qtentry = new CIMQualifierTypeRlogEntry(namespace, qtName);
                nsentry.addQualifierType(qtentry);
            }
            return qtentry;
        }
        catch (WBEMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
    }

    public void shutdown() {
        this.snapshotter.interrupt();
        try {
            this.log.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void takeSnapshot(OutputStream out) throws IOException {
        ObjectOutputStream stream = new ObjectOutputStream(out);
        stream.writeUTF(PSRlogImpl.class.getName());
        stream.writeInt(1);
        stream.writeObject(nameSpacesMap);
        this.store.addToSnapshot(stream);
        stream.writeObject(null);
        stream.flush();
    }

    private CIMInstance updateAssociationInstance(CIMInstance ci, CIMObjectPath target) {
        CIMObjectPath p = ci.getObjectPath();
        CIMProperty[] keys = p.getKeys();
        ArrayList<CIMProperty> propArray = new ArrayList<CIMProperty>();
        ArrayList<CIMProperty> keyArray = new ArrayList<CIMProperty>();
        for (CIMProperty prop : ci.getProperties()) {
            if (null != prop.getDataType().getRefClassName()) {
                CIMObjectPath path = this.updatePath(target, (CIMObjectPath)prop.getValue(), null);
                prop = new CIMProperty(prop.getName(), prop.getDataType(), (Object)path, prop.isKey());
            }
            propArray.add(prop);
            if (null == p.getKey(prop.getName())) continue;
            keyArray.add(prop);
        }
        ci = ci.deriveInstance(propArray.toArray(new CIMProperty[propArray.size()]));
        keys = keyArray.toArray(new CIMProperty[keyArray.size()]);
        CIMObjectPath op = this.updatePath(target, p, keys);
        ci = ci.deriveInstance(op);
        return ci;
    }

    private CIMObjectPath updateAssociationPath(CIMObjectPath p, CIMObjectPath target) {
        CIMProperty[] keys = p.getKeys();
        ArrayList<CIMProperty> keyArray = new ArrayList<CIMProperty>();
        for (CIMProperty prop : keys) {
            if (null != prop.getDataType().getRefClassName()) {
                CIMObjectPath path = this.updatePath(target, (CIMObjectPath)prop.getValue(), null);
                prop = new CIMProperty(prop.getName(), prop.getDataType(), (Object)path, prop.isKey());
            }
            keyArray.add(prop);
        }
        keys = keyArray.toArray(new CIMProperty[keyArray.size()]);
        CIMObjectPath op = this.updatePath(target, p, keys);
        return op;
    }

    private CIMObjectPath updatePath(CIMObjectPath target, CIMObjectPath rPath, CIMProperty<?>[] pKeys) {
        return new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), rPath.getNamespace(), rPath.getObjectName(), pKeys == null ? rPath.getKeys() : pKeys, target.getXmlSchemaName());
    }

    void validateAssociationClass(CIMClassRlogEntry entry) throws WBEMException {
        if (entry instanceof CIMAssocClassRlogEntry) {
            ((CIMAssocClassRlogEntry)entry).validateClassAsociations();
        }
        ArrayList<CIMClassRlogEntry> list = new ArrayList<CIMClassRlogEntry>(entry.getSubClassCollection());
        for (int i = 0; i < list.size(); ++i) {
            CIMClassRlogEntry ccentry = list.get(i);
            ArrayList<CIMClassRlogEntry> v = new ArrayList<CIMClassRlogEntry>(ccentry.getSubClassCollection());
            for (int j = 0; j < v.size(); ++j) {
                list.add(v.get(j));
            }
            if (!(ccentry instanceof CIMAssocClassRlogEntry)) continue;
            ((CIMAssocClassRlogEntry)ccentry).validateClassAsociations();
        }
    }

    static /* synthetic */ ReadersWriter access$1200(PSRlogImpl x0) {
        return x0.concurrentObj;
    }

    static /* synthetic */ Object access$1300(PSRlogImpl x0) {
        return x0.snapshotNotifier;
    }

    static /* synthetic */ ReliableLog access$1400(PSRlogImpl x0) {
        return x0.log;
    }

    static /* synthetic */ int access$1502(PSRlogImpl x0, int x1) {
        x0.logFileSize = x1;
        return x0.logFileSize;
    }

    static {
        nameSpacesMap = null;
    }

    private class SnapshotThread
    extends Thread {
        public SnapshotThread() {
            super("snapshot thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                PSRlogImpl.access$1200(PSRlogImpl.this).readLock();
            }
            catch (ReadersWriter.ConcurrentLockException e) {
                return;
            }
lbl6:
            // 3 sources

            try {
                while (!this.isInterrupted()) {
                    PSRlogImpl.access$1200(PSRlogImpl.this).readerWait(PSRlogImpl.access$1300(PSRlogImpl.this), 0x7FFFFFFFFFFFFFFFL);
                    try {
                        PSRlogImpl.access$1400(PSRlogImpl.this).snapshot();
                        PSRlogImpl.access$1502(PSRlogImpl.this, 0);
                        ** GOTO lbl6
                    }
                    catch (InterruptedIOException e) {
                        PSRlogImpl.access$1200(PSRlogImpl.this).readUnlock();
                        return;
                    }
                    catch (Exception e) {
                        try {
                            if (!(e instanceof LogException) || !(((LogException)e).detail instanceof InterruptedIOException)) ** GOTO lbl6
                        }
                        catch (ReadersWriter.ConcurrentLockException e) {
                            return;
                        }
                        catch (Throwable var2_5) {
                            throw var2_5;
                            return;
                        }
                        PSRlogImpl.access$1200(PSRlogImpl.this).readUnlock();
                        return;
                    }
                }
            }
            finally {
                PSRlogImpl.access$1200(PSRlogImpl.this).readUnlock();
            }
        }
    }

    private static class SetCIMQualifierLogObj
    extends AddCIMQualifierLogObj {
        private static final long serialVersionUID = 6509220164924254555L;

        public SetCIMQualifierLogObj(String namespace, String name, PersistentStore.PersistObject po) {
            super(namespace, name, po);
        }

        @Override
        protected void applyDo(PSRlogImpl psImpl) throws WBEMException {
            this.entry = psImpl.setQualifierTypeDo(this.namespace, this.name);
        }
    }

    private static class SetCIMInstanceLogObj
    extends SetCIMClassLogObj {
        private static final long serialVersionUID = 8152734320755230951L;

        public SetCIMInstanceLogObj(String namespace, String name, String otherName, PersistentStore.PersistObject po) {
            super(namespace, name, otherName, po);
        }

        @Override
        protected void applyDo(PSRlogImpl psImpl) throws WBEMException {
            this.entry = psImpl.setInstanceDo(this.namespace, this.name, this.otherName);
        }
    }

    private static class SetCIMClassLogObj
    extends AddCIMQualifierLogObj {
        private static final long serialVersionUID = 4842199887990665842L;
        protected String otherName;

        public SetCIMClassLogObj(String namespace, String name, String otherName, PersistentStore.PersistObject po) {
            super(namespace, name, po);
            this.otherName = otherName;
        }

        @Override
        protected void applyDo(PSRlogImpl psImpl) throws WBEMException {
            this.entry = psImpl.setClassDo(this.namespace, this.name, this.otherName);
        }
    }

    private static interface LogRecord
    extends Serializable {
        public void apply(PSRlogImpl var1) throws WBEMException;
    }

    private class LocalLogHandler
    extends LogHandler {
        @Override
        public void applyUpdate(Object logRecObj) {
            try {
                ((LogRecord)logRecObj).apply(PSRlogImpl.this);
            }
            catch (WBEMException wBEMException) {
                // empty catch block
            }
        }

        @Override
        public void recover(InputStream in) throws IOException, ClassNotFoundException {
            PSRlogImpl.this.recoverSnapshot(in);
        }

        @Override
        public void snapshot(OutputStream out) throws IOException {
            PSRlogImpl.this.takeSnapshot(out);
        }
    }

    private static class DeleteQualifierLogObj
    implements LogRecord {
        private static final long serialVersionUID = -4910178553526207227L;
        private final String namespace;
        private final String qtName;

        public DeleteQualifierLogObj(String namespace, String qtName) {
            this.namespace = PSRlogImpl.cleanNamespace(namespace);
            this.qtName = qtName;
        }

        @Override
        public void apply(PSRlogImpl psImpl) throws WBEMException {
            psImpl.deleteQualifierType(new CIMObjectPath(null, null, null, this.namespace, this.qtName, null));
        }
    }

    private static class DeleteNameSpaceLogObj
    implements LogRecord {
        private static final long serialVersionUID = 6349423596857633706L;
        private final String namespace;

        public DeleteNameSpaceLogObj(String namespace) {
            this.namespace = PSRlogImpl.cleanNamespace(namespace);
        }

        @Override
        public void apply(PSRlogImpl psImpl) throws WBEMException {
            psImpl.deleteNameSpaceDo(this.namespace);
        }
    }

    private static class DeleteInstanceLogObj
    implements LogRecord {
        private static final long serialVersionUID = -244838496512419329L;
        private final String namespace;
        private final String iname;

        public DeleteInstanceLogObj(String namespace, String iname) {
            this.namespace = PSRlogImpl.cleanNamespace(namespace);
            this.iname = iname;
        }

        @Override
        public void apply(PSRlogImpl psImpl) throws WBEMException {
            psImpl.deleteInstance(this.namespace, this.iname);
        }
    }

    private static class DeleteClassLogObj
    implements LogRecord {
        private static final long serialVersionUID = -6444092897893756582L;
        private final String namespace;
        private final String className;

        public DeleteClassLogObj(String namespace, String className) {
            this.namespace = PSRlogImpl.cleanNamespace(namespace);
            this.className = className;
        }

        @Override
        public void apply(PSRlogImpl psImpl) throws WBEMException {
            psImpl.deleteClass(new CIMObjectPath(null, null, null, this.namespace, this.className, null));
        }
    }

    private static class CreateNameSpaceLogObj
    implements LogRecord {
        private static final long serialVersionUID = -3217549711344318384L;
        private final String namespace;

        public CreateNameSpaceLogObj(String namespace) {
            this.namespace = PSRlogImpl.cleanNamespace(namespace);
        }

        @Override
        public void apply(PSRlogImpl psImpl) throws WBEMException {
            psImpl.createNameSpaceDo(this.namespace);
        }
    }

    private static class AddCIMQualifierLogObj
    implements LogRecord {
        private static final long serialVersionUID = 9136358929100936537L;
        protected String namespace;
        protected String name;
        protected PersistentStore.PersistObject po;
        protected transient CIMRlogEntry entry = null;

        public AddCIMQualifierLogObj(String namespace, String name, PersistentStore.PersistObject po) {
            this.namespace = PSRlogImpl.cleanNamespace(namespace);
            this.name = name;
            this.po = po;
        }

        @Override
        public void apply(PSRlogImpl psImpl) throws WBEMException {
            psImpl.store.addPersistObject(this.po);
            this.applyDo(psImpl);
            this.entry.setID(this.po.getID());
        }

        protected void applyDo(PSRlogImpl psImpl) throws WBEMException {
            this.entry = psImpl.createQualifierTypeDo(this.namespace, this.name);
        }

        protected Object getCIMElement(PSRlogImpl psImpl) throws WBEMException {
            try {
                byte[] bytes = psImpl.store.readObjectBytes(this.po.getID());
                return PSRlogImpl.deserialize(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException("object id = " + this.po.getID() + " does not exist");
            }
        }
    }

    private static class AddCIMInstanceLogObj
    extends AddCIMClassLogObj {
        private static final long serialVersionUID = -3727326644253863113L;

        public AddCIMInstanceLogObj(String namespace, String name, String otherName, boolean assoc, PersistentStore.PersistObject po) {
            super(namespace, name, otherName, assoc, po);
        }

        @Override
        protected void applyDo(PSRlogImpl psImpl) throws WBEMException {
            CIMInstance ci = this.assoc ? (CIMInstance)this.getCIMElement(psImpl) : null;
            this.entry = psImpl.addCIMInstanceDo(this.namespace, this.name, this.otherName, ci);
        }
    }

    private static class AddCIMClassLogObj
    extends AddCIMQualifierLogObj {
        private static final long serialVersionUID = -7848952153471853442L;
        protected String otherName;
        protected boolean assoc;

        public AddCIMClassLogObj(String namespace, String name, String otherName, boolean assoc, PersistentStore.PersistObject po) {
            super(namespace, name, po);
            this.assoc = assoc;
            this.otherName = otherName;
        }

        @Override
        protected void applyDo(PSRlogImpl psImpl) throws WBEMException {
            CIMClass cc = this.assoc ? (CIMClass)this.getCIMElement(psImpl) : null;
            this.entry = psImpl.createClassDo(this.namespace, this.name, this.otherName, this.assoc, cc);
        }
    }
}

