/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.repository;

import com.ws.utilities.WSIStandardMessages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;
import javax.cim.CIMQualifiedElementInterface;
import javax.cim.CIMQualifier;
import javax.wbem.WBEMException;
import org.wbemservices.wbem.repository.CIMOMUtils;

class PropertyChecker {
    CIMOMUtils mUtils;
    private static final String[] mReservedCIMWords = new String[]{"and", "from", "not", "or", "select", "where"};

    public PropertyChecker(CIMOMUtils cu) {
        this.mUtils = cu;
    }

    CIMClass checkPropertiesSanity(String namespace, CIMClass cc, int keysRequired, int refsRequired, CIMClass superclass, boolean isIndication) throws WBEMException, IllegalArgumentException {
        CIMClassProperty[] prt = cc.getProperties();
        Hashtable<String, String> overrideMap = new Hashtable<String, String>();
        Hashtable<String, String> propNames = new Hashtable<String, String>();
        if (prt != null) {
            for (int i = 0; i < prt.length; ++i) {
                Object[] o;
                CIMClassProperty<?> pe = prt[i];
                if (pe.getName() == null) {
                    Object[] o2 = new Object[]{cc.getName()};
                    throw new IllegalArgumentException(WSIStandardMessages.getMessage((String)"ERROR_PROPERTY_INVALID_NAME", (Object[])o2));
                }
                CIMDataType cdt = pe.getDataType();
                if (cdt == null) {
                    Object[] o3 = new Object[]{pe.getName(), cc.getName()};
                    throw new IllegalArgumentException(WSIStandardMessages.getMessage((String)"ERROR_PROPERTY_INVALID_TYPE", (Object[])o3));
                }
                int cdtt = cdt.getType();
                if (cdtt >= 16 || cdtt <= -1) {
                    o = new Object[]{pe.getName(), cc.getName()};
                    throw new IllegalArgumentException(WSIStandardMessages.getMessage((String)"ERROR_PROPERTY_INVALID_TYPE", (Object[])o));
                }
                if (Arrays.binarySearch(mReservedCIMWords, pe.getName().toLowerCase()) > 0) {
                    o = new Object[]{pe.getName(), cc.getName()};
                    throw new IllegalArgumentException(WSIStandardMessages.getMessage((String)"ERROR_PROPERTY_RESERVED_NAME", (Object[])o));
                }
                if (propNames.get(pe.getName().toLowerCase()) != null) {
                    o = new Object[]{pe.getName(), cc.getName()};
                    throw new IllegalArgumentException(WSIStandardMessages.getMessage((String)"ERROR_PROPERTY_DUPLICATE", (Object[])o));
                }
                propNames.put(pe.getName().toLowerCase(), "");
                pe = new CIMClassProperty(pe.getName(), pe.getDataType(), pe.getValue(), pe.getQualifiers(), pe.isKey(), false);
                CIMQualifier[] qt = pe.getQualifiers();
                if (pe.getDataType().getType() == 14) {
                    if (!cc.isAssociation()) {
                        Object[] o4 = new Object[]{pe.getName(), cc.getName()};
                        throw new IllegalArgumentException(WSIStandardMessages.getMessage((String)"ERROR_PROPERTY_INVALID_TYPE_REF", (Object[])o4));
                    }
                    qt = this.mUtils.doCommonQualifierChecks(namespace, pe.getName(), qt, 16);
                    --refsRequired;
                } else {
                    qt = this.mUtils.doCommonQualifierChecks(namespace, pe.getName(), qt, 8);
                }
                boolean isKey = pe.isKey();
                if (isKey && pe.getDataType().isArray()) {
                    Object[] o5 = new Object[]{pe.getName(), cc.getName()};
                    throw new IllegalArgumentException(WSIStandardMessages.getMessage((String)"ERROR_PROPERTY_INVALID_TYPE_KEY", (Object[])o5));
                }
                boolean newKey = false;
                CIMQualifier qe = (pe = this.handlePropertyOverride(namespace, cc, pe, overrideMap, superclass)).getQualifier("Override");
                if (qe == null && isKey || qe != null && newKey) {
                    if (isIndication) {
                        Object[] o6 = new Object[]{pe.getName(), cc.getName()};
                        throw new IllegalArgumentException(WSIStandardMessages.getMessage((String)"ERROR_PROPERTY_INVALID_KEY_INDICATION", (Object[])o6));
                    }
                    keysRequired = -1;
                }
                this.mUtils.verifyQualifiers((CIMQualifiedElementInterface)pe, cc.getName(), namespace, superclass, pe.getName(), pe.getDataType(), pe.isKey());
                prt[i] = pe;
            }
            cc = new CIMClass(cc.getObjectPath(), cc.getSuperClassName(), cc.getQualifiers(), prt, cc.getMethods(), cc.isAssociation(), cc.isKeyed());
        }
        if (keysRequired == -1 && !isIndication) {
            cc = new CIMClass(cc.getObjectPath(), cc.getSuperClassName(), cc.getQualifiers(), cc.getProperties(), cc.getMethods(), cc.isAssociation(), true);
        }
        if (keysRequired > 0) {
            Object[] o = new Object[]{cc.getName()};
            throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_CLASS_MISSING_KEYS", (Object[])o));
        }
        if (refsRequired > 0) {
            Object[] o = new Object[]{cc.getName()};
            throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_CLASS_MISSING_REFS", (Object[])o));
        }
        cc = this.assignInheritedProperties(namespace, cc, overrideMap, superclass);
        return cc;
    }

    private CIMClassProperty<?> handlePropertyOverride(String namespace, CIMClass cc, CIMClassProperty<?> pe, Hashtable<String, String> overrideMap, CIMClass superclass) throws WBEMException, IllegalArgumentException {
        CIMQualifier qe = pe.getQualifier("Override");
        if (qe == null) {
            String strict;
            if (superclass != null && superclass.getProperty(pe.getName()) != null && (strict = System.getProperty("com.ws.jserver.strict")) != null && strict.equalsIgnoreCase("true")) {
                Object[] o = new Object[]{cc.getName(), pe.getName()};
                throw new IllegalArgumentException(WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_OVERRIDE_NOT_USED", (Object[])o));
            }
            return pe;
        }
        Object ValueTable = qe.getValue();
        String Value = null;
        if (ValueTable != null) {
            Value = (String)ValueTable;
        }
        if (ValueTable == null || Value == null || Value.equals("")) {
            Object[] o = new Object[]{pe.getName(), cc.getName()};
            throw new IllegalArgumentException(WSIStandardMessages.getMessage((String)"ERROR_PROPERTY_INVALID_QUALIFIER_OVERRIDE", (Object[])o));
        }
        String ClassName = null;
        int trenner = Value.indexOf(".");
        String PropertyName = Value.substring(trenner + 1, Value.length());
        if (trenner > 0) {
            ClassName = Value.substring(0, trenner);
        }
        CIMClassProperty ope = null;
        if (superclass == null) {
            Object[] o = new Object[]{pe.getName(), cc.getName()};
            throw new IllegalArgumentException(WSIStandardMessages.getMessage((String)"ERROR_PROPERTY_INVALID_QUALIFIER_OVERRIDE_NO_SUPERCLASS", (Object[])o));
        }
        ope = superclass.getProperty(PropertyName);
        if (ope == null) {
            Object[] o = new Object[]{pe.getName(), cc.getName(), superclass.getName()};
            throw new IllegalArgumentException(WSIStandardMessages.getMessage((String)"ERROR_PROPERTY_INVALID_QUALIFIER_OVERRIDE_NO_PROPERTY", (Object[])o));
        }
        if (!ope.getName().equalsIgnoreCase(PropertyName)) {
            Object[] o = new Object[]{pe.getName(), cc.getName(), ClassName};
            throw new IllegalArgumentException(WSIStandardMessages.getMessage((String)"ERROR_PROPERTY_INVALID_QUALIFIER_OVERRIDE_NO_CLASSORIGIN", (Object[])o));
        }
        String tempop = overrideMap.get(ope.getName());
        if (tempop != null) {
            Object[] o = new Object[]{pe.getName(), cc.getName()};
            throw new IllegalArgumentException(WSIStandardMessages.getMessage((String)"ERROR_PROPERTY_INVALID_QUALIFIER_OVERRIDE", (Object[])o));
        }
        CIMQualifier<?>[] uq = this.mUtils.assignInheritedQualifiers(pe.getQualifiers(), ope.getQualifiers());
        if ((pe = new CIMClassProperty(pe.getName(), pe.getDataType(), pe.getValue(), uq, pe.isKey(), pe.isPropagated())).getQualifier("key") != null) {
            pe = new CIMClassProperty(pe.getName(), pe.getDataType(), pe.getValue(), pe.getQualifiers(), true, pe.isPropagated());
        }
        boolean isKeyOpe = ope.isKey();
        boolean isKeyPe = pe.isKey();
        if (isKeyOpe && !isKeyPe) {
            Object[] o = new Object[]{cc.getName(), pe.getName(), superclass.getName(), ope.getName()};
            throw new IllegalArgumentException(WSIStandardMessages.getMessage((String)"ERROR_PROPERTY_INVALID_QUALIFIER_OVERRIDE_NOT_KEY", (Object[])o));
        }
        StringBuilder key = new StringBuilder(superclass.getName());
        key.append(".");
        key.append(ope.getName());
        StringBuilder value = new StringBuilder(cc.getName());
        value.append(".");
        value.append(pe.getName());
        overrideMap.put(key.toString(), value.toString());
        return pe;
    }

    private CIMClass assignInheritedProperties(String namespace, CIMClass cc, Hashtable<String, String> overrideMap, CIMClass superclass) {
        ArrayList<CIMClassProperty> l = new ArrayList<CIMClassProperty>();
        if (superclass != null) {
            int i;
            CIMClassProperty[] PropTable = superclass.getProperties();
            if (cc.getProperties() != null) {
                for (i = 0; i < cc.getProperties().length; ++i) {
                    l.add(cc.getProperties()[i]);
                }
            }
            if (PropTable != null) {
                for (i = 0; i < PropTable.length; ++i) {
                    CIMClassProperty pe = PropTable[i];
                    if (cc.getProperty(pe.getName()) != null && cc.getProperty(pe.getName()).getQualifier("Override") != null) continue;
                    l.add(new CIMClassProperty(pe.getName(), pe.getDataType(), pe.getValue(), pe.getQualifiers(), pe.isKey(), true));
                }
                cc = new CIMClass(cc.getObjectPath(), cc.getSuperClassName(), cc.getQualifiers(), l.toArray(new CIMClassProperty[l.size()]), cc.getMethods(), cc.isAssociation(), cc.isKeyed());
            }
        }
        return cc;
    }
}

