/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing.encode;

import com.klg.jclass.util.swing.encode.Encoder;
import com.klg.jclass.util.swing.encode.EncoderException;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractImageEncoder
implements Encoder {
    public static byte byteFromChar(char c) {
        char c2 = c;
        byte by = 0;
        boolean bl = false;
        int n = 0;
        while (n <= 7) {
            if ((c2 & (byte)Math.pow(2.0, n)) != 0) {
                by = (byte)(by | (byte)Math.pow(2.0, n));
            }
            ++n;
        }
        return by;
    }

    public static byte byteFromInt(int n) {
        return (byte)(n & 0xFF);
    }

    public static byte[] bytesFromLong(long l) {
        byte[] byArray = new byte[]{(byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
        return byArray;
    }

    public byte compressColor(int n) {
        return this.compressColor(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    public byte compressColor(int n, int n2, int n3) {
        return (byte)(n & 0xE0 | n2 >> 3 & 0x1C | n3 >> 6 & 3);
    }

    public byte createByte(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        byte by = 0;
        if (n8 == 1) {
            by = (byte)(by | 1);
        }
        if (n7 == 1) {
            by = (byte)(by | 2);
        }
        if (n6 == 1) {
            by = (byte)(by | 4);
        }
        if (n5 == 1) {
            by = (byte)(by | 8);
        }
        if (n4 == 1) {
            by = (byte)(by | 0x10);
        }
        if (n3 == 1) {
            by = (byte)(by | 0x20);
        }
        if (n2 == 1) {
            by = (byte)(by | 0x40);
        }
        if (n == 1) {
            by = (byte)(by | 0x80);
        }
        return by;
    }

    public void encode(Component component, OutputStream outputStream) throws IOException, EncoderException {
        this.encode(AbstractImageEncoder.snapshot(component), outputStream);
    }

    public void encode(Image image, OutputStream outputStream) throws IOException, EncoderException {
        this.saveImage(image, outputStream);
    }

    protected void error(String string) throws EncoderException {
        throw new EncoderException(string);
    }

    public abstract void saveImage(Image var1, OutputStream var2) throws IOException, EncoderException;

    public static Image snapshot(Component component) {
        Image image = component.createImage(component.getSize().width, component.getSize().height);
        if (image != null) {
            Graphics graphics = image.getGraphics();
            graphics.setClip(0, 0, component.getSize().width, component.getSize().height);
            component.paint(graphics);
        }
        return image;
    }
}

