/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.kerberos;

import com.sun.security.auth.module.Krb5LoginModule;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import sanproject.sn2.base.SJbaseConst;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalAccountInfo;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExAuthenticationException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationException;
import sanproject.sn2.base.authentication.module.external.kerberos.SJbaseKerberosConfiguration;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sun.security.krb5.KrbException;

public class SJbaseKerberosGetInitialTicket {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseKerberosGetInitialTicket";

    public SJbaseExternalAccountInfo execute(SJbaseKerberosConfiguration kerberosConf, String userId, String password) throws SJbaseExAuthenticationException, SJbaseExCommunicationException {
        String method = "execute";
        logger.info(module, method, "", "start");
        SJbaseExternalAccountInfo account = null;
        String data = "[libdefaults]\ndefault_realm = " + kerberosConf.getRealm() + "\n" + "clockskew = " + kerberosConf.getClockskew() + "\n" + "kdc_timeout = " + kerberosConf.getTimeout() * 350 + "\n" + "\n" + "[realms]\n" + kerberosConf.getRealm() + " = {\n" + "kdc = " + kerberosConf.getKdc() + "\n" + "}\n";
        String dataPath = System.getProperty("SN_DataPath");
        String path = SJcFileUty.setEndPathSeparator(dataPath) + SJcFileUty.setEndPathSeparator("data") + SJbaseConst.SN_DIRECTORY_BASE_TMP + File.separator + "krb5.conf";
        File file = null;
        try {
            file = new File(path);
            if (!file.exists()) {
                file.createNewFile();
            }
            if (file.isFile() && file.canWrite()) {
                PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                pw.println(data);
                pw.close();
            } else {
                logger.error(module, method, "write to file", "faild");
            }
        }
        catch (Exception e) {
            logger.error(module, method, "write to file", "faild");
            SJbaseExAuthenticationException et = new SJbaseExAuthenticationException();
            et.setErrCode(9999);
            throw et;
        }
        System.setProperty("java.security.krb5.conf", path);
        try {
            Krb5LoginModule krb5 = new Krb5LoginModule();
            Subject subject = new Subject();
            HashMap<String, Object> shared = new HashMap<String, Object>();
            shared.put("javax.security.auth.login.name", userId);
            shared.put("javax.security.auth.login.password", password.toCharArray());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("debug", "false");
            map.put("useFirstPass", "true");
            map.put("clearPass", "true");
            map.put("refreshKrb5Config", "true");
            krb5.initialize(subject, null, shared, map);
            krb5.login();
            boolean com = krb5.commit();
            if (com) {
                account = new SJbaseExternalAccountInfo(userId);
                account.setAuthServerInfo(kerberosConf.getKdc());
                logger.info(module, method, "try the get ticket operation", "success");
            }
        }
        catch (SJbaseExAuthenticationException e) {
            throw e;
        }
        catch (SJbaseExCommunicationException e) {
            throw e;
        }
        catch (LoginException e) {
            String err = e.getMessage();
            Throwable ex = e.getCause();
            if (ex instanceof KrbException) {
                int code = ((KrbException)ex).returnCode();
                if (code == 6 || code == 24) {
                    logger.warn(module, method, "try the get ticket operation", "failed", ex);
                    SJbaseExAuthenticationException et = new SJbaseExAuthenticationException();
                    et.setErrCode(code);
                    throw et;
                }
                logger.error(module, method, "try the get ticket operation", err, ex);
                SJbaseExAuthenticationException et = new SJbaseExAuthenticationException();
                et.setErrCode(code);
                throw et;
            }
            logger.error(module, method, "try the get ticket operation", "connect failed", ex);
            SJbaseExCommunicationException et = new SJbaseExCommunicationException();
            throw et;
        }
        catch (Exception e) {
            logger.error(module, method, "try the bind operation", "failed", e);
            SJbaseExAuthenticationException et = new SJbaseExAuthenticationException();
            et.setErrCode(9999);
            throw et;
        }
        finally {
            file.delete();
        }
        logger.info(module, method, "", "end");
        return account;
    }
}

