/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.ldapgetgroup;

import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalAccountInfo;
import sanproject.sn2.base.authentication.module.external.common.SJbaseGetGroupModule;
import sanproject.sn2.base.authentication.module.external.common.SJbaseParamater;
import sanproject.sn2.base.authentication.module.external.common.SJbaseSrvRecord;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationGroupException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExGetGroupException;
import sanproject.sn2.base.authentication.module.external.ldapgetgroup.SJbaseLdapGetGroupModuleThread;
import sanproject.sn2.base.authentication.module.external.ldapgetgroup.SJbaseLdapGroupConfiguration;
import sanproject.sn2.base.authentication.module.external.ldapgetgroup.SJbaseLdapGroupConfigurationFactory;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseLdapGetGroupModule
implements SJbaseGetGroupModule {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseLdapGetGroupModule";
    private SJbaseLdapGroupConfiguration ldapGroupConf = null;
    private SJbaseExternalAccountInfo account;
    private SJbaseParamater paramater;

    public SJbaseLdapGetGroupModule(SJbaseParamater paramater) {
        String method = "constructor";
        logger.info(module, method, "", "start");
        this.paramater = paramater;
        logger.info(module, method, "", "end");
    }

    @Override
    public SJbaseExternalAccountInfo authorize() throws SJbaseExGetGroupException, SJbaseExCommunicationException {
        String method = "authorize";
        logger.info(module, method, "", "srart");
        this.ldapGroupConf = new SJbaseLdapGroupConfigurationFactory(this.paramater).getGroupConfigurations();
        if (this.ldapGroupConf == null) {
            logger.info(module, method, "check the configuration objectes", "invalid");
            SJbaseExGetGroupException et = new SJbaseExGetGroupException();
            et.setErrCode(9999);
            throw et;
        }
        logger.info(module, method, "start the authentication process", "server :" + this.ldapGroupConf.getHost() + "]");
        String authServerType = this.paramater.getAuthServerType();
        if (authServerType.equalsIgnoreCase("ldap") || authServerType.equalsIgnoreCase("kerberos")) {
            this.account = this.authorize(this.paramater, this.ldapGroupConf);
            logger.info(module, method, "authorize the user", "succeeded, server :" + this.ldapGroupConf.getHost());
            logger.info(module, method, "", "end");
            return this.account;
        }
        if (authServerType.equalsIgnoreCase("radius")) {
            if (this.ldapGroupConf.getDnsLookup().equalsIgnoreCase("true")) {
                String[] hostList = new SJbaseSrvRecord(this.ldapGroupConf.getProtocol(), this.ldapGroupConf.getDomainName()).getServerList();
                for (int i = 0; i < hostList.length; ++i) {
                    String[] tmpList = hostList[i].split(",");
                    this.ldapGroupConf.setPort(Integer.parseInt(tmpList[2]));
                    this.ldapGroupConf.setHost(tmpList[3].substring(0, tmpList[3].length() - 1));
                    try {
                        this.account = this.authorize(this.paramater, this.ldapGroupConf);
                        logger.info(module, method, "authorize the user", "succeeded, server :[" + i + "]");
                        logger.info(module, method, "", "end");
                        return this.account;
                    }
                    catch (SJbaseExCommunicationException e) {
                        logger.info(module, method, "authorize the user", "failed, server :[" + i + "]", e);
                        continue;
                    }
                }
            } else {
                this.account = this.authorize(this.paramater, this.ldapGroupConf);
                logger.info(module, method, "authorize the user", "succeeded, server :" + this.ldapGroupConf.getHost());
                logger.info(module, method, "", "end");
                return this.account;
            }
        }
        logger.info(module, method, "authentication the user", "failed at all servers");
        throw new SJbaseExCommunicationGroupException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SJbaseExternalAccountInfo authorize(SJbaseParamater paramater, SJbaseLdapGroupConfiguration ldapGroupConf) throws SJbaseExGetGroupException, SJbaseExCommunicationException {
        String method = "authorize";
        logger.info(module, method, "", "start");
        int timeoutCount = -1;
        int retryTimes = ldapGroupConf.getRetryTimes();
        int retryInterval = ldapGroupConf.getRetryInterval();
        do {
            logger.info(module, method, "start the authorization process", "retry times :" + Integer.toString(timeoutCount + 1));
            if (ldapGroupConf.getServerErrCode() == 10) {
                logger.info(module, method, "check the configuration object", "invalid");
                SJbaseExGetGroupException et = new SJbaseExGetGroupException();
                et.setErrCode(9999);
                throw et;
            }
            SJbaseLdapGetGroupModuleThread ldapGetGroupModuleThread = null;
            try {
                this.account = paramater.getAccount();
                ldapGetGroupModuleThread = new SJbaseLdapGetGroupModuleThread(this.account, ldapGroupConf);
                ldapGetGroupModuleThread.setDaemon(true);
                ldapGetGroupModuleThread.start();
                try {
                    int timeout = ldapGroupConf.getTimeout();
                    if (timeout == 0) {
                        logger.info(module, method, "set timeout", Integer.toString(120));
                        ldapGetGroupModuleThread.join(120000L);
                    } else {
                        logger.info(module, method, "set timeout", Integer.toString(timeout));
                        ldapGetGroupModuleThread.join(timeout * 1000);
                    }
                }
                catch (InterruptedException e) {
                    logger.info(module, method, "", "interrupted", e);
                }
                if (ldapGetGroupModuleThread.isAlive()) {
                    logger.info(module, method, "", "no response from the server -timeout");
                    throw new SJbaseExCommunicationGroupException();
                }
                this.account = ldapGetGroupModuleThread.getAuthorizationResult();
                paramater.setAccount(this.account);
                logger.info(module, method, "authorize the user", "succeeded");
                logger.info(module, method, "", "end");
                SJbaseExternalAccountInfo e = this.account;
                return e;
            }
            catch (SJbaseExCommunicationException e) {
                logger.info(module, method, "failed in the authentication process", "retry times :" + Integer.toString(timeoutCount + 1));
                if (++timeoutCount >= retryTimes) continue;
                try {
                    Thread.sleep(retryInterval * 1000);
                }
                catch (InterruptedException ie) {
                    logger.info(module, method, "", "interrupted", e);
                }
            }
            finally {
                if (ldapGetGroupModuleThread != null) {
                    ldapGetGroupModuleThread = null;
                }
            }
        } while (timeoutCount < retryTimes);
        logger.info(module, method, "authorize the user", "failed scheduled times");
        throw new SJbaseExCommunicationGroupException();
    }
}

