/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.Logger;

import java.util.List;
import java.util.Map;
import sanproject.sn2.com.utility.Logger.SJcAuditLogCtrlMultiStratumFormElemCon;
import sanproject.sn2.com.utility.Logger.SJcAuditLogCtrlMultiStratumLogData;
import sanproject.sn2.com.utility.Logger.SJcAuditLogPrinterSN2;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLogElementContainerInterface;

public class SJcAuditLogCtrlMultiStratumFormPrinter
extends SJcAuditLogPrinterSN2 {
    @Override
    public void formatDetail(SJcAuditLogElementContainerInterface ec) {
        SJcAuditLogCtrlMultiStratumFormElemCon elem = (SJcAuditLogCtrlMultiStratumFormElemCon)ec;
        this.outputHeader(elem);
        this.outputDetail(elem);
        this.outputFooter(elem);
    }

    private void outputHeader(SJcAuditLogCtrlMultiStratumFormElemCon elem) {
        Map<String, String> titleMap = elem.getTitleData();
        String head = titleMap.get("Header");
        if (head != null) {
            Object[] arg = new Object[]{this.handleDetail, null, "%s", head};
            this.invokeFormatDetail("AdtFmt_Printf", Integer.class, arg);
        }
    }

    private void outputDetail(SJcAuditLogCtrlMultiStratumFormElemCon elem) {
        List<SJcAuditLogCtrlMultiStratumLogData> logList = elem.getLogList();
        if (logList == null) {
            return;
        }
        int currentStratumLevel = 1;
        for (SJcAuditLogCtrlMultiStratumLogData logData : logList) {
            currentStratumLevel = this.changeStratum(currentStratumLevel, logData.getStratumLevel());
            int index = 0;
            for (String log : logData.getInfoList()) {
                String argType = index == 0 ? ",%s" : "%s";
                Object[] arg = new Object[]{this.handleDetail, argType, log};
                this.invokeFormatDetail("AdtFmt_Printf", Integer.class, arg);
                ++index;
            }
        }
        this.changeStratum(currentStratumLevel, 1);
    }

    private void outputFooter(SJcAuditLogCtrlMultiStratumFormElemCon elem) {
        Map<String, String> titleMap = elem.getTitleData();
        String foot = titleMap.get("Footer");
        if (foot != null) {
            Object[] arg = new Object[]{this.handleDetail, ",%s", foot};
            this.invokeFormatDetail("AdtFmt_Printf", Integer.class, arg);
        }
    }

    private int changeStratum(int currentStratum, int nextStratum) {
        if (currentStratum > nextStratum) {
            Object[] indent = new Object[]{this.handleDetail, false};
            for (int i = 0; i < currentStratum - nextStratum; ++i) {
                this.invokeFormatDetail("AdtFmt_Indent", Integer.class, indent);
            }
        } else {
            Object[] indent = new Object[]{this.handleDetail, true};
            for (int i = 0; i < nextStratum - currentStratum; ++i) {
                this.invokeFormatDetail("AdtFmt_Indent", Integer.class, indent);
            }
        }
        return nextStratum;
    }
}

