/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;

public class SJcRebrandingUty {
    private static final String REBRANDING_FILE_NAME = "Brand_Free_Flag";
    private static final String REBRANDING_FILE_DIR_EXT_PATH = "san\\htdocs\\san\\datachgtbl\\";
    private static final File REBRANDING_FILE;
    private static final String KEY_VALUE_DELIMITER = ":";
    private static final String COPYRIGHT_KEY = "Copyright";
    private static final String DEFAULT_COPYRIGHT = "";
    private static final int COPYRIGHT_VALUE_MAX_LENGTH = 60;

    public static boolean existRebrandingFile() {
        return REBRANDING_FILE != null && REBRANDING_FILE.isFile();
    }

    public static String getRebrandingCopyright() {
        if (!SJcRebrandingUty.existRebrandingFile()) {
            return DEFAULT_COPYRIGHT;
        }
        try {
            Map<String, String> rebrandingProperties = SJcRebrandingUty.readKeyValuePairs(REBRANDING_FILE);
            if (!rebrandingProperties.containsKey(COPYRIGHT_KEY)) {
                return DEFAULT_COPYRIGHT;
            }
            String copyright = rebrandingProperties.get(COPYRIGHT_KEY);
            if (copyright.length() > 60) {
                return DEFAULT_COPYRIGHT;
            }
            return copyright;
        }
        catch (IOException e) {
            return DEFAULT_COPYRIGHT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> readKeyValuePairs(File file) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] keyValuePair = line.split(KEY_VALUE_DELIMITER, 2);
                if (keyValuePair.length != 2) continue;
                map.put(keyValuePair[0], keyValuePair[1]);
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    static {
        String rebrandingFilePath = SJcFileUty.concatFolderPath(SJcEnvUty.getSnBasePath(), "san\\htdocs\\san\\datachgtbl\\Brand_Free_Flag");
        REBRANDING_FILE = rebrandingFilePath == null ? null : new File(rebrandingFilePath);
    }
}

