/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.system.exception.SJcSystemUtyNetworkException;

public class SJcSystemUty {
    private static final String function = "System";
    private static final String title = "SJcSystemUty";

    public static long getCommittedMemory() {
        return SJcSystemUty.getMemInfo().getCommitted();
    }

    private static MemoryUsage getMemInfo() {
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapUsage = mbean.getHeapMemoryUsage();
        return heapUsage;
    }

    public static long getInitMemory() {
        long init = SJcSystemUty.getMemInfo().getInit();
        return init;
    }

    public static long getMaxMemory() {
        long max = SJcSystemUty.getMemInfo().getMax();
        return max;
    }

    public static long getUsedMemory() {
        long used = SJcSystemUty.getMemInfo().getUsed();
        return used;
    }

    public static long getFreeMemory() {
        long free = SJcSystemUty.getMaxMemory() - SJcSystemUty.getUsedMemory();
        return free;
    }

    public static boolean chkFreeMemory(long necessaryMemory) {
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(function, title, "chkFreeMemory", "start");
        boolean result = false;
        if (SJcSystemUty.getFreeMemory() >= necessaryMemory) {
            result = true;
        }
        STD_LOGGER.info(function, title, "chkFreeMemory", "necessary memory " + necessaryMemory + " Byte : free memory " + SJcSystemUty.getFreeMemory() + " Byte : " + result);
        STD_LOGGER.trace(function, title, "chkFreeMemory", "end");
        return result;
    }

    public static void execGarbageCollection() {
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(function, title, "execGarbageCollection", "start");
        long before = SJcSystemUty.getUsedMemory();
        System.gc();
        long after = SJcSystemUty.getUsedMemory();
        STD_LOGGER.info(function, title, "execGarbageCollection", "<garbage collection> before " + before + " Byte : after " + after + " Byte");
        STD_LOGGER.trace(function, title, "execGarbageCollection", "end");
    }

    public static InetAddress[] getIP_Myself() throws SJcException {
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(function, title, "getIP_Myself", "start");
        InetAddress[] result = null;
        ArrayList<InetAddress> ipList = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> enuIfs = NetworkInterface.getNetworkInterfaces();
            if (null != enuIfs) {
                while (enuIfs.hasMoreElements()) {
                    NetworkInterface nic = enuIfs.nextElement();
                    Enumeration<InetAddress> enuAddrs = nic.getInetAddresses();
                    while (enuAddrs.hasMoreElements()) {
                        InetAddress intf = enuAddrs.nextElement();
                        ipList.add(intf);
                    }
                }
            }
            result = new InetAddress[ipList.size()];
            result = ipList.toArray(result);
        }
        catch (SocketException e) {
            throw new SJcSystemUtyNetworkException(e, "107013");
        }
        STD_LOGGER.trace(function, title, "getIP_Myself", "end");
        return result;
    }

    public static boolean chkIP_Myself(InetAddress ipAddress) throws SJcException {
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(function, title, "chkIP_Myself", "start");
        boolean result = false;
        InetAddress[] ipList = SJcSystemUty.getIP_Myself();
        for (int i = 0; i < ipList.length; ++i) {
            if (!ipList[i].equals(ipAddress)) continue;
            result = true;
            break;
        }
        if (!result) {
            STD_LOGGER.info(function, title, "chkIP_Myself", "not myself. IP address: " + ipAddress.getHostAddress());
        }
        STD_LOGGER.trace(function, title, "chkIP_Myself", "end");
        return result;
    }
}

