/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.fileuty;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.fileuty.inf.SJcFileInterface;

public class SJcFileOnDisk
implements SJcFileInterface {
    static final long serialVersionUID = 0L;
    private String path;

    public SJcFileOnDisk(String path) {
        this.path = path;
    }

    @Override
    public String getFilename() {
        File file = new File(this.path);
        String ret = file.getName();
        file = null;
        return ret;
    }

    @Override
    public long getLength() {
        File file = new File(this.path);
        long ret = file.length();
        file = null;
        return ret;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean createNewFile() throws IOException {
        File file = new File(this.path);
        boolean ret = file.createNewFile();
        file = null;
        return ret;
    }

    @Override
    public boolean delete() {
        File file = new File(this.path);
        boolean ret = file.delete();
        file = null;
        return ret;
    }

    @Override
    public void deleteAll() {
        File file = new File(this.path);
        this.deleteContainsAll(file);
        file = null;
    }

    private void deleteContainsAll(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.deleteContainsAll(files[i]);
            }
            file.delete();
        }
    }

    @Override
    public boolean equals(Object obj) {
        boolean ret = false;
        if (obj instanceof SJcFileOnDisk && this.path != null) {
            ret = new File(this.path).equals(new File(((SJcFileOnDisk)obj).path));
        }
        return ret;
    }

    @Override
    public boolean exists() {
        File file = new File(this.path);
        boolean ret = file.exists();
        file = null;
        return ret;
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        FileInputStream iStream = new FileInputStream(this.path);
        return iStream;
    }

    @Override
    public OutputStream getOutputStream() throws FileNotFoundException {
        FileOutputStream oStream = new FileOutputStream(this.path);
        return oStream;
    }

    @Override
    public boolean isDirectory() {
        File file = new File(this.path);
        boolean ret = file.isDirectory();
        file = null;
        return ret;
    }

    @Override
    public boolean isFile() {
        File file = new File(this.path);
        boolean ret = file.isFile();
        file = null;
        return ret;
    }

    @Override
    public SJcFileInterface getParent() {
        File file = new File(this.path);
        String parentPath = file.getParent();
        SJcFileOnDisk parent = new SJcFileOnDisk(parentPath);
        file = null;
        return parent;
    }

    @Override
    public long lastModified() {
        File file = new File(this.path);
        long ret = file.lastModified();
        file = null;
        return ret;
    }

    @Override
    public SJcFileInterface[] listFiles() {
        File file = new File(this.path);
        String[] pathes = file.list();
        SJcFileInterface[] files = null;
        if (pathes == null) {
            files = new SJcFileInterface[]{};
        } else {
            files = new SJcFileInterface[pathes.length];
            for (int i = 0; i < pathes.length; ++i) {
                files[i] = new SJcFileOnDisk(SJcFileUty.setEndPathSeparator(this.path) + pathes[i]);
            }
        }
        file = null;
        return files;
    }

    @Override
    public boolean mkdir() {
        File file = new File(this.path);
        boolean ret = file.mkdir();
        file = null;
        return ret;
    }

    @Override
    public boolean mkdirs() {
        File file = new File(this.path);
        boolean ret = file.mkdirs();
        file = null;
        return ret;
    }

    @Override
    public boolean renameTo(String newName) {
        File file = new File(this.path);
        File newFile = new File(newName);
        boolean ret = file.renameTo(newFile);
        file = null;
        newFile = null;
        return ret;
    }

    @Override
    public boolean setLastModified(long timeInMillis) {
        File file = new File(this.path);
        boolean ret = file.setLastModified(timeInMillis);
        file = null;
        return ret;
    }

    @Override
    public byte[] readBytes(int offset, int length) throws FileNotFoundException, IOException {
        byte[] data = new byte[length];
        RandomAccessFile rmf = null;
        try {
            rmf = new RandomAccessFile(this.path, "r");
            rmf.seek(offset);
            rmf.readFully(data, 0, length);
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (null != rmf) {
                rmf.close();
            }
        }
        return data;
    }

    @Override
    public void writeBytes(byte[] data, int offset) throws FileNotFoundException, IOException {
        RandomAccessFile rmf = null;
        try {
            rmf = new RandomAccessFile(this.path, "rw");
            rmf.seek(offset);
            rmf.write(data);
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (null != rmf) {
                rmf.close();
            }
        }
    }

    @Override
    public boolean containPath(SJcFileInterface inf) {
        boolean ret = false;
        if (inf != null) {
            File ownFile = new File(this.path);
            File otherFile = new File(inf.getPath());
            ret = ownFile.getPath().contains(otherFile.getPath());
        }
        return ret;
    }
}

