/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;

public abstract class SJctrDialogDataController
extends SJctrWizardDataController {
    private final Map<String, List<?>> dialogCache = new HashMap();
    private String dialogUnitSelect = null;

    public SJctrDialogDataController(int dispId) throws SJcException {
        super(dispId);
        this.initListener();
    }

    @Override
    public String getDispName() {
        return "";
    }

    @Override
    public void putCache(Class<?> key, List<?> list) {
        this.putCache(key.getName(), list);
    }

    @Override
    public void putCache(String key, List<?> list) {
        this.getProxy().putCache(key, list);
        this.dialogCache.put(key, list);
    }

    @Override
    protected void initUtilList() {
        this.utilList = new ArrayList();
        List<?> utilCarryList = this.getCache("KEY_CACHE_KEEP_UTIL_CLS");
        if (utilCarryList != null && utilCarryList.size() > 0) {
            this.utilList = utilCarryList;
        }
    }

    @Override
    protected void initUtilRsvDataMap() {
        this.rscUtilRsvDataMap = new HashMap();
        List<?> rsvDataList = this.getCache("KEY_CACHE_KEEP_RSV_DATA");
        if (rsvDataList != null && rsvDataList.size() > 0) {
            this.rscUtilRsvDataMap = (Map)rsvDataList.get(0);
        }
    }

    protected void doClose() {
        SJctrUserController uc = this.getOwner();
        SJctrRelatedDispDataObject related = uc.removeRelatedDispData(this.getuId());
        this.addUpdateDisp(related);
        List<SJctrDataController> relatedList = this.getRelatedDataController();
        if (relatedList != null) {
            for (SJctrDataController dc : relatedList) {
                for (SJctrRelatedDispDataObject additionalRelated : dc.getUpdataDispList()) {
                    this.addUpdateDisp(additionalRelated);
                }
                SJctrRelatedDispDataObject updateRelated = dc.getUpdateDisp();
                this.addUpdateDisp(updateRelated);
            }
        }
    }

    @Override
    protected SJctrWizardWindowDC getWizardWindow() {
        return null;
    }

    @Override
    protected void initProxy() {
        this.proxy = null;
    }

    @Override
    protected void updateFooter() {
        SJctrDataObjectModel<? extends SJctrDataObject> dataModel = this.getDataObjectModel("COM_FOOTER");
        if (dataModel instanceof SJctrFooterDataModel) {
            SJctrFooterDataModel footer = (SJctrFooterDataModel)dataModel;
            footer.setRollBackCheck(SJctrFooterDataModel.Button.OK, true);
            footer.setDirty();
        }
    }

    @Override
    protected void wizardConctruct() {
    }

    private void initListener() {
        this.addMessageEventListener(SJctrWizardDataController.WIZ_MSG.OK, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                if (!SJctrDialogDataController.this.checkEndData()) {
                    // empty if block
                }
                SJctrDialogDataController.this.dialogOkAction();
            }
        });
        this.addMessageEventListener(SJctrWizardDataController.WIZ_MSG.DLG_CANCEL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrDialogDataController.this.dialogCancelAction();
            }
        });
        this.addMessageEventListener(SJctrWizardDataController.WIZ_MSG.CLOSE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrDialogDataController.this.dialogCloseAction();
            }
        });
    }

    @Override
    public void setUnitSelect(String unitSelect) {
        this.dialogUnitSelect = unitSelect;
    }

    @Override
    public SJctrRelatedDispDataObject createWizard(Class<? extends SJctrSubWizard> subwiz, Map<String, List<?>> param) {
        super.setUnitSelect(this.dialogUnitSelect);
        return super.createWizard(subwiz, param);
    }

    @Override
    public void rollback() {
        this.saveControlDataWithDlgForWiz();
        super.rollback();
    }

    public void saveControlDataWithDlgForWiz() {
        SJctrWizardWindowDC topWizard = this.getTopWizard();
        if (topWizard == null) {
            this.getLogUty().putlog("saveControlDataWithDlgForWiz", "Not Top wizard", 10000);
            return;
        }
        int dispId = this.getDisplayId();
        if (!topWizard.isWizardDialog(dispId)) {
            this.getLogUty().putlog("saveControlDataWithDlgForWiz", "dispId: " + SJctrComUtility.toHexString(dispId), 10000);
            return;
        }
        if (!this.isConstruct()) {
            this.getLogUty().putlog("saveControlDataWithDlgForWiz", "unconstruct");
            return;
        }
        SJctrUserController uc = this.getOwner();
        if (uc == null) {
            this.getLogUty().putlog("saveControlDataWithDlgForWiz", "UserController is null.", 40000);
            return;
        }
        Map<String, Object> ctrlData = this.getRootDataModel().getControlDataWithDlgForWiz();
        HashMap<String, Object> data = uc.getControlData(dispId);
        data.putAll(ctrlData);
        this.setRestoreFlg(false);
    }

    protected void dialogOkAction() {
        this.rollback();
        List<SJctrDataController> relatedList = this.getRelatedDataController();
        if (relatedList != null) {
            for (SJctrDataController dc : relatedList) {
                dc.fireMessageEvent(SJctrWizardDataController.WIZ_MSG.SET_START, null);
                dc.fireMessageEvent(DIALOG_MSG.EXIT, this.dialogCache);
                dc.fireMessageEvent(SJctrWizardDataController.WIZ_MSG.SET_END, null);
            }
        }
        this.doClose();
    }

    protected void dialogCancelAction() {
        this.rollback();
        this.doClose();
    }

    protected void dialogCloseAction() {
        this.rollback();
        this.doClose();
    }

    public static enum DIALOG_MSG implements SJctrNotifyState
    {
        EXIT;

    }
}

