/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.replication;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.comparator.SJctrIscsiTargetPathInfoIpAddressComparator;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.com.SJctrRemoteReplicationTargetPathInfo;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetPathInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUPathInfo;

public class SJctrRemoteIPAddressColumnFromRemotePathInfo
extends SJctrColumn {
    public SJctrRemoteIPAddressColumnFromRemotePathInfo(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("IP_ADDRESS"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>(0);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJctrRemoteReplicationTargetPathInfo> retList = new ArrayList<SJctrRemoteReplicationTargetPathInfo>();
        SJmoRemoteReplicationRCUPathInfo rcuPathInfo = (SJmoRemoteReplicationRCUPathInfo)index;
        List<?> remotePathInfList = modelData.get(SJctrRemoteReplicationTargetPathInfo.class);
        if (remotePathInfList == null || remotePathInfList.isEmpty()) {
            return retList;
        }
        for (SJctrRemoteReplicationTargetPathInfo remotePathInfo : remotePathInfList) {
            if (remotePathInfo.getSPort() != rcuPathInfo.getSPort() || remotePathInfo.getRemotePortId() != rcuPathInfo.getIRCUPortNo()) continue;
            retList.add(remotePathInfo);
            break;
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJctrRemoteReplicationTargetPathInfo pathInfo;
        String ret = "?";
        if (dataList != null && dataList.size() > 0 && (pathInfo = (SJctrRemoteReplicationTargetPathInfo)dataList.get(0)) != null) {
            int portType = pathInfo.getPortType();
            if (portType == 1) {
                int ipType = pathInfo.getIIpType();
                if (ipType == 0) {
                    ret = SJctrPortUtility.toDispIPv4(pathInfo.getIIpv4Address());
                } else if (ipType == 1) {
                    ret = SJctrIscsiUtility.getIpv6AddrString(pathInfo.getIIpv6Address());
                }
            } else if (portType == 0) {
                ret = "-";
            }
        }
        return ret;
    }

    @Override
    public Comparator<HashMap<String, Object>> createComparator() {
        Comparator<HashMap<String, Object>> retComparator = new Comparator<HashMap<String, Object>>(){

            @Override
            public int compare(HashMap<String, Object> o1, HashMap<String, Object> o2) {
                SJmoIscsiTargetPathInfo info1 = SJctrRemoteIPAddressColumnFromRemotePathInfo.this.getTargetObject(o1);
                SJmoIscsiTargetPathInfo info2 = SJctrRemoteIPAddressColumnFromRemotePathInfo.this.getTargetObject(o2);
                SJctrIscsiTargetPathInfoIpAddressComparator comparator = new SJctrIscsiTargetPathInfoIpAddressComparator();
                return comparator.compare(info1, info2);
            }
        };
        return retComparator;
    }

    private SJmoIscsiTargetPathInfo getTargetObject(Map<String, Object> o) {
        String ip = (String)o.get(this.getMyFullPathKey());
        InetAddress address = null;
        try {
            address = InetAddress.getByName(ip);
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        SJmoIscsiTargetPathInfo retPathInfo = new SJmoIscsiTargetPathInfo();
        if (address instanceof Inet4Address) {
            retPathInfo.setIIpType(0);
            retPathInfo.setIIpv4Address(SJctrRemoteReplicationUtility.getIpv4Address(address));
        } else if (address instanceof Inet6Address) {
            retPathInfo.setIIpType(1);
            retPathInfo.setIIpv6Address(SJctrRemoteReplicationUtility.getIpv6Address(address));
        }
        return retPathInfo;
    }
}

