/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.uvm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrExtUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetExdPathGroupInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetExdPhysicalPathInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.exdevice.SJmoExdPathGroupInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdPhysicalPathInfo;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdPhysicalPathInfoMgr;

public class SJctrPathGrpPtTypeColumnFromExdPathGroupInfo
extends SJctrColumn {
    public SJctrPathGrpPtTypeColumnFromExdPathGroupInfo(String key) {
        super(key);
        this.setPartsId("PORT_TYPE");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortDetail.class);
        list.add(SJmoGetExdPathGroupInfoMgr.class);
        list.add(SJmoGetExdPhysicalPathInfoMgr.class);
        return list;
    }

    @Override
    public int getFilterType() {
        return 3;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        int physicalPathId;
        ArrayList<SJmoPortDetail> list = new ArrayList<SJmoPortDetail>();
        SJmoExdPathGroupInfo pathGroup = (SJmoExdPathGroupInfo)index;
        List<SJmoPortDetail> portDtlList = basicData.get(SJmoGetPortDetail.class);
        SJmoExdPhysicalPathInfoMgr physicalPathMgr = (SJmoExdPhysicalPathInfoMgr)basicData.get(SJmoGetExdPhysicalPathInfoMgr.class).get(0);
        int[] physicalPathList = pathGroup.getRmiExdPathGroupInfo().referAllPhysicalPathList();
        HashSet<Byte> portKindSet = new HashSet<Byte>(physicalPathList.length);
        for (int pathNum = 0; pathNum < physicalPathList.length && (physicalPathId = physicalPathList[pathNum]) != -1; ++pathNum) {
            SJmoExdPhysicalPathInfo physicalPathInfo = physicalPathMgr.getExdPhysicalPathInfo(physicalPathId);
            SJmoPortDetail portDtl = SJctrExtUtility.getPortDtlFromPhysicalPathInfo(physicalPathInfo, portDtlList);
            byte portKind = portDtl.getByPortKindNo();
            if (!portKindSet.add(portKind)) continue;
            list.add(portDtl);
        }
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "?";
        List<?> portDtlList = dataList;
        if (!portDtlList.isEmpty()) {
            if (portDtlList.size() == 1) {
                SJmoPortDetail portDtl = (SJmoPortDetail)portDtlList.get(0);
                ret = portDtl.getStrPortKindName();
            } else {
                SJctrComUtility comUtil = this.getTable().getComUtility();
                ret = comUtil.getGuidance("MIXED");
            }
        }
        return ret;
    }
}

