/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.alert.comdialog.alerts;

import java.util.List;
import sanproject.serverux.dataimpl.DISKgetErrorLogInfoEx;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.alert.com.SJctrAlertUtility;
import sanproject.sn2.controller.topwindow.alert.comdialog.alerts.SJctrAlertsDC;

public class SJctrAlertsSummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_NUM_ACUTE = "COM_NUM_ACUTE";
    public static final String KEY_NUM_SERIOUS = "COM_NUM_SERIOUS";
    public static final String KEY_NUM_MODERATE = "COM_NUM_MODERATE";
    public static final String KEY_NUM_SERVICE = "COM_NUM_SERVICE";
    public static final String KEY_TOTAL = "COM_TOTAL";

    @Override
    public void makeDataObject() {
        int countAcute = 0;
        int countSerious = 0;
        int countModerate = 0;
        int countService = 0;
        int countTotal = 0;
        SJctrAlertsDC dc = (SJctrAlertsDC)this.getDataController();
        SJctrAlertUtility util = dc.getOwner().getComUtility().getAlertUtility();
        List<DISKgetErrorLogInfoEx> errorInfoList = dc.getErrorInfoList();
        block6: for (DISKgetErrorLogInfoEx errorInfo : errorInfoList) {
            if (util.isCompleted(errorInfo)) continue;
            int intErrorLevel = util.getErrorLevel(errorInfo);
            switch (intErrorLevel) {
                case 2: {
                    ++countAcute;
                    continue block6;
                }
                case 3: {
                    ++countSerious;
                    continue block6;
                }
                case 4: {
                    ++countModerate;
                    continue block6;
                }
                case 5: {
                    ++countService;
                    continue block6;
                }
            }
            SJctrLogUty.warn(SJctrAlertsSummaryModel.class.getSimpleName(), "makeDataObject", "ErrorLevel : 0x" + intErrorLevel);
        }
        countTotal = countAcute + countSerious + countModerate + countService;
        SJctrLogUty.info(SJctrAlertsSummaryModel.class.getSimpleName(), "makeDataObject", "Acute : " + countAcute + ", Serious : " + countSerious + ", Moderate : " + countModerate + ", Service : " + countService + ", Total : " + countTotal);
        Object sumData = this.getManageData();
        ((SJctrDataObject)sumData).setData(KEY_NUM_ACUTE, Integer.toString(countAcute));
        ((SJctrDataObject)sumData).setData(KEY_NUM_SERIOUS, Integer.toString(countSerious));
        ((SJctrDataObject)sumData).setData(KEY_NUM_MODERATE, Integer.toString(countModerate));
        ((SJctrDataObject)sumData).setData(KEY_NUM_SERVICE, Integer.toString(countService));
        ((SJctrDataObject)sumData).setData(KEY_TOTAL, Integer.toString(countTotal));
    }
}

