/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.base;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import sanproject.serverux.data.AuditLogFileData;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrFileDownloadDataController;
import sanproject.sn2.controller.com.SJctrFileDownloadInterface;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.topwindow.base.SJctrAuditLogDownloadDC;
import sanproject.sn2.controller.topwindow.base.SJctrGetAuditLogDKC;
import sanproject.sn2.controller.topwindow.base.SJctrGetAuditLogSVP;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemStatusMgr;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.system.SJmoSubsystemStatusMgr;

public class SJctrAuditLogStatusDC
extends SJctrDialogDataController
implements SJctrFileDownloadInterface {
    public static final int DISP_ID = 34664469;
    public static final String KEY_AUDIT_ST_SVP = "COM_AUDIT_ST_SVP";
    public static final String KEY_AUDIT_ST_DKC = "COM_AUDIT_ST_DKC";
    public static final String KEY_MSG = "COM_MSG";
    public static final String KEY_DOWNLOAD_SVP = "COM_DOWNLOAD_SVP";
    public static final String KEY_DOWNLOAD_DKC = "COM_DOWNLOAD_DKC";
    public static final String KEY_FOOTER = "COM_FOOTER";
    public static final String KEY_CLOSE = "COM_CLOSE";
    public static final String GUID_DEF_NAME_SVP = "AUDIT_DEF_NAME_SVP";
    public static final String GUID_DEF_NAME_DKC = "AUDIT_DEF_NAME_DKC";
    private static final String ID_BASE = "001";
    private static final String ID_CONTROLLER = "022";
    private static final String ID_AUDIT_NORMAL = "109011";
    private static final String ID_AUDIT_WARNING = "105260";
    private static final String ID_AUDIT_WRAPAROUND = "105261";
    private static final String ID_AUDIT_UNKNOWN = "107020";
    private static final int ID_BASE_INT = 1;
    private static final int ID_CONTROLLER_INT = 22;
    private static final int ID_AUDIT_UNKNOWN_INT = 107020;
    private static final String DIRECTORY = "controller\\auditsvptmp";
    private static final String PARM_KIND_AUDITLOG = "PARM_KIND_AUDITLOG";
    private static final short KIND_SVP = 1;
    private static final short KIND_DKC = 0;
    private short kindAuditLog = 0;
    private String defaultFileName = "";
    private String defaultFileNameformatSVP = "";
    private String defaultFileNameformatDKC = "";
    private static int[] mStatusTable = new int[]{-1, 1, 6, 7};
    private static String[] mMsgTable = new String[]{"107020", "109011", "105260", "105261"};

    private void initDataModel() {
        this.addDataObjectModel(KEY_AUDIT_ST_SVP, new SJctrSimpleDataModel(){

            @Override
            protected void makeDataObject() {
                int statusSvp = -1;
                int usageSvp = -1;
                List<?> datalist = SJctrAuditLogStatusDC.this.getCache(SJmoGetSubsystemStatusMgr.class);
                if (datalist.size() == 0) {
                    this.getLogUty().putlog("getBasicData", "SJmoSubsystemStatusMgr is null");
                    SJctrError err = new SJctrError(1, 22, 107020);
                    SJcException exp = err.createException();
                    throw exp;
                }
                SJmoSubsystemStatusMgr mgr = (SJmoSubsystemStatusMgr)datalist.get(0);
                statusSvp = mgr.getSvpAuditLogStatus();
                if (statusSvp == -1) {
                    this.getLogUty().putlog("getBasicData", "getSvpAuditLogStatus : " + statusSvp);
                    SJctrError err = new SJctrError(1, 22, 107020);
                    SJcException exp = err.createException();
                    throw exp;
                }
                usageSvp = mgr.getSvpAuditLogUsage();
                if (usageSvp == -1) {
                    this.getLogUty().putlog("getBasicData", "getSvpAuditLogUsage : " + usageSvp);
                    SJctrError err = new SJctrError(1, 22, 107020);
                    SJcException exp = err.createException();
                    throw exp;
                }
                String strSvpMsgId = SJctrAuditLogStatusDC.this.getMsgId(statusSvp);
                String strSvpUsage = SJctrAuditLogStatusDC.this.usageToStinrg(usageSvp);
                Object data = this.getManageData();
                String[] msgarg = new String[]{strSvpUsage};
                SJcMessage msg = new SJcMessage(SJctrAuditLogStatusDC.ID_BASE, SJctrAuditLogStatusDC.ID_CONTROLLER, strSvpMsgId);
                msg.setMsg_argument(msgarg);
                ((SJctrDataObject)data).setData(SJctrAuditLogStatusDC.KEY_MSG, msg);
            }
        });
        this.addDataObjectModel(KEY_AUDIT_ST_DKC, new SJctrSimpleDataModel(){

            @Override
            protected void makeDataObject() {
                int statusDkc = -1;
                int usageDkc = -1;
                List<?> datalist = SJctrAuditLogStatusDC.this.getCache(SJmoGetSubsystemStatusMgr.class);
                if (datalist.size() == 0) {
                    this.getLogUty().putlog("getBasicData", "SJmoSubsystemStatusMgr is null");
                    SJctrError err = new SJctrError(1, 22, 107020);
                    SJcException exp = err.createException();
                    throw exp;
                }
                SJmoSubsystemStatusMgr mgr = (SJmoSubsystemStatusMgr)datalist.get(0);
                statusDkc = mgr.getDkcAuditLogStatus();
                if (statusDkc == -1) {
                    this.getLogUty().putlog("getBasicData", "getDkcAuditLogStatus : " + statusDkc);
                    SJctrError err = new SJctrError(1, 22, 107020);
                    SJcException exp = err.createException();
                    throw exp;
                }
                usageDkc = mgr.getDkcAuditLogUsage();
                if (usageDkc == -1) {
                    this.getLogUty().putlog("getBasicData", "getDkcAuditLogUsage : " + usageDkc);
                    SJctrError err = new SJctrError(1, 22, 107020);
                    SJcException exp = err.createException();
                    throw exp;
                }
                String strDkcMsgId = SJctrAuditLogStatusDC.this.getMsgId(statusDkc);
                String strDkcUsage = SJctrAuditLogStatusDC.this.usageToStinrg(usageDkc);
                Object data = this.getManageData();
                String[] msgarg = new String[]{strDkcUsage};
                SJcMessage msg = new SJcMessage(SJctrAuditLogStatusDC.ID_BASE, SJctrAuditLogStatusDC.ID_CONTROLLER, strDkcMsgId);
                msg.setMsg_argument(msgarg);
                ((SJctrDataObject)data).setData(SJctrAuditLogStatusDC.KEY_MSG, msg);
            }
        });
        this.addDataObjectModel(KEY_DOWNLOAD_SVP, new SJctrButtonDataModel(){

            @Override
            protected void makeDataObject() {
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrAuditLogStatusDC.this.kindAuditLog = (short)1;
                        ArrayList<Short> list = new ArrayList<Short>();
                        list.add(SJctrAuditLogStatusDC.this.kindAuditLog);
                        HashMap param = new HashMap();
                        param.put(SJctrAuditLogStatusDC.PARM_KIND_AUDITLOG, list);
                        SJctrRelatedDispDataObject relatedObj = SJctrAuditLogStatusDC.this.createFileDownload(SJctrAuditLogStatusDC.this, param);
                        SJctrAuditLogStatusDC.this.addUpdateDisp(relatedObj);
                    }
                });
            }
        });
        this.addDataObjectModel(KEY_DOWNLOAD_DKC, new SJctrButtonDataModel(){

            @Override
            protected void makeDataObject() {
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrAuditLogStatusDC.this.kindAuditLog = (short)0;
                        ArrayList<Short> list = new ArrayList<Short>();
                        list.add(SJctrAuditLogStatusDC.this.kindAuditLog);
                        HashMap param = new HashMap();
                        param.put(SJctrAuditLogStatusDC.PARM_KIND_AUDITLOG, list);
                        SJctrRelatedDispDataObject relatedObj = SJctrAuditLogStatusDC.this.createFileDownload(SJctrAuditLogStatusDC.this, param);
                        SJctrAuditLogStatusDC.this.addUpdateDisp(relatedObj);
                    }
                });
                this.setVisible(!SJctrAuditLogStatusDC.this.getOwner().getAuthorizeContainer().getSystemParamContainer().isLocalHost());
            }
        });
        this.addDataObjectModel(KEY_FOOTER, new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    String usageToStinrg(int usage) {
        String ret;
        if (usage >= 0 && usage <= 100) {
            ret = String.valueOf(usage);
        } else {
            this.getLogUty().putlog("usageToStinrg", "Invalid value of Audit Log usage:" + usage);
            ret = "?";
        }
        return ret;
    }

    private int indexOfStatus(int status) {
        int ret = Arrays.binarySearch((int[])mStatusTable, (int)status);
        if (ret < 0) {
            this.getLogUty().putlog("indexOfStatus", "Unknown status:" + status);
            ret = 0;
        }
        return ret;
    }

    String getMsgId(int status) {
        int index = this.indexOfStatus(status);
        return mMsgTable[index];
    }

    public SJctrAuditLogStatusDC() throws SJcException {
        super(34664469);
        this.initDataModel();
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.defaultFileNameformatSVP = util.getGuidance(GUID_DEF_NAME_SVP);
        this.defaultFileNameformatDKC = util.getGuidance(GUID_DEF_NAME_DKC);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetSubsystemStatusMgr kind = new SJmoGetSubsystemStatusMgr();
        SJmoGetRange_IF range = null;
        List filterList = null;
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    public SJctrRelatedDispDataObject createFileDownload(SJctrFileDownloadInterface download, Map<String, List<?>> param) {
        SJctrRelatedDispDataObject related = this.createDialog(SJctrAuditLogDownloadDC.class, param);
        SJctrFileDownloadDataController downloadDC = (SJctrFileDownloadDataController)this.getOwner().getDataController(related);
        downloadDC.setFileDownload(download);
        return related;
    }

    @Override
    public ArrayList<String> fileDownload() {
        List<?> datalist = null;
        datalist = this.kindAuditLog == 1 ? this.getModelData(SJctrGetAuditLogSVP.class) : this.getModelData(SJctrGetAuditLogDKC.class);
        if (datalist == null) {
            if (this.kindAuditLog == 1) {
                this.getLogUty().putlog("getModelData", "SJctrAuditLogSVP is null");
            } else {
                this.getLogUty().putlog("getModelData", "SJctrAuditLogDKC is null");
            }
            SJctrError err = new SJctrError(1, 22, 107020);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoThroughRmiData rmiData = (SJmoThroughRmiData)datalist.get(0);
        AuditLogFileData auditLog = (AuditLogFileData)rmiData.getObjRmi();
        String randomFileName = this.saveDownloadFile(auditLog);
        ArrayList<String> result = new ArrayList<String>();
        result.add(randomFileName);
        return result;
    }

    private String saveDownloadFile(AuditLogFileData AuditLog) {
        String fileName = UUID.randomUUID().toString();
        SJcFileUty.saveBinary(DIRECTORY, fileName, AuditLog.byBinData, 0);
        String randomFileName = SJcFileUty.saveDownloadFile(DIRECTORY, fileName);
        SJcFileUty.deleteFile(DIRECTORY, fileName);
        return randomFileName;
    }

    @Override
    public ArrayList<String> getDefaultFileNameList() {
        String defaultFileName = this.getDefaultFileName();
        ArrayList<String> result = new ArrayList<String>();
        result.add(defaultFileName);
        return result;
    }

    public String getDefaultFileName() {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMdd");
        String yyyyMMdd = sdf1.format(new Date());
        MessageFormat formName = null;
        formName = this.kindAuditLog == 1 ? new MessageFormat(this.defaultFileNameformatSVP) : new MessageFormat(this.defaultFileNameformatDKC);
        String[] ymdarg = new String[]{yyyyMMdd};
        String defaultFileName = formName.format(ymdarg);
        this.setDefaultFileName(defaultFileName);
        return defaultFileName;
    }

    public void setDefaultFileName(String defaultFileName) {
        this.defaultFileName = defaultFileName;
    }
}

