/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.base;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.List;
import sanproject.serverux.dataimpl.BASEgetDkcLockList;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrMainteRoleUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrSystemParamContainer;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrSelectableDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.topwindow.base.SJctrOperationLockStatus;
import sanproject.sn2.controller.topwindow.base.SJctrResourceLockDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemStatusMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.system.SJmoSubsystemStatusMgr;

public class SJctrResourceLockModel
extends SJctrButtonDataModel {
    public static final String KEY_ICON = "COM_ICON";
    public static final String RESOURCELOCK = "RESOURCELOCK";
    public static final String RESOURCEUNLOCK = "RESOURCEUNLOCK";
    public static final String RESOURCEUNKNOWN = "RESOURCEUNKNOWN";
    public static int RESOURCELOCK_ST_UNKNOWN = 0;
    private String labelResourceLock = "";
    private String labelResourceUnlock = "";
    private String labelResourceUnknown = "";

    public SJctrResourceLockModel() {
        this.initListener();
    }

    private void initListener() {
        this.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrResourceLockModel.this.getLogUty().putlog("selectChanged", "Resource Lock Button Pushed");
                ArrayList<Class<SJctrResourceLockDC>> list = new ArrayList<Class<SJctrResourceLockDC>>();
                list.add(SJctrResourceLockDC.class);
                SJctrResourceLockModel.this.fireMessageEvent(SJctrDataController.NOTIFY_STATE.MAKE_DIALOG_EX, list);
            }
        });
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.labelResourceLock = util.getGuidance(RESOURCELOCK);
        this.labelResourceUnlock = util.getGuidance(RESOURCEUNLOCK);
        this.labelResourceUnknown = util.getGuidance(RESOURCEUNKNOWN);
    }

    @Override
    protected void makeModelDirect() {
        SJmoGetDirect direct = new SJmoGetDirect();
        direct.setGetKind(new SJmoGetSubsystemStatusMgr());
        this.directList.add(new SJctrGetDirectWrapper(direct, false));
    }

    @Override
    protected void makeDataObject() {
        boolean authority = this.getAuthority();
        this.setVisible(authority);
        if (!authority) {
            return;
        }
        this.setLabel(this.labelResourceUnknown);
        int statusLock = RESOURCELOCK_ST_UNKNOWN;
        int idIcon = 12294;
        List<SJmoGetSubsystemStatusMgr> datalist = this.getBasicDataList(SJmoGetSubsystemStatusMgr.class);
        if (datalist.size() == 0) {
            this.getLogUty().putlog("getBasicDataList", "SJmoSubsystemStatusMgr is null");
        } else {
            SJmoSubsystemStatusMgr mgr = (SJmoSubsystemStatusMgr)((Object)datalist.get(0));
            statusLock = mgr.getDkcLockStatus();
        }
        if (statusLock == 1) {
            idIcon = 16396;
            this.setLabel(this.labelResourceUnlock);
        }
        if (statusLock == 9) {
            boolean rsgLock = this.checkRSGLock();
            if (rsgLock) {
                idIcon = 16395;
                this.setLabel(this.labelResourceLock);
            } else {
                idIcon = 16396;
                this.setLabel(this.labelResourceUnlock);
            }
        }
        if (idIcon == 12294) {
            this.getLogUty().putlog("getDkcLockStatus", "Unknown status:" + statusLock);
        }
        SJctrSelectableDataObject data = (SJctrSelectableDataObject)this.getManageData();
        data.setData(KEY_ICON, idIcon);
    }

    private boolean getAuthority() {
        boolean ret;
        block5: {
            block4: {
                ret = false;
                SJctrDataController dc = this.getDataController();
                SJctrUserController uc = dc.getOwner();
                SJctrAuthorizeContainer ac = uc.getAuthorizeContainer();
                SJcRoleResourceContainer rr = ac.getRoleResourceContainer();
                SJctrLicenseContainer lc = ac.getLisenceContainer();
                SJctrSystemParamContainer spc = ac.getSystemParamContainer();
                ret = rr.checkAuthority(32);
                boolean host = spc.isLocalHost();
                if (!host) {
                    ret = ret && lc.checkPP(SJctrLicenseContainer.PPID_SN);
                }
                SJctrMainteRoleUtility roleUtil = new SJctrMainteRoleUtility();
                roleUtil.setContainer(ac);
                int role = roleUtil.isMainteRole();
                if (role == 1) break block4;
                if (role != 2) break block5;
            }
            ret = false;
        }
        return ret;
    }

    private boolean checkRSGLock() {
        SJctrDataController dc = this.getDataController();
        SJctrUserController uc = dc.getOwner();
        List<?> rsgDetailList = dc.getModelData(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null) {
            return false;
        }
        SJmoRSGgetAllRsgs rsgData = (SJmoRSGgetAllRsgs)rsgDetailList.get(0);
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(uc, rsgData);
        List<SJmoRSGgetRsg> rsgList = rsgUtil.extractRsg();
        List<SJmoGetSubsystemStatusMgr> datalist = this.getBasicDataList(SJmoGetSubsystemStatusMgr.class);
        if (datalist.size() == 0) {
            this.getLogUty().putlog("checkRSGLock", "SJmoSubsystemStatusMgr is null");
            return true;
        }
        SJmoSubsystemStatusMgr mgr = (SJmoSubsystemStatusMgr)((Object)datalist.get(0));
        BASEgetDkcLockList svpLockInfo = null;
        BASEgetDkcLockList systemLockInfo = null;
        BASEgetDkcLockList[] dkcLockList = null;
        SanResponse responseData = mgr.getAllDkcLockList();
        if (responseData != null) {
            try {
                SanObject errorInfo = responseData.getObj("ErrorInfo");
                int errorCode = errorInfo.getInt("ErrorCode");
                if (errorCode == 0) {
                    SJctrOperationLockStatus operationLockStatus = new SJctrOperationLockStatus(responseData);
                    svpLockInfo = operationLockStatus.getSVPLockInfo();
                    systemLockInfo = operationLockStatus.getSystemLockInfo();
                    dkcLockList = operationLockStatus.getResourceLockInfo();
                } else {
                    int[] msgId = errorInfo.getIntArray("MessageId");
                    this.getLogUty().putlog("checkRSGLock", "SanResponse ErrorCode:" + errorCode + " MessageId:" + msgId[0] + "," + msgId[1]);
                }
            }
            catch (SanDataException sanEx) {
                this.getLogUty().putlog("checkRSGLock", "SanDataException msg=" + sanEx.getMessage());
            }
        }
        if (dkcLockList == null) {
            this.getLogUty().putlog("checkRSGLock", "BASEgetDkcLockList[] is null");
            return true;
        }
        if (systemLockInfo != null) {
            return true;
        }
        if (svpLockInfo != null && dkcLockList.length == 0) {
            return true;
        }
        for (SJmoRSGgetRsg rsg : rsgList) {
            int id = rsg.getRsgInfo().getRsgId();
            for (BASEgetDkcLockList dkcLock : dkcLockList) {
                if (id != dkcLock.getIResourceId()) continue;
                return true;
            }
        }
        return false;
    }
}

