/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.pool.poolvol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.pool.poolvol.SJctrPoolLdevDetail;
import sanproject.sn2.controller.topwindow.pool.poolvol.SJctrPoolVolumesDC;
import sanproject.sn2.controller.topwindow.pool.poolvol.SJctrPoolVolumesTableModel;
import sanproject.sn2.controller.wizard.uvm.editextvols.SJctrEditExtVolsSubWizard;
import sanproject.sn2.model.connector.kind.SJmoGetExDVirtualPgInfo;
import sanproject.sn2.model.connector.kind.SJmoGetExdVolumeInfoMgr;
import sanproject.sn2.model.data.exdevice.SJmoExDPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExDVirtualPgInfo;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.exdevice.manager.SJmoExdVolumeInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrPoolVolumesEventEditExternalVolumes
implements SJctrMessageEventListener {
    private SJctrPoolVolumesDC m_dataCtr = null;

    public SJctrPoolVolumesEventEditExternalVolumes(SJctrPoolVolumesDC dataCtr) {
        this.m_dataCtr = dataCtr;
    }

    @Override
    public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrPoolVolumesTableModel tableModel = (SJctrPoolVolumesTableModel)this.m_dataCtr.getDataObjectModel("COM_TABLE");
        List<Object> selectData = tableModel.getSelectedRowDataOrder();
        if (0 == selectData.size()) {
            this.m_dataCtr.getLogUty().putlog("doMessageAction", "Not selected");
        } else {
            ArrayList poolVolIdxList = new ArrayList(selectData.size());
            ArrayList<SJmoLdevDetail> ldevList = new ArrayList<SJmoLdevDetail>();
            HashSet<String> pgSet = new HashSet<String>();
            for (int iListCnt = 0; iListCnt < selectData.size(); ++iListCnt) {
                SJctrPoolLdevDetail poolldevDtl = (SJctrPoolLdevDetail)selectData.get(iListCnt);
                SJmoLdevDetail ldev = poolldevDtl.getLdevDetail();
                if (!ldev.getbExternalVolume()) {
                    SJctrError err = new SJctrError(31, 22, 106165);
                    SJcException exp = err.createException();
                    throw exp;
                }
                String fb4pg = String.valueOf(ldev.getIFB4()) + String.valueOf(ldev.getIPG());
                if (!pgSet.add(fb4pg)) continue;
                ldevList.add(ldev);
            }
            List<?> vpgInfoList = this.m_dataCtr.getModelData(SJmoGetExDVirtualPgInfo.class);
            if (vpgInfoList == null || vpgInfoList.isEmpty()) {
                SJctrError err = new SJctrError(31, 22, 107023);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoExDVirtualPgInfo vpgInfo = (SJmoExDVirtualPgInfo)vpgInfoList.get(0);
            ArrayList exdVpgList = vpgInfo.getAlVpgForExd();
            List<?> extVolInfoMgrList = this.m_dataCtr.getModelData(SJmoGetExdVolumeInfoMgr.class);
            if (extVolInfoMgrList == null || extVolInfoMgrList.isEmpty()) {
                SJctrError err = new SJctrError(31, 22, 107023);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoExdVolumeInfoMgr extVolInfoMgr = (SJmoExdVolumeInfoMgr)extVolInfoMgrList.get(0);
            ArrayList<SJmoExdVolumeInfo> exdInfoList = new ArrayList<SJmoExdVolumeInfo>();
            for (SJmoLdevDetail ldev : ldevList) {
                SJmoPgIndex pg = new SJmoPgIndex();
                pg.setFB4(ldev.getIFB4());
                pg.setPG(ldev.getIPG());
                int index = Collections.binarySearch(exdVpgList, pg);
                SJmoExDPgInfo exdPgInfo = (SJmoExDPgInfo)exdVpgList.get(index);
                SJmoExdVolumeInfo exdVolInfo = extVolInfoMgr.getExdVolumeInfoOfVpgId(exdPgInfo);
                if (exdVolInfo == null) {
                    SJctrError err = new SJctrError(31, 22, 107023);
                    SJcException exp = err.createException();
                    throw exp;
                }
                exdInfoList.add(exdVolInfo);
            }
            HashMap dataMap = new HashMap();
            dataMap.put(SJctrEditExtVolsSubWizard.EDIT_EXT_VOLS_DATA, exdInfoList);
            SJctrRelatedDispDataObject editExtVolsSubWizard = this.m_dataCtr.createWizard(SJctrEditExtVolsSubWizard.class, dataMap);
            this.m_dataCtr.addUpdateDispFromPLPVol(editExtVolsSubWizard);
        }
    }
}

