/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.port.hostgroup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLaunchDispItem;
import sanproject.sn2.controller.com.SJctrLaunchInterface;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.port.SJctrPortSummaryModel;
import sanproject.sn2.controller.topwindow.port.hostgroup.SJctrHostGroupActionMenuModel;
import sanproject.sn2.controller.topwindow.port.hostgroup.SJctrHostGroupTableModel;
import sanproject.sn2.controller.wizard.lunm.addhosts.SJctrAddHostsSubWizard;
import sanproject.sn2.controller.wizard.lunm.addiscsihosts.SJctrAddHostsIscsiSubWizard;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHGIndex;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.createaltpaths.SJctrCreateAltPathsSelectHG;
import sanproject.sn2.controller.wizard.lunm.createaltpaths.SJctrCreateAltPathsSelectIT;
import sanproject.sn2.controller.wizard.lunm.createaltpaths.SJctrCreateAltPathsSubWizard;
import sanproject.sn2.controller.wizard.lunm.delhg.SJctrDelHGSubWizard;
import sanproject.sn2.controller.wizard.lunm.editaluastate.SJctrEditAsymmetricAccessStatesSubWizard;
import sanproject.sn2.controller.wizard.lunm.edithgs.SJctrEditHGSubWizard;
import sanproject.sn2.controller.wizard.lunm.iscsi.addchapusers.SJctrAddChapUsersSubWizard;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrCreateIscsiTargetsSubWizard;
import sanproject.sn2.controller.wizard.lunm.iscsi.deleteiscsitargets.SJctrDeleteIscsiTargetsSubWizard;
import sanproject.sn2.controller.wizard.lunm.iscsi.editiscsitargets.SJctrEditIscsiTargetsSubWizard;
import sanproject.sn2.controller.wizard.lunm.iscsi.removechaptargetusers.SJctrRemoveChapTargetUsersSubWizard;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrMapLUNsSubWizard;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;

public class SJctrHostGroupDC
extends SJctrDataController
implements SJctrLaunchInterface {
    public static final int DISP_ID = 1796;
    public static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_SUMMARY = "COM_SUMMARY";
    public static final String KEY_ACTION_MENU = "COM_ACTION_MENU";
    public static final String KEY_SELECTED_ISCSI_TARGETS = "COM_SELECTED_ISCSI_TARGETS";
    private static final String STR_DISP_ID = "V7-4";
    private static final String STR_SEPARATOR = ":";
    private static final String KEY_NAME = "NAME";
    private static final String KEY_PORT = "PORT";

    private void initDataModel() {
        this.addDataObjectModel(KEY_SUMMARY, new SJctrPortSummaryModel());
        SJctrHostGroupTableModel tableModel = new SJctrHostGroupTableModel();
        this.addDataObjectModel(KEY_TABLE, tableModel);
        this.addDataObjectModel(KEY_ACTION_MENU, new SJctrHostGroupActionMenuModel());
    }

    public SJctrHostGroupDC() throws SJcException {
        super(1796);
        this.initDataModel();
        this.initListener();
    }

    private void initListener() {
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_MAP_LUNS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrHostGroupDC.this.makeMapLuns(event, dstModel);
            }
        });
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_EDITHG, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrHostGroupDC.this.makeEditHGs(event, dstModel);
            }
        });
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_ADDHOST, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrHostGroupDC.this.makeAddHosts(event, dstModel);
            }
        });
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_CREATEALTPATHS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrHostGroupDC.this.makeCreateAltPaths(event, dstModel);
            }
        });
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_DELETEHOSTGROUPS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrHostGroupDC.this.makeDeleteHG(event, dstModel);
            }
        });
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_CREATEIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrHostGroupDC.this.makeCreateITs(event, dstModel);
            }
        });
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_EDITIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrHostGroupDC.this.makeEditITs(event, dstModel);
            }
        });
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_DELETEISCSITARGETS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrHostGroupDC.this.makeDeleteIT(event, dstModel);
            }
        });
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_ADDCHAPUSER, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrHostGroupDC.this.makeAddChapUser(event, dstModel);
            }
        });
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_DELETECHAPUSER, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrHostGroupDC.this.makeRemoveTargetChapUser(event, dstModel);
            }
        });
        this.addMessageEventListener(HG_NOTIFY_STATE.MAKE_EDITASYMMETRICACCESSSTATE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrHostGroupDC.this.makeEditAsymmetricAccessState(event, dstModel);
            }
        });
    }

    private void makeMapLuns(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        this.getLogUty().putlog("makeMapLuns", "Selected row = " + selectedRowList.size());
        ArrayList<SJctrPortHGIndex> paramList = new ArrayList<SJctrPortHGIndex>(selectedRowList.size());
        ArrayList<SJmoIscsiTargetIndex> paramITList = new ArrayList<SJmoIscsiTargetIndex>(selectedRowList.size());
        Boolean fibreFlg = null;
        boolean mixedFlg = false;
        int fiberPort = 0;
        int hnasPort = 0;
        int iscsiPort = 0;
        List<?> portDetailList = table.getBasicDataMap().get(SJmoGetPortDetail.class);
        for (Object rowObj : selectedRowList) {
            SJctrPortHostGroupTableKey tableKey = (SJctrPortHostGroupTableKey)rowObj;
            if (tableKey.isFibre()) {
                SJmoHostGroupInfo hgInfo = tableKey.getHostGroupInfo();
                SJctrPortHGIndex phgIndex = new SJctrPortHGIndex();
                phgIndex.setPort(hgInfo.getSPort());
                phgIndex.setHostGroup(hgInfo.getSHostGroup());
                paramList.add(phgIndex);
                int index = Collections.binarySearch(portDetailList, tableKey.getPortHostGroupInfo());
                if (index >= 0) {
                    SJmoPortDetail portDetail = (SJmoPortDetail)portDetailList.get(index);
                    if (SJctrPortUtility.isHnasUserPort(portDetail)) {
                        hnasPort = 1;
                    } else {
                        fiberPort = 1;
                    }
                } else {
                    fiberPort = 1;
                }
            } else {
                paramITList.add(this.makeMapLunsIscsi(tableKey, selectedRowList));
                iscsiPort = 1;
            }
            if (fibreFlg == null) {
                fibreFlg = tableKey.isFibre();
                continue;
            }
            if (fibreFlg.booleanValue() == tableKey.isFibre()) continue;
            mixedFlg = true;
        }
        if (hnasPort + fiberPort + iscsiPort >= 2) {
            SJctrError err = new SJctrError(10, 22, 206519);
            SJcException exp = err.createException();
            throw exp;
        }
        HashMap param = new HashMap();
        if (mixedFlg) {
            param.put("KEY_SELECT_HG_INDEX", paramList);
            param.put("KEY_SELECT_IT_INDEX", paramITList);
        } else if (fibreFlg == null || fibreFlg.booleanValue()) {
            param.put("KEY_SELECT_HG_INDEX", paramList);
        } else {
            param.put("KEY_SELECT_IT_INDEX", paramITList);
        }
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrMapLUNsSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    private SJmoIscsiTargetIndex makeMapLunsIscsi(SJctrPortHostGroupTableKey tableKey, List<Object> selectedRowList) {
        SJmoIscsiTargetInfo itInfo = tableKey.getIscsiTargetInfo();
        SJmoIscsiTargetIndex itIndex = new SJmoIscsiTargetIndex();
        itIndex.setSPort(itInfo.getSPort());
        itIndex.setSIscsiTarget(itInfo.getSIscsiTarget());
        return itIndex;
    }

    private void makeEditHGs(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeEditHGs", "not selected");
            return;
        }
        ArrayList<Object> selectList = new ArrayList<Object>(selectedRowList.size());
        for (Object rowObj : selectedRowList) {
            if (!((SJctrPortHostGroupTableKey)rowObj).isFibre()) {
                this.getLogUty().putlog("makeEditHGs", "selected row is iSCSI");
                SJctrError err = new SJctrError(10, 22, 206517);
                SJcException exp = err.createException();
                throw exp;
            }
            selectList.add(rowObj);
        }
        HashMap param = new HashMap();
        param.put(SJctrPortHostGroupTableKey.class.getName(), selectList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrEditHGSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    private void makeCreateITs(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeEditHGs", "not selected");
            SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrCreateIscsiTargetsSubWizard.class, null);
            this.addUpdateDisp(wizardRelated);
            return;
        }
        ArrayList<SJctrPortHostGroupTableKey> paramList = new ArrayList<SJctrPortHostGroupTableKey>(selectedRowList.size());
        for (Object rowObj : selectedRowList) {
            SJctrPortHostGroupTableKey tableKey = (SJctrPortHostGroupTableKey)rowObj;
            if (tableKey.isFibre()) continue;
            paramList.add(tableKey);
        }
        HashMap param = new HashMap();
        param.put(SJctrPortHostGroupTableKey.class.getName(), paramList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrCreateIscsiTargetsSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    private void makeEditITs(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeEditHGs", "not selected");
            return;
        }
        ArrayList<SJmoIscsiTargetInfo> selectList = new ArrayList<SJmoIscsiTargetInfo>(selectedRowList.size());
        for (Object rowObj : selectedRowList) {
            SJctrPortHostGroupTableKey ptHgKey = (SJctrPortHostGroupTableKey)rowObj;
            if (ptHgKey.isFibre()) {
                this.getLogUty().putlog("makeEditHGs", "selected row is Fibre");
                SJctrError err = new SJctrError(10, 22, 206518);
                SJcException exp = err.createException();
                throw exp;
            }
            selectList.add(ptHgKey.getIscsiTargetInfo());
        }
        HashMap param = new HashMap();
        param.put("KEY_SELECTED_ISCSI_TARGETS", selectList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrEditIscsiTargetsSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    private void makeAddHosts(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeAddHosts", "not selected");
            return;
        }
        Boolean fibreFlg = null;
        ArrayList<Object> selectList = new ArrayList<Object>(selectedRowList.size());
        for (Object rowObj : selectedRowList) {
            if (fibreFlg == null) {
                fibreFlg = ((SJctrPortHostGroupTableKey)rowObj).isFibre() ? Boolean.valueOf(true) : Boolean.valueOf(false);
            } else if (fibreFlg.booleanValue() != ((SJctrPortHostGroupTableKey)rowObj).isFibre()) {
                this.getLogUty().putlog("makeAddHosts", "both Fibre and iSCSI were selected");
                SJctrError err = new SJctrError(10, 22, 206519);
                SJcException exp = err.createException();
                throw exp;
            }
            selectList.add(rowObj);
        }
        HashMap param = new HashMap();
        param.put(SJctrPortHostGroupTableKey.class.getName(), selectList);
        SJctrRelatedDispDataObject wizardRelated = fibreFlg != false ? this.createWizard(SJctrAddHostsSubWizard.class, param) : this.createWizard(SJctrAddHostsIscsiSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    private void makeCreateAltPaths(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeCreateAltPaths", "not selected");
            return;
        }
        SJctrPortHostGroupTableKey tableKey = (SJctrPortHostGroupTableKey)selectedRowList.get(0);
        if (tableKey.isFibre()) {
            SJmoPortHostGroupInfo portHostGroup = tableKey.getPortHostGroupInfo();
            SJmoHostGroupInfo hostGroup = tableKey.getHostGroupInfo();
            SJctrCreateAltPathsSelectHG selectHG = new SJctrCreateAltPathsSelectHG();
            selectHG.setSPort(portHostGroup.getSPort());
            ArrayList<SJmoHostGroupInfo> alPortHostGroup = new ArrayList<SJmoHostGroupInfo>();
            alPortHostGroup.add(hostGroup);
            selectHG.setAlPortHostGroup(alPortHostGroup);
            HashMap param = new HashMap();
            ArrayList<SJctrCreateAltPathsSelectHG> selecteList = new ArrayList<SJctrCreateAltPathsSelectHG>(1);
            selecteList.add(selectHG);
            param.put(SJctrCreateAltPathsSelectHG.class.getName(), selecteList);
            SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrCreateAltPathsSubWizard.class, param);
            this.addUpdateDisp(wizardRelated);
        } else {
            SJmoPortIscsiTargetInfo portIscsiTarget = tableKey.getPortIscsiTargetInfo();
            SJmoIscsiTargetInfo iscsiTarget = tableKey.getIscsiTargetInfo();
            SJctrCreateAltPathsSelectIT selectIT = new SJctrCreateAltPathsSelectIT();
            selectIT.setSPort(portIscsiTarget.getSPort());
            ArrayList<SJmoIscsiTargetInfo> alPortIscsiTarget = new ArrayList<SJmoIscsiTargetInfo>();
            alPortIscsiTarget.add(iscsiTarget);
            selectIT.setAlPortIscsiTarget(alPortIscsiTarget);
            HashMap param = new HashMap();
            ArrayList<SJctrCreateAltPathsSelectIT> selecteList = new ArrayList<SJctrCreateAltPathsSelectIT>(1);
            selecteList.add(selectIT);
            param.put(SJctrCreateAltPathsSelectIT.class.getName(), selecteList);
            SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrCreateAltPathsSubWizard.class, param);
            this.addUpdateDisp(wizardRelated);
        }
    }

    private void makeDeleteHG(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeDeleteHG", "not selected");
            return;
        }
        ArrayList<SJctrPortHGIndex> selecteList = new ArrayList<SJctrPortHGIndex>(selectedRowList.size());
        for (Object selectedRow : selectedRowList) {
            SJctrPortHostGroupTableKey tableKey = (SJctrPortHostGroupTableKey)selectedRow;
            if (!tableKey.isFibre()) {
                this.getLogUty().putlog("makeDeleteHG", "selected row is iSCSI");
                SJctrError err = new SJctrError(10, 22, 206517);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoPortHostGroupInfo portHostGroup = tableKey.getPortHostGroupInfo();
            SJmoHostGroupInfo hostGroup = tableKey.getHostGroupInfo();
            SJctrPortHGIndex portHGIndex = new SJctrPortHGIndex();
            portHGIndex.setPort(portHostGroup.getSPort());
            portHGIndex.setHostGroup(hostGroup.getSHostGroup());
            selecteList.add(portHGIndex);
        }
        HashMap param = new HashMap();
        param.put("SELECTDELHG", selecteList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrDelHGSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    protected void makeDeleteIT(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeDeleteITs", "not selected");
            return;
        }
        ArrayList<SJmoIscsiTargetInfo> paramList = new ArrayList<SJmoIscsiTargetInfo>(selectedRowList.size());
        for (Object rowObj : selectedRowList) {
            SJctrPortHostGroupTableKey tableKey = (SJctrPortHostGroupTableKey)rowObj;
            try {
                if (tableKey.isFibre()) {
                    this.getLogUty().putlog("makeDeleteITs", "selected row is Fibre");
                    SJctrError err = new SJctrError(10, 22, 206518);
                    SJcException exp = err.createException();
                    throw exp;
                }
                paramList.add((SJmoIscsiTargetInfo)tableKey.getIscsiTargetInfo().clone());
            }
            catch (CloneNotSupportedException e) {}
        }
        HashMap param = new HashMap();
        param.put("KEY_SELECTED_ISCSI_TARGETS", paramList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrDeleteIscsiTargetsSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    protected void makeAddChapUser(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeAddChapUsers", "not selected");
            return;
        }
        ArrayList<SJmoIscsiTargetInfo> paramList = new ArrayList<SJmoIscsiTargetInfo>(selectedRowList.size());
        for (Object rowObj : selectedRowList) {
            SJctrPortHostGroupTableKey tableKey = (SJctrPortHostGroupTableKey)rowObj;
            if (tableKey.isFibre()) {
                this.getLogUty().putlog("makeAddChapUsers", "selected row is Fibre");
                SJctrError err = new SJctrError(10, 22, 206518);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoIscsiTargetInfo itInfo = tableKey.getIscsiTargetInfo();
            paramList.add(itInfo);
        }
        HashMap param = new HashMap();
        param.put("KEY_SELECTED_ISCSI_TARGETS", paramList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrAddChapUsersSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    protected void makeRemoveTargetChapUser(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeRemoveChapUsers", "not selected");
            return;
        }
        ArrayList<SJmoIscsiTargetInfo> paramList = new ArrayList<SJmoIscsiTargetInfo>(selectedRowList.size());
        for (Object rowObj : selectedRowList) {
            SJctrPortHostGroupTableKey tableKey = (SJctrPortHostGroupTableKey)rowObj;
            if (tableKey.isFibre()) {
                this.getLogUty().putlog("makeRemoveChapUsers", "selected row is Fibre");
                SJctrError err = new SJctrError(10, 22, 206518);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoIscsiTargetInfo itInfo = tableKey.getIscsiTargetInfo();
            paramList.add(itInfo);
        }
        HashMap param = new HashMap();
        param.put("KEY_SELECTED_ISCSI_TARGETS", paramList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrRemoveChapTargetUsersSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    private void makeEditAsymmetricAccessState(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        if (selectedRowList.size() == 0) {
            this.getLogUty().putlog("makeEditAsymmetricAccessState", "not selected");
            return;
        }
        ArrayList<Object> selectList = new ArrayList<Object>(selectedRowList.size());
        for (Object rowObj : selectedRowList) {
            if (!((SJctrPortHostGroupTableKey)rowObj).isFibre()) {
                this.getLogUty().putlog("makeEditAsymmetricAccessState", "selected row is iSCSI");
                SJctrError err = new SJctrError(10, 22, 206517);
                SJcException exp = err.createException();
                throw exp;
            }
            selectList.add(rowObj);
        }
        HashMap param = new HashMap();
        param.put(SJctrPortHostGroupTableKey.class.getName(), selectList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrEditAsymmetricAccessStatesSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    @Override
    public SJctrLaunchDispItem getSelectionItem() {
        SJctrTableDataModel table = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = table.getSelectedRowData();
        int selectListSize = selectedRowList.size();
        if (selectListSize == 0) {
            SJctrLaunchDispItem dispSelItem;
            this.getLogUty().putlog("getSelectionItem", "not selected");
            SJctrLaunchDispItem sJctrLaunchDispItem = dispSelItem = new SJctrLaunchDispItem(STR_DISP_ID, 1);
            sJctrLaunchDispItem.getClass();
            SJctrLaunchDispItem.SelItem selItem = sJctrLaunchDispItem.new SJctrLaunchDispItem.SelItem("Port", null);
            SJctrLaunchDispItem.SelItem[] selItemList = new SJctrLaunchDispItem.SelItem[]{selItem};
            dispSelItem.addSelItemEx(null, null, selItemList);
            return dispSelItem;
        }
        ArrayList<String> sortlist = new ArrayList<String>();
        HashMap allItemMap = new HashMap();
        SJctrLaunchDispItem dispSelItem = new SJctrLaunchDispItem(STR_DISP_ID, selectListSize);
        List<SJmoGetPortDetail> portList = table.getBasicDataList(SJmoGetPortDetail.class);
        for (Object object : selectedRowList) {
            SJctrPortHostGroupTableKey portHG = (SJctrPortHostGroupTableKey)object;
            SJmoHostGroupInfo portHGInfo = portHG.getHostGroupInfo();
            HashMap<String, Object> itemMap = new HashMap<String, Object>();
            String hgName = SJctrComUtility.toHexString(portHGInfo.getSHostGroup(), 2, true) + STR_SEPARATOR + portHGInfo.getStrHostgroupNickName();
            itemMap.put(KEY_NAME, hgName);
            String portID = "";
            if (portList != null) {
                Object obj;
                for (SJmoPortDetail sJmoPortDetail : portList) {
                    if (sJmoPortDetail.getSPort() != portHGInfo.getSPort()) continue;
                    portID = sJmoPortDetail.getStrPortDisplayName();
                    SJctrLaunchDispItem sJctrLaunchDispItem = dispSelItem;
                    sJctrLaunchDispItem.getClass();
                    SJctrLaunchDispItem.SelItem selItem = sJctrLaunchDispItem.new SJctrLaunchDispItem.SelItem("Port", portID);
                    SJctrLaunchDispItem.SelItem[] selItemList = new SJctrLaunchDispItem.SelItem[]{selItem};
                    itemMap.put(KEY_PORT, selItemList);
                    break;
                }
                if ((obj = itemMap.get(KEY_PORT)) == null) {
                    this.getLogUty().putlog("getSelectionItem", "SJmoPortDetail not found");
                    SJctrLaunchDispItem sJctrLaunchDispItem = dispSelItem;
                    sJctrLaunchDispItem.getClass();
                    SJctrLaunchDispItem.SelItem selItem = sJctrLaunchDispItem.new SJctrLaunchDispItem.SelItem("Port", null);
                    SJctrLaunchDispItem.SelItem[] selItemList = new SJctrLaunchDispItem.SelItem[]{selItem};
                    itemMap.put(KEY_PORT, selItemList);
                }
            } else {
                this.getLogUty().putlog("getSelectionItem", "getBasicDataList(SJmoGetPortDetail.class) failed");
                SJctrLaunchDispItem sJctrLaunchDispItem = dispSelItem;
                sJctrLaunchDispItem.getClass();
                SJctrLaunchDispItem.SelItem selItem = sJctrLaunchDispItem.new SJctrLaunchDispItem.SelItem("Port", null);
                SJctrLaunchDispItem.SelItem[] selItemArray = new SJctrLaunchDispItem.SelItem[]{selItem};
                itemMap.put(KEY_PORT, selItemArray);
            }
            String sortName = portID + STR_SEPARATOR + hgName;
            sortlist.add(sortName);
            allItemMap.put(sortName, itemMap);
        }
        Collections.sort(sortlist);
        for (String string : sortlist) {
            HashMap itemMap = (HashMap)allItemMap.get(string);
            dispSelItem.addSelItemEx("Host Group", (String)itemMap.get(KEY_NAME), (SJctrLaunchDispItem.SelItem[])itemMap.get(KEY_PORT));
        }
        return dispSelItem;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetPortAttributeInfo kind = new SJmoGetPortAttributeInfo();
        SJmoGetRange_IF range = null;
        List filterList = null;
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    public static enum HG_NOTIFY_STATE implements SJctrNotifyState
    {
        MAKE_MAP_LUNS,
        MAKE_ADDHOST,
        MAKE_EDITHG,
        MAKE_DELETEHOSTGROUPS,
        MAKE_CREATEALTPATHS,
        MAKE_EDITASYMMETRICACCESSSTATE,
        MAKE_CREATEIT,
        MAKE_EDITIT,
        MAKE_DELETEISCSITARGETS,
        MAKE_ADDCHAPUSER,
        MAKE_DELETECHAPUSER;

    }
}

