/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.port.hostgroup;

import java.util.Collections;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrTabDataController;
import sanproject.sn2.controller.topwindow.port.hostgroup.host.SJctrHostGroupHostDC;
import sanproject.sn2.controller.topwindow.port.hostgroup.host.SJctrIscsiTargetHostDC;
import sanproject.sn2.controller.topwindow.port.hostgroup.hostopt.SJctrHostModeOptionDC;
import sanproject.sn2.controller.topwindow.port.hostgroup.lun.SJctrHostGroupLunDC;
import sanproject.sn2.controller.topwindow.port.hostgroup.lun.SJctrIscsiHostGroupLunDC;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;

public class SJctrHostGroupTabDC
extends SJctrTabDataController {
    public static final String TAB_HGHOST = "TAB_HGHOST";
    public static final String TAB_HGLUN = "TAB_HGLUN";
    public static final String TAB_MOSTMODEOPT = "TAB_MOSTMODEOPT";
    private static final String TAB_CHAP_USERS = "TAB_ISCSI_TARGET_CHAP_USERS";
    public static final String TAB_ITHOST = "TAB_ITHOST";
    public static final String TAB_ITLUN = "TAB_ITLUN";
    public static final String TAB_IT_MOSTMODEOPT = "TAB_IT_MOSTMODEOPT";
    private static int portId = 0;
    private static final int DISP_ID = 1050371;

    public SJctrHostGroupTabDC() throws SJcException {
        super(1050371);
    }

    @Override
    public void makeDataModel() {
        String tabLabel;
        super.makeDataModel();
        SJctrComUtility util = this.getComUtility();
        List<?> portDtlList = this.getModelData(SJmoGetPortDetail.class);
        SJmoPortIndex portIndex = new SJmoPortIndex();
        portIndex.setSPort((short)portId);
        boolean bIscsi = false;
        int seach = Collections.binarySearch(portDtlList, portIndex);
        if (seach >= 0) {
            SJmoPortDetail ptDtl = (SJmoPortDetail)portDtlList.get(seach);
            bIscsi = SJctrPortUtility.isIscsiPort(ptDtl);
        }
        if (!bIscsi) {
            tabLabel = util.getGuidance("HOSTS");
            this.addTab(TAB_HGHOST, tabLabel, SJctrHostGroupHostDC.class);
            tabLabel = util.getGuidance("LUNS");
            this.addTab(TAB_HGLUN, tabLabel, SJctrHostGroupLunDC.class);
            tabLabel = util.getGuidance("LUNM", "DISP_HMOS");
            this.addTab(TAB_MOSTMODEOPT, tabLabel, SJctrHostModeOptionDC.class);
        } else {
            tabLabel = util.getGuidance("HOSTS");
            this.addTab(TAB_ITHOST, tabLabel, SJctrIscsiTargetHostDC.class);
            tabLabel = util.getGuidance("LUNS");
            this.addTab(TAB_ITLUN, tabLabel, SJctrIscsiHostGroupLunDC.class);
            tabLabel = util.getGuidance("LUNM", "DISP_HMOS");
            this.addTab(TAB_IT_MOSTMODEOPT, tabLabel, SJctrHostModeOptionDC.class);
        }
    }

    @Override
    public void setParameter(Object ... args) {
        portId = ((Short)args[1]).shortValue();
        super.setParameter(args);
    }
}

