/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.portcondition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrIconDefine;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.topwindow.portcondition.SJctrDKCKgetPortLEDStatusInfo;
import sanproject.sn2.controller.topwindow.portcondition.SJctrPortConditionMgr;
import sanproject.sn2.model.data.device.SJmoChaDetail;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;

public class SJctrPortImageDataModel
extends SJctrSimpleDataModel {
    public static final String KEY_CHA = "COM_CHA";
    public static final String KEY_PORT_NAME = "COM_PORT_NAME";
    public static final String KEY_CONDITION = "COM_CONDITION";
    public static final String KEY_CHA_NAME = "COM_CHA_NAME";
    public static final String KEY_CHA_TYPE = "COM_CHA_TYPE";
    public static final String KEY_PORT_CONDITION = "COM_PORT_CONDITION";
    public static final String KEY_EX_CHASSIS_LIST = "COM_EX_CHASSIS_LIST";
    public static final String KEY_EX_CHASSIS_TYPE = "COM_EX_CHASSIS_TYPE";
    private static final int PORT_KIND_COPPER = 65536;
    public static final Integer EX_CHASSIS_TYPE_CHBB = 1;
    private List<SJmoPortDetail> portDetailList = null;
    private List<SJmoPortIndex> resourcePortIndexList = null;
    private List<SJctrDKCKgetPortLEDStatusInfo> portLEDInfoList = null;
    private List<String> CHANameList = null;
    private SJctrPortConditionMgr portConditionMgr = null;
    private List<SJmoChaDetail> chaDetailList = null;

    @Override
    public void makeDataModel() {
        HashMap<String, List<HashMap<String, Object>>> CHAMap = new HashMap<String, List<HashMap<String, Object>>>();
        HashMap<String, Integer> portKindMap = new HashMap<String, Integer>();
        for (SJmoPortDetail portDetail : this.portDetailList) {
            int portConditionIconId = 0;
            int resourcePortIndex = Collections.binarySearch(this.resourcePortIndexList, portDetail);
            if (resourcePortIndex >= 0) {
                int portLEDIndex = Collections.binarySearch(this.portLEDInfoList, portDetail);
                if (portLEDIndex >= 0) {
                    SJctrDKCKgetPortLEDStatusInfo portLEDInfo = this.portLEDInfoList.get(portLEDIndex);
                    portConditionIconId = SJctrPortUtility.getPortConditionlIcon(portLEDInfo);
                }
            } else {
                portConditionIconId = SJctrIconDefine.ICON_ST_NOT_AVAILABLE;
            }
            String sCHAName = this.portConditionMgr.getPortConditionInfo(portDetail).getStrPKLocation();
            String portShortName = this.portConditionMgr.getPortConditionInfo(portDetail).getStrShortPortName();
            HashMap<String, Object> portConditionMap = new HashMap<String, Object>();
            portConditionMap.put(KEY_PORT_NAME, portShortName);
            portConditionMap.put(KEY_CONDITION, portConditionIconId);
            int portKindNo = portDetail.getByPortKindNo();
            if (this.isiSCSICopper(portDetail.getSPort())) {
                portKindNo |= 0x10000;
            }
            portKindMap.put(sCHAName, portKindNo);
            List<Object> portConditionMapList = null;
            if (CHAMap.get(sCHAName) == null) {
                portConditionMapList = new ArrayList<HashMap<String, Object>>();
                portConditionMapList.add(portConditionMap);
                CHAMap.put(sCHAName, portConditionMapList);
                continue;
            }
            portConditionMapList = CHAMap.get(sCHAName);
            portConditionMapList.add(portConditionMap);
        }
        List<HashMap<String, Object>> imageDataMapList = this.makeChaInfo(CHAMap, portKindMap, this.CHANameList);
        Object imageData = this.getManageData();
        ((SJctrDataObject)imageData).setData(KEY_CHA, imageDataMapList);
        ArrayList<Integer> exChassisTypeList = new ArrayList<Integer>();
        ArrayList<ArrayList<String>> exChassisChaList = new ArrayList<ArrayList<String>>();
        boolean hasCHBB = SJctrPortUtility.hasCHBB(this.chaDetailList);
        if (hasCHBB) {
            exChassisTypeList.add(EX_CHASSIS_TYPE_CHBB);
            exChassisChaList.add(SJctrPortConditionMgr.CHBB_CHANAME_LIST);
        }
        if (exChassisChaList.size() > 0) {
            ArrayList exChassisImageList = new ArrayList();
            for (int index = 0; index < exChassisChaList.size(); ++index) {
                List exChaNameList = (List)exChassisChaList.get(index);
                int exChassisType = (Integer)exChassisTypeList.get(index);
                List<HashMap<String, Object>> chaChassisImage = this.makeChaInfo(CHAMap, portKindMap, exChaNameList);
                HashMap<String, Object> chaChassisMap = new HashMap<String, Object>();
                chaChassisMap.put(KEY_EX_CHASSIS_TYPE, exChassisType);
                chaChassisMap.put(KEY_CHA, chaChassisImage);
                exChassisImageList.add(chaChassisMap);
            }
            ((SJctrDataObject)imageData).setData(KEY_EX_CHASSIS_LIST, exChassisImageList);
        }
    }

    private List<HashMap<String, Object>> makeChaInfo(HashMap<String, List<HashMap<String, Object>>> CHAMap, HashMap<String, Integer> portKindMap, List<String> chaNameList) {
        ArrayList<HashMap<String, Object>> imageDataMapList = new ArrayList<HashMap<String, Object>>(chaNameList.size());
        for (String CHAName : chaNameList) {
            List<HashMap<String, Object>> portConditionMapList = CHAMap.get(CHAName);
            if (portConditionMapList != null) {
                HashMap<String, Object> CHADataMap = new HashMap<String, Object>();
                if (SJctrDataController.isHM()) {
                    CHADataMap.put(KEY_CHA_TYPE, portKindMap.get(CHAName));
                } else {
                    CHADataMap.put(KEY_CHA_NAME, CHAName);
                }
                Integer kind = portKindMap.get(CHAName);
                byte portKind = kind.byteValue();
                if (!SJctrPortUtility.isHnasPort(portKind)) {
                    CHADataMap.put(KEY_PORT_CONDITION, portConditionMapList);
                }
                imageDataMapList.add(CHADataMap);
                continue;
            }
            imageDataMapList.add(null);
        }
        return imageDataMapList;
    }

    public void setCreateImageData(List<SJmoPortDetail> portDetailList, List<SJmoPortIndex> resourcePortIndexList, List<SJctrDKCKgetPortLEDStatusInfo> portLEDInfoList, List<String> CHANameList, SJctrPortConditionMgr portConditionMgr, List<SJmoChaDetail> chaDetailList) {
        this.portDetailList = portDetailList;
        this.resourcePortIndexList = resourcePortIndexList;
        this.portLEDInfoList = portLEDInfoList;
        this.CHANameList = CHANameList;
        this.portConditionMgr = portConditionMgr;
        this.chaDetailList = chaDetailList;
    }

    boolean isiSCSICopper(short sPortId) {
        boolean ret = false;
        if (this.chaDetailList == null || this.chaDetailList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "isiSCSICopper", "SJmoChaDetail List is null or size 0");
            return ret;
        }
        short sCHAClusterNumber = SJctrPortUtility.getPortToCluster(sPortId);
        short sCHANumber = SJctrPortUtility.getPortToCHANumber(sPortId);
        for (SJmoChaDetail chaDetail : this.chaDetailList) {
            if (chaDetail.getSCHAClusterNumber() != sCHAClusterNumber || chaDetail.getSCHANumber() != sCHANumber) continue;
            ret = chaDetail.getByCHAPackageType() == 121;
            break;
        }
        return ret;
    }
}

