/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.replication.local.ctgs;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.replication.local.SJctrLocalReplicationSummaryActionMenuModel;
import sanproject.sn2.controller.topwindow.replication.local.SJctrLocalReplicationSummaryModel;
import sanproject.sn2.controller.topwindow.replication.local.ctgs.SJctrLocalReplicationCtgsActionMenuModel;
import sanproject.sn2.controller.topwindow.replication.local.ctgs.SJctrLocalReplicationCtgsTopTableModel;
import sanproject.sn2.controller.wizard.replication.local.releasereservectgs.SJctrReleaseReserveConsistencyGroupsSubWizard;

public class SJctrLocalReplicationCtgsDC
extends SJctrDataController {
    private static final int DISP_ID = 12804;
    public static final String KEY_SUMMARY = "COM_SUMMARY";
    public static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_ACTION_MENU = "COM_ACTION_MENU";
    public static final String KEY_ACTION_MENU2 = "COM_ACTION_MENU2";

    public SJctrLocalReplicationCtgsDC() throws SJcException {
        super(12804);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_SUMMARY, new SJctrLocalReplicationSummaryModel());
        this.addDataObjectModel(KEY_TABLE, new SJctrLocalReplicationCtgsTopTableModel());
        this.addDataObjectModel(KEY_ACTION_MENU2, new SJctrLocalReplicationSummaryActionMenuModel());
        this.addDataObjectModel(KEY_ACTION_MENU, new SJctrLocalReplicationCtgsActionMenuModel());
    }

    private void initListener() {
        this.addMessageEventListener(LREPLICA_CTGL_MSG.SELECT_RELEASE_RSV_CTGS, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrLocalReplicationCtgsDC.this.makeReleaseRsvCtgs(event, dstModel);
            }
        });
    }

    private void makeReleaseRsvCtgs(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrLocalReplicationCtgsTopTableModel ctgsTopTable = (SJctrLocalReplicationCtgsTopTableModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedCtgsList = ctgsTopTable.getSelectedRowData();
        HashMap param = new HashMap();
        if (!SJctrReplicationUtility.isCtgStatusMFReserved(selectedCtgsList)) {
            this.getLogUty().putlog("makeReleaseRsvCtgs", " Selected CTG is not reserved.");
            SJctrError err = new SJctrError(209, 22, 106145);
            SJcException exp = err.createException();
            throw exp;
        }
        Collections.sort(selectedCtgsList);
        param.put("KEY_SELECTED_CTG", selectedCtgsList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrReleaseReserveConsistencyGroupsSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    public static enum LREPLICA_CTGL_MSG implements SJctrNotifyState
    {
        SELECT_RELEASE_RSV_CTGS;

    }
}

