/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.report;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import sanproject.sn2.controller.topwindow.report.com.SJctrReportDef;

public class SJctrReportInfoData
implements Serializable,
Comparable<Object> {
    private String mId = "";
    private String mName = "";
    private String mUserId = "";
    private long mSubmitTime = 0L;
    private String mReportFullDir = "";
    private String mReportDir;
    private String mReportTgz = "";
    private String mReportHtml = "";
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMddHHmmss");

    public String toString() {
        return this.mId;
    }

    public String chgLongToDate(long lSource) {
        if (lSource == 0L) {
            return "";
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(lSource));
        String sRet = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(cal.getTime());
        return sRet;
    }

    public long chgStringToDate(String sDate) {
        long retValue = 0L;
        try {
            if (sDate.length() > 0) {
                Date date = this.dateFormatter.parse(sDate);
                retValue = date.getTime();
            }
        }
        catch (ParseException e) {
            // empty catch block
        }
        return retValue;
    }

    @Override
    public int compareTo(Object arg0) {
        SJctrReportInfoData dRpt = (SJctrReportInfoData)arg0;
        return this.mId.compareTo(dRpt.getId());
    }

    public String getId() {
        return this.mId;
    }

    public void setId(String mId) {
        this.mId = mId;
    }

    public void setId(int mId) {
        this.mId = Integer.toString(mId);
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String mName) {
        this.mName = mName;
    }

    public String getUserId() {
        return this.mUserId;
    }

    public void setUserId(String mUserId) {
        this.mUserId = mUserId;
    }

    public long getSubmitTimeToLong() {
        return this.mSubmitTime;
    }

    public String getSubmitTimeToString() {
        return this.chgLongToDate(this.mSubmitTime);
    }

    public void setSubmitTime(long mSubmitTime) {
        this.mSubmitTime = mSubmitTime;
    }

    public void setSubmitTime(String mSubmitTime) {
        this.mSubmitTime = this.chgStringToDate(mSubmitTime);
    }

    public String getReportDir() {
        return this.mReportDir;
    }

    public void setReportDir(String mReportDir) {
        this.setMReportFullDir(mReportDir);
        this.mReportDir = mReportDir.replace(SJctrReportDef.DEFAULT_REPORT_PATH, "");
    }

    public String getReportTgz() {
        if (this.mReportTgz == "") {
            this.setReportTgz("Report_" + this.getName() + ".tgz");
        }
        return this.mReportTgz;
    }

    public void setReportTgz(String mReportTgz) {
        this.mReportTgz = mReportTgz;
    }

    public String getMReportFullDir() {
        return this.mReportFullDir;
    }

    public void setMReportFullDir(String mReportFullDir) {
        this.mReportFullDir = mReportFullDir;
    }

    public String getMReportHtml() {
        if (this.mReportHtml == "") {
            this.setMReportHtml("html\\index.html");
        }
        return this.mReportHtml;
    }

    public void setMReportHtml(String mReportHtml) {
        this.mReportHtml = mReportHtml;
    }
}

