/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.edituser;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcAccountChkUty;
import sanproject.sn2.com.utility.account.SJcAccountConst;
import sanproject.sn2.com.utility.account.exception.SJcParamErrorException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrSelectableDataObject;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountDataMacro;
import sanproject.sn2.controller.wizard.account.com.SJctrTextLabelDataModel;
import sanproject.sn2.controller.wizard.account.com.SJctrUserInfoDetail;
import sanproject.sn2.controller.wizard.account.edituser.SJctrEditUserAccountDataModel;
import sanproject.sn2.controller.wizard.account.edituser.SJctrEditUserAuthServDataModel;
import sanproject.sn2.controller.wizard.account.edituser.SJctrEditUserData;
import sanproject.sn2.controller.wizard.account.edituser.SJctrEditUserPwdDataModel;
import sanproject.sn2.controller.wizard.account.edituser.SJctrEditUserReEntPwdDataModel;
import sanproject.sn2.controller.wizard.account.edituser.SJctrEditUserSelectData;
import sanproject.sn2.controller.wizard.account.edituser.SJctrEditUserUserIDDataModel;

public class SJctrEditUserDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17828161;
    private static final String COM_USER_ID = "COM_USER_ID";
    private static final String COM_CHECKBOX = "COM_CHECKBOX";
    private static final String COM_ACC = "COM_ACC";
    public static final String COM_ACTIVE = "COM_ACTIVE";
    public static final String COM_LOCKED = "COM_LOCKED";
    private static final String COM_AUTH = "COM_AUTH";
    public static final String COM_LOCAL = "COM_LOCAL";
    public static final String COM_EXTERNAL = "COM_EXTERNAL";
    private static final String COM_PW = "COM_PW";
    private static final String COM_PW_RE = "COM_PW_RE";
    private static final String COM_TITLE = "COM_TITLE";
    public static final String TITLE = "EDIT_USER";

    public SJctrEditUserDC() throws SJcException {
        super(17828161);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(TITLE);
    }

    private void initDataModel() {
        this.addDataObjectModel(COM_USER_ID, new SJctrEditUserUserIDDataModel());
        this.addDataObjectModel(COM_ACC, new SJctrEditUserAccountDataModel());
        this.addDataObjectModel(COM_AUTH, new SJctrEditUserAuthServDataModel());
        this.addDataObjectModel(COM_PW, new SJctrEditUserPwdDataModel());
        this.addDataObjectModel(COM_PW_RE, new SJctrEditUserReEntPwdDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(EDIT_USER_NOTIFY_STATE.SELECT_LOCAL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditUserDC.this.changeAuthServRadioButton(SJctrEditUserDC.COM_LOCAL);
            }
        });
        this.addMessageEventListener(EDIT_USER_NOTIFY_STATE.SELECT_EXTERNAL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditUserDC.this.changeAuthServRadioButton(SJctrEditUserDC.COM_EXTERNAL);
            }
        });
    }

    private void changeAuthServRadioButton(String ButtonKey) {
        String strLogSubTitle = "changeAuthServRadioButton";
        this.getLogUty().putlog(strLogSubTitle, "start");
        List<?> dat = this.getCache(SJctrAccountDataMacro.WIZARD_EDITUSER_SELECT_DATA);
        if (!this.checkContactData(dat)) {
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrEditUserSelectData editUserSelectData = (SJctrEditUserSelectData)dat.get(0);
        SJctrUserInfoDetail userInfoDetail = editUserSelectData.getUserInfoDetail();
        if (userInfoDetail == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.CLASS_USER_INFO_DETAIL.getSimpleName() + ") is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrEditUserPwdDataModel pwdDataModel = (SJctrEditUserPwdDataModel)this.getDataObjectModel(COM_PW);
        SJctrTextLabelDataModel pwdTitle = (SJctrTextLabelDataModel)pwdDataModel.getDataModel(COM_TITLE).getDataModel(COM_CHECKBOX);
        SJctrTextBoxDataModel pwdTextBox = (SJctrTextBoxDataModel)pwdDataModel.getDataModel(COM_PW);
        SJctrEditUserReEntPwdDataModel reEntPwdDataModel = (SJctrEditUserReEntPwdDataModel)this.getDataObjectModel(COM_PW_RE);
        SJctrTextLabelDataModel reEntPwdTitle = (SJctrTextLabelDataModel)reEntPwdDataModel.getDataModel(COM_TITLE).getDataModel(COM_CHECKBOX);
        SJctrTextBoxDataModel reEntPwdTextBox = (SJctrTextBoxDataModel)reEntPwdDataModel.getDataModel(COM_PW_RE);
        if (userInfoDetail.getAuthPtn() == SJcAccountConst.INT_AUTHPTN_EXTERNAL) {
            boolean enableFlg = false;
            if (ButtonKey.equals(COM_LOCAL)) {
                enableFlg = true;
            } else if (ButtonKey.equals(COM_EXTERNAL)) {
                pwdTextBox.setValue("");
                reEntPwdTextBox.setValue("");
                enableFlg = false;
            }
            pwdTitle.setEnable(enableFlg);
            pwdTextBox.setEnable(enableFlg);
            reEntPwdTitle.setEnable(enableFlg);
            reEntPwdTextBox.setEnable(enableFlg);
        } else if (userInfoDetail.getAuthPtn() != SJcAccountConst.INT_AUTHPTN_LOCAL) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Auth Pattern is illegal num (" + userInfoDetail.getAuthPtn() + ") is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        pwdDataModel.setDirtyAll();
        reEntPwdDataModel.setDirtyAll();
        this.getLogUty().putlog(strLogSubTitle, "end");
    }

    @Override
    public boolean checkStartData() {
        String strLogSubTitle = "checkStartData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        List<?> dat = this.getCache(SJctrAccountDataMacro.WIZARD_EDITUSER_SELECT_DATA);
        if (!this.checkContactData(dat)) {
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrEditUserSelectData editUserSelectData = (SJctrEditUserSelectData)dat.get(0);
        SJctrUserInfoDetail userInfoDetail = editUserSelectData.getUserInfoDetail();
        if (userInfoDetail == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.CLASS_USER_INFO_DETAIL.getSimpleName() + ") is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    @Override
    public boolean checkEndData() {
        String strLogSubTitle = "checkEndData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        boolean bChangeFlg = false;
        ArrayList<String> changeList = new ArrayList<String>();
        SJctrEditUserUserIDDataModel userIDDataModel = (SJctrEditUserUserIDDataModel)this.getDataObjectModel(COM_USER_ID);
        SJctrTextLabelDataModel userIDTextLabel = (SJctrTextLabelDataModel)userIDDataModel.getDataModel(COM_USER_ID);
        SJctrEditUserAccountDataModel accountDataModel = (SJctrEditUserAccountDataModel)this.getDataObjectModel(COM_ACC);
        SJctrCheckBoxDataModel accountCheckBox = (SJctrCheckBoxDataModel)accountDataModel.getDataModel(COM_TITLE).getDataModel(COM_CHECKBOX);
        SJctrRadioButtonGroupDataModel accountRadioButton = (SJctrRadioButtonGroupDataModel)accountDataModel.getDataModel(COM_ACC);
        SJctrEditUserAuthServDataModel authServDataModel = (SJctrEditUserAuthServDataModel)this.getDataObjectModel(COM_AUTH);
        SJctrCheckBoxDataModel authServCheckBox = (SJctrCheckBoxDataModel)authServDataModel.getDataModel(COM_TITLE).getDataModel(COM_CHECKBOX);
        SJctrRadioButtonGroupDataModel authServRadioButton = (SJctrRadioButtonGroupDataModel)authServDataModel.getDataModel(COM_AUTH);
        SJctrEditUserPwdDataModel pwdDataModel = (SJctrEditUserPwdDataModel)this.getDataObjectModel(COM_PW);
        SJctrTextBoxDataModel pwdTextBox = (SJctrTextBoxDataModel)pwdDataModel.getDataModel(COM_PW);
        List<?> dat = this.getCache(SJctrAccountDataMacro.WIZARD_EDITUSER_SELECT_DATA);
        if (!this.checkContactData(dat)) {
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrEditUserSelectData editUserSelectData = (SJctrEditUserSelectData)dat.get(0);
        SJctrUserInfoDetail userInfoDetail = editUserSelectData.getUserInfoDetail();
        if (userInfoDetail == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.CLASS_USER_INFO_DETAIL.getSimpleName() + ") is Empty", null, 40000);
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        String userID = ((SJctrSelectableDataObject)userIDTextLabel.getManageData()).label();
        boolean bAccount = userInfoDetail.getEnable();
        int iAuthServ = userInfoDetail.getAuthPtn();
        String password = null;
        if (iAuthServ == SJcAccountConst.INT_AUTHPTN_LOCAL) {
            password = "******";
        }
        if (accountCheckBox.isSelect()) {
            this.checkAccountRadioButton();
            changeList.add(COM_ACC);
            bAccount = accountRadioButton.isSelect(COM_ACTIVE);
            bChangeFlg = true;
        }
        if (authServCheckBox.isSelect()) {
            if (!authServRadioButton.isSelect(COM_LOCAL)) {
                this.checkAuthServRadioButton(userInfoDetail);
                iAuthServ = SJcAccountConst.INT_AUTHPTN_EXTERNAL;
                password = null;
            } else {
                if (iAuthServ != SJcAccountConst.INT_AUTHPTN_LOCAL) {
                    password = pwdTextBox.getValue().replaceAll("^[\\s\u3000]*", "").replaceAll("[\\s\u3000]*$", "");
                    this.checkAuthServRadioButton(userInfoDetail);
                }
                iAuthServ = SJcAccountConst.INT_AUTHPTN_LOCAL;
            }
            changeList.add(COM_AUTH);
            bChangeFlg = true;
        }
        if (!bChangeFlg) {
            this.getLogUty().putlog(strLogSubTitle, "[Error]Not select All CheckBox", null, 40000);
            SJctrError err = new SJctrError(2, 22, 105221);
            SJcException exception = err.createException();
            throw exception;
        }
        SJctrUserInfoDetail newUserInfoDetail = new SJctrUserInfoDetail();
        newUserInfoDetail.setUserName(userID);
        newUserInfoDetail.setEnable(bAccount);
        newUserInfoDetail.setAuthPtn(iAuthServ);
        newUserInfoDetail.setPassword(password);
        SJctrEditUserData editUserData = new SJctrEditUserData();
        editUserData.setUserInfoDetail(newUserInfoDetail);
        editUserData.setChangeList(changeList);
        if (this.checkBeforeContactData(editUserData)) {
            ArrayList<SJctrEditUserData> list = new ArrayList<SJctrEditUserData>();
            list.add(editUserData);
            this.putCache(SJctrAccountDataMacro.WIZARD_EDITUSER_DATA, list);
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    private void checkAccountRadioButton() {
        String strLogSubTitle = "checkAccountRadioButton";
        this.getLogUty().putlog(strLogSubTitle, "start");
        SJctrEditUserUserIDDataModel userIDDataModel = (SJctrEditUserUserIDDataModel)this.getDataObjectModel(COM_USER_ID);
        SJctrTextLabelDataModel userIDTextLabel = (SJctrTextLabelDataModel)userIDDataModel.getDataModel(COM_USER_ID);
        SJctrEditUserAccountDataModel accountDataModel = (SJctrEditUserAccountDataModel)this.getDataObjectModel(COM_ACC);
        SJctrRadioButtonGroupDataModel accountRadioButton = (SJctrRadioButtonGroupDataModel)accountDataModel.getDataModel(COM_ACC);
        if (!accountRadioButton.isSelect(COM_ACTIVE)) {
            if (!accountRadioButton.isSelect(COM_LOCKED)) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]Not Select Account Radio Button", null, 40000);
                SJctrError err = new SJctrError(2, 22, 105213);
                SJcException exception = err.createException();
                throw exception;
            }
            SJctrUserController uc = this.getOwner();
            String myUserID = uc.getUserSession().getUserName();
            String userID = ((SJctrSelectableDataObject)userIDTextLabel.getManageData()).label();
            if (myUserID == null || userID == null) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]userID is Empty", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            if (myUserID.equals(userID)) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]Select My User ID", null, 40000);
                SJctrError err = new SJctrError(2, 22, 106046);
                SJcException exception = err.createException();
                throw exception;
            }
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
    }

    private void checkAuthServRadioButton(SJctrUserInfoDetail userInfoDetail) {
        String strLogSubTitle = "checkAuthServRadioButton";
        this.getLogUty().putlog(strLogSubTitle, "start");
        SJctrEditUserAuthServDataModel authServDataModel = (SJctrEditUserAuthServDataModel)this.getDataObjectModel(COM_AUTH);
        SJctrRadioButtonGroupDataModel authServRadioButton = (SJctrRadioButtonGroupDataModel)authServDataModel.getDataModel(COM_AUTH);
        if (!authServRadioButton.isSelect(COM_LOCAL)) {
            if (!authServRadioButton.isSelect(COM_EXTERNAL)) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]Not Select Authentication Server Radio Button", null, 40000);
                SJctrError err = new SJctrError(2, 22, 105214);
                SJcException exception = err.createException();
                throw exception;
            }
            if (userInfoDetail.getType() == SJcAccountConst.INT_USERTYPE_BUILDIN) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]Built-in user cannot set external authentication.", null, 40000);
                SJctrError err = new SJctrError(2, 22, 106048);
                SJcException exception = err.createException();
                throw exception;
            }
        } else {
            SJctrEditUserPwdDataModel pwdDataModel = (SJctrEditUserPwdDataModel)this.getDataObjectModel(COM_PW);
            SJctrTextBoxDataModel pwdTextBox = (SJctrTextBoxDataModel)pwdDataModel.getDataModel(COM_PW);
            SJctrEditUserReEntPwdDataModel reEntPwdDataModel = (SJctrEditUserReEntPwdDataModel)this.getDataObjectModel(COM_PW_RE);
            SJctrTextBoxDataModel reEntPwdTextBox = (SJctrTextBoxDataModel)reEntPwdDataModel.getDataModel(COM_PW_RE);
            String password = pwdTextBox.getValue().replaceAll("^[\\s\u3000]*", "").replaceAll("[\\s\u3000]*$", "");
            String ReEntPwd = reEntPwdTextBox.getValue().replaceAll("^[\\s\u3000]*", "").replaceAll("[\\s\u3000]*$", "");
            try {
                SJcAccountChkUty.chkPassword(password);
            }
            catch (SJcParamErrorException e) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]illegal Password String", null, 40000);
                SJctrError err = new SJctrError(2, 22, 105215);
                SJcException exception = err.createException();
                throw exception;
            }
            if (!password.equals(ReEntPwd)) {
                this.getLogUty().putlog(strLogSubTitle, "[Error]illegal Re-enter Password String", null, 40000);
                SJctrError err = new SJctrError(2, 22, 105216);
                SJcException exception = err.createException();
                throw exception;
            }
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
    }

    public boolean checkContactData(List<?> dat) {
        String strLogSubTitle = "checkContactData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        if (dat == null || dat.isEmpty()) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data List is Empty", null, 40000);
            return false;
        }
        Object obj = dat.get(0);
        if (obj == null) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.WIZARD_EDITUSER_SELECT_DATA.getSimpleName() + ") is Empty", null, 40000);
            return false;
        }
        if (!(obj instanceof SJctrEditUserSelectData)) {
            this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data is illegal Class", null, 40000);
            return false;
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return true;
    }

    public boolean checkBeforeContactData(SJctrEditUserData editUserData) {
        String strLogSubTitle = "checkBeforeContactData";
        this.getLogUty().putlog(strLogSubTitle, "start");
        boolean bRet = true;
        List<?> confirm_dat = this.getCache(SJctrAccountDataMacro.WIZARD_EDITUSER_DATA);
        if (confirm_dat != null && !confirm_dat.isEmpty()) {
            Object confirm_dat_obj = confirm_dat.get(0);
            if (confirm_dat_obj == null) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data (" + SJctrAccountDataMacro.WIZARD_EDITUSER_DATA.getSimpleName() + ") is Empty", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            if (!(confirm_dat_obj instanceof SJctrEditUserData)) {
                this.getLogUty().putlog(strLogSubTitle, "[Logic Error]Contact Data is illegal Class", null, 40000);
                SJctrError err = new SJctrError(2, 22, 107010);
                SJcException exception = err.createException();
                throw exception;
            }
            SJctrEditUserData old_editUserData = (SJctrEditUserData)confirm_dat_obj;
            if (editUserData.compareTo(old_editUserData) != 0) {
                this.getLogUty().putlog(strLogSubTitle, "Contact Data has been changed.");
            } else {
                this.getLogUty().putlog(strLogSubTitle, "Contact Data has not been changed.");
                bRet = false;
            }
        } else {
            this.getLogUty().putlog(strLogSubTitle, "Not Found Contact Data.");
        }
        if (bRet) {
            ArrayList<SJctrEditUserData> list = new ArrayList<SJctrEditUserData>();
            list.add(editUserData);
            this.putCache(SJctrAccountDataMacro.WIZARD_EDITUSER_DATA, list);
        }
        this.getLogUty().putlog(strLogSubTitle, "end");
        return bRet;
    }

    public static enum EDIT_USER_NOTIFY_STATE implements SJctrNotifyState
    {
        SELECT_LOCAL,
        SELECT_EXTERNAL;

    }
}

