/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.removeusers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcUserInfoUty;
import sanproject.sn2.controller.com.SJctrAuditLogData;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDefaultAuditLogData;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.SJctrUserGrpInfoDetailUtility;
import sanproject.sn2.controller.com.SJctrUserInfoDetailUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.account.com.SJctrAccAdtLogData;
import sanproject.sn2.controller.wizard.account.com.SJctrAccAdtLogUty;
import sanproject.sn2.controller.wizard.account.com.SJctrAccountDataMacro;
import sanproject.sn2.controller.wizard.account.com.SJctrUserGrpInfoDetail;
import sanproject.sn2.controller.wizard.account.com.SJctrUserInfoDetail;
import sanproject.sn2.controller.wizard.account.removeusers.SJctrRemoveUsersAC;
import sanproject.sn2.controller.wizard.account.removeusers.SJctrRemoveUsersSelectData;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;

public class SJctrRemoveUsersSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "REMOVE_USERS";
    private static final Class<?> CONFIRM_DC = SJctrAccountDataMacro.WIZARD_REMOVEUSERS_CONFIRM_DC;

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        SJctrRelatedDispDataObject related;
        String strLogTitle = this.getClass().getSimpleName();
        String strLogSubTitle = "constructConfirmData";
        SJctrLogUty logUty = wizard.getLogUty();
        logUty.setTitle(strLogTitle);
        Class[] paramClass = new Class[]{String[].class, String.class};
        logUty.putlog(strLogSubTitle, "start");
        SJctrUserController uc = wizard.getOwner();
        if (uc == null) {
            String strLog = "[Logic Error]user controller is null";
            this.putDetailLogthrowExcep(logUty, strLogSubTitle, strLog, 107010);
        }
        if ((related = uc.getRelatedDispData(CONFIRM_DC)) == null) {
            String strLog = "[Logic Error]SJctrRelatedDispDataObject is null";
            this.putDetailLogthrowExcep(logUty, strLogSubTitle, strLog, 107010);
        }
        SJctrRemoveUsersAC ac = new SJctrRemoveUsersAC();
        SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(wizard.getClass());
        SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
        if (dc == null) {
            String strLog = "[Logic Error]data controller is null";
            this.putDetailLogthrowExcep(logUty, strLogSubTitle, strLog, 107010);
        }
        List<?> param = dc.getProxy().getCache(SJctrAccountDataMacro.WIZARD_REMOVEUSERS_SELECT_DATA);
        this.checkParam(param, logUty, strLogSubTitle);
        Object obj = param.get(0);
        this.checkObj(obj, logUty, strLogSubTitle);
        SJctrRemoveUsersSelectData removeUsersSelectData = (SJctrRemoveUsersSelectData)obj;
        List<SJctrUserInfoDetail> userInfoDetailList = removeUsersSelectData.getUserInfoDetailList();
        List<SJctrUserGrpInfoDetail> userGrpInfoDetailList = removeUsersSelectData.getUserGrpInfoDetailList();
        this.checkUserUserGrpInfoDetail(logUty, userInfoDetailList, userGrpInfoDetailList, strLogSubTitle);
        int userNum = userInfoDetailList.size();
        String[] userIDs = new String[userNum];
        for (int i = 0; i < userNum; ++i) {
            String str = new String();
            str = userInfoDetailList.get(i).getUserName();
            if (str == null) {
                String strLog = "[Logic Error]user id is null.";
                this.putDetailLogthrowExcep(logUty, strLogSubTitle, strLog, 107012);
            }
            userIDs[i] = str;
        }
        String userGrpName = userGrpInfoDetailList.get(0).getGroupName();
        if (userGrpName == null) {
            String strLog = "[Logic Error]user group name is null.";
            this.putDetailLogthrowExcep(logUty, strLogSubTitle, strLog, 107011);
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        Object[] params = null;
        paramList.add(userIDs);
        paramList.add(userGrpName);
        params = paramList.toArray(new Object[0]);
        if (params == null) {
            String strLog = "[Logic Error]paramters are null.";
            this.putDetailLogthrowExcep(logUty, strLogSubTitle, strLog, 107010);
        }
        Class<SJcUserInfoUty> cls = SJcUserInfoUty.class;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KEY_METHOD_NAME", "removeUserGroup");
        map.put("KEY_PARAM_CLASS", paramClass);
        map.put("KEY_OBJECT", cls);
        map.put("KEY_PARAM", params);
        ArrayList<Map<String, Object>> applyData = new ArrayList<Map<String, Object>>();
        applyData.add(map);
        ac.setApplyList(applyData);
        SJctrAccAdtLogData adtLogData = this.makeAdtLogData(logUty, (SJbaseUserSession)wizard.getOwner().getUserSession(), wizard.getOwner().getComUtility(), removeUsersSelectData);
        ac.setAdtLogData(adtLogData);
        wizard.addConfirmData(ac, related);
        logUty.putlog(strLogSubTitle, "end");
    }

    private void checkParam(List<?> param, SJctrLogUty logUty, String strLogST) {
        if (logUty != null) {
            if (param == null) {
                String strLog = "[Logic Error]Contact Data List is Empty";
                this.putDetailLogthrowExcep(logUty, strLogST, strLog, 107010);
            } else if (param.isEmpty()) {
                String strLog = "[Logic Error]Contact Data List is Empty";
                this.putDetailLogthrowExcep(logUty, strLogST, strLog, 107010);
            }
        }
    }

    private void checkObj(Object obj, SJctrLogUty logUty, String strLogST) {
        if (logUty != null) {
            if (obj == null) {
                String strLog = "[Logic Error]Contact Data (" + SJctrAccountDataMacro.WIZARD_REMOVEUSERS_SELECT_DATA.getSimpleName() + ") is Empty";
                this.putDetailLogthrowExcep(logUty, strLogST, strLog, 107010);
            } else if (!(obj instanceof SJctrRemoveUsersSelectData)) {
                String strLog = "[Logic Error]Contact Data is illegal Class";
                this.putDetailLogthrowExcep(logUty, strLogST, strLog, 107010);
            }
        }
    }

    private void checkUserUserGrpInfoDetail(SJctrLogUty logUty, List<SJctrUserInfoDetail> u, List<SJctrUserGrpInfoDetail> ug, String strLogST) {
        if (logUty != null) {
            String strLog;
            String strLog2;
            if (u == null) {
                ArrayList uidl = new ArrayList();
                strLog2 = null;
                strLog2 = "[Logic Error]Contact Data (" + uidl.getClass().getSimpleName() + ") is Empty";
                this.putDetailLogthrowExcep(logUty, strLogST, strLog2, 107010);
            } else if (u.isEmpty()) {
                strLog = null;
                strLog = "[Logic Error]Contact Data (" + u.getClass().getSimpleName() + ") is Empty";
                this.putDetailLogthrowExcep(logUty, strLogST, strLog, 107010);
            }
            if (ug == null) {
                ArrayList ugidl = new ArrayList();
                strLog2 = null;
                strLog2 = "[Logic Error]Contact Data (" + ugidl.getClass().getSimpleName() + ") is Empty";
                this.putDetailLogthrowExcep(logUty, strLogST, strLog2, 107010);
            } else if (ug.isEmpty()) {
                strLog = null;
                strLog = "[Logic Error]Contact Data (" + ug.getClass().getSimpleName() + ") is Empty";
                this.putDetailLogthrowExcep(logUty, strLogST, strLog, 107010);
            }
        }
    }

    private void putDetailLogthrowExcep(SJctrLogUty logUty, String subtitle, String log, int errorCode) {
        if (logUty != null) {
            logUty.putlog(subtitle, log, null, 40000);
            SJctrError err = new SJctrError(2, 22, errorCode);
            SJcException exception = err.createException();
            throw exception;
        }
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{};
        return clsList;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", TITLE);
    }

    private SJctrAccAdtLogData makeAdtLogData(SJctrLogUty logUty, SJbaseUserSession userSession, SJctrComUtility comUty, SJctrRemoveUsersSelectData removeUsersSelectData) {
        String strLogSubTitle = "makeAdtLogData";
        SJctrAccAdtLogData adtLogData = new SJctrAccAdtLogData();
        try {
            adtLogData = SJctrAccAdtLogUty.makeAccAdtLogData(logUty, userSession, comUty.getGuidance("ACCOUNT", "ADT_REMOVE_USERS"));
            adtLogData.setDetailList(this.makeAdtDetailList(comUty, removeUsersSelectData));
            if (!adtLogData.getDetailList().isEmpty()) {
                adtLogData.setStrFooter(comUty.getGuidance("ACCOUNT", "ADT_USER_NUM"));
            }
            adtLogData.setStrNormalEnd(comUty.getGuidance("ADT_NORMAL_END"));
            adtLogData.setStrError(comUty.getGuidance("ADT_ERROR"));
        }
        catch (Exception e) {
            if (logUty != null) {
                logUty.putlog(strLogSubTitle, "[Logic Error]makeAdtLogData() is failed.", e, 40000);
            }
            SJctrError err = new SJctrError(2, 22, 107010);
            SJcException exception = err.createException();
            throw exception;
        }
        return adtLogData;
    }

    private List<SJctrAuditLogData> makeAdtDetailList(SJctrComUtility util, SJctrRemoveUsersSelectData removeUsersSelectData) {
        ArrayList<SJctrAuditLogData> detailList = new ArrayList<SJctrAuditLogData>();
        SJctrUserInfoDetailUtility userInfoDetailUty = util.getUserInfoDetailUtility();
        SJctrUserGrpInfoDetailUtility userGrpInfoDetailUty = util.getUserGrpInfoDetailUtility();
        ArrayList<String> partsIDList = new ArrayList<String>();
        partsIDList.add("ADT_USER_ID");
        partsIDList.add("ADT_GRP_NAME");
        partsIDList.add("ADT_RESULT");
        List<SJctrUserInfoDetail> userInfoDetailList = removeUsersSelectData.getUserInfoDetailList();
        List<SJctrUserGrpInfoDetail> userGrpInfoDetailList = removeUsersSelectData.getUserGrpInfoDetailList();
        for (int i = 0; i < removeUsersSelectData.getUserInfoDetailList().size(); ++i) {
            SJctrDefaultAuditLogData adtData = new SJctrDefaultAuditLogData();
            adtData.setKeys(partsIDList);
            adtData.setScrID(new ArrayList<String>(0));
            adtData.setTitle("ADT_USER_ID", util.getGuidance("ACCOUNT", "ADT_USER_ID"));
            adtData.setValue("ADT_USER_ID", userInfoDetailUty.toUserIDDisplay(userInfoDetailList.get(i)));
            adtData.setTitle("ADT_GRP_NAME", util.getGuidance("ACCOUNT", "ADT_GRP_NAME"));
            adtData.setValue("ADT_GRP_NAME", userGrpInfoDetailUty.toUserGrpNameDisplay(userGrpInfoDetailList.get(0)));
            adtData.setTitle("ADT_RESULT", util.getGuidance("ADT_RESULT"));
            adtData.setValue("ADT_RESULT", util.getGuidance("ADT_NORMAL_END"));
            detailList.add(adtData);
        }
        return detailList;
    }
}

