/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.account.rsg.deletersgs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.account.com.SJctrUserGrpInfoDetail;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgInfo;
import sanproject.sn2.controller.wizard.account.rsg.deletersgs.SJctrDeleteRsgsAC;
import sanproject.sn2.controller.wizard.account.rsg.deletersgs.SJctrDeleteRsgsConfirmDC;
import sanproject.sn2.controller.wizard.account.rsg.deletersgs.SJctrDeleteRsgsConfirmData;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;

public class SJctrDeleteRsgsSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "DELETE_RES_GRPS";
    private static final Class<?> CONFIRM_DC = SJctrDeleteRsgsConfirmDC.class;

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetRSGgetAllRsgs kind = new SJmoGetRSGgetAllRsgs();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        try {
            SJctrUserController uc = wizard.getOwner();
            SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
            SJctrDeleteRsgsAC ac = new SJctrDeleteRsgsAC();
            SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
            SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
            List<Object> deleteInfo = new ArrayList();
            deleteInfo = dc.getProxy().getCache(SJctrRsgInfo.class.getName());
            SJctrDeleteRsgsConfirmData confirmData = new SJctrDeleteRsgsConfirmData();
            if (null == deleteInfo) {
                uc.getLogUty().putlog("constructConfirmData", "Information of SJctrRsgInfo is null.");
                SJctrError err = new SJctrError(207, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            if (deleteInfo.size() == 0) {
                uc.getLogUty().putlog("constructConfirmData", "Size of SJctrRsgInfo data list is zero.");
                SJctrError err = new SJctrError(207, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            ArrayList rsgInfoList = (ArrayList)SJctrRsgUtility.getRsgListInfo(dc);
            HashSet<Integer> assignRsgIds = new HashSet<Integer>();
            Map<String, SJctrUserGrpInfoDetail> usrGroupList = SJctrRsgUtility.getUserGroupsInfo(dc.getLogUty());
            if (null == usrGroupList) {
                SJctrError err = new SJctrError(207, 22, 107002);
                SJcException exp = err.createException();
                throw exp;
            }
            Collection<SJctrUserGrpInfoDetail> usrGroupCol = usrGroupList.values();
            for (SJctrUserGrpInfoDetail usrGroupInfo : usrGroupCol) {
                int[] nArray;
                for (int rsgId : nArray = usrGroupInfo.getRsrcGroupID()) {
                    assignRsgIds.add(rsgId);
                }
            }
            boolean checkVdkcResult = SJctrRsgUtility.isIncludeDifferentVdkc(deleteInfo);
            if (checkVdkcResult) {
                uc.getLogUty().putlog("constructConfirmData", "selected RSGs are join different VDKCs.");
                SJctrError err = new SJctrError(207, 22, 205067);
                SJcException sJcException = err.createException();
                throw sJcException;
            }
            for (SJctrRsgInfo sJctrRsgInfo : deleteInfo) {
                SJmoRSGgetRsg targetRsgInfo = SJctrRsgUtility.getRsgInfoByRsgId(sJctrRsgInfo.getRsgInfo().getRsgInfo().getRsgId(), rsgInfoList);
                if (null == targetRsgInfo) {
                    uc.getLogUty().putlog("constructConfirmData", "The resource group to delete does not exist.");
                    SJctrError err = new SJctrError(207, 22, 105303);
                    SJcException exp = err.createException();
                    throw exp;
                }
                if (SJctrRsgUtility.isExistResource(targetRsgInfo)) {
                    uc.getLogUty().putlog("constructConfirmData", "A resource exists in the resource group for deletion.");
                    SJctrError err = new SJctrError(207, 22, 105290);
                    SJcException exp = err.createException();
                    throw exp;
                }
                if (!assignRsgIds.contains(sJctrRsgInfo.getRsgInfo().getRsgInfo().getRsgId())) continue;
                uc.getLogUty().putlog("constructConfirmData", "The resource group assigned the user group cannot be deleted.");
                SJctrError err = new SJctrError(207, 22, 105311);
                SJcException exp = err.createException();
                throw exp;
            }
            confirmData.setDeleteRsgsInfo(deleteInfo);
            String gsid = uc.getUserSession().getSessionID();
            confirmData.setGlobalSessionID(gsid);
            ArrayList<SJctrDeleteRsgsConfirmData> arrayList = new ArrayList<SJctrDeleteRsgsConfirmData>();
            arrayList.add(confirmData);
            dc.getProxy().putCache(SJctrDeleteRsgsConfirmData.class, arrayList);
            ac.setApplyData(confirmData);
            wizard.addConfirmData(ac, related);
        }
        catch (SJcException e) {
            throw SJctrRsgUtility.convRsgLogicalErr(e, 107002);
        }
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", TITLE);
    }

    @Override
    public Class<?>[] getClassList() {
        return new Class[0];
    }
}

