/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.cvs.com;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import edu.emory.mathcs.backport.java.util.Collections;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrTiReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.topwindow.base.authorize.SJctrAuthorizeSVP;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSMacro;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVErrorInfo;
import sanproject.sn2.controller.wizard.cvs.com.SJctrUnbindLdevInfo;
import sanproject.sn2.controller.wizard.cvs.createldevs.hdp.com.SJctrPoolDetail;
import sanproject.sn2.controller.wizard.cvs.unbindslus.SJctrGetThroughRmiDataAluBindSlu;
import sanproject.sn2.controller.wizard.cvs.unbindslus.SJctrGetThroughRmiDataAluId;
import sanproject.sn2.controller.wizard.vvol.com.data.SJctrHDPLDEVDetail;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetMacroMgr;
import sanproject.sn2.model.connector.kind.SJmoGetPoolTieringPolicy;
import sanproject.sn2.model.connector.kind.SJmoGetThroughRmiData;
import sanproject.sn2.model.data.SJmoMacroMgr;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolNameInfo;
import sanproject.sn2.model.data.group.SJmoPoolTieringPolicy;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.system.SJmoSubsystemStatusMgr;
import sanproject.sn2.model.data.volume.SJmoCuLdevIdInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIdInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.data.volume.SJmoSsidDetail;
import sanproject.sn2.model.data.volume.SJmoSsidSummary;
import sanproject.sn2.modelrc.util.SJmoRscUtilLdev;
import sanproject.sn2.modelrc.util.SJmoRscUtilSsid;

public class SJctrCVSUtility
implements SJctrCVSMacro {
    private static final String className = "SJctrCVSUtility";
    public static final int CVS_GETMACRO_INDEX = 0;
    private static final int UNINITIALIZED = -1;
    private static final Object MACRO_LOCK = new Object();
    private static int MAX_CU = -1;
    private static int MAX_QF_PG = -1;
    private static int MAX_CU_DEFAULT = 254;
    private static int MAX_QF_PG_DEFAULT = 72;
    public static final String MACROKEY_CU_MAX_DKC = "MAX_CU_PER_SYSTEM";
    public static final String MACROKEY_MAX_QF_PG = "MAX_QUICKFORMAT_PG";
    public static final int MAX_FPT = 1;
    private static String[] macroKeyList = new String[]{"MAX_CU_PER_SYSTEM", "MAX_QUICKFORMAT_PG"};

    private SJctrCVSUtility() {
    }

    private static void macroChange(SJmoMacroMgr macroMgr, String macroKey) {
        Long v;
        if (macroKey.equals(MACROKEY_CU_MAX_DKC)) {
            v = (Long)macroMgr.getMacroObj(MACROKEY_CU_MAX_DKC);
            MAX_CU = v.intValue() - 1;
        }
        if (macroKey.equals(MACROKEY_MAX_QF_PG)) {
            v = (Long)macroMgr.getMacroObj(MACROKEY_MAX_QF_PG);
            MAX_QF_PG = v.intValue();
        }
    }

    private static SJmoMacroMgr getMacroInf() {
        ArrayList<SJmoGetDirect> alGetInf = new ArrayList<SJmoGetDirect>();
        SJmoGetDirect getDir = new SJmoGetDirect(new SJmoGetMacroMgr(), null, null);
        alGetInf.add(getDir);
        List retList = SJmoModelMgr.getModelMgr().getDataAgent().getDataInf(alGetInf);
        ArrayList alNestList = (ArrayList)retList.get(0);
        return (SJmoMacroMgr)alNestList.get(0);
    }

    private static void macroAllChange() {
        SJmoMacroMgr macroMgr = SJctrCVSUtility.getMacroInf();
        for (int iCnt = 0; iCnt < macroKeyList.length; ++iCnt) {
            try {
                SJctrCVSUtility.macroChange(macroMgr, macroKeyList[iCnt]);
                continue;
            }
            catch (Exception e) {
                SJctrLogUty.info(className, "macroAllChange", "Key = " + macroKeyList[iCnt], e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getMaxCu() {
        Object object = MACRO_LOCK;
        synchronized (object) {
            if (MAX_CU == -1) {
                SJctrCVSUtility.macroAllChange();
            }
            if (MAX_CU == -1) {
                MAX_CU = MAX_CU_DEFAULT;
            }
        }
        return MAX_CU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMaxQuickFormatPG() {
        Object object = MACRO_LOCK;
        synchronized (object) {
            if (MAX_QF_PG == -1) {
                SJctrCVSUtility.macroAllChange();
            }
            if (MAX_QF_PG == -1) {
                MAX_QF_PG = MAX_QF_PG_DEFAULT;
            }
        }
        return MAX_QF_PG;
    }

    public static void deleteLdevID(SJmoLdevIndex ldevIndex, List<SJmoCuLdevIdInfo> cuLdevIdInfoList) {
        SJmoCuLdevIdInfo cuLdevIdInfo = cuLdevIdInfoList.get(ldevIndex.getSCu());
        SJmoLdevIdInfo[] ldevIdInfo = cuLdevIdInfo.getLDEVIDInfo();
        SJmoLdevIdInfo targetLdevIdInfo = ldevIdInfo[ldevIndex.getSLdev()];
        int[] iBoundary = SJctrCVSUtility.getLDEVBoundary(ldevIndex.getSLdev());
        boolean bFlag = false;
        for (int i = iBoundary[0]; i <= iBoundary[1]; ++i) {
            SJmoLdevIdInfo checkLdevIdInfo = ldevIdInfo[i];
            if (i == ldevIndex.getSLdev() || checkLdevIdInfo.getLDEVID() != 0) continue;
            bFlag = true;
            break;
        }
        if (bFlag) {
            targetLdevIdInfo.setLDEVID((byte)2);
        } else {
            targetLdevIdInfo.setLDEVID((byte)1);
            for (int j = iBoundary[0]; j <= iBoundary[1]; ++j) {
                SJmoLdevIdInfo boundaryLdevIdInfo = ldevIdInfo[j];
                if (boundaryLdevIdInfo.getEmulationGroup() == -1) continue;
                boundaryLdevIdInfo.setLDEVID((byte)1);
                boundaryLdevIdInfo.setEmulationGroup((byte)0);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static SJmoLdevIndex getFreeLDEV(short sLdkc, short sCu, short sLdev, int iEmuGroup, List<SJmoCuLdevIdInfo> cuLdevIdInfoList, int iEmuType, SJmoRscUtilLdev ldevUty, SJctrResourceGroupUtility rsgUty, int iTseAttri, SJctrComCVSUtility cvsUty, List<SJmoHUVMVirtualLdev> vldevList) {
        SJmoLdevIndex moCreateLdevIndex;
        block7: {
            boolean bRet = false;
            int iEnd = 255;
            moCreateLdevIndex = SJctrCVSUtility.createLdevIndex(-1, -1, -1);
            Iterator<SJmoCuLdevIdInfo> i$ = cuLdevIdInfoList.iterator();
            while (i$.hasNext()) {
                block6: {
                    block8: {
                        SJmoCuLdevIdInfo moCuLdevIdInfoList = i$.next();
                        if (moCuLdevIdInfoList.getSCu() != sCu) continue;
                        SJmoLdevIdInfo[] moLdevIdInfo = moCuLdevIdInfoList.getLDEVIDInfo();
                        int iLDEV = SJctrCVSUtility.checkFreeLDEV(sLdev, iEnd, iEmuGroup, moLdevIdInfo, iEmuType, ldevUty, rsgUty, cvsUty, vldevList);
                        if (iLDEV == -1) break block8;
                        if (iTseAttri == 1 && sCu % 2 == 0) {
                            sCu = (short)(sCu + 1);
                            sLdev = 0;
                            break block6;
                        } else if (iTseAttri == 2 && sCu % 2 > 0) {
                            sCu = (short)(sCu + 1);
                            sLdev = 0;
                            break block6;
                        } else {
                            moCreateLdevIndex.setLdevIndex(sLdkc, sCu, (short)iLDEV);
                            return moCreateLdevIndex;
                        }
                    }
                    sCu = (short)(sCu + 1);
                    sLdev = 0;
                }
                if (sCu <= SJctrCVSUtility.getMaxCu()) {
                    continue;
                }
                break block7;
            }
            return moCreateLdevIndex;
        }
        SJctrLogUty.warn(className, "getFreeLDEV", "FreeLDEV not found");
        return moCreateLdevIndex;
    }

    public static int checkFreeLDEV(short sLdev, int iEnd, int iEmuGroup, SJmoLdevIdInfo[] moLdevIdInfo, int iEmuType, SJmoRscUtilLdev ldevUty, SJctrResourceGroupUtility rsgUty, SJctrComCVSUtility cvsUty, List<SJmoHUVMVirtualLdev> vldevList) {
        int rtn = -1;
        for (int i = sLdev; i <= iEnd; ++i) {
            int iChk;
            SJmoLdevIdInfo moCheckLdevIdInfo = moLdevIdInfo[i];
            if (moCheckLdevIdInfo.getEmulationGroup() != (byte)iEmuGroup && moCheckLdevIdInfo.getEmulationGroup() != 0 && moCheckLdevIdInfo.getEmulationGroup() != -1 || moCheckLdevIdInfo.getLDEVID() != 2 && moCheckLdevIdInfo.getLDEVID() != 1 || (iChk = ldevUty.chkLdevID(moCheckLdevIdInfo.getSLdkc(), moCheckLdevIdInfo.getSCu(), (short)i, iEmuGroup)) != 0 || !SJctrCVSUtility.chkLdevIDRSG(moCheckLdevIdInfo, rsgUty, iEmuType, cvsUty, vldevList)) continue;
            rtn = i;
            break;
        }
        if (rtn == -1) {
            SJctrLogUty.warn(className, "checkFreeLDEV", "FreeLDEV not found");
        }
        return rtn;
    }

    public static boolean chkLdevIDRSG(SJmoLdevIdInfo ldevId, SJctrResourceGroupUtility rsgUty, int iEmu, SJctrComCVSUtility cvsUty, List<SJmoHUVMVirtualLdev> vldevList) {
        int vldevIndex;
        boolean rtn = false;
        if (rsgUty == null) {
            rtn = true;
            return rtn;
        }
        List<SJmoRSGgetRsg> rsgList = rsgUty.extractRsg();
        for (int i = 0; i < rsgList.size(); ++i) {
            SJmoRSGgetRsg rsg = rsgList.get(i);
            ArrayList<SJmoLdevIndex> ldevList = rsg.getLdevs();
            int ldevIdIndex = Collections.binarySearch(ldevList, (Object)ldevId);
            if (ldevIdIndex < 0) continue;
            rtn = true;
            break;
        }
        if (vldevList != null && rtn && cvsUty.isMainframe(cvsUty.getEmulationTypeName(iEmu)) && (vldevIndex = Collections.binarySearch(vldevList, (Object)ldevId)) >= 0 && (vldevList.get(vldevIndex).getSVAttrHuvm() & Short.MIN_VALUE) != 0) {
            rtn = false;
        }
        return rtn;
    }

    public static void createLDEVID(short sLdkc, short sCu, short sLdev, int iEmuId, List<SJmoCuLdevIdInfo> cuLdevIdInfoList) {
        SJmoCuLdevIdInfo cuLdevIdInfo = cuLdevIdInfoList.get(sCu);
        SJmoLdevIdInfo[] ldevIdInfo = cuLdevIdInfo.getLDEVIDInfo();
        SJmoLdevIdInfo targetLdevIdInfo = ldevIdInfo[sLdev];
        if (targetLdevIdInfo.getEmulationGroup() == 0 || targetLdevIdInfo.getEmulationGroup() == -1) {
            int[] iBoundary = SJctrCVSUtility.getLDEVBoundary(sLdev);
            for (int i = iBoundary[0]; i <= iBoundary[1]; ++i) {
                SJmoLdevIdInfo boundaryLdevIdInfo = ldevIdInfo[i];
                if (boundaryLdevIdInfo.getLDEVID() == -1) continue;
                boundaryLdevIdInfo.setLDEVID((byte)2);
                boundaryLdevIdInfo.setEmulationGroup((byte)iEmuId);
            }
        }
        targetLdevIdInfo.setLDEVID((byte)0);
        targetLdevIdInfo.setEmulationGroup((byte)iEmuId);
    }

    public static SJmoLdevIndex createLdevIndex(int iLdkc, int iCu, int iLdev) {
        SJmoLdevIndex createLdevIndex = new SJmoLdevIndex();
        createLdevIndex.setLdevIndex((short)iLdkc, (short)iCu, (short)iLdev);
        return createLdevIndex;
    }

    public static int[] getLDEVBoundary(int iLdev) {
        int[] iBoundary;
        iBoundary = new int[]{32 * (iLdev / 32), 31 + iBoundary[0]};
        return iBoundary;
    }

    public static int getRemainingLDEVNum(int iEmuId, List<SJmoCuLdevIdInfo> cuLdevIdInfoList, int iEmuType, SJmoRscUtilLdev ldevUty, SJctrResourceGroupUtility rsgUty, int iTseAttri, SJctrComCVSUtility cvsUty, List<SJmoHUVMVirtualLdev> vldevList) {
        int iSetLDEVNum = 0;
        if (iEmuId == -1) {
            return 0;
        }
        Iterator<SJmoCuLdevIdInfo> i$ = cuLdevIdInfoList.iterator();
        while (i$.hasNext()) {
            SJmoCuLdevIdInfo cuLdevIdObj;
            SJmoCuLdevIdInfo cuLdevIdInfo = cuLdevIdObj = i$.next();
            if (iTseAttri == 2 && cuLdevIdInfo.getSCu() % 2 > 0 || iTseAttri == 1 && cuLdevIdInfo.getSCu() % 2 == 0) continue;
            SJmoLdevIdInfo[] ldevIdInfo = cuLdevIdInfo.getLDEVIDInfo();
            for (int i = 0; i < ldevIdInfo.length; ++i) {
                int iChk;
                if (ldevIdInfo[i].getLDEVID() == 1) {
                    iChk = ldevUty.chkLdevID(ldevIdInfo[i], iEmuId);
                    if (iChk != 0 || !SJctrCVSUtility.chkLdevIDRSG(ldevIdInfo[i], rsgUty, iEmuType, cvsUty, vldevList)) continue;
                    ++iSetLDEVNum;
                    continue;
                }
                if (ldevIdInfo[i].getLDEVID() != 2 || ldevIdInfo[i].getEmulationGroup() != iEmuId && ldevIdInfo[i].getEmulationGroup() != 0 || (iChk = ldevUty.chkLdevID(ldevIdInfo[i], iEmuId)) != 0 || !SJctrCVSUtility.chkLdevIDRSG(ldevIdInfo[i], rsgUty, iEmuType, cvsUty, vldevList)) continue;
                ++iSetLDEVNum;
            }
        }
        return iSetLDEVNum;
    }

    public static int getSSID(short sLdkc, short sCu, short sLdev, List<?> ssidDetailList) {
        int iSsid = 0;
        for (int i = 0; i < ssidDetailList.size(); ++i) {
            SJmoSsidDetail ssidDetail = (SJmoSsidDetail)ssidDetailList.get(i);
            if (ssidDetail.getLDKC() != sLdkc || ssidDetail.getCU() != sCu || ssidDetail.getStartLDEV() > sLdev || ssidDetail.getEndLDEV() < sLdev) continue;
            iSsid = ssidDetail.getSSID();
            break;
        }
        return iSsid;
    }

    public static ArrayList setSSID(short sLdkc, short sCu, short sLdev, int iSsid, List<SJmoSsidDetail> ssidDetailList, short sSSIDBoundary) {
        SJmoSsidDetail moSsidDetail = new SJmoSsidDetail();
        moSsidDetail.setLDKC(sLdkc);
        moSsidDetail.setCU(sCu);
        if (sSSIDBoundary == 256) {
            moSsidDetail.setStartLDEV((short)0);
            moSsidDetail.setEndLDEV((short)255);
        } else if (sSSIDBoundary == 64) {
            if (sLdev >= 0 && sLdev <= 63) {
                moSsidDetail.setStartLDEV((short)0);
                moSsidDetail.setEndLDEV((short)63);
            } else if (sLdev >= 64 && sLdev <= 127) {
                moSsidDetail.setStartLDEV((short)64);
                moSsidDetail.setEndLDEV((short)127);
            } else if (sLdev >= 128 && sLdev <= 191) {
                moSsidDetail.setStartLDEV((short)128);
                moSsidDetail.setEndLDEV((short)191);
            } else if (sLdev >= 192 && sLdev <= 255) {
                moSsidDetail.setStartLDEV((short)192);
                moSsidDetail.setEndLDEV((short)255);
            }
        }
        moSsidDetail.setSSID(iSsid);
        moSsidDetail.setIDataMode(1);
        ArrayList<SJmoSsidDetail> rtn = new ArrayList<SJmoSsidDetail>();
        for (int i = 0; i < ssidDetailList.size(); ++i) {
            rtn.add(ssidDetailList.get(i));
        }
        boolean bChk = false;
        for (int i = 0; i < rtn.size(); ++i) {
            SJmoSsidDetail ssid = (SJmoSsidDetail)rtn.get(i);
            if (ssid.getCU() == moSsidDetail.getCU() && ssid.getStartLDEV() > moSsidDetail.getStartLDEV()) {
                rtn.add(i, moSsidDetail);
                bChk = true;
                break;
            }
            if (ssid.getCU() <= moSsidDetail.getCU()) continue;
            rtn.add(i, moSsidDetail);
            bChk = true;
            break;
        }
        if (!bChk) {
            rtn.add(moSsidDetail);
        }
        return rtn;
    }

    public static int getSpaceSSID(int iSsid, List<SJmoSsidDetail> ssidDetailList, SJmoRscUtilSsid ssid, SJmoLdevIndex ldev) {
        int iRetSsid = 0;
        while (iRetSsid == 0) {
            int iChk;
            if (iSsid > 65534) {
                iRetSsid = -1;
                SJctrLogUty.warn(className, "getSpaceSSID", "SpaceSSID not found");
                break;
            }
            if (iSsid < 4) {
                iSsid = 4;
            }
            if ((iRetSsid = SJctrCVSUtility.checkSSID(iSsid, ssidDetailList)) != 0 && (iChk = ssid.chkSsid(iRetSsid, ldev)) != 0) {
                iRetSsid = 0;
            }
            ++iSsid;
        }
        if (iRetSsid == 0) {
            for (int i = 4; i < iSsid; ++i) {
                int iChk = ssid.chkSsid(i, ldev);
                if (iChk != 0) continue;
                iRetSsid = i;
                break;
            }
        }
        return iRetSsid;
    }

    public static int checkSSID(int iSsid, List<SJmoSsidDetail> ssidDetailList) {
        int iRetSsid = 0;
        for (SJmoSsidDetail moSsidDetail : ssidDetailList) {
            if (iSsid != moSsidDetail.getSSID()) continue;
            iRetSsid = 0;
            return iRetSsid;
        }
        iRetSsid = iSsid;
        return iRetSsid;
    }

    public static void output_Error(int func, int module, int error) {
        SJctrError err = new SJctrError(func, module, error);
        SJcException exp = err.createException();
        throw exp;
    }

    public static void output_ErrorEx(int func, int module, int error, String ... params) {
        SJctrError err = new SJctrError(func, module, error);
        err.setMsgArgument(params);
        SJcException exp = err.createException();
        throw exp;
    }

    public static void delSSID(SJmoLdevIndex ldevIndex, List<SJmoCuLdevIdInfo> cuLdevIdInfoList, List<SJmoSsidDetail> ssidDetailList, List<SJmoSsidDetail> originSsidDetailList) {
        SJmoCuLdevIdInfo cuLdevIdInfo = cuLdevIdInfoList.get(ldevIndex.getSCu());
        SJmoLdevIdInfo[] ldevIdInfo = cuLdevIdInfo.getLDEVIDInfo();
        short sLDKC = ldevIndex.getSLdkc();
        short sCU = ldevIndex.getSCu();
        short sLDEV = ldevIndex.getSLdev();
        int iCount = 0;
        for (int iIndex = 0; iIndex < ssidDetailList.size(); ++iIndex) {
            SJmoSsidDetail moSsidDetail = ssidDetailList.get(iIndex);
            if (moSsidDetail.getLDKC() != sLDKC || moSsidDetail.getCU() != sCU) continue;
            SJmoSsidDetail originSsidDetail = SJctrCVSUtility.getOriginSsidDetail(sLDKC, sCU, sLDEV, originSsidDetailList);
            int sStartLDEV = moSsidDetail.getStartLDEV();
            short sEndLDEV = moSsidDetail.getEndLDEV();
            if (sStartLDEV > sLDEV || sLDEV > sEndLDEV) continue;
            for (int j = sStartLDEV; j <= sEndLDEV; ++j) {
                if (ldevIdInfo[j].getLDEVID() == 1 && originSsidDetail.getSSID() == 0) continue;
                ++iCount;
            }
            if (iCount != 0) continue;
            ssidDetailList.remove(iIndex);
            break;
        }
    }

    private static SJmoSsidDetail getOriginSsidDetail(short sLDKC, short sCU, short sLdevId, List<SJmoSsidDetail> originSsidDetailList) {
        SJmoSsidDetail originSsidDetail = null;
        boolean bRet = false;
        for (int i = 0; i < originSsidDetailList.size(); ++i) {
            originSsidDetail = originSsidDetailList.get(i);
            if (originSsidDetail.getLDKC() != sLDKC || originSsidDetail.getCU() != sCU || originSsidDetail.getStartLDEV() > sLdevId || originSsidDetail.getEndLDEV() < sLdevId) continue;
            bRet = true;
            break;
        }
        if (!bRet) {
            originSsidDetail = new SJmoSsidDetail();
            originSsidDetail.setSSID(0);
        }
        return originSsidDetail;
    }

    public static void output_Error(int func, int module, int error, ArrayList errColumnList) {
        if (errColumnList == null) {
            SJctrError err = new SJctrError(func, module, error);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    public static String s_iCLPR(int iCLPR) {
        String sCLPR = Integer.toString(iCLPR);
        return sCLPR;
    }

    public static int i_sCLPR(String sCLPR) {
        int index = sCLPR.indexOf(":");
        int iCLPR = Integer.parseInt(sCLPR.substring(0, index));
        return iCLPR;
    }

    public static String s_sCLPRName(String sCLPR) {
        int index = sCLPR.indexOf(":");
        String rtn = sCLPR.substring(index + 1);
        return rtn;
    }

    public static SJctrCapacityUtility.UNIT getUnit(String strUnit) {
        if (strUnit.equals("TB")) {
            return SJctrCapacityUtility.UNIT.TB;
        }
        if (strUnit.equals("GB")) {
            return SJctrCapacityUtility.UNIT.GB;
        }
        if (strUnit.equals("MB")) {
            return SJctrCapacityUtility.UNIT.MB;
        }
        if (strUnit.equals("CYL")) {
            return SJctrCapacityUtility.UNIT.CYL;
        }
        if (strUnit.equals("BLOCK2")) {
            return SJctrCapacityUtility.UNIT.BLOCK;
        }
        return SJctrCapacityUtility.UNIT.BLOCK;
    }

    public static String toUnitLBA_UP(long block, SJctrCapacityUtility.UNIT unit) {
        if (unit == null) {
            return String.valueOf(block);
        }
        DecimalFormat BYTE_CHANGE_FORMAT = new DecimalFormat("0.00");
        String result = "";
        switch (unit) {
            case MB: {
                BigDecimal bdBlock = new BigDecimal(block);
                BigDecimal bdBase = new BigDecimal(2048L);
                BigDecimal bdResult = bdBlock.divide(bdBase, 2, RoundingMode.DOWN);
                result = BYTE_CHANGE_FORMAT.format(bdResult);
                break;
            }
            case GB: {
                BigDecimal bdBlock2 = new BigDecimal(block);
                BigDecimal bdBase2 = new BigDecimal(0x200000L);
                BigDecimal bdResult2 = bdBlock2.divide(bdBase2, 2, RoundingMode.DOWN);
                result = BYTE_CHANGE_FORMAT.format(bdResult2);
                break;
            }
            case TB: {
                BigDecimal bdBlock3 = new BigDecimal(block);
                BigDecimal bdBase3 = new BigDecimal(0x80000000L);
                BigDecimal bdResult3 = bdBlock3.divide(bdBase3, 2, RoundingMode.UP);
                result = BYTE_CHANGE_FORMAT.format(bdResult3);
                break;
            }
            default: {
                result = String.valueOf(block);
            }
        }
        return result;
    }

    public static String toUnitLBA_ExpandUP(long block, SJctrCapacityUtility.UNIT unit) {
        if (unit == null) {
            return String.valueOf(block);
        }
        DecimalFormat BYTE_CHANGE_FORMAT = new DecimalFormat("0.00");
        String result = "";
        switch (unit) {
            case MB: {
                BigDecimal bdBlock = new BigDecimal(block);
                BigDecimal bdBase = new BigDecimal(2048L);
                BigDecimal bdResult = bdBlock.divide(bdBase, 2, RoundingMode.DOWN);
                result = BYTE_CHANGE_FORMAT.format(bdResult);
                break;
            }
            case GB: {
                BigDecimal bdBlock2 = new BigDecimal(block);
                BigDecimal bdBase2 = new BigDecimal(0x200000L);
                BigDecimal bdResult2 = bdBlock2.divide(bdBase2, 2, RoundingMode.UP);
                result = BYTE_CHANGE_FORMAT.format(bdResult2);
                break;
            }
            case TB: {
                BigDecimal bdBlock3 = new BigDecimal(block);
                BigDecimal bdBase3 = new BigDecimal(0x80000000L);
                BigDecimal bdResult3 = bdBlock3.divide(bdBase3, 2, RoundingMode.UP);
                result = BYTE_CHANGE_FORMAT.format(bdResult3);
                break;
            }
            default: {
                result = String.valueOf(block);
            }
        }
        return result;
    }

    public static long getCapacity(String str, String strUnit) {
        long rtn = 0L;
        Double dSize = Double.parseDouble(str);
        if (strUnit.equals("TB")) {
            dSize = dSize * 1024.0 * 1024.0 * 1024.0 * 2.0;
            rtn = dSize.longValue();
        } else if (strUnit.equals("GB")) {
            dSize = dSize * 1024.0 * 1024.0 * 2.0;
            rtn = dSize.longValue();
        } else if (strUnit.equals("MB")) {
            dSize = dSize * 1024.0 * 2.0;
            rtn = dSize.longValue();
        } else {
            rtn = Long.parseLong(str);
        }
        return rtn;
    }

    public static String getPoolName(int iPool, String PoolName) {
        return PoolName + "(" + iPool + ")";
    }

    public static int[] getFB4PGNO(int Mode, int VolID) {
        int[] iVOLID = new int[2];
        if (Mode == 1) {
            if (VolID % 2048 == 0) {
                iVOLID[0] = VolID / 2048 + 65 - 1;
                iVOLID[1] = 2048;
            } else {
                iVOLID[0] = VolID / 2048 + 65;
                iVOLID[1] = VolID % 2048;
            }
        } else if (VolID % 2048 == 0) {
            iVOLID[0] = VolID / 2048 + 16485 - 1;
            iVOLID[1] = 2048;
        } else {
            iVOLID[0] = VolID / 2048 + 16485;
            iVOLID[1] = VolID % 2048;
        }
        return iVOLID;
    }

    public static int getVVOLID(int Mode, int FB4, int PGID) {
        int iVOLID = 0;
        iVOLID = Mode == 1 ? (FB4 - 65) * 2048 + PGID : (FB4 - 16485) * 2048 + PGID;
        return iVOLID;
    }

    public static int getLdevNumber(SJmoLdevIndex ldevIndex) {
        int rtn = 0;
        rtn = ldevIndex.getSLdkc() + ldevIndex.getSCu() * 256 + ldevIndex.getSLdev();
        return rtn;
    }

    public static int getPgNum(ArrayList ldevList, List pgList) {
        for (int i = 0; i < ldevList.size(); ++i) {
            SJmoLdevDetail ldev = (SJmoLdevDetail)ldevList.get(i);
            boolean bFlg = false;
            for (int j = 0; j < pgList.size(); ++j) {
                SJmoPgIndex pg = (SJmoPgIndex)pgList.get(j);
                if (pg.getFB4() != ldev.getIFB4() || pg.getPG() != ldev.getIPG()) continue;
                bFlg = true;
                break;
            }
            if (bFlg) continue;
            SJmoPgIndex wkPg = new SJmoPgIndex();
            wkPg.setFB4(ldev.getIFB4());
            wkPg.setPG(ldev.getIPG());
            pgList.add(wkPg);
        }
        return pgList.size();
    }

    public static int getPgNumQfCount(ArrayList ldevList, List pgList, ArrayList<SJmoPgDetail> allPgDetailList) {
        int iCount = 0;
        for (int i = 0; i < ldevList.size(); ++i) {
            SJmoLdevDetail ldev = (SJmoLdevDetail)ldevList.get(i);
            boolean bFlg = false;
            for (int j = 0; j < pgList.size(); ++j) {
                SJmoPgIndex pg = (SJmoPgIndex)pgList.get(j);
                if (pg.getFB4() != ldev.getIFB4() || pg.getPG() != ldev.getIPG()) continue;
                bFlg = true;
                break;
            }
            if (bFlg) continue;
            SJmoPgIndex wkPg = new SJmoPgIndex();
            wkPg.setFB4(ldev.getIFB4());
            wkPg.setPG(ldev.getIPG());
            pgList.add(wkPg);
            int pg = Collections.binarySearch(allPgDetailList, (Object)wkPg);
            if (pg < 0) continue;
            SJmoPgDetail pgDetail = allPgDetailList.get(pg);
            iCount += pgDetail.getQuickFormatCount();
        }
        return iCount;
    }

    public static int getPgNum(ArrayList ldevList) {
        ArrayList list = new ArrayList();
        return SJctrCVSUtility.getPgNum(ldevList, list);
    }

    public static ArrayList<SJmoLdevDetail> getLDEVList(ArrayList<SJmoLdevDetail> ldevList, ArrayList<SJctrLDEVDetail> originLdevDtlList) {
        for (int i = 0; i < originLdevDtlList.size(); ++i) {
            SJmoLdevDetail detail = originLdevDtlList.get(i);
            ldevList.add(detail);
        }
        return ldevList;
    }

    public static ArrayList<SJmoLdevDetail> getQFLdevList(List ldevDtlList, List LDEVStatuslList) {
        ArrayList<SJmoLdevDetail> ldevList = new ArrayList<SJmoLdevDetail>();
        for (int i = 0; i < ldevDtlList.size(); ++i) {
            SJmoLdevStatusInfo ldev;
            SJmoLdevDetail ldevDetail = (SJmoLdevDetail)ldevDtlList.get(i);
            int indexCnt = Collections.binarySearch((List)LDEVStatuslList, (Object)ldevDetail);
            if (indexCnt < 0 || (ldev = (SJmoLdevStatusInfo)LDEVStatuslList.get(indexCnt)).getLDEVStatus() != 9) continue;
            ldevList.add(ldevDetail);
        }
        return ldevList;
    }

    public static boolean chkPoolStatus(SJmoPoolDetail pool) {
        boolean rtn = false;
        long lPoolStatus = pool.getPoolStatus();
        if ((lPoolStatus & 0x20000000L) > 0L) {
            lPoolStatus ^= 0x20000000L;
        }
        if (lPoolStatus == 4101L) {
            rtn = true;
        } else if (lPoolStatus == 2147487750L) {
            rtn = true;
        } else if (lPoolStatus == 1073745926L) {
            rtn = true;
        } else if (lPoolStatus == 3221229574L) {
            rtn = true;
        } else if (lPoolStatus == 8392709L) {
            rtn = true;
        } else if (lPoolStatus == 2155876358L) {
            rtn = true;
        } else if (lPoolStatus == 1082134534L) {
            rtn = true;
        } else if (lPoolStatus == 3229618182L) {
            rtn = true;
        }
        return rtn;
    }

    public static boolean chkPoolStatus_DepOver(SJmoPoolDetail pool) {
        boolean rtn = false;
        long lPoolStatus = pool.getPoolStatus();
        if ((lPoolStatus & 0x20000000L) > 0L) {
            rtn = true;
        }
        return rtn;
    }

    public static ArrayList<SJctrErrorColumnData> checkRSGLDEVtoLDEV(List<SJmoLdevIndex> ldevIndexList, SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>();
        List<SJmoLdevIndex> NGLdevIndexList = rsgUtil.extractImpossibleLdev(ldevIndexList);
        for (SJmoLdevIndex NGLdevIndex : NGLdevIndexList) {
            SJctrError error = new SJctrError(30, 22, 105299);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(NGLdevIndex, error);
            errColumnList.add(errColumn);
        }
        return errColumnList;
    }

    public static ArrayList<SJctrErrorColumnData> checkRSGPGtoPG(List<SJmoPgIndex> pgIndexList, SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>();
        List<SJmoPgIndex> NGPgIndexList = rsgUtil.extractImpossiblePg(pgIndexList);
        for (SJmoPgIndex NGPgIndex : NGPgIndexList) {
            SJctrError error = new SJctrError(30, 22, 105300);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(NGPgIndex, error);
            errColumnList.add(errColumn);
        }
        return errColumnList;
    }

    public static List<SJmoPgIndex> getRSGPGIndex(List<SJmoRSGgetRsg> rsgList) {
        ArrayList<SJmoPgIndex> pgIndexList = new ArrayList<SJmoPgIndex>();
        for (SJmoRSGgetRsg rsgDetail : rsgList) {
            ArrayList<SJmoPgIndex> OKPGIndexList = rsgDetail.getVdevs();
            pgIndexList.addAll(OKPGIndexList);
        }
        Collections.sort(pgIndexList);
        return pgIndexList;
    }

    public static ArrayList<SJctrErrorColumnData> checkRSGLDEVPGtoLDEV(List<SJmoLdevDetail> ldevDetailList, SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>();
        List<SJmoPgIndex> OKPGIndexList = SJctrCVSUtility.getRSGPGIndex(rsgUtil.extractRsg());
        for (SJmoLdevDetail ldevDetail : ldevDetailList) {
            SJmoPgIndex pgIndex;
            int iIndex;
            if (ldevDetail.getbVvol() || (iIndex = Collections.binarySearch(OKPGIndexList, (Object)(pgIndex = SJctrCVSUtility.createPgIndex(ldevDetail.getIFB4(), ldevDetail.getIPG())))) >= 0) continue;
            SJctrError error = new SJctrError(30, 22, 105301);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldevDetail, error);
            errColumnList.add(errColumn);
        }
        return errColumnList;
    }

    public static ArrayList<SJctrErrorColumnData> checkRSGLDEVDetailtoPG(List<SJmoLdevDetail> ldevDetailList, SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>();
        List<SJmoPgIndex> OKPGIndexList = SJctrCVSUtility.getRSGPGIndex(rsgUtil.extractRsg());
        for (SJmoLdevDetail ldevDetail : ldevDetailList) {
            SJmoPgIndex pgIndex;
            int iIndex;
            if (ldevDetail.getbVvol() || (iIndex = Collections.binarySearch(OKPGIndexList, (Object)(pgIndex = SJctrCVSUtility.createPgIndex(ldevDetail.getIFB4(), ldevDetail.getIPG())))) >= 0) continue;
            SJctrError error = new SJctrError(30, 22, 105300);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(pgIndex, error);
            errColumnList.add(errColumn);
        }
        return errColumnList;
    }

    public static ArrayList<SJctrErrorColumnData> checkRSGLDEVDetailtoPGColumn(List<SJmoLdevDetail> ldevDetailList, SJctrResourceGroupUtility rsgUtil, List<SJmoPgScatteredInfo> pgList) {
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>();
        List<SJmoLdevIndex> OKLDEVIndexList = SJctrCVSUtility.getRSGLDEVIndex(rsgUtil.extractRsg());
        for (SJmoLdevDetail ldevDetail : ldevDetailList) {
            int iIndex = Collections.binarySearch(OKLDEVIndexList, (Object)ldevDetail);
            if (iIndex >= 0) continue;
            boolean bMatch = false;
            SJmoPgIndex wkPg = SJctrCVSUtility.createPgIndex(ldevDetail.getIFB4(), ldevDetail.getIPG());
            wkPg = SJctrComCVSUtility.getTopScatteredPG(pgList, wkPg);
            for (int i = 0; i < errColumnList.size(); ++i) {
                SJmoPgIndex errPg = (SJmoPgIndex)errColumnList.get(i).getKeyObj();
                if (errPg.getFB4() != wkPg.getFB4() || errPg.getPG() != wkPg.getPG()) continue;
                bMatch = true;
                break;
            }
            if (bMatch) continue;
            SJctrError error = new SJctrError(30, 22, 105302);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(wkPg, error);
            errColumnList.add(errColumn);
        }
        return errColumnList;
    }

    public static ArrayList<SJctrErrorColumnData> checkRSGPOOLtoLDEV(List<SJctrLDEVDetail> ldevDetailList, List<SJmoPoolVolDetail> poolVolList, SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>();
        for (SJctrLDEVDetail ldevDetail : ldevDetailList) {
            List<SJmoLdevIndex> NGLdevIndexList;
            SJmoPoolVolDetail poolVolInf;
            if (!ldevDetail.getbAouVvol()) continue;
            ArrayList poolVol = new ArrayList();
            ArrayList poolVolOne = new ArrayList();
            SJmoPoolIndex pool = new SJmoPoolIndex();
            pool.setPoolId(ldevDetail.getIRelationPoolID());
            int poolIndex = Collections.binarySearch(poolVolList, (Object)pool);
            if (poolIndex >= 0 && (poolVol = (poolVolInf = poolVolList.get(poolIndex)).getAlPoolInfo()) != null && poolVol.size() > 0) {
                poolVolOne.add(poolVol.get(0));
            }
            if ((NGLdevIndexList = rsgUtil.extractImpossibleLdev(poolVolOne)).size() < 1) continue;
            SJctrError error = new SJctrError(30, 22, 105308);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldevDetail, error);
            errColumnList.add(errColumn);
        }
        return errColumnList;
    }

    public static ArrayList<SJctrErrorColumnData> checkRSGPOOLtoVVOL(List<SJctrHDPLDEVDetail> ldevDetailList, List<SJmoPoolVolDetail> poolVolList, SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>();
        for (SJctrHDPLDEVDetail ldevDetail : ldevDetailList) {
            List<SJmoLdevIndex> NGLdevIndexList;
            SJmoPoolVolDetail poolVolInf;
            if (!ldevDetail.getbAouVvol()) continue;
            ArrayList poolVol = new ArrayList();
            ArrayList poolVolOne = new ArrayList();
            SJmoPoolIndex pool = new SJmoPoolIndex();
            pool.setPoolId(ldevDetail.getIRelationPoolID());
            int poolIndex = Collections.binarySearch(poolVolList, (Object)pool);
            if (poolIndex >= 0 && (poolVol = (poolVolInf = poolVolList.get(poolIndex)).getAlPoolInfo()) != null && poolVol.size() > 0) {
                poolVolOne.add(poolVol.get(0));
            }
            if ((NGLdevIndexList = rsgUtil.extractImpossibleLdev(poolVolOne)).size() < 1) continue;
            SJctrError error = new SJctrError(30, 22, 105308);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldevDetail, error);
            errColumnList.add(errColumn);
        }
        return errColumnList;
    }

    public static List<SJmoLdevIndex> getRSGLDEVIndex(List<SJmoRSGgetRsg> rsgList) {
        ArrayList<SJmoLdevIndex> ldevIndexList = new ArrayList<SJmoLdevIndex>();
        for (SJmoRSGgetRsg rsgDetail : rsgList) {
            ArrayList<SJmoLdevIndex> OKLDEVIndexList = rsgDetail.getLdevs();
            ldevIndexList.addAll(OKLDEVIndexList);
        }
        Collections.sort(ldevIndexList);
        return ldevIndexList;
    }

    public static SJmoPgIndex createPgIndex(int iFB4, int iPG) {
        SJmoPgIndex createPgIndex = new SJmoPgIndex();
        createPgIndex.setFB4(iFB4);
        createPgIndex.setPG(iPG);
        return createPgIndex;
    }

    public static boolean checkLdevOfRSG(SJmoLdevIndex ldevIndex, SJctrResourceGroupUtility rsgUty) {
        boolean rtn = false;
        ArrayList<SJmoLdevIndex> ldevList = new ArrayList<SJmoLdevIndex>();
        ldevList.add(ldevIndex);
        List<SJmoLdevIndex> extLdevList = rsgUty.extractLdev(ldevList);
        if (extLdevList.size() > 0) {
            rtn = true;
        }
        return rtn;
    }

    public static boolean checkPgOfRSG(SJmoPgIndex pgIndex, SJctrResourceGroupUtility rsgUty) {
        boolean rtn = false;
        ArrayList<SJmoPgIndex> pgList = new ArrayList<SJmoPgIndex>();
        pgList.add(pgIndex);
        List<SJmoPgIndex> extPgList = rsgUty.extractPg(pgList);
        if (extPgList.size() > 0) {
            rtn = true;
        }
        return rtn;
    }

    public static int getTseAttribute_PoolDetail(SJmoPoolDetail pool) {
        int rtn = 0;
        rtn = pool.getPoolId() % 2 == 0 ? 2 : 1;
        return rtn;
    }

    public static int getTseAttribute_LdevDetail(List ldevList) {
        int rtn = 0;
        int wkPoolSts = 0;
        int wkTseAttri = 0;
        for (int i = 0; i < ldevList.size(); ++i) {
            SJctrLDEVDetail ldev = (SJctrLDEVDetail)ldevList.get(i);
            wkTseAttri = ldev.getbTseVol() ? (wkTseAttri |= 1) : (wkTseAttri |= 2);
            if (ldev.getIRelationPoolID() % 2 == 0) {
                wkPoolSts |= 1;
                continue;
            }
            wkPoolSts |= 2;
        }
        if (wkTseAttri == 1) {
            rtn = wkPoolSts == 1 ? 2 : (wkPoolSts == 2 ? 1 : 3);
        } else if (wkTseAttri != 2) {
            rtn = 3;
        }
        return rtn;
    }

    public static SJctrRelatedDispDataObject createOkCancelMsgDialog(int errorDetail, SJctrItemSelectListener listener, SJctrWizardDataController dc) {
        SJctrRelatedDispDataObject related = SJctrCVSUtility.getMessageDataObject(errorDetail, dc);
        SJctrMessageDataController msgDC = (SJctrMessageDataController)dc.getOwner().getDataController(related);
        msgDC.addButton(SJctrMessageDataController.MD_OK, listener);
        msgDC.addButton(SJctrMessageDataController.MD_CANCEL);
        return related;
    }

    public static SJctrRelatedDispDataObject createOkCancelMsgDialogEx(int errorDetail, SJctrItemSelectListener listener, SJctrWizardDataController dc, Object ... args) {
        SJctrRelatedDispDataObject related = SJctrCVSUtility.getMessageDataObject(errorDetail, dc);
        SJctrMessageDataController msgDC = (SJctrMessageDataController)dc.getOwner().getDataController(related);
        if (listener != null) {
            msgDC.addButton(SJctrMessageDataController.MD_OK, listener);
        } else {
            msgDC.addButton(SJctrMessageDataController.MD_OK);
        }
        if (args != null || args.length > 0) {
            msgDC.setErrColumnOnlyTableParam(args);
        }
        return related;
    }

    public static SJctrRelatedDispDataObject getMessageDataObject(int errorDetail, SJctrWizardDataController dc) {
        String strFuncID = Integer.toString(30);
        String strModuleID = Integer.toString(22);
        String strMsgID = Integer.toString(errorDetail);
        SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
        SJctrRelatedDispDataObject related = dc.createMsgDialog(msg);
        return related;
    }

    public static ArrayList<SJctrError> createStatusList(int func, int module, List<SJctrLDEVDetail> sourceList, SanList resultList) throws SanDataException {
        ArrayList<SJctrError> statusList = new ArrayList<SJctrError>();
        ArrayList<SJctrLDEVErrorInfo> keyedResultList = SJctrLDEVErrorInfo.createList(resultList);
        Collections.sort(keyedResultList);
        Collections.sort(sourceList);
        for (SJctrLDEVDetail ldev : sourceList) {
            int found = Collections.binarySearch(keyedResultList, (Object)ldev);
            SJctrError status = null;
            if (found >= 0) {
                SJctrLDEVErrorInfo result = keyedResultList.get(found);
                status = result.createError();
            } else {
                status = new SJctrError(func, module, 0);
            }
            statusList.add(status);
        }
        return statusList;
    }

    public static boolean chkBaseRole(SJctrDataController dc) {
        boolean rtn = false;
        SJctrAuthorizeSVP svp = new SJctrAuthorizeSVP();
        SJctrAuthorizeContainer container = dc.getOwner().getAuthorizeContainer();
        svp.setContainer(container);
        if (container.getRoleResourceContainer().checkAuthority(143) || svp.chkRole()) {
            rtn = true;
        }
        return rtn;
    }

    public static SJcException makeException(int errCode) {
        return SJctrCVSUtility.makeError(errCode).createException();
    }

    public static SJctrError makeError(int errCode) {
        SJctrError err = new SJctrError(30, 22, errCode);
        return err;
    }

    public static void checkErrorSanResponse(SanObject sanObject) {
        if (sanObject == null) {
            SJctrLogUty.error(className, "checkErrorSanResponse", "parameter is null.");
            throw SJctrCVSUtility.makeException(107001);
        }
        int[] messageId = SJctrCVSUtility.getMessageId(sanObject);
        if (messageId[1] != 0) {
            SJctrLogUty.error(className, "checkErrorSanResponse", "An error has occurred.");
            int funcCode = messageId[0] / 100;
            int moduleCode = messageId[0] % 100;
            int errorCode = messageId[1];
            SJctrError err = new SJctrError(funcCode, moduleCode, errorCode);
            throw err.createException();
        }
    }

    public static int[] getMessageId(SanObject sanObject) {
        if (sanObject == null) {
            SJctrLogUty.error(className, "getMessageId", "parameter is null.");
            throw SJctrCVSUtility.makeException(107001);
        }
        int[] messageId = null;
        try {
            SanObject errorInfo = sanObject.getObj("ErrorInfo");
            messageId = errorInfo.getIntArray("MessageId");
        }
        catch (SanDataException e) {
            SJctrLogUty.error(className, "getMessageId", e.getMessage());
            throw SJctrCVSUtility.makeException(107001);
        }
        return messageId;
    }

    public static SanResponse getSJmoThroughRmiData(SJmoGetThroughRmiData kind_IF, SJctrDataController dc) {
        List<Object> rmiData = new ArrayList();
        if (kind_IF == null || dc == null) {
            SJctrLogUty.error(className, "getSJmoThroughRmiData", "parameter is null.");
            throw SJctrCVSUtility.makeException(107001);
        }
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetThroughRmiData kind = kind_IF;
        SJmoGetRange_IF range = null;
        ArrayList filter = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filter);
        SJctrGetDirectWrapper directWrapper = new SJctrGetDirectWrapper(direct, false);
        set.add(directWrapper);
        Map<SJctrGetDirectWrapper, List<?>> map = dc.getProxy().getDataInf(set);
        rmiData = map.get(directWrapper);
        return (SanResponse)rmiData.get(0);
    }

    public static HashMap<String, byte[]> getAluIdMap(List<SJctrUnbindLdevInfo> unBindLdevDetailList, SJctrDataController dc) {
        if (null == unBindLdevDetailList || null == dc) {
            SJctrLogUty.error(className, "getAluIdMap", "parameter is null.");
            throw SJctrCVSUtility.makeException(107001);
        }
        HashMap<String, byte[]> aluLdevMap = new HashMap<String, byte[]>();
        try {
            SJmoGetAgent modelAgent = dc.getOwner().getModelAgent();
            SanRequest aluIdRequest = modelAgent.newRequest("VVOLreadConglomerateLuId");
            SanList reqLdevsList = aluIdRequest.newList("Ldevs");
            for (SJctrUnbindLdevInfo targetAluLdev : unBindLdevDetailList) {
                int[] setLdevId = new int[]{targetAluLdev.getSLdkc(), targetAluLdev.getSCu(), targetAluLdev.getSLdev()};
                SanObject id = reqLdevsList.addObj();
                id.putIntArray("Id", setLdevId);
            }
            SJctrGetThroughRmiDataAluId requestKind = new SJctrGetThroughRmiDataAluId(aluIdRequest);
            SanResponse aluIdResult = SJctrCVSUtility.getSJmoThroughRmiData(requestKind, dc);
            SJctrCVSUtility.checkErrorSanResponse((SanObject)aluIdResult);
            SanList resultList = aluIdResult.getList("Ldevs");
            for (SanObject resultData : resultList) {
                int[] ldevIdwork = resultData.getIntArray("Id");
                SJmoLdevIndex setLdevId = new SJmoLdevIndex();
                setLdevId.setLdevIndex((short)(ldevIdwork[0] & 0xFF), (short)(ldevIdwork[1] & 0xFF), (short)(ldevIdwork[2] & 0xFF));
                SanObject aluResultObj = resultData.getObj("Alu");
                if (null == aluResultObj) continue;
                byte[] aluId = aluResultObj.getByteArray("Id");
                aluLdevMap.put(setLdevId.toString(), aluId);
            }
        }
        catch (SanDataException ex) {
            SJctrLogUty.error(className, "getAluIdMap", ex.getMessage());
            throw SJctrCVSUtility.makeException(107001);
        }
        return aluLdevMap;
    }

    public static List<SJctrUnbindLdevInfo> getcompAluList(List<SJctrUnbindLdevInfo> unBindLdevDetailList, SJctrWizardWindowDC dc, SJctrUserController uc, List<SJmoLdevDetail> ldevDetailList) {
        if (null == unBindLdevDetailList || null == dc || null == uc || null == ldevDetailList) {
            SJctrLogUty.error(className, "getcompAluList", "parameter is null.");
            throw SJctrCVSUtility.makeException(107001);
        }
        ArrayList<SJctrUnbindLdevInfo> compAluLdevList = new ArrayList();
        try {
            SJmoGetAgent modelAgent = dc.getOwner().getModelAgent();
            SanRequest aluBindCheckRequest = modelAgent.newRequest("VVOLreadBoundSluInfo");
            SanList reqLdevsList = aluBindCheckRequest.newList("Alus");
            for (SJctrUnbindLdevInfo unBindAluLdev : unBindLdevDetailList) {
                int[] setLdevId = new int[]{unBindAluLdev.getSLdkc(), unBindAluLdev.getSCu(), unBindAluLdev.getSLdev()};
                SanObject ldev = reqLdevsList.addObj();
                SanObject id = ldev.newObj("Ldev");
                id.putIntArray("Id", setLdevId);
            }
            SJctrGetThroughRmiDataAluBindSlu requestKind = new SJctrGetThroughRmiDataAluBindSlu(aluBindCheckRequest);
            SanResponse aluBindSluResult = SJctrCVSUtility.getSJmoThroughRmiData(requestKind, dc);
            SJctrCVSUtility.checkErrorSanResponse((SanObject)aluBindSluResult);
            SanList resultList = aluBindSluResult.getList("Alus");
            for (SanObject alusObject : resultList) {
                SJctrCVSUtility.checkErrorSanResponse(alusObject);
            }
            compAluLdevList = SJctrCVSUtility.setBindSluIdList(resultList, unBindLdevDetailList, dc, ldevDetailList);
        }
        catch (SanDataException ex) {
            SJctrLogUty.error(className, "getcompAluList", ex.getMessage());
            throw SJctrCVSUtility.makeException(107001);
        }
        return compAluLdevList;
    }

    private static List<SJctrUnbindLdevInfo> setBindSluIdList(SanList alusList, List<SJctrUnbindLdevInfo> unBindLdevDetailList, SJctrDataController dc, List<SJmoLdevDetail> ldevDetailList) {
        ArrayList<SJctrUnbindLdevInfo> compAluLdevList = new ArrayList();
        HashMap<String, List<int[]>> bindSluLdevIdMap = new HashMap<String, List<int[]>>();
        try {
            for (SanObject alusObject : alusList) {
                SanObject alusIdObj = alusObject.getObj("Ldev");
                int[] targetAluId = alusIdObj.getIntArray("Id");
                SJmoLdevIndex bindSlu = new SJmoLdevIndex();
                bindSlu.setLdevIndex((short)(targetAluId[0] & 0xFF), (short)(targetAluId[1] & 0xFF), (short)(targetAluId[2] & 0xFF));
                ArrayList<int[]> bindSluList = new ArrayList<int[]>();
                SanList slusSanList = alusObject.getList("Slus");
                if (null == slusSanList) continue;
                for (SanObject slusObject : slusSanList) {
                    SanObject sluLdev = slusObject.getObj("Ldev");
                    int[] bindSluId = sluLdev.getIntArray("Id");
                    bindSluList.add(bindSluId);
                }
                bindSluLdevIdMap.put(bindSlu.toString(), bindSluList);
            }
        }
        catch (SanDataException ex) {
            SJctrLogUty.error(className, "setBindSluIdList", ex.getMessage());
            throw SJctrCVSUtility.makeException(107001);
        }
        compAluLdevList = SJctrCVSUtility.setBindSluData(unBindLdevDetailList, dc, ldevDetailList, bindSluLdevIdMap);
        return compAluLdevList;
    }

    private static List<SJctrUnbindLdevInfo> setBindSluData(List<SJctrUnbindLdevInfo> unBindLdevDetailList, SJctrDataController dc, List<SJmoLdevDetail> ldevDetailList, HashMap<String, List<int[]>> bindSluLdevIdMap) {
        ArrayList<SJctrUnbindLdevInfo> compAluLdevList = new ArrayList<SJctrUnbindLdevInfo>();
        ArrayList<SJmoLdevDetail> sluLdevList = new ArrayList<SJmoLdevDetail>();
        Collections.sort((List)((ArrayList)ldevDetailList));
        for (SJctrUnbindLdevInfo aluLdev : unBindLdevDetailList) {
            List<int[]> bindSluList = bindSluLdevIdMap.get(aluLdev.toString());
            if (null == bindSluList) continue;
            for (int[] bindSluId : bindSluList) {
                SJmoLdevIndex bindSlu = new SJmoLdevIndex();
                bindSlu.setLdevIndex((short)(bindSluId[0] & 0xFF), (short)(bindSluId[1] & 0xFF), (short)(bindSluId[2] & 0xFF));
                int index = Collections.binarySearch(ldevDetailList, (Object)bindSlu);
                if (index < 0) continue;
                sluLdevList.add(ldevDetailList.get(index));
            }
        }
        HashMap<String, byte[]> sluIdMap = SJctrTiReplicationUtility.getDpSluIdMap(sluLdevList, dc);
        for (SJctrUnbindLdevInfo aluLdev : unBindLdevDetailList) {
            ArrayList<byte[]> unBindSluIdList = new ArrayList<byte[]>();
            List<int[]> bindSluList = bindSluLdevIdMap.get(aluLdev.toString());
            if (null == bindSluList) continue;
            for (int[] bindSluId : bindSluList) {
                SJmoLdevIndex bindSlu = new SJmoLdevIndex();
                bindSlu.setLdevIndex((short)(bindSluId[0] & 0xFF), (short)(bindSluId[1] & 0xFF), (short)(bindSluId[2] & 0xFF));
                unBindSluIdList.add(sluIdMap.get(bindSlu.toString()));
            }
            aluLdev.setBindSluIdList(unBindSluIdList);
            compAluLdevList.add(aluLdev);
        }
        return compAluLdevList;
    }

    public static SJcException convCvsLogicErrorException(SJcException e, int errCode) {
        SJcException err = e;
        if (e != null) {
            SJcMessage msgObj = e.getMsg();
            if (!msgObj.getFunctionID().equals(Integer.toString(30))) {
                return err;
            }
            if (!msgObj.getModuleID().equals(Integer.toString(22))) {
                return err;
            }
            if (!msgObj.getMsgID().equals(Integer.toString(107001))) {
                return err;
            }
        }
        err = SJctrCVSUtility.makeException(errCode);
        return err;
    }

    public static boolean chkSanresponseDetailErr(SanResponse responseData) throws SanDataException {
        boolean result = false;
        try {
            if (null == responseData) {
                SJctrLogUty.error(className, "chkSanresponseDetailErr", "responseData is null.");
                throw SJctrCVSUtility.makeException(107001);
            }
            SanObject errInfo = responseData.getObj("ErrorInfo");
            int errCode = errInfo.getInt("ErrorCode");
            if (7000 <= errCode && errCode < 8000) {
                result = true;
            }
        }
        catch (SanDataException e) {
            SJctrLogUty.error(className, "chkSanresponseDetailErr", e.getMessage());
            throw SJctrCVSUtility.makeException(107001);
        }
        return result;
    }

    public static boolean checkSubSystemStatus() {
        SJmoSubsystemStatusMgr subSystemStatMGR = new SJmoSubsystemStatusMgr(SJdsSupplierMgr.getSupplierMgr().getDKCDKUStatusInfo(), SJdsSupplierMgr.getSupplierMgr().getAllLookList());
        int subSyStatus = subSystemStatMGR.getSubsystemStatus();
        switch (subSyStatus) {
            case 1: {
                return true;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static ArrayList<SJctrErrorColumnData> checkSysRSGLDEVtoLDEV(List<SJmoLdevIndex> ldevIndexList, SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>();
        List<SJmoLdevIndex> NGLdevIndexList = rsgUtil.extractLdevInSysRsg(ldevIndexList);
        for (SJmoLdevIndex NGLdevIndex : NGLdevIndexList) {
            SJctrError error = new SJctrError(30, 22, 205176);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(NGLdevIndex, error);
            errColumnList.add(errColumn);
        }
        return errColumnList;
    }

    public static ArrayList<SJctrErrorColumnData> checkSysRSGPGtoPG(List<SJmoPgIndex> pgIndexList, SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>();
        List<SJmoPgIndex> NGPgIndexList = rsgUtil.extractPgInSysRsg(pgIndexList);
        for (SJmoPgIndex NGPgIndex : NGPgIndexList) {
            SJctrError error = new SJctrError(30, 22, 205177);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(NGPgIndex, error);
            errColumnList.add(errColumn);
        }
        return errColumnList;
    }

    public static ArrayList<SJctrErrorColumnData> checkSysRSGLDEVtoPGScattered(List<SJmoLdevDetail> ldevDetailList, SJctrResourceGroupUtility rsgUtil, List<SJmoPgScatteredInfo> pgList) {
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>();
        Collections.sort((List)((ArrayList)ldevDetailList));
        List<SJmoLdevIndex> OKLDEVIndexList = rsgUtil.extractLdevExceptSysRsg(ldevDetailList);
        for (SJmoLdevDetail ldevDetail : ldevDetailList) {
            int iIndex = SJctrCVSUtility.sortAndBinarySearch(OKLDEVIndexList, ldevDetail, false);
            if (iIndex >= 0) continue;
            boolean bMatch = false;
            SJmoPgIndex wkPg = SJctrCVSUtility.createPgIndex(ldevDetail.getIFB4(), ldevDetail.getIPG());
            wkPg = SJctrComCVSUtility.getTopScatteredPG(pgList, wkPg);
            for (int i = 0; i < errColumnList.size(); ++i) {
                SJmoPgIndex errPg = (SJmoPgIndex)errColumnList.get(i).getKeyObj();
                if (errPg.getFB4() != wkPg.getFB4() || errPg.getPG() != wkPg.getPG()) continue;
                bMatch = true;
                break;
            }
            if (bMatch) continue;
            SJctrError error = new SJctrError(30, 22, 205177);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(wkPg, error);
            errColumnList.add(errColumn);
        }
        return errColumnList;
    }

    public static ArrayList<SJctrErrorColumnData> checkSysRSGLDEVPGtoLDEV(List<SJmoLdevDetail> ldevDetailList, SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>();
        for (SJmoLdevDetail ldevDetail : ldevDetailList) {
            SJmoPgIndex pgIndex;
            if (ldevDetail.getbAouVvol() || ldevDetail.getbQsVvol() || !rsgUtil.isSelRscPgInSysRsg(pgIndex = SJctrCVSUtility.createPgIndex(ldevDetail.getIFB4(), ldevDetail.getIPG()))) continue;
            SJctrError error = new SJctrError(30, 22, 205176);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldevDetail, error);
            errColumnList.add(errColumn);
        }
        return errColumnList;
    }

    private static int sortAndBinarySearch(List list, Object obj, boolean flg) {
        if (flg) {
            Collections.sort((List)list);
        }
        return Collections.binarySearch((List)list, (Object)obj);
    }

    public static boolean checkFptVolLdevStatus(SJmoPoolDetail pool, List ldevStatusList) {
        boolean rtn = false;
        if (pool.getIDataMode() == 2) {
            rtn = true;
        } else {
            ArrayList<SJmoLdevIndex> fptVolList = pool.getAlFptVolInfo();
            if (0 < fptVolList.size()) {
                rtn = true;
                for (int i = 0; i < fptVolList.size(); ++i) {
                    SJmoLdevIndex frpVol = (SJmoLdevIndex)fptVolList.get(i);
                    int ldevIndex = Collections.binarySearch((List)ldevStatusList, (Object)frpVol);
                    if (ldevIndex >= 0) {
                        SJmoLdevStatusInfo ldevStatus = (SJmoLdevStatusInfo)ldevStatusList.get(ldevIndex);
                        if (ldevStatus.getLDEVStatus() == 1) continue;
                        SJctrLogUty.warn(className, "checkFptVolLdevStatus", "ldevStatus not Normal");
                        return false;
                    }
                    SJctrLogUty.warn(className, "checkFptVolLdevStatus", "ldevStatus notFound");
                    return false;
                }
            } else {
                SJctrLogUty.warn(className, "checkFptVolLdevStatus", "FPT-Vol is nothing");
            }
        }
        return rtn;
    }

    public static boolean checkLDEVID(int ldevnum, int iEmuGroup, List<SJmoCuLdevIdInfo> cuLdevIdInfoListOpe, List<SJctrLDEVDetail> newLdevIdListOpe, int iEmuType, SJmoRscUtilLdev ldevUty, SJctrResourceGroupUtility rsgUty, int iTseAttri, List<SJmoHUVMVirtualLdev> vldevList, int iRsgId, int iMaxCU, SJctrComUtility comUty, SJmoLdevIndex startLdevIndex, short Interval) {
        boolean ret = true;
        short sLdkc = startLdevIndex.getSLdkc();
        short sCu = startLdevIndex.getSCu();
        short sLdev = startLdevIndex.getSLdev();
        short sInterval = (short)(Interval + 1);
        for (int i = 0; i < ldevnum; ++i) {
            SJmoLdevIndex freeLdev = SJctrCVSUtility.getFreeLDEV(sLdkc, sCu, sLdev, iEmuGroup, cuLdevIdInfoListOpe, iEmuType, ldevUty, rsgUty, iTseAttri, comUty.getCVSUtility(), vldevList);
            if (freeLdev.getSCu() >= iMaxCU || freeLdev.getSCu() == -1) {
                ret = false;
                break;
            }
            if (iRsgId == rsgUty.getRsgId(freeLdev)) {
                SJctrLDEVDetail wkLDEV = new SJctrLDEVDetail();
                wkLDEV.setLdevIndex(freeLdev.getSLdkc(), freeLdev.getSCu(), freeLdev.getSLdev());
                newLdevIdListOpe.add(wkLDEV);
            } else {
                --i;
            }
            if (i == ldevnum - 1) continue;
            sLdkc = freeLdev.getSLdkc();
            sCu = freeLdev.getSCu();
            sLdev = freeLdev.getSLdev();
            if (sLdev + sInterval > 255) {
                sCu = (short)(sCu + 1);
                sLdev = (short)(sLdev + sInterval - 256);
            } else {
                sLdev = (short)(sLdev + sInterval);
            }
            if (sCu < iMaxCU) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public static void createFptVol(int ldevnum, int iEmuGroup, List<SJmoCuLdevIdInfo> cuLdevIdInfoListOpe, List<SJctrLDEVDetail> newLdevIdListOpe, int iEmuType, SJmoRscUtilLdev ldevUty, SJctrResourceGroupUtility rsgUty, int iTseAttri, List<SJmoHUVMVirtualLdev> vldevList, int iRsgId, SJctrComUtility comUty, List<SJmoSsidDetail> ssidDetailList, List<SJmoSsidSummary> ssidSummaryListOpe, SJmoRscUtilSsid ssidUty, SJmoLdevIndex startLdevIndex, short Interval) {
        if (SJctrCVSUtility.checkLDEVID(ldevnum, iEmuGroup, cuLdevIdInfoListOpe, newLdevIdListOpe, iEmuType, ldevUty, rsgUty, 0, vldevList, iRsgId, ssidSummaryListOpe.get(0).getMaxCUCount(), comUty, startLdevIndex, Interval)) {
            for (int i = 0; i < newLdevIdListOpe.size(); ++i) {
                SJctrLDEVDetail ldev = newLdevIdListOpe.get(i);
                ldev.setIEmulationType(iEmuType);
                int wkSSID = SJctrCVSUtility.getSSID(ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev(), ssidDetailList);
                if (wkSSID == 0) {
                    int iSsId = 4;
                    wkSSID = SJctrCVSUtility.getSpaceSSID(iSsId, ssidDetailList, ssidUty, ldev);
                }
                if (wkSSID == -1) {
                    SJctrCVSUtility.output_Error(30, 22, 105131, null);
                }
                ldev.setISSID(wkSSID);
                if (SJctrCVSUtility.getSSID(ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev(), ssidDetailList) != 0) continue;
                ssidDetailList = SJctrCVSUtility.setSSID(ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev(), ldev.getISSID(), ssidDetailList, ssidSummaryListOpe.get(0).getSSIDBoundary());
            }
        } else {
            int iErrorCnt = ldevnum - newLdevIdListOpe.size();
            String[] msgArg = new String[]{Integer.toString(iErrorCnt)};
            SJctrError err = new SJctrError(30, 22, 105132);
            SJcException exp = err.createException();
            exp.getMsg().setMsg_argument(msgArg);
            throw exp;
        }
    }

    public static boolean chkRsgPoolFptNum(List PoolIndexList, List<SJmoPoolDetail> PoolDetailList, List<SJmoPoolNameInfo> PoolNameList, List<SJmoPoolVolDetail> poolVolList, SJctrResourceGroupUtility rsgUty, List<SJmoCuLdevIdInfo> cuLdevIdInfoList, SJmoRscUtilLdev ldevUty, int iTseAttri, SJctrComCVSUtility cvsUty, List<SJmoHUVMVirtualLdev> vldevList) {
        boolean rtn = true;
        List wkRsgPoolList = SJctrCVSUtility.getRsgPoolList(PoolIndexList, PoolDetailList, PoolNameList, poolVolList, rsgUty);
        for (int i = 0; i < wkRsgPoolList.size(); ++i) {
            int iEmu;
            ArrayList wkList = (ArrayList)wkRsgPoolList.get(i);
            SJctrPoolDetail pool = (SJctrPoolDetail)wkList.get(0);
            int iRsgId = SJctrCVSUtility.getPoolVolRsgId(pool, rsgUty);
            int iMaxNum = 1 * wkList.size();
            int iEmuGroup = cvsUty.getEmuTypeGroup("OPEN-V");
            if (SJctrCVSUtility.chkFptRemainingLDEVNum(iEmuGroup, cuLdevIdInfoList, iEmu = cvsUty.getEmu("OPEN-V"), ldevUty, rsgUty, iTseAttri, cvsUty, vldevList, iRsgId, iMaxNum)) continue;
            rtn = false;
            break;
        }
        return rtn;
    }

    public static ArrayList<SJctrLDEVDetail> createCtrPoolDetailFptVol(List PoolIndexList, List<SJmoPoolDetail> PoolDetailList, List<SJmoPoolNameInfo> PoolNameList, List<SJmoPoolVolDetail> poolVolList, SJmoRscUtilLdev ldevUty, SJctrResourceGroupUtility rsgUty, SJctrComUtility comUty, SJmoRscUtilSsid ssidUty, List<SJmoCuLdevIdInfo> cuLdevIdInfoListOpe, List<SJmoSsidSummary> ssidSummaryListOpe, List<SJmoSsidDetail> ssidDetailListOpe, SJctrWizardDataController dc, boolean[] VVolID) {
        List wkRsgPoolList = SJctrCVSUtility.getRsgPoolList(PoolIndexList, PoolDetailList, PoolNameList, poolVolList, rsgUty);
        ArrayList<SJctrLDEVDetail> rtn = new ArrayList<SJctrLDEVDetail>();
        List<SJmoCuLdevIdInfo> wkcuLdevIdInfoListOpe = SJctrCVSUtility.cloneLDEVID(cuLdevIdInfoListOpe);
        List<SJmoSsidDetail> wkssidDetailListOpe = SJctrCVSUtility.cloneSSIDDetail(ssidDetailListOpe);
        for (int i = 0; i < wkRsgPoolList.size(); ++i) {
            ArrayList wkList = (ArrayList)wkRsgPoolList.get(i);
            rtn.addAll(SJctrCVSUtility.createFptLdevList(wkList, ldevUty, rsgUty, comUty, ssidUty, wkcuLdevIdInfoListOpe, ssidSummaryListOpe, wkssidDetailListOpe, dc, VVolID));
        }
        return rtn;
    }

    public static void createLDEV(List<SJctrLDEVDetail> ldevList, SJctrComCVSUtility cvsUty, List<SJmoCuLdevIdInfo> cuLdevIdInfoListOpe, List<SJmoSsidDetail> ssidDetailListOpe, List<SJmoSsidSummary> ssidSummaryListOpe) {
        for (int i = 0; i < ldevList.size(); ++i) {
            SJctrLDEVDetail ldev = ldevList.get(i);
            String strEmu = cvsUty.getEmulationTypeName(ldev.getIEmulationType());
            int iEmuGrouopID = cvsUty.getEmuTypeGroup(strEmu);
            SJctrCVSUtility.createLDEVID(ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev(), iEmuGrouopID, cuLdevIdInfoListOpe);
            if (SJctrCVSUtility.getSSID(ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev(), ssidDetailListOpe) != 0) continue;
            ArrayList ssidList = SJctrCVSUtility.setSSID(ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev(), ldev.getISSID(), ssidDetailListOpe, ssidSummaryListOpe.get(0).getSSIDBoundary());
            ssidDetailListOpe.clear();
            ssidDetailListOpe.addAll(ssidList);
        }
    }

    public static List getRsgPoolList(List PoolIndexList, List<SJmoPoolDetail> PoolDetailList, List<SJmoPoolNameInfo> PoolNameList, List<SJmoPoolVolDetail> poolVolList, SJctrResourceGroupUtility rsgUty) {
        ArrayList wkRsgPoolList = new ArrayList();
        ArrayList<SJctrPoolDetail> ctrPoolList = SJctrCVSUtility.createCtrPoolDetail(PoolIndexList, PoolDetailList, PoolNameList, poolVolList);
        for (int i = 0; i < ctrPoolList.size(); ++i) {
            SJctrPoolDetail targetPool = ctrPoolList.get(i);
            int targetRsgId = SJctrCVSUtility.getPoolVolRsgId(targetPool, rsgUty);
            ArrayList addWkList = new ArrayList();
            block1: for (int j = 0; j < wkRsgPoolList.size(); ++j) {
                ArrayList wkList = (ArrayList)wkRsgPoolList.get(j);
                for (int k = 0; k < wkList.size(); ++k) {
                    SJctrPoolDetail soucePool = (SJctrPoolDetail)wkList.get(k);
                    if (targetRsgId != SJctrCVSUtility.getPoolVolRsgId(soucePool, rsgUty)) continue;
                    addWkList = wkList;
                    continue block1;
                }
            }
            if (addWkList.size() != 0) {
                addWkList.add(targetPool);
                continue;
            }
            ArrayList<SJctrPoolDetail> newList = new ArrayList<SJctrPoolDetail>();
            newList.add(targetPool);
            wkRsgPoolList.add(newList);
        }
        return wkRsgPoolList;
    }

    public static ArrayList<SJctrPoolDetail> createCtrPoolDetail(List PoolIndexList, List<SJmoPoolDetail> PoolDetailList, List<SJmoPoolNameInfo> PoolNameList, List<SJmoPoolVolDetail> poolVolList) {
        SJctrPoolDetail PoolDetail;
        int i;
        ArrayList<SJctrPoolDetail> PoolList = new ArrayList<SJctrPoolDetail>();
        if (PoolDetailList != null) {
            for (i = 0; i < PoolIndexList.size(); ++i) {
                SJmoPoolIndex pool = (SJmoPoolIndex)PoolIndexList.get(i);
                int poolIndex = Collections.binarySearch(PoolDetailList, (Object)pool);
                if (poolIndex < 0) continue;
                SJmoPoolDetail poolDetail = PoolDetailList.get(poolIndex);
                SJctrPoolDetail newPool = new SJctrPoolDetail();
                newPool.setData(poolDetail);
                if (newPool.isPoolDedup()) continue;
                PoolList.add(newPool);
            }
        }
        if (PoolNameList != null) {
            for (i = 0; i < PoolList.size(); ++i) {
                PoolDetail = PoolList.get(i);
                SJmoPoolIndex pool = new SJmoPoolIndex();
                pool.setPoolId(PoolDetail.getPoolId());
                int poolIndex = Collections.binarySearch(PoolNameList, (Object)pool);
                if (poolIndex < 0) continue;
                SJmoPoolNameInfo poolNameInfo = PoolNameList.get(poolIndex);
                PoolDetail.setPoolName(poolNameInfo.getStrName());
            }
        }
        if (poolVolList != null) {
            for (i = 0; i < PoolList.size(); ++i) {
                PoolDetail = PoolList.get(i);
                SJmoPoolIndex pool = new SJmoPoolIndex();
                pool.setPoolId(PoolDetail.getPoolId());
                int poolIndex = Collections.binarySearch(poolVolList, (Object)pool);
                if (poolIndex < 0) continue;
                SJmoPoolVolDetail poolVolInfo = poolVolList.get(poolIndex);
                PoolDetail.setPoolVolDetail(poolVolInfo);
            }
        }
        return PoolList;
    }

    public static int getPoolVolRsgId(SJctrPoolDetail pool, SJctrResourceGroupUtility rsgUty) {
        int iRsgId = -1;
        if (pool.getPoolVolDetail() != null && pool.getPoolVolDetail().getAlPoolInfo().size() > 0) {
            SJmoLdevIndex ldev = (SJmoLdevIndex)pool.getPoolVolDetail().getAlPoolInfo().get(0);
            iRsgId = rsgUty.getRsgId(ldev);
        }
        return iRsgId;
    }

    public static ArrayList<SJctrLDEVDetail> createFptLdevList(List PoolList, SJmoRscUtilLdev ldevUty, SJctrResourceGroupUtility rsgUty, SJctrComUtility comUty, SJmoRscUtilSsid ssidUty, List<SJmoCuLdevIdInfo> cuLdevIdInfoListOpe, List<SJmoSsidSummary> ssidSummaryListOpe, List<SJmoSsidDetail> ssidDetailListOpe, SJctrWizardDataController dc, boolean[] VVolID) {
        ArrayList<SJctrLDEVDetail> rtn = new ArrayList<SJctrLDEVDetail>();
        SJmoLdevIndex startLdevIndex = new SJmoLdevIndex();
        startLdevIndex.setLdevIndex((short)0, (short)0, (short)0);
        for (int i = 0; i < PoolList.size(); ++i) {
            SJctrPoolDetail poolDetail = (SJctrPoolDetail)PoolList.get(i);
            SJmoLdevIndex ldev = (SJmoLdevIndex)poolDetail.getPoolVolDetail().getAlPoolInfo().get(0);
            ArrayList<SJctrLDEVDetail> ldevDetail = SJctrCVSUtility.createFptLdevDetail(1, ldevUty, rsgUty, comUty, ssidUty, cuLdevIdInfoListOpe, ssidSummaryListOpe, ssidDetailListOpe, dc, VVolID, rsgUty.getRsgId(ldev), startLdevIndex);
            SJctrCVSUtility.createLDEV(ldevDetail, comUty.getCVSUtility(), cuLdevIdInfoListOpe, ssidDetailListOpe, ssidSummaryListOpe);
            rtn.addAll(ldevDetail);
            for (int j = 0; j < ldevDetail.size(); ++j) {
                SJctrLDEVDetail detail = ldevDetail.get(j);
                if (poolDetail != null) {
                    detail.setStrPoolName(poolDetail.getPoolName());
                    detail.setIRelationPoolID(poolDetail.getPoolId());
                    detail.setSRelationThreshold((short)80);
                    detail.setIRaidLevel(comUty.getCVSUtility().getRaidLevel(comUty.getCVSUtility().toRaidLevelDisplay(poolDetail)));
                    detail.setstrDriveTypeRPM(comUty.getCVSUtility().toDriveTypeDisplay(poolDetail));
                    detail.setBPoolType(poolDetail.isOpen());
                    detail.setIDpEncrypt(poolDetail.getIEncrypt());
                }
                if (j != ldevDetail.size() - 1) continue;
                startLdevIndex = new SJmoLdevIndex();
                short sLdev = (short)(detail.getSLdev() + 1);
                startLdevIndex.setLdevIndex(detail.getSLdkc(), detail.getSCu(), sLdev);
            }
        }
        return rtn;
    }

    public static ArrayList<SJctrLDEVDetail> createFptLdevDetail(int iNum, SJmoRscUtilLdev ldevUty, SJctrResourceGroupUtility rsgUty, SJctrComUtility comUty, SJmoRscUtilSsid ssidUty, List<SJmoCuLdevIdInfo> cuLdevIdInfoListOpe, List<SJmoSsidSummary> ssidSummaryListOpe, List<SJmoSsidDetail> ssidDetailListOpe, SJctrWizardDataController dc, boolean[] VVolID, int iRsgId, SJmoLdevIndex startLdevIndex) {
        ArrayList<SJctrLDEVDetail> rtn = new ArrayList<SJctrLDEVDetail>();
        int iEmu = comUty.getCVSUtility().getEmu("OPEN-V");
        List<SJmoSsidDetail> ssidDetailList = SJctrCVSUtility.cloneSSIDDetail(ssidDetailListOpe);
        List<SJmoHUVMVirtualLdev> vldevList = dc.getCache(SJmoGetHUVMVirtualLdev.class);
        int iEmuGroup = comUty.getCVSUtility().getEmuTypeGroup("OPEN-V");
        int iVVOLID = 0;
        SJctrCVSUtility.createFptVol(iNum, iEmuGroup, cuLdevIdInfoListOpe, rtn, iEmu, ldevUty, rsgUty, 0, vldevList, iRsgId, comUty, ssidDetailList, ssidSummaryListOpe, ssidUty, startLdevIndex, (short)0);
        for (int i = 0; i < rtn.size(); ++i) {
            SJctrLDEVDetail ldev = rtn.get(i);
            ldev.setByVolumeType((byte)3);
            ldev.setByVolumeFlag((byte)comUty.getCVSUtility().getEmuFlg(comUty.getCVSUtility().getEmulationTypeName(iEmu)));
            ldev.setSLUSEEmlCount((short)1);
            ldev.setILUPathNumber(0);
            ldev.setByCurrentMPBladeID((byte)-1);
            ldev.setStrLdevName("");
            int[] wkID = SJctrCVSUtility.getNonUsedVVOLID(VVolID, iVVOLID);
            ldev.setIFB4(wkID[0]);
            ldev.setIPG(wkID[1]);
            ldev.setIVdev(1);
            ldev.setSCLPR((short)0);
            ldev.setCLPRName(SJctrCVSUtility.getClprName(dc, ldev.getSCLPR()));
            Double minSize = Double.parseDouble(Long.toString(40L));
            long[] lMaxLBA = comUty.getCVSUtility().getCapacity(minSize, "TB", comUty.getCVSUtility().getEmu("OPEN-V"), 1, false, false, true);
            ldev.setLLDEVSize(lMaxLBA[1] / 2L);
            ldev.setLLDEVLBASize(lMaxLBA[0]);
            ldev.setLTotalLBA(lMaxLBA[2]);
            ldev.setbCvsVolume(true);
            ldev.setIFaAttri(2);
            ldev.setbTseVol(false);
            ldev.setBT10pi(false);
            ldev.setBFPTVol(true);
        }
        return rtn;
    }

    public static List<SJmoCuLdevIdInfo> cloneLDEVID(List<SJmoCuLdevIdInfo> LDEVID) {
        ArrayList<SJmoCuLdevIdInfo> rtn = new ArrayList<SJmoCuLdevIdInfo>(LDEVID.size());
        Iterator<SJmoCuLdevIdInfo> i$ = LDEVID.iterator();
        while (i$.hasNext()) {
            SJmoCuLdevIdInfo culdevidinfo;
            SJmoCuLdevIdInfo ldevID = culdevidinfo = i$.next();
            SJmoCuLdevIdInfo newLDEVID = new SJmoCuLdevIdInfo();
            newLDEVID.setCuIndex(ldevID.getSLdkc(), ldevID.getSCu());
            newLDEVID.setIDataMode(ldevID.getIDataMode());
            SJmoLdevIdInfo[] ldev = ldevID.getLDEVIDInfo();
            SJmoLdevIdInfo[] newldev = new SJmoLdevIdInfo[ldev.length];
            for (int i = 0; i < ldev.length; ++i) {
                newldev[i] = new SJmoLdevIdInfo();
                newldev[i].setEmulationGroup(ldev[i].getEmulationGroup());
                newldev[i].setIDataMode(ldev[i].getIDataMode());
                newldev[i].setLDEVID(ldev[i].getLDEVID());
                newldev[i].setLdevIndex(ldev[i].getSLdkc(), ldev[i].getSCu(), ldev[i].getSLdev());
            }
            newLDEVID.setLDEVIDInfo(newldev);
            rtn.add(newLDEVID);
        }
        return rtn;
    }

    public static List<SJmoSsidDetail> cloneSSIDDetail(List<SJmoSsidDetail> ssidDetailList) {
        ArrayList<SJmoSsidDetail> rtn = new ArrayList<SJmoSsidDetail>(ssidDetailList.size());
        for (SJmoSsidDetail ssiddetail : ssidDetailList) {
            try {
                SJmoSsidDetail detail = (SJmoSsidDetail)ssiddetail.clone();
                rtn.add(detail);
            }
            catch (CloneNotSupportedException e) {}
        }
        return rtn;
    }

    public static int[] getNonUsedVVOLID(boolean[] VVolID, int iVVOLD) {
        int[] rtn = new int[2];
        for (int i = iVVOLD; i < VVolID.length; ++i) {
            if (VVolID[i]) continue;
            rtn = SJctrCVSUtility.getFB4PGNO(2, i + 1);
            break;
        }
        return rtn;
    }

    public static String getClprName(SJctrWizardDataController dc, int iId) {
        String rtn = "";
        List<?> CLPRList = dc.getCache(SJctrCVSMacro.KEY_CLASS_CLPR_INFO);
        for (int i = 0; i < CLPRList.size(); ++i) {
            SJmoClprInfo clpr = (SJmoClprInfo)CLPRList.get(i);
            if (iId != clpr.getSClpr()) continue;
            rtn = clpr.getStrClprName();
            break;
        }
        return rtn;
    }

    public static SJmoPoolTieringPolicy getTierPolicy(SJctrWizardDataController dc, int iId) {
        SJmoPoolTieringPolicy rtn = null;
        ArrayList policyDataList = (ArrayList)dc.getCache(SJmoGetPoolTieringPolicy.class);
        for (int i = 0; i < policyDataList.size(); ++i) {
            SJmoPoolTieringPolicy policyData = (SJmoPoolTieringPolicy)policyDataList.get(i);
            if (iId != policyData.getPolicyId()) continue;
            rtn = policyData;
            break;
        }
        return rtn;
    }

    public static boolean chkFptRemainingLDEVNum(int iEmuId, List<SJmoCuLdevIdInfo> cuLdevIdInfoList, int iEmuType, SJmoRscUtilLdev ldevUty, SJctrResourceGroupUtility rsgUty, int iTseAttri, SJctrComCVSUtility cvsUty, List<SJmoHUVMVirtualLdev> vldevList, int iRsgId, int iMaxNum) {
        boolean rtn = false;
        if (iEmuId == -1) {
            return false;
        }
        int iSetLDEVNum = 0;
        Iterator<SJmoCuLdevIdInfo> i$ = cuLdevIdInfoList.iterator();
        while (i$.hasNext()) {
            SJmoCuLdevIdInfo cuLdevIdObj;
            SJmoCuLdevIdInfo cuLdevIdInfo = cuLdevIdObj = i$.next();
            if (iTseAttri == 2 && cuLdevIdInfo.getSCu() % 2 > 0 || iTseAttri == 1 && cuLdevIdInfo.getSCu() % 2 == 0) continue;
            SJmoLdevIdInfo[] ldevIdInfo = cuLdevIdInfo.getLDEVIDInfo();
            for (int i = 0; i < ldevIdInfo.length; ++i) {
                int iChk;
                if (ldevIdInfo[i].getLDEVID() == 1) {
                    iChk = ldevUty.chkLdevID(ldevIdInfo[i], iEmuId);
                    if (iChk == 0 && SJctrCVSUtility.chkLdevIDRSG(ldevIdInfo[i], rsgUty, iEmuType, cvsUty, vldevList) && iRsgId == rsgUty.getRsgId(ldevIdInfo[i])) {
                        ++iSetLDEVNum;
                    }
                } else if (ldevIdInfo[i].getLDEVID() == 2 && (ldevIdInfo[i].getEmulationGroup() == iEmuId || ldevIdInfo[i].getEmulationGroup() == 0) && (iChk = ldevUty.chkLdevID(ldevIdInfo[i], iEmuId)) == 0 && SJctrCVSUtility.chkLdevIDRSG(ldevIdInfo[i], rsgUty, iEmuType, cvsUty, vldevList) && iRsgId == rsgUty.getRsgId(ldevIdInfo[i])) {
                    ++iSetLDEVNum;
                }
                if (iSetLDEVNum < iMaxNum) continue;
                return true;
            }
        }
        return rtn;
    }

    public static boolean chkDedupCompUsedCap_LdevList(List ldevList) {
        boolean rtn = false;
        for (int i = 0; i < ldevList.size(); ++i) {
            SJctrLDEVDetail ldev = (SJctrLDEVDetail)ldevList.get(i);
            if (!SJctrCVSUtility.chkDedupCompUsedCap_LdevInf(ldev)) continue;
            rtn = true;
            break;
        }
        return rtn;
    }

    public static boolean chkDedupCompUsedCap_LdevInf(SJctrLDEVDetail ldev) {
        boolean rtn = false;
        if (ldev.getByVolumeType() == 3 && ldev.getSDataSaving() == 2 && ldev.getLUsedpage() > 0L) {
            rtn = true;
        }
        return rtn;
    }
}

