/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.cvs.createldevs.base.model;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrTextBoxEvent;
import sanproject.sn2.controller.com.model.event.SJctrTextChangeListener;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVDEVCountInfo;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSMacro;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.controller.wizard.cvs.createldevs.base.cntl.SJctrCreateLDEVsBaseDC;
import sanproject.sn2.controller.wizard.cvs.createldevs.base.com.SJctrCreateLDEVsDef;
import sanproject.sn2.controller.wizard.cvs.createldevs.base.model.SJctrCreateLDEVsDmDataModel;

public class SJctrCreateLDEVCapModel
extends SJctrSimpleDataModel
implements SJctrCreateLDEVsDef,
SJctrCVSMacro {
    protected SJctrTextBoxDataModel textBox;
    protected SJctrComboBoxDataModel comboBox;
    protected SJctrTextBoxDataModel numTextBox;
    private int iEmuFlg = -1;
    protected SJctrCheckBoxDataModel chkOffset;
    public static final String KEY_CAP_OFFSET = "COM_CAP_OFFSET";
    public static final String GUID_OFFSET = "OFFSET_BOUNDARY";
    private int iEmuFlgEx = -1;

    public SJctrCreateLDEVCapModel() {
        this.initDataModel();
        this.initListener();
    }

    public void initDataModel() {
        this.textBox = new SJctrTextBoxDataModel();
        this.comboBox = new SJctrComboBoxDataModel();
        this.numTextBox = new SJctrTextBoxDataModel();
        this.chkOffset = new SJctrCheckBoxDataModel();
        this.addDataModel("COM_CAP_GRP", this.textBox);
        this.addDataModel("COM_CAP_LIST", this.comboBox);
        this.addDataModel("COM_VOL_TXT", this.numTextBox);
        this.addDataModel(KEY_CAP_OFFSET, this.chkOffset);
    }

    public void refData(String strEmuType) {
        this.textBox.setEnableListener(false);
        this.chkOffset.setEnableListener(false);
        this.chkOffset.setLabel(this.getComUtility().getGuidance(GUID_OFFSET));
        if (this.iEmuFlgEx != this.getComUtility().getCVSUtility().getEmuFlgEx(strEmuType)) {
            this.iEmuFlgEx = this.getComUtility().getCVSUtility().getEmuFlgEx(strEmuType);
            this.refData_Offset(strEmuType);
        }
        int iEmuFlg = this.getComUtility().getCVSUtility().getEmuFlg(strEmuType);
        this.refData(iEmuFlg);
        this.chkOffset.setEnableListener(true);
        this.textBox.setEnableListener(true);
    }

    private void refData_Offset(String strEmuType) {
        if (this.getComUtility().getCVSUtility().isOpen(strEmuType)) {
            this.chkOffset.setEnable(true);
            if (strEmuType.equals("OPEN-V")) {
                this.chkOffset.setSelect(false);
            } else {
                this.chkOffset.setSelect(true);
            }
        } else {
            this.chkOffset.setSelect(true);
            this.chkOffset.setEnable(false);
        }
    }

    private void refData(int iEmuFlg) {
        this.comboBox.setEnableListener(false);
        this.numTextBox.setEnable(true);
        if (this.iEmuFlg != iEmuFlg) {
            this.comboBox.removeAllItems();
            if (iEmuFlg == 3) {
                this.comboBox.addItem("TB", this.getComUtility().getGuidance("TB"));
                this.comboBox.addItem("GB", this.getComUtility().getGuidance("GB"));
                this.comboBox.addItem("MB", this.getComUtility().getGuidance("MB"));
                this.comboBox.addItem("BLOCK2", this.getComUtility().getGuidance("BLOCK2"));
                this.comboBox.setSelectedIndex(1);
            } else if (iEmuFlg == 0) {
                this.comboBox.addItem("TB", this.getComUtility().getGuidance("TB"));
                this.comboBox.addItem("GB", this.getComUtility().getGuidance("GB"));
                this.comboBox.addItem("MB", this.getComUtility().getGuidance("MB"));
                this.comboBox.addItem("BLOCK2", this.getComUtility().getGuidance("BLOCK2"));
                this.comboBox.setSelectedIndex(1);
            } else {
                this.comboBox.addItem("CYL", this.getComUtility().getGuidance("CYL"));
                this.comboBox.setSelectedIndex(0);
            }
            this.iEmuFlg = iEmuFlg;
        }
        this.refData_UnitData(iEmuFlg);
        this.comboBox.setEnableListener(true);
    }

    public void refData2(String strEmu) {
        int iEmuFlg = this.getComUtility().getCVSUtility().getEmuFlg(strEmu);
        if (iEmuFlg == 3) {
            this.comboBox.setSelectedIndex(1);
        } else {
            this.comboBox.setSelectedIndex(0);
        }
        this.refData_Offset(strEmu);
        this.textBox.setValue("");
        SJctrCreateLDEVsDmDataModel dm = (SJctrCreateLDEVsDmDataModel)this.getDataController().getDataObjectModel("COM_DIRECT_MAPPING");
        if (dm.isDM()) {
            this.textBox.setMin("0");
            this.textBox.setMax("0");
            this.numTextBox.setEnable(false);
            this.numTextBox.setValue("1");
            this.numTextBox.setMin("1");
            this.numTextBox.setMax("1");
        }
    }

    private void refData_UnitData(int iEmuFlg) {
        if (iEmuFlg == 3) {
            if (this.comboBox.getItem("BLOCK2") != null) {
                if (this.chkOffset.isSelect()) {
                    if (this.comboBox.getSelection().equals("BLOCK2")) {
                        this.comboBox.setSelectedIndex(1);
                        this.textBox.setValue("");
                    }
                    this.comboBox.removeItem("BLOCK2");
                }
            } else if (!this.chkOffset.isSelect()) {
                this.comboBox.addItem("BLOCK2", this.getComUtility().getGuidance("BLOCK2"));
            }
        }
    }

    public void chkData() {
        String strUnit = this.comboBox.getSelection();
        this.logUty.putlog("initTextBox", "comboBox: " + strUnit);
        int iError = this.chkCapacity();
        if (iError != 0) {
            SJctrCVSUtility.output_Error(30, 22, iError, null);
        }
        if ((iError = this.chkNum()) != 0) {
            SJctrCVSUtility.output_Error(30, 22, iError, null);
        }
    }

    public void chkData_num() {
        int iError = this.chkNum();
        if (iError != 0) {
            SJctrCVSUtility.output_Error(30, 22, iError, null);
        }
    }

    private int chkCapacity() {
        String strCap = this.textBox.getValue();
        this.logUty.putlog("initTextBox", "Capacity: " + strCap);
        if (!strCap.equals("")) {
            Double lCap = 0.0;
            try {
                lCap = Double.parseDouble(strCap);
            }
            catch (Exception ex) {
                return 105155;
            }
            if (lCap < Double.parseDouble(this.textBox.getMin()) || lCap > Double.parseDouble(this.textBox.getMax())) {
                return 105153;
            }
            if (lCap <= 0.0) {
                return 105154;
            }
        } else {
            return 105148;
        }
        return 0;
    }

    private int chkNum() {
        String strNum = this.numTextBox.getValue();
        this.logUty.putlog("initTextBox", "Capacity: " + strNum);
        if (!strNum.equals("")) {
            Double lNum = 0.0;
            try {
                lNum = Double.parseDouble(strNum);
            }
            catch (Exception ex) {
                return 105155;
            }
            if (lNum < Double.parseDouble(this.numTextBox.getMin()) || lNum > Double.parseDouble(this.numTextBox.getMax())) {
                return 105153;
            }
            if (lNum <= 0.0) {
                return 105154;
            }
        } else {
            return 105148;
        }
        return 0;
    }

    public int getNum() {
        int rtn = Integer.parseInt(this.numTextBox.getValue());
        return rtn;
    }

    public void initListener() {
        this.chkOffset.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrCreateLDEVCapModel.this.fireMessageEvent(SJctrCreateLDEVsBaseDC.NOTIFY_CREATE_LDEVS.CHANGE_OFFSET);
            }
        });
        this.textBox.addTextChangeListener(new SJctrTextChangeListener(){

            @Override
            public void textChanged(SJctrTextBoxEvent event) {
                SJctrCreateLDEVCapModel.this.fireMessageEvent(SJctrCreateLDEVsBaseDC.NOTIFY_CREATE_LDEVS.CHANGE_CAPACITY);
            }
        });
        this.comboBox.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrCreateLDEVCapModel.this.fireMessageEvent(SJctrCreateLDEVsBaseDC.NOTIFY_CREATE_LDEVS.CHANGE_CAPACITY_LIST);
                }
            }
        });
    }

    public void toDisplayData(long lMinSize, long lMaxSize, int iMinNum, int iMaxNum, String strEmu) {
        if (lMaxSize < lMinSize) {
            this.setSelectDlgExitWarningMsg(105456);
        }
        int iEmu = this.getComUtility().getCVSUtility().getEmu(strEmu);
        SJctrCapacityUtility.UNIT unit = SJctrCVSUtility.getUnit(this.comboBox.getSelection());
        String strMinSize = "";
        switch (unit) {
            case CYL: {
                strMinSize = this.getComUtility().getCapacityUtility().toString(lMinSize, unit, iEmu);
                break;
            }
            case GB: 
            case MB: {
                long lDisplaySize = this.getDisplaySize(lMinSize, unit, strEmu);
                strMinSize = SJctrCVSUtility.toUnitLBA_UP(lDisplaySize, unit);
                if (this.chkOffset.isSelect() || !this.checkRoundUP(lDisplaySize, unit)) break;
                Double dbMin = Double.parseDouble(strMinSize);
                Double dbSize = Double.parseDouble("0.01");
                BigDecimal bd1 = new BigDecimal(dbMin);
                BigDecimal bd2 = new BigDecimal(dbSize);
                BigDecimal bd3 = bd1.add(bd2);
                DecimalFormat BYTE_CHANGE_FORMAT = new DecimalFormat("0.00");
                strMinSize = BYTE_CHANGE_FORMAT.format(bd3);
                break;
            }
            default: {
                strMinSize = SJctrCVSUtility.toUnitLBA_UP(this.getDisplaySize(lMinSize, unit, strEmu), unit);
            }
        }
        String strMaxSize = this.getComUtility().getCapacityUtility().toString(this.getDisplaySize(lMaxSize, unit, strEmu), unit, iEmu);
        this.textBox.setMin(strMinSize);
        this.textBox.setMax(strMaxSize);
        this.numTextBox.setMin(Integer.toString(iMinNum));
        this.numTextBox.setMax(Integer.toString(iMaxNum));
        if (Double.parseDouble(strMinSize) > Double.parseDouble(strMaxSize)) {
            this.clearData();
        } else if (iMaxNum == 0) {
            this.numTextBox.setMin("0");
            this.numTextBox.setMax("0");
        } else if (this.chkCapacity() != 0 && this.chkCapacity() != 105148) {
            this.numTextBox.setMin("0");
            this.numTextBox.setMax("0");
        }
    }

    public long getDisplaySize(long lSize, SJctrCapacityUtility.UNIT unit, String strEmu) {
        long rtn = 0L;
        int iEmu = this.getComUtility().getCVSUtility().getEmu(strEmu);
        switch (unit) {
            case CYL: 
            case BLOCK: {
                rtn = lSize;
                break;
            }
            default: {
                if (this.chkOffset.isSelect()) {
                    long wk1 = lSize / 2L;
                    int iSlot = this.getComUtility().getCVSUtility().getSlotSize(iEmu);
                    if (strEmu.equals("OPEN-V")) {
                        iSlot = 64;
                    }
                    long wk2 = wk1 / (long)iSlot;
                    long wk3 = wk2 / 15L;
                    rtn = wk3 * 15L * (long)iSlot * 2L;
                    break;
                }
                rtn = lSize;
            }
        }
        return rtn;
    }

    @Override
    public void clearData() {
        this.textBox.setMin("0");
        this.textBox.setMax("0");
        this.numTextBox.setValue("");
        this.numTextBox.setMin("0");
        this.numTextBox.setMax("0");
    }

    public void capTextCreate() {
        this.textBox.setValue("");
    }

    protected long getMinSize(String strEmuType) {
        return this.getComUtility().getCVSUtility().getMinSize(strEmuType);
    }

    public long[] getCapacity(String strEmuType, int iRaidLevel) {
        return this.getCapacitySimple(strEmuType, iRaidLevel, false);
    }

    public long[] getCapacitySimple(String strEmuType, int iRaidLevel, boolean bHDP) {
        int iEmuType = this.getComUtility().getCVSUtility().getEmu(strEmuType);
        long wkMinSize = this.getMinSize(strEmuType);
        Double minSize = Double.parseDouble(Long.toString(wkMinSize));
        long[] rtn = this.getComUtility().getCVSUtility().getCapacity(minSize, "LBA", iEmuType, iRaidLevel, false, this.chkOffset.isSelect(), bHDP);
        int iError = this.chkCapacity();
        if (iError == 0 || iError == 105153) {
            Double textSize = Double.parseDouble(this.textBox.getValue());
            long[] cap = this.getComUtility().getCVSUtility().getCapacity(textSize, this.comboBox.getSelection(), iEmuType, iRaidLevel, false, this.chkOffset.isSelect(), bHDP);
            if (iError == 105153 || iError == 0 && rtn[0] < cap[0]) {
                rtn = cap;
            }
        }
        return rtn;
    }

    public long[] getCapacity(String strEmuType, long lLdevSize) {
        int iEmuType = this.getComUtility().getCVSUtility().getEmu(strEmuType);
        long wkMinSize = this.getMinSize(strEmuType);
        Double minSize = Double.parseDouble(Long.toString(wkMinSize));
        long[] rtn = this.getComUtility().getCVSUtility().getCapacity(minSize, "LBA", iEmuType, 1, false, this.chkOffset.isSelect(), true);
        int iError = this.chkCapacity();
        if (iError == 0 || iError == 105153) {
            Double textSize = Double.parseDouble(this.textBox.getValue());
            long[] cap = this.getComUtility().getCVSUtility().getCapacity(textSize, this.comboBox.getSelection(), iEmuType, 1, false, false, true);
            long lNewSize = cap[0] + lLdevSize;
            Double dNewSize = Double.parseDouble(Long.toString(lNewSize));
            cap = this.getComUtility().getCVSUtility().getCapacity(dNewSize, "LBA", iEmuType, 1, false, this.chkOffset.isSelect(), true);
            if (iError == 105153 || iError == 0 && rtn[0] < cap[0]) {
                rtn = cap;
            }
        }
        return rtn;
    }

    public long[] getCapacityMF(String strEmuType, long lLdevSize) {
        int iEmuType = this.getComUtility().getCVSUtility().getEmu(strEmuType);
        long wkMinSize = this.getMinSize(strEmuType);
        Double minSize = Double.parseDouble(Long.toString(wkMinSize));
        long[] rtn = this.getComUtility().getCVSUtility().getCapacity(minSize, "LBA", iEmuType, 1, false, this.chkOffset.isSelect(), true);
        int iError = this.chkCapacity();
        if (iError == 0 || iError == 105153) {
            SJctrCapacityUtility.UNIT unit = SJctrCVSUtility.getUnit(this.comboBox.getSelection());
            String wkCap = this.getComUtility().getCapacityUtility().toString(lLdevSize, unit, iEmuType);
            long lTextSize = Long.parseLong(this.textBox.getValue()) + Long.parseLong(wkCap);
            Double textSize = Double.parseDouble(Long.toString(lTextSize));
            long[] cap = this.getComUtility().getCVSUtility().getCapacity(textSize, this.comboBox.getSelection(), iEmuType, 1, false, this.chkOffset.isSelect(), true);
            if (iError == 105153 || iError == 0 && rtn[0] < cap[0]) {
                rtn = cap;
            }
        }
        return rtn;
    }

    public long getCVDEVMaxSize(byte byType, boolean bPoolAttri) {
        return this.getCVDEVData().getCVDEVMaxSize(byType, bPoolAttri);
    }

    public int getRemainingNum(long lTotal, int iNum, byte byType, boolean bPoolType) {
        return this.getCVDEVData().getRemainingNum(lTotal, iNum, byType, bPoolType);
    }

    public SJctrCVDEVCountInfo getCVDEVData() {
        List<?> CVDEVList = this.getDataController().getProxy().getCache("CVDEV_COUNT_DATA");
        return (SJctrCVDEVCountInfo)CVDEVList.get(0);
    }

    public void setSelectDlgExitWarningMsg(int iError) {
        SJctrDataController data = this.getDataController();
        if (data instanceof SJctrCreateLDEVsBaseDC) {
            SJctrCreateLDEVsBaseDC baseDC = (SJctrCreateLDEVsBaseDC)data;
            baseDC.setSelectDlgExitWarningMsg(iError);
        }
    }

    protected boolean checkRoundUP(long block, SJctrCapacityUtility.UNIT unit) {
        long lBase;
        boolean ret = true;
        switch (unit) {
            case MB: {
                lBase = 2048L;
                break;
            }
            case GB: {
                lBase = 0x200000L;
                break;
            }
            default: {
                return ret;
            }
        }
        long lAmari = block * 100L % lBase;
        if (lAmari == 0L) {
            ret = false;
        }
        return ret;
    }

    public void numTextClr() {
        this.numTextBox.setValue("");
    }
}

