/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.editauditlog.settings.tab.ftp.dc;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.concrete.SJctrEnableDisableRadioButtonModel;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.editauditlog.com.SJctrEditAuditLogDef;
import sanproject.sn2.controller.wizard.editauditlog.com.SJctrEditAuditLogUtility;
import sanproject.sn2.controller.wizard.editauditlog.settings.tab.ftp.SJctrFTPConfirmTableType;
import sanproject.sn2.controller.wizard.editauditlog.settings.tab.ftp.model.SJctrEditFTPConfirmTable;
import sanproject.sn2.controller.wizard.editauditlog.settings.tab.ftp.model.SJctrEditFTPSettingData;
import sanproject.sn2.controller.wizard.editauditlog.settings.tab.ftp.model.SJctrPrimaryFTPServerSettingDataModel;
import sanproject.sn2.controller.wizard.editauditlog.settings.tab.ftp.model.SJctrSecondaryFTPServerSettingDataModel;
import sanproject.sn2.controller.wizard.editauditlog.settings.tab.ftp.model.SJctrTransferPrimaryButtonModel;
import sanproject.sn2.controller.wizard.editauditlog.settings.tab.ftp.model.SJctrTransferSecondaryButtonModel;
import sanproject.sn2.controller.wizard.tabmanage.dc.SJctrTabManageDataController;
import sanproject.sn2.controller.wizard.tabmanage.model.SJctrMultiInheritedData;
import sanproject.sn2.controller.wizard.tabmanage.sub.SJctrTabManageSubDC;

public class SJctrEditFTPSettingSubDC
extends SJctrTabManageSubDC
implements SJctrEditAuditLogDef {
    private SJctrEnableDisableRadioButtonModel primaryRadio;
    private SJctrPrimaryFTPServerSettingDataModel primarySrv;
    private SJctrEnableDisableRadioButtonModel secondaryRadio;
    private SJctrSecondaryFTPServerSettingDataModel secondarySrv;
    private SJctrCheckBoxDataModel completeSIMs;
    private SJctrCheckBoxDataModel edited;
    private SJctrCheckBoxDataModel preFinish;

    public SJctrEditFTPSettingSubDC(SJctrTabManageDataController managerDC) throws SJcException {
        super(managerDC);
    }

    @Override
    public String getTabName() {
        return this.getOwner().getComUtility().getGuidance("FTP_SN2");
    }

    @Override
    public Map<String, SJctrDataObjectModel<?>> getDataObjects() {
        LinkedHashMap map = new LinkedHashMap();
        this.primaryRadio = new SJctrEnableDisableRadioButtonModel();
        map.put("COM_PRIMARY_RADIO_FTP", this.primaryRadio);
        this.primarySrv = new SJctrPrimaryFTPServerSettingDataModel();
        map.put("COM_PRIMARY_FTP", this.primarySrv);
        this.secondaryRadio = new SJctrEnableDisableRadioButtonModel();
        map.put("COM_SECONDARY_RADIO_FTP", this.secondaryRadio);
        this.secondarySrv = new SJctrSecondaryFTPServerSettingDataModel();
        map.put("COM_SECONDARY_FTP", this.secondarySrv);
        this.completeSIMs = new SJctrCheckBoxDataModel();
        map.put("COM_COMPLETE_SIMS", this.completeSIMs);
        map.put("COM_TRANSFER_PRIMARY", new SJctrTransferPrimaryButtonModel());
        map.put("COM_TRANSFER_SECONDARY", new SJctrTransferSecondaryButtonModel());
        this.edited = new SJctrCheckBoxDataModel();
        map.put("COM_FTP_EDITED", this.edited);
        this.preFinish = new SJctrCheckBoxDataModel();
        map.put("COM_PRE_FINISH", this.preFinish);
        return map;
    }

    @Override
    protected void initListener() {
        this.addMessageEventListener(NOTIFY_FTP_SETTINGS.PUSH_TRANSFER_PRIMARY, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditFTPSettingSubDC.this.doActionTransferPrimary();
            }
        });
        this.addMessageEventListener(NOTIFY_FTP_SETTINGS.PUSH_TRANSFER_SECONDARY, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditFTPSettingSubDC.this.doActionTransferSecondary();
            }
        });
    }

    @Override
    public boolean checkStartData() {
        return true;
    }

    private SJctrEditFTPSettingData getFTPData() {
        SJctrEditFTPSettingData data = new SJctrEditFTPSettingData(SJctrEditAuditLogUtility.getAuditFTPData());
        ArrayList<SJctrEditFTPSettingData> array = new ArrayList<SJctrEditFTPSettingData>();
        array.add(data);
        this.putCache(KEY_CLASS_FTP_SETTING_DATA, array);
        return data;
    }

    @Override
    public boolean checkConstructData() {
        SJctrEditFTPSettingData data = this.getFTPData();
        this.primaryRadio.initItems();
        this.primaryRadio.setSelectEnabled(data.isEnablePrimary());
        this.primarySrv.organizeDataModel(data);
        this.secondaryRadio.initItems();
        this.secondaryRadio.setSelectEnabled(data.isEnableSecondary());
        this.secondarySrv.organizeDataModel(data);
        boolean isAllowed = false;
        boolean isSIMAllowed = false;
        SJcRoleResourceContainer container = this.getOwner().getAuthorizeContainer().getRoleResourceContainer();
        isAllowed = container.checkAuthority(19);
        isSIMAllowed = container.checkAuthority(43);
        if (!isAllowed) {
            this.primaryRadio.setEnable(false);
            this.primarySrv.setEnableAll(false);
            this.secondaryRadio.setEnable(false);
            this.secondarySrv.setEnableAll(false);
        }
        if (!isAllowed || !isSIMAllowed) {
            this.completeSIMs.setEnable(false);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        boolean isEdited = this.edited.isSelect();
        if (isEdited) {
            if (this.primaryRadio.isSelectedEnable()) {
                this.primarySrv.checkInputData();
            }
            if (this.secondaryRadio.isSelectedEnable()) {
                this.secondarySrv.checkInputData();
            }
            if (this.primaryRadio.isSelectedEnable() && this.secondaryRadio.isSelectedEnable()) {
                boolean isSame = this.primarySrv.getAddress().equals(this.secondarySrv.getAddress());
                isSame &= this.primarySrv.getUserName().equals(this.secondarySrv.getUserName());
                if (isSame &= this.primarySrv.getOutputFolder().equals(this.secondarySrv.getOutputFolder())) {
                    SJctrEditAuditLogUtility.errorMsg(100, 22, 205041);
                }
            }
        }
        return true;
    }

    @Override
    public void createInheritedData(SJctrMultiInheritedData data) {
        List<?> list = this.getCache(KEY_CLASS_FTP_SETTING_DATA);
        SJctrEditFTPSettingData settingData = (SJctrEditFTPSettingData)list.get(0);
        boolean isEdited = this.edited.isSelect();
        settingData.setEdited(this.edited.isSelect());
        if (isEdited) {
            settingData.setEnabledPrimary(this.primaryRadio.isSelectedEnable());
            if (this.primaryRadio.isSelectedEnable()) {
                settingData.setIpVersionPrimary(this.primarySrv.getVersion());
                settingData.setIpTextPrimary(this.primarySrv.getAddress());
                settingData.setUserNamePrimary(this.primarySrv.getUserName());
                settingData.setPasswordPrimary(this.primarySrv.getPassword());
                settingData.setFolderPrimary(this.primarySrv.getOutputFolder());
            }
            settingData.setEnabledSecondary(this.secondaryRadio.isSelectedEnable());
            if (this.secondaryRadio.isSelectedEnable()) {
                settingData.setIpVersionSecondary(this.secondarySrv.getVersion());
                settingData.setIpTextSecondary(this.secondarySrv.getAddress());
                settingData.setUserNameSecondary(this.secondarySrv.getUserName());
                settingData.setPasswordSecondary(this.secondarySrv.getPassword());
                settingData.setFolderSecondary(this.secondarySrv.getOutputFolder());
            }
        }
        settingData.setCompletedSIMs(this.completeSIMs.isSelect());
        boolean isCompleted = this.completeSIMs.isSelect();
        if (isEdited && isCompleted) {
            SJctrEditFTPConfirmTable.setTableType(SJctrFTPConfirmTableType.SET_AND_COMP);
        } else if (isEdited) {
            SJctrEditFTPConfirmTable.setTableType(SJctrFTPConfirmTableType.SETTING);
        } else if (isCompleted) {
            SJctrEditFTPConfirmTable.setTableType(SJctrFTPConfirmTableType.COMPLETE);
        }
        data.putInheritedData(KEY_CLASS_FTP_SETTING_DATA, list);
    }

    public void doActionTransferPrimary() {
        SJctrEditAuditLogUtility.transferFTPPrimary();
        this.setDirtyAll();
    }

    public void doActionTransferSecondary() {
        SJctrEditAuditLogUtility.transferFTPSecondary();
        this.setDirtyAll();
    }

    @Override
    public void doActionDialogClosed(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
    }

    public static enum NOTIFY_FTP_SETTINGS implements SJctrNotifyState
    {
        PUSH_TRANSFER_PRIMARY,
        PUSH_TRANSFER_SECONDARY;

    }
}

