/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.createkeys;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.serverux.dataimpl.SetEncryptionKeyCreate;
import sanproject.serverux.dataimpl.SetEncryptionKeyCreate_IN;
import sanproject.serverux.dataimpl.SetEncryptionKeyCreate_OUT;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.Logger.SJcAuditLogApplyElemCon;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrEncryptionKeysUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.encryption.com.SJctrCreateKMSInfo;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionAuditLog;
import sanproject.sn2.controller.wizard.encryption.createkeys.SJctrCreateKeysOnServerAuditLog;
import sanproject.sn2.kms.common.SJkmsCreateInfo;
import sanproject.sn2.kms.exception.SJkmsCommunicationException;
import sanproject.sn2.kms.util.SJkmsCommunicationUty;

public class SJctrCreateKeysAC
extends SJctrApplyController {
    private static final long serialVersionUID = -3362076792027746032L;
    private SJctrEncryptionAuditLog adtLog;
    private List<?> createKeyList;
    private List<SJctrError> resultData = Collections.emptyList();
    private SetEncryptionKeyCreate_OUT addRst = null;
    private int itopErrorCode = 0;
    private String product_Num = null;
    private int iKeyNum = 0;

    public SJctrCreateKeysAC(String productNum, int keyNum) {
        this.product_Num = productNum;
        this.iKeyNum = keyNum;
    }

    public void setApplyList(List<?> list) {
        if (list == null || list.isEmpty()) {
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        this.createKeyList = list;
    }

    @Override
    public ArrayList<?> getSetList() {
        int key = 0;
        try {
            key = SJctrEncryptionKeysUtility.getKeyGeneration();
        }
        catch (SJcException ex) {
            SJcLogUty.getLogger().info("[ENC]", "SJctrCreateKeysAC", "getSetList", "EncKey not Obtained.");
            throw ex;
        }
        ArrayList<SetEncryptionKeyCreate_IN> retList = new ArrayList<SetEncryptionKeyCreate_IN>();
        if (key == 1 || key == 2) {
            SetEncryptionKeyCreate_IN applyData = new SetEncryptionKeyCreate_IN();
            applyData.setIEncKeyCommand(1);
            applyData.setIEncKeyGenerate(1);
            applyData.setIEncKeyNum(this.iKeyNum);
            retList.add(applyData);
            return retList;
        }
        if (key == 3 || key == 4 || key == 5) {
            SetEncryptionKeyCreate_IN applyData = new SetEncryptionKeyCreate_IN();
            applyData.setIEncKeyCommand(1);
            applyData.setIEncKeyGenerate(0);
            applyData.setIEncKeyNum(this.iKeyNum);
            int key_Num = this.iKeyNum * 2;
            ArrayList<SJkmsCreateInfo> kmsList = new ArrayList();
            try {
                kmsList = SJkmsCommunicationUty.create(this.product_Num, key_Num);
            }
            catch (SJkmsCommunicationException ex) {
                List<SJctrCreateKMSInfo> dataList = this.setCreateKMSInfo(null, ex);
                this.createAuditLog(ex, dataList);
                throw ex;
            }
            List<SJctrCreateKMSInfo> dataList = this.setCreateKMSInfo(kmsList, null);
            this.createAuditLog(null, dataList);
            SetEncryptionKeyCreate[] keyList = new SetEncryptionKeyCreate[dataList.size()];
            for (int i = 0; i < this.iKeyNum; ++i) {
                SJctrCreateKMSInfo data = dataList.get(i);
                keyList[i] = new SetEncryptionKeyCreate();
                keyList[i].setByEKey(data.getByKeyData());
                keyList[i].setByTKey(data.getByKeyData_Tk());
            }
            applyData.setObjEncKeyData(keyList);
            retList.add(applyData);
        }
        return retList;
    }

    @Override
    public int getLeadTime() {
        int key = 0;
        int time = 0;
        try {
            key = SJctrEncryptionKeysUtility.getKeyGeneration();
        }
        catch (SJcException ex) {
            SJcLogUty.getLogger().info("[ENC]", "SJctrCreateKeysAC", "getLeadTime", "EncKey not Obtained.");
            throw ex;
        }
        if (key == 0) {
            time = 7;
        } else if (key == 1 || key == 2) {
            time = 10 + 5 * this.iKeyNum + 5;
        }
        return time;
    }

    @Override
    public boolean hasApplyResult() {
        return false;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        super.setApplyResult(resultObject);
        List rstList = new ArrayList<Object>();
        if (null == resultObject) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setApplyResult", "The parameter is illegal.");
            SJctrEncryptionKeysUtility.createErrorDialog(105493);
        }
        if (resultObject instanceof List) {
            rstList = (List)resultObject;
        } else {
            rstList.add(resultObject);
        }
        for (int iCnt = 0; iCnt < rstList.size(); ++iCnt) {
            if (null != rstList.get(iCnt) && rstList.get(iCnt) instanceof SetEncryptionKeyCreate_OUT) {
                this.addRst = (SetEncryptionKeyCreate_OUT)rstList.get(iCnt);
                if (this.addRst.getObjEncKeyData() == null) continue;
                SetEncryptionKeyCreate[] result = this.addRst.getObjEncKeyData();
                for (int i = 0; i < result.length; ++i) {
                    if (result[i].iResult == 0) continue;
                    super.setError(30, 5, result[i].iResult);
                    return;
                }
                continue;
            }
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setApplyResult", "The element in the list is illegal.");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
    }

    private List<SJctrCreateKMSInfo> setCreateKMSInfo(List<SJkmsCreateInfo> kmsList, SJkmsCommunicationException ex) {
        ArrayList<SJctrCreateKMSInfo> dataList = new ArrayList<SJctrCreateKMSInfo>();
        for (int i = 0; i < this.iKeyNum; ++i) {
            SJctrCreateKMSInfo data = new SJctrCreateKMSInfo();
            if (kmsList != null) {
                int key = i * 2;
                int key_TK = key + 1;
                SJkmsCreateInfo keyData = kmsList.get(key);
                SJkmsCreateInfo keyData_TK = kmsList.get(key_TK);
                data.setStrUuid(keyData.getUUID());
                data.setStrUuid_Tk(keyData_TK.getUUID());
                data.setByKeyData(keyData.getCreateDataDEK());
                data.setByKeyData_Tk(keyData_TK.getCreateDataDEK());
            }
            if (ex != null) {
                int md_ID = Integer.parseInt(ex.getMsg().getModuleID());
                data.setStrResult("(" + ex.getMsg().getFunctionID() + SJctrComUtility.toPaddingZeroString(md_ID, 2) + "-" + ex.getMsg().getMsgID() + ")");
                String[] errMsg = ex.getMsg().getMeansure_argument();
                String errServ = SJctrEncryptionKeysUtility.getErrMsg(errMsg);
                data.setStrServ_Reply(errServ);
            }
            dataList.add(data);
        }
        return dataList;
    }

    public void setAdtLog(SJctrCreateKeysOnServerAuditLog adtLog) {
        this.adtLog = adtLog;
    }

    private void createAuditLog(SJkmsCommunicationException err, List<SJctrCreateKMSInfo> dataList) {
        SJcLogUty.getLogger().info("[ENC]", "SJctrCreateKeysAC", "createAuditLog", "AuditLog Output start.");
        SJcAuditLoggerInterface SJcLogger2 = SJcLogUty.getAuditLogger();
        this.adtLog.setPrintData(dataList);
        SJcAuditLogApplyElemCon adtLogCont_IF = this.adtLog.createElemCon();
        adtLogCont_IF.setTaskName(this.getTaskName());
        String result_Info = "Success";
        SJcMessage err_Msg = null;
        if (err != null && err.getMsg() != null) {
            result_Info = "Error";
            err_Msg = err.getMsg();
        }
        adtLogCont_IF.setOperationResult(result_Info);
        adtLogCont_IF.setOperationErrorCode(err_Msg);
        SJcLogger2.putLog(adtLogCont_IF);
        SJcLogUty.getLogger().info("[ENC]", "SJctrCreateKeysAC", "createAuditLog", "AuditLog Output end.");
    }
}

