/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.kmip.regularbackupkeys;

import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrEncryptionKeysUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrQueueController;
import sanproject.sn2.controller.com.SJctrTask;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.topwindow.base.SJctrTopWindowDC;
import sanproject.sn2.controller.wizard.confirm.SJctrConfirmDC;
import sanproject.sn2.controller.wizard.encryption.kmip.enviromentalset.data.SJctrConfiguration;
import sanproject.sn2.controller.wizard.encryption.kmip.regularbackupkeys.SJctrRegularBackupKeyScheduleManager;
import sanproject.sn2.controller.wizard.encryption.kmip.regularbackupkeys.SJctrRegularBackupKeysToServerDC;
import sanproject.sn2.controller.wizard.encryption.kmip.regularbackupkeys.SJctrRegularBackupKeysToServerSubWizard;
import sanproject.sn2.datasupplier.SJdsSupplierException;
import sanproject.sn2.kms.common.SJkmsKmipConfiguration;
import sanproject.sn2.kms.util.SJkmsConfigUty;

public class SJctrRegularBackupKey
extends TimerTask {
    private final int ERR_FUNC_COMMON = 0;
    private final int ERR_MODULE_CONF = 2;
    private final int ERR_LOCK_FAILED = 9000;
    private final int WAIT_TIME = 300000;
    private final int SN_TASK_QUEUE_MAX = 128;
    private final int SN_TASK_RECORD_MAX = 256;
    private boolean bWaitState = false;
    private boolean bLoopFlg = false;
    private RUN_METHOD_STATE iRunMethodState = RUN_METHOD_STATE.PRESTART;

    public boolean isbWaitState() {
        return this.bWaitState;
    }

    public void setbWaitState(boolean bWaitState) {
        this.bWaitState = bWaitState;
    }

    public RUN_METHOD_STATE getiRunMethodState() {
        return this.iRunMethodState;
    }

    public void setiRunMethodState(RUN_METHOD_STATE iRunMethodState) {
        this.iRunMethodState = iRunMethodState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.setiRunMethodState(RUN_METHOD_STATE.PROCESSING);
            SJctrRegularBackupKeyScheduleManager ins = SJctrRegularBackupKeyScheduleManager.getInstance();
            if (ins.isNowTimeScheduleCheck()) {
                this.action();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.setiRunMethodState(RUN_METHOD_STATE.FINISHED);
        }
    }

    public void action() throws Exception {
        SJctrLogUty.info(this.getClass().getSimpleName(), "action", "action start.");
        String[] regularBackupData = this.getRegularBackupData();
        SJctrUserController uc = new SJctrUserController();
        SJbaseUserSessionInterface session = null;
        do {
            this.bLoopFlg = false;
            try {
                SJctrRegularBackupKeyScheduleManager otherRegularBackupState;
                SJctrConfirmDC confirmDC;
                SJctrRelatedDispDataObject confirmDO;
                SJctrDataController dc;
                if (SJctrEncryptionKeysUtility.isUserEnabled(regularBackupData[0], regularBackupData[1])) {
                    session = SJctrEncryptionKeysUtility.createSessionForRegularBackup(regularBackupData[0], regularBackupData[1]);
                    uc.initialize(session);
                    SJctrRelatedDispDataObject rd = uc.getRelatedDispData(SJctrTopWindowDC.class);
                    dc = uc.getDataController(rd);
                    dc.createWizard(SJctrRegularBackupKeysToServerSubWizard.class, null);
                    confirmDO = dc.getOwner().getRelatedDispData(SJctrConfirmDC.class);
                    confirmDC = (SJctrConfirmDC)dc.getOwner().getDataController(confirmDO);
                    otherRegularBackupState = SJctrRegularBackupKeyScheduleManager.getInstance();
                    if (!otherRegularBackupState.waitTaskCheck()) {
                        if (!this.isProcessingRegularBackup(dc)) {
                            if (!this.checkTaskMax()) {
                                confirmDC.autoApplyEvent(null, null);
                            } else {
                                this.retry();
                            }
                        }
                    } else {
                        SJctrLogUty.warn(this.getClass().getSimpleName(), "action", "other RegularBackupTask is waiting.");
                    }
                    uc.finish();
                    continue;
                }
                SJctrRegularBackupKeysToServerDC rbdc = new SJctrRegularBackupKeysToServerDC(regularBackupData[0]);
                dc = rbdc.getTopWindow();
                dc.createWizardForRegularBackup(SJctrRegularBackupKeysToServerSubWizard.class);
                confirmDO = dc.getOwner().getRelatedDispData(SJctrConfirmDC.class);
                confirmDC = (SJctrConfirmDC)dc.getOwner().getDataController(confirmDO);
                otherRegularBackupState = SJctrRegularBackupKeyScheduleManager.getInstance();
                if (!otherRegularBackupState.waitTaskCheck()) {
                    if (this.isProcessingRegularBackup(dc)) continue;
                    if (!this.checkTaskMax()) {
                        confirmDC.autoApplyEventForAuthError(null, null);
                        continue;
                    }
                    this.retry();
                    continue;
                }
                SJctrLogUty.warn(this.getClass().getSimpleName(), "action", "other RegularBackupTask is waiting.");
            }
            catch (SJdsSupplierException e) {
                this.checkDkcLockResult(e);
            }
            catch (Exception e) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "action", "exception", e);
                throw e;
            }
            finally {
                if (session != null) {
                    session.logoutForRegularBackup();
                }
            }
        } while (this.bLoopFlg);
        SJctrLogUty.info(this.getClass().getSimpleName(), "action", "action end.");
    }

    private String[] getRegularBackupData() throws Exception {
        String[] regularBackupData = new String[2];
        try {
            SJkmsKmipConfiguration conf;
            String strType = SJkmsConfigUty.getType();
            List<Object> list = new ArrayList();
            if (strType.equals("kmip")) {
                list = SJkmsConfigUty.getConfiguration(strType);
            }
            SJctrConfiguration data = new SJctrConfiguration();
            data.setDefault();
            if (list != null && list.size() > 0 && (conf = (SJkmsKmipConfiguration)list.get(0)).getEnabled()) {
                regularBackupData[0] = conf.getRegularbackupUserid();
                regularBackupData[1] = conf.getRegularbackupPasswd();
            }
        }
        catch (Exception e) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getRegularBackupData", "getRegularbackupData failed");
            throw e;
        }
        return regularBackupData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retry() {
        this.bLoopFlg = true;
        try {
            this.setbWaitState(true);
            Thread.sleep(300000L);
        }
        catch (Exception e) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "retry", "Sleep failed");
            this.bLoopFlg = false;
        }
        finally {
            this.setbWaitState(false);
        }
    }

    private boolean isProcessingRegularBackup(SJctrDataController dc) {
        boolean rtn = false;
        List<SJctrTask> taskList = dc.getOwner().getQueueBox().getTaskList();
        for (SJctrTask task : taskList) {
            if (task.isFinish() || !task.getActionTypeEn().toString().matches(".*Regular Backup.*")) continue;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "isProcessingRegularBackup", "task processing");
            rtn = true;
            break;
        }
        return rtn;
    }

    private boolean checkTaskMax() {
        boolean rtn = false;
        int taskRecordCnt = 0;
        int taskQueueMax = SJcEnvUty.getProperty2int("SN_TASK_QUEUE_MAX", 128);
        int taskRecordMax = SJcEnvUty.getProperty2int("SN_TASK_RECORD_MAX", 256);
        SJctrQueueController queueCtr = SJctrQueueController.getInstance();
        List<SJctrTask> taskList = queueCtr.getTaskList();
        for (SJctrTask task : taskList) {
            if (!task.isFinish()) continue;
            ++taskRecordCnt;
        }
        SJctrTask unProtectTask = new SJctrTask();
        while (taskRecordMax <= taskRecordCnt) {
            unProtectTask = SJctrQueueController.getDeleteTargetTask(taskList);
            if (unProtectTask != null) {
                queueCtr.removeTaskForRegularBackup(unProtectTask);
                --taskRecordCnt;
                continue;
            }
            rtn = true;
            SJctrLogUty.info(this.getClass().getSimpleName(), "checkTaskMax", "task Record max.");
            break;
        }
        if (taskQueueMax <= taskList.size() - taskRecordCnt) {
            rtn = true;
            SJctrLogUty.info(this.getClass().getSimpleName(), "checkTaskMax", "task Queue max.");
        }
        return rtn;
    }

    private void checkDkcLockResult(SJdsSupplierException e) {
        int func = Integer.parseInt(e.getMsg().getFunctionID());
        int module = Integer.parseInt(e.getMsg().getModuleID());
        int msg = Integer.parseInt(e.getMsg().getMsgID());
        if (func != 0 || module != 2 || msg != 9000) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkDkcLockResult", "exception", e);
            throw e;
        }
        SJctrLogUty.info(this.getClass().getSimpleName(), "checkDkcLockResult", "resource locked.");
        this.retry();
    }

    public static enum RUN_METHOD_STATE {
        PRESTART,
        PROCESSING,
        FINISHED;

    }
}

