/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.rekeykek;

import java.util.ArrayList;
import java.util.List;
import sanproject.serverux.dataimpl.EncryptionKeyInfoKEK;
import sanproject.serverux.dataimpl.SetEncryptionKeyKEKdynamicRekey_IN;
import sanproject.serverux.dataimpl.SetEncryptionKeyKEKdynamicRekey_OUT;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.Logger.SJcAuditLogApplyElemCon;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrEncryptionKeysUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.wizard.encryption.com.SJctrCreateKekAuditLog;
import sanproject.sn2.controller.wizard.encryption.com.SJctrDeleteKekAuditLog;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionAuditLog;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionKeyDef;
import sanproject.sn2.controller.wizard.encryption.com.SJctrKekAuditLogData;
import sanproject.sn2.controller.wizard.encryption.com.SJctrRegistKekAuditLog;
import sanproject.sn2.controller.wizard.encryption.rekeykek.SJctrRekeyKekConfirmData;
import sanproject.sn2.kms.common.SJkmsCreateInfo;
import sanproject.sn2.kms.exception.SJkmsCommunicationException;
import sanproject.sn2.kms.util.SJkmsCommunicationUty;

public class SJctrRekeyKekAC
extends SJctrApplyController
implements SJctrEncryptionKeyDef {
    private SJctrCreateKekAuditLog m_CreAdt;
    private SJctrDeleteKekAuditLog m_DelAdt;
    private SJctrRegistKekAuditLog m_RegAdt;
    private String m_OldUuid;
    private SJctrRekeyKekConfirmData m_confData;
    private String m_StrNo;

    @Override
    public ArrayList<?> getSetList() {
        EncryptionKeyInfoKEK[] wkKek = SJctrEncryptionKeysUtility.getEncKeyKEK();
        this.m_OldUuid = wkKek[0].getStrKeyUUID();
        SJkmsCreateInfo info = new SJkmsCreateInfo();
        try {
            info = SJkmsCommunicationUty.createKEKDynamic(this.m_StrNo);
        }
        catch (SJkmsCommunicationException ex) {
            SJkmsCreateInfo info_ex = new SJkmsCreateInfo();
            info_ex.setUUID(this.m_OldUuid);
            this.createAuditLog(info_ex, ex.getMsg(), this.m_CreAdt);
            throw ex;
        }
        this.createAuditLog(info, null, this.m_CreAdt);
        SetEncryptionKeyKEKdynamicRekey_IN rmiKek = new SetEncryptionKeyKEKdynamicRekey_IN();
        rmiKek.setStrUUID(info.getUUID());
        rmiKek.setByKEKdynamic(info.getCreateDataDEK());
        ArrayList<SetEncryptionKeyKEKdynamicRekey_IN> rtn = new ArrayList<SetEncryptionKeyKEKdynamicRekey_IN>();
        rtn.add(rmiKek);
        return rtn;
    }

    public void setAdtLog(SJctrCreateKekAuditLog creAdt, SJctrDeleteKekAuditLog delAdt, SJctrRegistKekAuditLog regAdt) {
        this.m_CreAdt = creAdt;
        this.m_DelAdt = delAdt;
        this.m_RegAdt = regAdt;
    }

    @Override
    public int getLeadTime() {
        int rtn = 30;
        return rtn;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        super.setApplyResult(resultObject);
        if (resultObject instanceof SetEncryptionKeyKEKdynamicRekey_OUT) {
            SetEncryptionKeyKEKdynamicRekey_OUT result = (SetEncryptionKeyKEKdynamicRekey_OUT)resultObject;
            if (result.getIResult() == 0) {
                SJkmsCreateInfo regInfo = new SJkmsCreateInfo();
                regInfo.setUUID(result.getStrUUID());
                regInfo.setHASH(new String(result.getByHash()));
                byte[] hash = result.getByHash();
                String strHash = SJcSecureUty.byteToStrEx(result.getByHash());
                SJcLogUty.getLogger().info("[ENC]", "SJctrRekeyKekAC", "*******", strHash);
                try {
                    SJkmsCommunicationUty.registKEKDynamicHash(this.m_StrNo, result.getStrUUID(), strHash);
                    this.createAuditLog(regInfo, null, this.m_RegAdt);
                }
                catch (SJkmsCommunicationException ex) {
                    this.createAuditLog(regInfo, ex.getMsg(), this.m_RegAdt);
                    return;
                }
                SJkmsCreateInfo info = new SJkmsCreateInfo();
                try {
                    info = SJkmsCommunicationUty.deleteKEKDynamic(this.m_OldUuid);
                    this.createAuditLog(info, null, this.m_DelAdt);
                }
                catch (SJkmsCommunicationException ex) {
                    SJkmsCreateInfo info_ex = new SJkmsCreateInfo();
                    info_ex.setUUID(this.m_OldUuid);
                    this.createAuditLog(info_ex, ex.getMsg(), this.m_DelAdt);
                    return;
                }
            }
            this.setErrorCode(30, 5, result.getIResult());
            return;
        }
        return;
    }

    private void createAuditLog(SJkmsCreateInfo info, SJcMessage msg, SJctrEncryptionAuditLog adtLog) {
        SJcAuditLoggerInterface SJcLogger2 = SJcLogUty.getAuditLogger();
        SJctrKekAuditLogData adtData = new SJctrKekAuditLogData();
        adtData.setCreateInf(info);
        adtData.setMessage(msg);
        adtLog.setPrintData(adtData);
        SJcAuditLogApplyElemCon adtLogCont_IF = adtLog.createElemCon();
        adtLogCont_IF.setTaskName(this.getTaskName());
        String adtResult = "Success";
        SJcMessage adtMessage = null;
        if (msg != null) {
            adtResult = "Error";
            adtMessage = msg;
            super.setError(SJctrEncryptionKeysUtility.createError(msg));
        }
        adtLogCont_IF.setOperationResult(adtResult);
        adtLogCont_IF.setOperationErrorCode(adtMessage);
        SJcLogger2.putLog(adtLogCont_IF);
        SJcLogUty.getLogger().info("[ENC]", "SJctrRekeyKekAC", "createAuditLog", "AuditLog Output end.");
    }

    public void setConfirmData(SJctrRekeyKekConfirmData confirmData, String strNo) {
        this.m_confData = confirmData;
        this.m_StrNo = strNo;
    }

    @Override
    protected List<SJctrError> getResultData() {
        return new ArrayList<SJctrError>();
    }

    @Override
    public boolean hasApplyResult() {
        return false;
    }

    public void setErrorCode(int iFunc, int iModule, int iError) {
        SJctrError error = new SJctrError(iFunc, iModule, iError);
        super.setError(error);
    }
}

